/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class DataPumpUtil {
    private final CmdToolUtil m_cmdTool;
    private final String m_home;
    private final String BIN = "bin";
    private final String EXPDP = "expdp";
    private final String IMPDP = "impdp";
    private final String OHOME_ENV_VAR = "ORACLE_HOME=";
    private final String LSEP = System.getProperty("line.separator");

    public DataPumpUtil(String crshome, boolean expdp) throws CmdToolUtilException {
        CmdToolUtil.assertDir(crshome, true);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String tool = expdp ? "expdp" : "impdp";
        tool = nativeSystem.getScriptFileName(tool);
        String toolLoc = crshome + File.separator + "bin";
        String[] toolDeps = new String[]{tool};
        this.m_cmdTool = new CmdToolUtil(tool, toolLoc, toolDeps);
        this.m_home = crshome;
    }

    public void runCmd(String[] args, String[] stdin, String[] env) throws CmdToolUtilException {
        String[] envs = new String[env.length + 1];
        System.arraycopy(env, 0, envs, 0, env.length);
        envs[env.length] = "ORACLE_HOME=" + this.m_home;
        this.checkResult(this.m_cmdTool.execute("localnode", args, envs, stdin));
    }

    private void checkResult(CommandResult res) throws CmdToolUtilException {
        String[] error;
        if (!res.getBooleanResult() && (error = res.getResultString()) != null && error.length > 0) {
            String errStr = Utils.getString(error, this.LSEP);
            Trace.out((Object)"Error found: %s", errStr);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.DATAPMP_FAILED, errStr);
        }
    }
}

