/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.ClusterClassification;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.NodeRole;
import oracle.cluster.crs.CRSException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceNames;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class CRSCTLUtil {
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle(PrCtMsgID.facility);
    private CmdToolUtil m_cmdtool;
    static final String CRSCTLUTL = new SystemFactory().CreateSystem().getExeName("crsctl");
    private static final String EXE_LOC = "bin";
    static final String CRSCTL_COMMAND_STAT = "stat";
    private static final String CRSCTL_COMMAND_CHECK = "check";
    private static final String CRSCTL_COMMAND_QUERY = "query";
    static final String CRSCTL_ENTITY_RESOURCE = "resource";
    private static final String CRSCTL_ARG_CLUSTER = "cluster";
    private static final String CRSCTL_ARG_HAS = "has";
    private static final String CRSCTL_ARG_CSS = "css";
    private static final String CRSCTL_ARG_CRS = "crs";
    private static final String CRSCTL_IPMI_CONFIG = "ipmiconfig";
    private static final String CRSCTL_GET = "get";
    private static final String CRSCTL_NODE = "node";
    private static final String CRSCTL_ROLE = "role";
    private static final String CRSCTL_CONFIG = "config";
    private static final String CRSCTL_ARG_TYPE = "type";
    private static final String CRSCTL_ARG_MODE = "mode";
    private static final String CRSCTL_ARG_CLASS = "class";
    private static final String CRSCTL_BRIEF = "-brief";
    private static final String CRSCTL_ARG_ALL = "-all";
    private static final String CRSCTL_FILTER_FLAG = "-w";
    private static final String CRSCTL_ARG_GUID = "clusterguid";
    private static final String ORA_MGMTDB = "ora.mgmtdb";
    private static final String ORA_MGMTLSNR = "ora.MGMTLSNR";
    private static final String CRSCTL_ATTR = "-attr";
    static final String CRSCTL_EVAL_FLAG = "-e";
    static final String CRSCTL_NODE_FLAG = "-n";
    static final String CRSCTL_PROF_FLAG = "-p";
    private static final String CRSCTL_RUNTIME_FLAG = "-v";
    private static final String CRSCTL_PROFILE_FLAG = "-f";
    private static final String CRSCTL_INIT_FLAG = "-init";
    static final String[] CRSCTLUTL_DEP = null;
    public static final String CRS_OHAS_ONLINE = "CRS-4638";
    public static final String CRS_OHAS_NOT_ONLINE = "CRS-4639";
    public static final String CSS_ONLINE = "CRS-4529";
    public static final String CLU_RDY_SRVCS_ONLINE = "CRS-4537";
    public static final String EM_ONLINE = "CRS-4533";
    public static final String CSS_ONLINE_PRE11 = "CSS ";
    public static final String CLU_RDY_SRVCS_ONLINE_PRE11 = "CRS ";
    public static final String EM_ONLINE_PRE11 = "EVM ";
    public static final String CSS_ONLINE_PRE11_FULL = "Cluster Synchronization Services";
    public static final String CLU_RDY_SRVCS_ONLINE_PRE11_FULL = "Cluster Ready Services";
    public static final String EM_ONLINE_PRE11_FULL = "Event Manager";
    public static final String CSS_NOT_ONLINE = "CRS-4530";
    public static final String CLU_RDY_SRVCS_NOT_ONLINE = "CRS-4535";
    public static final String EM_NOT_ONLINE = "CRS-4534";
    public static final String CRS_RESOURCE_REGISTERED = "CRS-4003";
    public static final String CRS_RESOURCE_NOT_REGISTERED = "CRS-212";
    public static final String CRS_RES_NOT_REGISTERED = "CRS-210";
    public static final String CLUSTER_CLASS_STANDALONE = "Standalone Cluster";
    public static final String CLUSTER_CLASS_DOMAIN_SERVICES = "Domain Services Cluster";
    public static final String CLUSTER_CLASS_MEMBER = "Member Cluster";
    private static final String CRSCTL_MSG_IPMI_CONFIGURED = "CRS-4236";
    private static final String CRSCTL_NODE_NOT_REPLY = "CRS-4404";
    private static final String CRS_MOUNTPOINT_PATH = "MOUNTPOINT_PATH";
    private static final String DELIMITER = "\\:";
    private static final String NEWLINE = "\\n";
    private static final String DOT_DELIMITER = "\\.";

    public CRSCTLUtil(String haHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(haHome, true);
        String toolLoc = haHome + File.separator + EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(CRSCTLUTL, toolLoc, CRSCTLUTL_DEP);
    }

    public CRSCTLUtil(String haHome, RemoteUserInfo uInfo) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(haHome, "CRSCTLUtil-constr2-haHome");
        oracle.cluster.impl.util.Utils.assertInputNotNull(uInfo, "CRSCTLUtil-constr2-uInfo");
        String toolLoc = haHome + File.separator + EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(uInfo, CRSCTLUTL, toolLoc);
    }

    public boolean isHARunning() throws CmdToolUtilException {
        return this.checkHARunning(null);
    }

    public boolean isHARunning(String nodeName) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        return this.checkHARunning(nodeName);
    }

    private boolean checkHARunning(String nodeName) throws CmdToolUtilException {
        String[] args = new String[]{CRSCTL_COMMAND_CHECK, CRSCTL_ARG_HAS};
        boolean runningStatus = false;
        String cmdOutString = this.runCrsctlCmd(nodeName, args, null);
        if (cmdOutString.indexOf(CRS_OHAS_ONLINE) >= 0) {
            runningStatus = true;
        }
        return runningStatus;
    }

    public boolean isSIHA() throws CmdToolUtilException {
        return this.checkSIHA(null);
    }

    public boolean isSIHA(String nodeName) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        return this.checkSIHA(nodeName);
    }

    private boolean checkSIHA(String nodeName) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, "ora.crsd", CRSCTL_INIT_FLAG, "-g"};
        CommandResult result = null;
        result = nodeName == null ? this.m_cmdtool.executeLocally(args, null) : this.m_cmdtool.execute(nodeName, args, null, false);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            if (nodeName == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_NODE_FAIL, nodeName, sb.toString());
        }
        boolean crsdResourceRegistered = false;
        String[] cmdOutPut = result.getResultString();
        String cmdOutString = Utils.getString(cmdOutPut, Constants.LINE_SEPARATOR);
        if (cmdOutString.indexOf(CRS_RESOURCE_REGISTERED) >= 0) {
            crsdResourceRegistered = true;
        }
        return !crsdResourceRegistered;
    }

    public void validateHARunning(String nodeName) throws CmdToolUtilException {
        String[] args = new String[]{CRSCTL_COMMAND_CHECK, CRSCTL_ARG_HAS};
        String cmdOutString = this.runCrsctlCmd(nodeName, args, null);
        if (cmdOutString.indexOf(CRS_OHAS_ONLINE) >= 0) {
            throw new CmdToolUtilException(cmdOutString);
        }
    }

    public boolean isCRSRunning(Version version) throws CmdToolUtilException {
        CmdToolUtil.assertVersion(version);
        return this.checkCRSRunning(null, version);
    }

    public boolean isCRSRunning(String nodeName, Version version) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        CmdToolUtil.assertVersion(version);
        return this.checkCRSRunning(nodeName, version);
    }

    private boolean checkCRSRunning(String nodeName, Version version) throws CmdToolUtilException {
        boolean runningStatus = false;
        boolean isVersionPre112 = false;
        if (version != null && Version.isPre112(version)) {
            Trace.out("Checking if CRS is running for pre 112 release");
            isVersionPre112 = true;
        } else {
            Trace.out("Checking if CRS is running for post 11 release");
        }
        String[] args = new String[]{CRSCTL_COMMAND_CHECK, isVersionPre112 ? CRSCTL_ARG_CRS : CRSCTL_ARG_CLUSTER};
        String[] env = null;
        String cmdOutString = this.runCrsctlCmd(nodeName, args, env);
        runningStatus = this.parseCmdOutput(cmdOutString, isVersionPre112);
        return runningStatus;
    }

    public void validateCRSRunning(String nodeName, Version version) throws CmdToolUtilException {
        boolean isVersionPre112 = false;
        if (version != null && Version.isPre112(version)) {
            Trace.out("Checking if CRS is running for pre 112 release");
            isVersionPre112 = true;
        } else {
            Trace.out("Checking if CRS is running for post 11 release");
        }
        String[] args = new String[]{CRSCTL_COMMAND_CHECK, isVersionPre112 ? CRSCTL_ARG_CRS : CRSCTL_ARG_CLUSTER};
        String[] env = null;
        String cmdOutString = this.runCrsctlCmd(nodeName, args, env);
        if (!this.parseCmdOutput(cmdOutString, isVersionPre112)) {
            throw new CmdToolUtilException(cmdOutString);
        }
    }

    private String runCrsctlCmd(String nodeName, String[] args, String[] env) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = null;
        String localNodeName = null;
        try {
            localNodeName = Utils.getLocalNodeName();
            Trace.out("Fetched Local Node Name: " + localNodeName);
        }
        catch (UnknownHostException e) {
            throw new CmdToolUtilException(e);
        }
        result = nodeName == null || nodeName != null && nodeName.equalsIgnoreCase(localNodeName) ? this.m_cmdtool.executeLocally(args, env) : this.m_cmdtool.execute(nodeName, args, env, false);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            if (nodeName == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_NODE_FAIL, nodeName, sb.toString());
        }
        String[] cmdOutPut = result.getResultString();
        String cmdOutString = Utils.getString(cmdOutPut, Constants.LINE_SEPARATOR);
        return cmdOutString;
    }

    private boolean parseCmdOutput(String cmdOutput, boolean isVersionPre112) {
        return !(cmdOutput.indexOf(isVersionPre112 ? CSS_ONLINE_PRE11 : CSS_ONLINE) < 0 && cmdOutput.indexOf(isVersionPre112 ? CSS_ONLINE_PRE11_FULL : CSS_ONLINE) < 0 || cmdOutput.indexOf(isVersionPre112 ? CLU_RDY_SRVCS_ONLINE_PRE11 : CLU_RDY_SRVCS_ONLINE) < 0 && cmdOutput.indexOf(isVersionPre112 ? CLU_RDY_SRVCS_ONLINE_PRE11_FULL : CLU_RDY_SRVCS_ONLINE) < 0 || cmdOutput.indexOf(isVersionPre112 ? EM_ONLINE_PRE11 : EM_ONLINE) < 0 && cmdOutput.indexOf(isVersionPre112 ? EM_ONLINE_PRE11_FULL : EM_ONLINE) < 0);
    }

    public boolean isDatabaseExists(String dbUniqueName) throws CmdToolUtilException {
        return this.checkDatabaseExists(null, dbUniqueName);
    }

    public boolean isDatabaseExists(String nodeName, String dbUniqueName) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        return this.checkDatabaseExists(nodeName, dbUniqueName);
    }

    private boolean checkDatabaseExists(String nodeName, String dbUniqueName) throws CmdToolUtilException {
        String dbResourceName = DatabaseFactory.getDatabaseResourceName(dbUniqueName, true);
        boolean[] retArr = this.statResource(dbResourceName, nodeName, true);
        if (!retArr[0] && retArr[1]) {
            return retArr[1];
        }
        dbResourceName = DatabaseFactory.getDatabaseResourceName(dbUniqueName, false);
        retArr = this.statResource(dbResourceName, nodeName, false);
        return retArr[1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean[] statResource(String dbResourceName, String nodeName, boolean noException) throws CmdToolUtilException {
        boolean[] retArr = new boolean[]{false, false};
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, dbResourceName, "-g"};
        CommandResult result = null;
        result = nodeName == null ? this.m_cmdtool.executeLocally(args, null) : this.m_cmdtool.execute(nodeName, args, null, false);
        retArr[0] = false;
        if (!result.getBooleanResult()) {
            String[] errorString = result.getResultString();
            String[] outputString = result.getOutputString();
            String[] useString = errorString != null && errorString.length > 0 ? errorString : (outputString != null && outputString.length > 0 ? outputString : null);
            if (useString != null) {
                Trace.out("m_cmdtool.execute failed ");
                StringBuilder sb = new StringBuilder("");
                for (int i = 0; i < useString.length; ++i) {
                    sb.append(useString[i]);
                }
                if (nodeName == null) {
                    if (!noException) throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
                    retArr[0] = true;
                } else {
                    if (!noException) throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_NODE_FAIL, nodeName, sb.toString());
                    retArr[0] = true;
                }
            }
        }
        retArr[1] = false;
        String[] cmdOutPut = result.getResultString();
        String cmdOutString = Utils.getString(cmdOutPut, Constants.LINE_SEPARATOR);
        if (cmdOutString.indexOf(CRS_RESOURCE_REGISTERED) < 0) return retArr;
        retArr[1] = true;
        return retArr;
    }

    public List<String> getHAManagedDatabases() throws CmdToolUtilException, DatabaseException {
        return this.doGetHAManagedDatabases();
    }

    public List<String> getHAManagedDatabases(String nodeName) throws CmdToolUtilException, DatabaseException {
        CmdToolUtil.assertNode(nodeName);
        return this.doGetHAManagedDatabases();
    }

    private List<String> doGetHAManagedDatabases() throws CmdToolUtilException, DatabaseException {
        String[] errorString;
        String CRSCTL_DB_FILTER = "((" + ResourceLiterals.TYPE.name() + " " + "=" + " " + ResourceLiterals.DATABASE_TYPE.toString() + ") OR ((" + ResourceLiterals.TYPE.name() + " " + "=" + " " + (Object)((Object)ResourceLiterals.APPLICATION) + ") AND (" + ResourceLiterals.NAME.name() + " st ora.) AND (" + ResourceLiterals.NAME.name() + " en .db)))";
        Trace.out((Object)"crsctl filter = %s", CRSCTL_DB_FILTER);
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, CRSCTL_FILTER_FLAG, CRSCTL_DB_FILTER, CRSCTL_PROFILE_FLAG};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        Trace.out("Executed crsctl ");
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed. Error String = " + result.getErrorString());
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
        }
        String[] dbResNameArr = result.getResultString();
        int dbResArrLen = dbResNameArr != null ? dbResNameArr.length : 0;
        ArrayList<String> dbNameList = new ArrayList<String>(dbResArrLen);
        for (String dbResourceAttributes : dbResNameArr) {
            String[] tokens = dbResourceAttributes.split("=");
            if (tokens.length != 2 || !ResourceLiterals.DB_UNIQUE_NAME.name().equals(tokens[0].trim())) continue;
            dbNameList.add(tokens[1].trim());
        }
        return dbNameList;
    }

    public boolean isDependentOnASM(String dbUniqueName) throws CmdToolUtilException, CRSException {
        return this.checkDependentOnASM(dbUniqueName);
    }

    public boolean isDependentOnASM(String nodeName, String dbUniqueName) throws CmdToolUtilException, CRSException {
        CmdToolUtil.assertNode(nodeName);
        return this.checkDependentOnASM(dbUniqueName);
    }

    private boolean checkDependentOnASM(String dbUniqueName) throws CmdToolUtilException, CRSException {
        String[] errorString;
        String[] errorString2;
        String CRSCTL_DG_FILTER = "(" + ResourceLiterals.TYPE.name() + " " + "=" + " " + ResourceLiterals.DISKGROUP_TYPE.toString() + ")";
        String[] args = null;
        CommandResult result = null;
        args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, CRSCTL_FILTER_FLAG, CRSCTL_DG_FILTER};
        result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString2 = result.getResultString()) != null && errorString2.length > 0) {
            Trace.out("m_cmdtool.execute failed. Error String = " + result.getErrorString());
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString2.length; ++i) {
                sb.append(errorString2[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
        }
        String[] dgResNames = result.getResultString();
        if (dgResNames == null || dgResNames.length == 0) {
            return false;
        }
        ArrayList<String> dgList = new ArrayList<String>(Arrays.asList(dgResNames));
        String dbResourceName = DatabaseFactory.getDatabaseResourceName(dbUniqueName);
        args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, dbResourceName};
        result = this.m_cmdtool.executeLocally(args, null);
        Trace.out("result.getBooleanResult()" + result.getBooleanResult());
        Trace.out("result.getErrorString()" + result.getErrorString());
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed. Error String = " + result.getErrorString());
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
        }
        String[] output = result.getResultString();
        boolean dependsOnASM = false;
        block2: for (int i = 0; i < output.length && !dependsOnASM; ++i) {
            if (!output[i].startsWith(ResourceLiterals.START_DEPENDENCIES.name())) continue;
            String depListString = output[i].substring((ResourceLiterals.START_DEPENDENCIES.name() + " " + "=" + " ").length());
            ResourceAttribute startDep = CRSFactoryImpl.getInstance().create(ResourceLiterals.START_DEPENDENCIES.name(), depListString);
            for (String depResName : ResourceDependency.getResourceNames(startDep, ResourceDependency.DepType.HARD_DEP)) {
                if (!dgList.contains(depResName)) continue;
                dependsOnASM = true;
                continue block2;
            }
        }
        Trace.out("dependsOnASM = " + dependsOnASM);
        return dependsOnASM;
    }

    public boolean isDHCPServerConfigured() throws CmdToolUtilException {
        String[] errorString;
        String defNetResName = ResourceNames.getNetworkResourceName(String.valueOf(1));
        boolean vipDHCPEnabled = false;
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, defNetResName, CRSCTL_PROFILE_FLAG};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        Trace.out("result.getBooleanResult()" + result.getBooleanResult());
        Trace.out("result.getResultString()" + Arrays.asList(result.getResultString()));
        Trace.out("result.getErrorString()" + result.getErrorString());
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed. Error String = " + result.getErrorString());
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
        }
        String[] output = result.getResultString();
        for (int i = 0; i < output.length; ++i) {
            if (!output[i].startsWith(ResourceLiterals.USR_ORA_AUTO.name())) continue;
            Trace.out("Calling crsctl. Check output: " + output[i]);
            String[] tokens = output[i].split("=");
            if (tokens.length != 2) continue;
            String[] dhcpTypeStr = tokens[1].split(" ");
            if (dhcpTypeStr.length == 2) {
                if (dhcpTypeStr[0].equals(DHCPServerType.NONE.toString()) || dhcpTypeStr[1].equals(DHCPServerType.NONE.toString())) continue;
                vipDHCPEnabled = true;
                continue;
            }
            if (tokens[1].equals(DHCPServerType.NONE.toString())) continue;
            vipDHCPEnabled = true;
        }
        Trace.out("DHCP server configured = " + vipDHCPEnabled);
        return vipDHCPEnabled;
    }

    public boolean isACFSRegistered(String volName, String dgName) throws CmdToolUtilException {
        String resName;
        try {
            resName = ResourceNames.getACFSResourceName(dgName, volName);
        }
        catch (CRSException sme) {
            throw new CmdToolUtilException(sme);
        }
        return this.isResourceExists(resName);
    }

    public boolean isACFSRegisteredForMtPt(String mtptPath) throws CmdToolUtilException {
        Map<String, String> volDg = this.getVolumeDgForMtPt(mtptPath);
        if (volDg.size() == 0) {
            Trace.out("Check ACFS resources using canonicalized form");
            return this.isACFSReg4MountPoint(mtptPath);
        }
        return true;
    }

    private boolean isACFSReg4MountPoint(String mtptPath) throws CmdToolUtilException {
        String[] errorString;
        if (mtptPath == null || mtptPath.isEmpty()) {
            return false;
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String internalMtPt = nativeSystem.isUnixSystem() ? mtptPath : mtptPath.toLowerCase();
        boolean found = false;
        try {
            internalMtPt = new File(internalMtPt).getCanonicalPath();
            Trace.out("Canonical mount point " + internalMtPt);
        }
        catch (IOException io) {
            throw new CmdToolUtilException(io);
        }
        String CRSCTL_ACFS_FILTER = "(" + ResourceLiterals.TYPE.name() + " " + "=" + " " + ResourceLiterals.ACFS_TYPE.toString() + ")";
        String CRSCTL_ATTR_MTPT = CRS_MOUNTPOINT_PATH;
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, CRSCTL_FILTER_FLAG, CRSCTL_ACFS_FILTER, CRSCTL_ATTR, CRSCTL_ATTR_MTPT, CRSCTL_PROF_FLAG};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed. Error String = " + result.getErrorString());
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
        }
        String[] output = result.getResultString();
        Trace.out("output size = " + output.length);
        if (output.length > 1) {
            for (String out : output) {
                Trace.out("crsctl output: " + out);
                if (!out.startsWith(CRS_MOUNTPOINT_PATH)) continue;
                String[] values = out.split("=");
                try {
                    Trace.out("mt point " + values[1]);
                    Trace.out("Canonical mt point " + new File(values[1]).getCanonicalPath());
                    if (!new File(values[1]).getCanonicalPath().equalsIgnoreCase(internalMtPt)) break;
                    found = true;
                    break;
                }
                catch (IOException io) {
                    throw new CmdToolUtilException(io);
                }
            }
        }
        return found;
    }

    public Map<String, String> getVolumeDgForMtPt(String mtptPath) throws CmdToolUtilException {
        String[] errorString;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String internalMtPt = nativeSystem.isUnixSystem() ? mtptPath : mtptPath.toLowerCase();
        String CRSCTL_ACFS_FILTER = "((" + ResourceLiterals.TYPE.name() + " " + "=" + " " + ResourceLiterals.ACFS_TYPE.toString() + ") AND (" + ResourceLiterals.INTERNAL_MOUNTPOINT_PATH.name() + " " + "=" + " " + internalMtPt + "))";
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, CRSCTL_FILTER_FLAG, CRSCTL_ACFS_FILTER};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed. Error String = " + result.getErrorString());
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
        }
        String[] output = result.getResultString();
        HashMap<String, String> info = new HashMap<String, String>();
        Trace.out("output size = " + output.length);
        if (output.length > 1) {
            if (output.length > 5) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_MULTI_ACFS_FOR_MTPT, mtptPath);
            }
            Trace.out("crsctl output: " + output[0]);
            int index = output[0].indexOf(ResourceLiterals.NAME.name() + "=");
            if (index != -1) {
                String acfsResName = output[0].substring(index);
                Trace.out("acfs resource name = " + acfsResName);
                String[] values = acfsResName.split(Pattern.quote(String.valueOf('.')));
                info.put(ResourceLiterals.DISKGROUP.name(), values[1]);
                info.put(ResourceLiterals.VOLUME.name(), values[2]);
                Trace.out("info = " + ((Object)info).toString());
            }
        }
        return info;
    }

    public boolean isIPMIConfigured() throws CmdToolUtilException {
        boolean retVal = false;
        Trace.out("ENTRY");
        String[] args = new String[]{CRSCTL_COMMAND_QUERY, CRSCTL_ARG_CSS, CRSCTL_IPMI_CONFIG};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        String[] output = result.getResultString();
        if (output.length == 1) {
            Trace.out("crsctl output: " + output[0]);
            retVal = output[0].startsWith(CRSCTL_MSG_IPMI_CONFIGURED);
        }
        Trace.out("Returning " + retVal);
        return retVal;
    }

    private boolean isResourceExists(String resName) throws CmdToolUtilException {
        String[] errorString;
        boolean isResExists = false;
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, resName};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        Trace.out("result.getBooleanResult()" + result.getBooleanResult());
        Trace.out("result.getResultString()" + Arrays.asList(result.getResultString()));
        Trace.out("result.getErrorString()" + result.getErrorString());
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed. Error String = " + result.getErrorString());
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
        }
        String[] output = result.getResultString();
        for (int i = 0; i < output.length; ++i) {
            Trace.out("CRSCTL output line: " + output[i]);
            if (!output[i].startsWith(ResourceLiterals.NAME.name() + "=") || !output[i].contains(resName)) continue;
            isResExists = true;
        }
        Trace.out("ACFS resource " + resName + " configured = " + isResExists);
        return isResExists;
    }

    public HashMap<String, NodeRole> getClusterNodeConfigRoles() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{CRSCTL_GET, CRSCTL_NODE, CRSCTL_ROLE, CRSCTL_CONFIG, CRSCTL_BRIEF, CRSCTL_ARG_ALL};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_CLUSTER_CONFIG_NODE_ROLES_FAILED, new Object[]{errorString});
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] outputs = result.getResultString();
        HashMap<String, NodeRole> roleMap = null;
        if (outputs != null && outputs.length > 0) {
            int outputLen = outputs.length;
            roleMap = new HashMap<String, NodeRole>(outputLen);
            for (int i = 0; i < outputLen; ++i) {
                Trace.out("outputs[" + i + "] = " + outputs[i]);
                String[] values = outputs[i].trim().split(DELIMITER);
                Trace.out("values length = " + values.length);
                if (values.length == 2) {
                    if (values[0].equals(CRSCTL_NODE_NOT_REPLY)) continue;
                    try {
                        NodeRole noderole = NodeRole.getEnumMember(values[1].toString());
                        Trace.out("putting values " + values[0].toString() + " " + values[1].toString() + " in map");
                        roleMap.put(values[0], noderole);
                        continue;
                    }
                    catch (EnumConstantNotPresentException e) {
                        throw new CmdToolUtilException(e);
                    }
                }
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_EXECUTION_FAILED, new Object[0]);
            }
        } else {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_EMPTY_RESULT, new Object[0]);
        }
        return roleMap;
    }

    public String getClusterType() throws CmdToolUtilException {
        return this.getClusterType(null);
    }

    public String getClusterType(String nodeName) throws CmdToolUtilException {
        return this.getClustInfo(nodeName, CRSCTL_ARG_TYPE);
    }

    public ClusterClassification getClusterClassification() throws CmdToolUtilException {
        String clustClass = this.getClustInfo(null, CRSCTL_ARG_CLASS);
        if (CLUSTER_CLASS_STANDALONE.equalsIgnoreCase(clustClass)) {
            return ClusterClassification.STANDALONE_CLUSTER;
        }
        if (CLUSTER_CLASS_MEMBER.equalsIgnoreCase(clustClass)) {
            return ClusterClassification.MEMBER_CLUSTER;
        }
        if (CLUSTER_CLASS_DOMAIN_SERVICES.equalsIgnoreCase(clustClass)) {
            return ClusterClassification.DOMAIN_CLUSTER;
        }
        return null;
    }

    public ClusterClassification getClusterClassification(String nodeName) throws CmdToolUtilException {
        String clustClass = this.getClustInfo(nodeName, CRSCTL_ARG_CLASS);
        if (CLUSTER_CLASS_STANDALONE.equalsIgnoreCase(clustClass)) {
            return ClusterClassification.STANDALONE_CLUSTER;
        }
        if (CLUSTER_CLASS_MEMBER.equalsIgnoreCase(clustClass)) {
            return ClusterClassification.MEMBER_CLUSTER;
        }
        if (CLUSTER_CLASS_DOMAIN_SERVICES.equalsIgnoreCase(clustClass)) {
            return ClusterClassification.DOMAIN_CLUSTER;
        }
        return null;
    }

    public String getClusterMode(String nodeName) throws CmdToolUtilException {
        return this.getClustInfo(nodeName, CRSCTL_ARG_MODE);
    }

    private String getClustInfo(String nodeName, String option) throws CmdToolUtilException {
        String[] errorString;
        String[] args;
        if (this.checkSIHA(nodeName)) {
            Object[] args2 = new Object[]{"CRSCTLUtil-getClustInfo-isSIHA"};
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, args2);
        }
        if (option == CRSCTL_ARG_TYPE) {
            args = new String[]{CRSCTL_GET, CRSCTL_ARG_CLUSTER, CRSCTL_ARG_TYPE};
        } else if (option == CRSCTL_ARG_MODE) {
            args = new String[]{CRSCTL_GET, CRSCTL_ARG_CLUSTER, CRSCTL_ARG_MODE, CRSCTL_CONFIG};
        } else if (option == CRSCTL_ARG_CLASS) {
            args = new String[]{CRSCTL_GET, CRSCTL_ARG_CLUSTER, CRSCTL_ARG_CLASS};
        } else {
            Trace.out("getClustType(nodeName, null) is returning cluster type by default.");
            args = new String[]{CRSCTL_GET, CRSCTL_ARG_CLUSTER, CRSCTL_ARG_TYPE};
        }
        CommandResult result = null;
        result = nodeName == null ? this.m_cmdtool.executeLocally(args, null) : this.m_cmdtool.execute(nodeName, args, null, false);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            if (nodeName == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_NODE_FAIL, nodeName, sb.toString());
        }
        String[] cmdOutPut = result.getResultString();
        String cmdOutString = Utils.getString(cmdOutPut, Constants.LINE_SEPARATOR);
        Trace.out("cmdOutString   : " + cmdOutString);
        Pattern pattern = Pattern.compile("'(.*?)'|\"(.*?)\"");
        Matcher matcher = pattern.matcher(cmdOutString);
        String finalOutput = null;
        if (matcher.find() && (finalOutput = matcher.group(1)) == null) {
            finalOutput = matcher.group(2);
        }
        return finalOutput;
    }

    public String getClusterGUID() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{CRSCTL_GET, CRSCTL_ARG_CSS, CRSCTL_ARG_GUID};
        CommandResult result = null;
        result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_GET_CLUSTER_GUID_FAIL, sb.toString());
        }
        Object[] cmdOutPut = result.getResultString();
        String cmdOutString = Arrays.toString(cmdOutPut);
        String finalString = cmdOutString.substring(1, cmdOutString.length() - 1);
        Trace.out("cmdOutString   : " + cmdOutString);
        return finalString.trim();
    }

    public NodeRole getNodeConfigRole(String nodeName) throws CmdToolUtilException {
        String[] errorString;
        String[] temp = nodeName.split(DOT_DELIMITER);
        String[] args = new String[]{CRSCTL_GET, CRSCTL_NODE, CRSCTL_ROLE, CRSCTL_CONFIG, CRSCTL_BRIEF, "-node", nodeName = temp[0]};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_CONFIG_NODE_ROLE_FAILED, errorString);
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] output = result.getResultString();
        if (output != null) {
            String[] values = output[0].trim().split(DELIMITER);
            Trace.out("values length = " + values.length);
            if (values.length == 2) {
                Trace.out("Configured node role is " + values[1].toString());
                return NodeRole.getEnumMember(values[1].toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_EXECUTION_FAILED, new Object[0]);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_EMPTY_RESULT, new Object[0]);
    }

    public boolean isMgmtDBRegistered() throws CmdToolUtilException {
        return this.isResourceExists(ResourceLiterals.MGMTDB_RES_NAME.toString());
    }

    public String getSpfileMgmtDB() throws NotExistsException, CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, ORA_MGMTDB, CRSCTL_PROF_FLAG};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_MGMTDB_FAILED, sb.toString());
        }
        String[] cmdOutPut = result.getResultString();
        String cmdOutString = Utils.getString(cmdOutPut, Constants.LINE_SEPARATOR);
        Trace.out("Command output is \n" + cmdOutString);
        String spfile = "";
        if (cmdOutString.startsWith(CRS_RES_NOT_REGISTERED)) {
            throw new NotExistsException((MessageKey)PrCtMsgID.SRVCTL_MGMTDB_FAILED, cmdOutString);
        }
        int index = cmdOutString.indexOf("SPFILE=");
        if (index != -1) {
            int beg = cmdOutString.indexOf(61, index);
            int end = cmdOutString.indexOf(Constants.LINE_SEPARATOR, index);
            if (beg != -1 && end != 1 && end != beg + 1) {
                spfile = cmdOutString.substring(beg + 1, end);
                Trace.out("spfile of mgmtdb = " + spfile);
            }
        }
        return spfile;
    }

    public String[] getMgmtLsnrAddrs() throws CmdToolUtilException {
        String[] args = new String[]{CRSCTL_COMMAND_STAT, CRSCTL_ENTITY_RESOURCE, ORA_MGMTLSNR, CRSCTL_RUNTIME_FLAG};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        String[] output = result.getResultString();
        if (!result.getBooleanResult() && output != null && output.length > 0) {
            Trace.out((Object)"m_cmdtool.execute failed. Error: %s", result.getErrorString());
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < output.length; ++i) {
                sb.append(output[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
        }
        String[] addrs = new String[]{};
        String stateDetails = ResourceLiterals.STATE_DETAILS.toString();
        for (String out : output) {
            if (!out.startsWith(stateDetails)) continue;
            String addrStr = out.substring(stateDetails.length() + 1);
            Trace.out((Object)"addrStr: %s", addrStr);
            addrs = addrStr.split(" ");
            break;
        }
        return addrs;
    }
}

