/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class CEMUTLUtil {
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle(PrCtMsgID.facility);
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String CEMUTL = this.nativeSystem.getExeName("cemutlo");
    private static final String CEM_EXE_LOC = "bin";
    private final String[] CEMUTL_DEP = new String[]{this.CEMUTL};
    private static final String CEM_CLUSTER_NAME = "-n";
    private static final String NEWLINE = Constants.LINE_SEPARATOR;
    private CmdToolUtil m_cmdtool;

    public CEMUTLUtil(String crsHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(crsHome, true);
        String cemloc = crsHome + File.separator + CEM_EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(this.CEMUTL, cemloc, this.CEMUTL_DEP);
    }

    public String getClusterName() throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = this.m_cmdtool.execute(new String[]{CEM_CLUSTER_NAME}, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_ORCL_CLUSTER_NAME, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] res = result.getResultString();
        res[0] = res[0].trim();
        return res[0];
    }
}

