/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.cmdtools.CRSCTLUtil;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.deployment.ASMDGInfo;
import oracle.cluster.deployment.ASMStatusInfo;
import oracle.cluster.deployment.ClientClusterInfo;
import oracle.cluster.deployment.VolumeInfo;
import oracle.cluster.helper.HelperException;
import oracle.cluster.helper.HelperUtil;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ASMCMDUtil {
    private CmdToolUtil m_cmdtool;
    private String[] m_envs;
    private String m_crsHome;
    private Version m_version;
    private boolean m_isPre121;
    private String m_oracleSIDName = null;
    private String m_owner = null;
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String ASMCMD = this.nativeSystem.getScriptFileName("asmcmd");
    private static final String EXE_LOC = "bin";
    private final String[] ASMCMD_DEP = new String[]{this.ASMCMD};
    private static final String ASMCMD_VOLINFO = "volinfo";
    private static final String ASMCMD_CREATE = "volcreate";
    private static final String ASMCMD_DELETE = "voldelete";
    private static final String ASMCMD_ENABLE = "volenable";
    private static final String ASMCMD_DISABLE = "voldisable";
    private static final String ASMCMD_RESIZE = "volresize";
    private static final String ASMCMD_LSATTR = "lsattr";
    private static final String ASMCMD_LSCC = "lscc";
    private static final String ASMCMD_VOLINFO_DG_OPT = "--show_diskgroup";
    private static final String ASMCMD_VOLINFO_VOL_OPT = "--show_volume";
    private static final String ASMCMD_VOLINFO_ALL_OPT = "--all";
    private static final String ASMCMD_CRVOL_DGOPT = "-G";
    private static final String ASMCMD_CRVOL_SZOPT = "-s";
    private static final String ASMCMD_LSATTR_NAME_VAL = "-l";
    private static final String ASMCMD_DISCOVERY_STRING_CMD = "dsget";
    private static final String ASMCMD_SPFILE_GET_CMD = "spget";
    private static final String ASMCMD_PWDFILE_GET_CMD = "pwget";
    private static final String ASMCMD_PWDFILE_ASM_OPT = "--asm";
    private static final String ASMCMD_DISCOVERY_STRING_LOCATION = "--normal";
    private static final String ASMCMD_LS_CMD = "ls";
    private static final String ASMCMD_LSDG_CMD = "lsdg";
    private static final String ASMCMD_LSDISK_CMD = "lsdsk";
    private static final String ASMCMD_MKDIR_CMD = "mkdir";
    private static final String ASMCMD_RM_CMD = "rm";
    private static final String ASMCMD_FORCE_OPT = "-f";
    private static final String ASMCMD_LSDISK_LIBRARY_OPT = "-k";
    private static final String ASMCMD_NOHDR_OPT = "--suppressheader";
    private static final String ASMCMD_NOCP_OPT = "--nocp";
    private static final String ASMCMD_COMPATIBLE_ADVM = "compatible.advm";
    private static final String ASMCMD_PRIVILEGE_OPT = "--privilege";
    private static final String ASMCMD_PRIVILEGE_PRE11202_OPT = "-a";
    private static final String ASMCMD_SYSDBA_PRIVLEGE = "sysdba";
    private static final String ASMCMD_OUTPUT_DISKGROUP_NAME = "Diskgroup Name";
    private static final String ASMCMD_OUTPUT_VOLUME_NAME = "Volume Name";
    private static final String ASMCMD_OUTPUT_VOLUME_DEVICE = "Volume Device";
    private static final String ASMCMD_OUTPUT_STATE = "State";
    private static final String ASMCMD_OUTPUT_SIZE = "Size (MB)";
    private static final String ASMCMD_OUTPUT_RESIZE = "Resize Unit (MB)";
    private static final String ASMCMD_OUTPUT_REDUNDANCY = "Redundancy";
    private static final String ASMCMD_OUTPUT_STRIPE_COLUMNS = "Stripe Columns";
    private static final String ASMCMD_OUTPUT_STRIPE_WIDTH = "Stripe Width (K)";
    private static final String ASMCMD_OUTPUT_USAGE = "Usage";
    private static final String ASMCMD_OUTPUT_MOUNTPATH = "Mountpath";
    private static final String ASMCMD_MSG_NO_DEVICE = "no device name";
    private static final String ASMCMD_MSG_NO_VOLS = "no volumes found";
    public static final String ASMCMD_MSG_NO_SPACE = "ORA-15041";
    public static final String ASMCMD_MSG_NO_DSKGP = "ORA-15001";
    public static final String ASMCMD_MSG_VOL_INUSE = "ORA-15460";
    public static final String ASMCMD_MSG_NO_VOLUME = "ORA-15466";
    public static final String ASMCMD_MSG_ALIAS_EXISTS = "ORA-15005";
    public static final String ASMCMD_MSG_NOT_EXIST = "ASMCMD-8002";
    private static final String ASMCMD_MSG_NO_CLIENT_CLUSTER = "KFOD-00332";
    private static final String DELIMITER = "\\s+";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String EQUAL = "=";
    private static final String ORACLE_HOME_ENV = "ORACLE_HOME";
    private static final String ORACLE_SID_ENV = "ORACLE_SID";
    private static final String PATH_ENV = "PATH";
    private static final String ASM_REMOTE = "remote";
    private static final String ASM_CLIENT = "client";

    public ASMCMDUtil(String crshome) throws CmdToolUtilException {
        this(crshome, null, null);
    }

    public ASMCMDUtil(String crshome, String oracleSID, Version version) throws CmdToolUtilException {
        CmdToolUtil.assertDir(crshome, true);
        this.m_crsHome = crshome;
        String toolLoc = crshome + File.separator + EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(this.ASMCMD, toolLoc, this.ASMCMD_DEP);
        CmdToolUtil crsctlTool = new CmdToolUtil(CRSCTLUtil.CRSCTLUTL, toolLoc, CRSCTLUtil.CRSCTLUTL_DEP);
        this.m_version = version == null ? this.getReleaseVersionObj() : version;
        if (oracleSID != null) {
            this.m_oracleSIDName = oracleSID;
        } else {
            this.m_isPre121 = Version.isPre12c(this.m_version);
            boolean isRemote = false;
            boolean isASMClient = false;
            if (!this.m_isPre121) {
                try {
                    new HelperUtil();
                    ASMStatusInfo asmStatusInfo = HelperUtil.getASMStatusInfo();
                    String asmMode = asmStatusInfo.getASMModeStr();
                    Trace.out("ASM mode=" + asmMode);
                    if (asmMode.equals(ASM_REMOTE)) {
                        isRemote = true;
                        Trace.out("isRemote=" + isRemote);
                    } else if (asmMode.equals(ASM_CLIENT)) {
                        isASMClient = true;
                        Trace.out("isASMClient = " + isASMClient);
                    }
                }
                catch (HelperException e) {
                    Trace.out("The default mode is LEGACY");
                }
            }
            if (!isRemote && !isASMClient) {
                try {
                    String[] output;
                    String[] errorString;
                    String nodeName = Utils.getLocalNodeName();
                    Trace.out("nodeName = " + nodeName);
                    boolean sidfound = false;
                    String[] args = new String[]{"stat", "resource", ResourceLiterals.ASM_RES_NAME.toString(), "-n", nodeName, "-p", "-e"};
                    CommandResult result = crsctlTool.execute(args, null);
                    if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
                        Trace.out("m_cmdtool.execute failed. Error String = " + result.getErrorString());
                        StringBuilder sb = new StringBuilder("");
                        for (int i = 0; i < errorString.length; ++i) {
                            sb.append(errorString[i]);
                        }
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.CRSCTL_FAIL, sb.toString());
                    }
                    for (String attr : output = result.getResultString()) {
                        String[] nv;
                        if (attr.startsWith("USR_ORA_INST_NAME")) {
                            nv = attr.split(EQUAL);
                            this.m_oracleSIDName = nv[1].trim();
                            Trace.out("instname=%s, nodename=%s", this.m_oracleSIDName, nodeName);
                            sidfound = true;
                        } else if (attr.startsWith("ACL")) {
                            nv = attr.split(EQUAL);
                            String ACL2 = nv[1].trim();
                            String[] vals = ACL2.split(String.valueOf(':'));
                            this.m_owner = vals[1];
                            Trace.out("ASM owner is " + this.m_owner);
                        }
                        if (sidfound && this.m_owner != null) break;
                    }
                    if (!sidfound) {
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_ORACLE_SID_FAIL, crshome);
                    }
                }
                catch (UnknownHostException e) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_ORACLE_SID_FAIL, (Throwable)e, crshome);
                }
            }
        }
        this.m_envs = this.m_oracleSIDName == null || this.m_oracleSIDName.equals("") ? new String[2] : new String[3];
        this.m_envs[0] = "PATH=" + System.getenv(PATH_ENV);
        this.m_envs[1] = "ORACLE_HOME=" + crshome;
        if (this.m_oracleSIDName != null && !this.m_oracleSIDName.equals("")) {
            this.m_envs[2] = "ORACLE_SID=" + this.m_oracleSIDName;
        }
    }

    public String getOracleSID() {
        return this.m_oracleSIDName;
    }

    public String getASMOwner() {
        return this.m_owner;
    }

    public List<ClientClusterInfo> getClientClusterInfo() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ASMCMD_LSCC, ASMCMD_NOHDR_OPT, ASMCMD_LSATTR_NAME_VAL};
        ArrayList<ClientClusterInfo> cclist = new ArrayList<ClientClusterInfo>();
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed to get client clusters: " + errorString);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_CLIENT_CLUSTERS_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr == null || resultArr.length == 0) {
            Trace.out("Client cluster does not exist.");
            return cclist;
        }
        int resultArrLen = resultArr.length;
        for (int i = 0; i < resultArrLen; ++i) {
            String resultStr = resultArr[i].trim();
            Trace.out("resultArr[" + i + "] is " + resultStr);
            if (resultStr.equals("")) continue;
            if (resultStr.startsWith(ASMCMD_MSG_NO_CLIENT_CLUSTER)) {
                return cclist;
            }
            String[] values = resultStr.split(DELIMITER);
            if (values.length != 3 && values.length != 4) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_PARSE_VALUE_FAIL, resultStr, this.m_cmdtool.getSourceLocation());
            }
            try {
                if (values.length == 3) {
                    cclist.add(new ClientClusterInfo(values[0].trim(), Version.getVersion(values[1].trim()), values[2]));
                    continue;
                }
                cclist.add(new ClientClusterInfo(values[0].trim(), Version.getVersion(values[1].trim()), values[2], values[3].trim()));
                continue;
            }
            catch (ConfigurationException e) {
                throw new CmdToolUtilException(e);
            }
        }
        return cclist;
    }

    public String getDiskGroupName(String volDevice) throws NotExistsException, CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_VOLINFO, ASMCMD_VOLINFO_DG_OPT, volDevice} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_VOLINFO, ASMCMD_VOLINFO_DG_OPT, volDevice};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed with specified vol device, " + volDevice);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_DG_FAIL, volDevice, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        if (resultArr[0].startsWith(ASMCMD_MSG_NO_DEVICE)) {
            Trace.out("volume device does not exist. Error: " + resultArr[0]);
            throw new NotExistsException((MessageKey)PrCtMsgID.ASMCMD_VOL_DEVICE_NOT_EXIST, volDevice, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
        }
        String dgName = this.parseOutput(null, resultArr, 0, 0);
        Trace.out("Disk group name = " + dgName);
        return dgName;
    }

    public String getVolumeName(String volDevice) throws NotExistsException, CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_VOLINFO, ASMCMD_VOLINFO_VOL_OPT, volDevice} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_VOLINFO, ASMCMD_VOLINFO_VOL_OPT, volDevice};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed with specified vol device, " + volDevice);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_VOL_NAME_FAIL, volDevice, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        if (resultArr[0].startsWith(ASMCMD_MSG_NO_DEVICE)) {
            Trace.out("volume device does not exist. Error: " + resultArr[0]);
            throw new NotExistsException((MessageKey)PrCtMsgID.ASMCMD_VOL_DEVICE_NOT_EXIST, volDevice, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
        }
        String volName = this.parseOutput(null, result.getResultString(), 0, 0);
        Trace.out("Volume name = " + volName);
        return volName;
    }

    public List<VolumeInfo> getVolumes() throws NotExistsException, CmdToolUtilException {
        return this.getVolumes(null);
    }

    public List<VolumeInfo> getVolumes(String userName) throws NotExistsException, CmdToolUtilException {
        String[] args = new String[]{ASMCMD_NOCP_OPT, ASMCMD_VOLINFO, ASMCMD_VOLINFO_ALL_OPT};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, userName, true, false);
        Trace.out("Called asmcmd --nocp volinfo --all");
        if (!result.getBooleanResult()) {
            Trace.out("Return the error exit code: " + result.getBooleanResult());
            String[] errorString = result.getResultString();
            if (errorString != null && errorString.length > 0) {
                Trace.out("m_cmdtool.execute failed to get volumes.");
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_VOLS_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
            }
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        if (resultArr[0].startsWith(ASMCMD_MSG_NO_VOLS)) {
            Trace.out("volume device does not exist. Error: " + resultArr[0]);
            throw new NotExistsException((MessageKey)PrCtMsgID.ASMCMD_NO_VOLUME, this.m_cmdtool.getSourceLocation());
        }
        int arrLen = resultArr.length;
        Trace.out("arrLen is " + arrLen);
        int indx = 0;
        ArrayList<VolumeInfo> volumeInfoArr = new ArrayList<VolumeInfo>();
        String dgName = "";
        String volName = "";
        String volDevice = "";
        String state = "";
        String size = "";
        String resize = "";
        String redundancy = "";
        String stripeColumns = "";
        String stripeWidth = "";
        String usage = "";
        String mountpath = "";
        boolean bAddVolume = false;
        while (indx < arrLen) {
            String resultLine = resultArr[indx++].trim();
            Trace.out("Parse line [" + indx + "]: " + resultLine);
            if (resultLine.equals("")) continue;
            if (resultLine.indexOf(58) < 0) {
                Trace.out("Skip the line: " + resultLine);
                continue;
            }
            String[] values = resultLine.split(String.valueOf(':'));
            if (values[0].equals(ASMCMD_OUTPUT_DISKGROUP_NAME)) {
                dgName = values[1].trim();
                Trace.out("Diskgroup name: " + dgName);
            } else if (values[0].equals(ASMCMD_OUTPUT_VOLUME_NAME)) {
                bAddVolume = false;
                volName = values[1].trim();
                Trace.out("Volume Name: " + volName);
            } else if (values[0].equals(ASMCMD_OUTPUT_VOLUME_DEVICE)) {
                volDevice = values[1].trim();
                Trace.out("Volume Device: " + volDevice);
            } else if (values[0].equals(ASMCMD_OUTPUT_STATE)) {
                state = values[1].trim();
                Trace.out("State: " + state);
            } else if (values[0].equals(ASMCMD_OUTPUT_SIZE)) {
                size = values[1].trim();
                Trace.out("Size Unit (MB): " + size);
            } else if (values[0].equals(ASMCMD_OUTPUT_RESIZE)) {
                resize = values[1].trim();
                Trace.out("Resize Unit (MB): " + resize);
            } else if (values[0].equals(ASMCMD_OUTPUT_REDUNDANCY)) {
                redundancy = values[1].trim();
                Trace.out("Redundancy: " + redundancy);
            } else if (values[0].equals(ASMCMD_OUTPUT_STRIPE_COLUMNS)) {
                stripeColumns = values[1].trim();
                Trace.out("Stripe Columns: " + stripeColumns);
            } else if (values[0].equals(ASMCMD_OUTPUT_STRIPE_WIDTH)) {
                stripeWidth = values[1].trim();
                Trace.out("Stripe Width (K): " + stripeWidth);
            } else if (values[0].equals(ASMCMD_OUTPUT_USAGE)) {
                usage = values.length == 2 ? values[1].trim() : "";
                Trace.out("Usage: " + usage);
            } else if (values[0].equals(ASMCMD_OUTPUT_MOUNTPATH)) {
                bAddVolume = true;
                mountpath = values.length == 2 ? values[1].trim() : "";
                Trace.out("Mountpath: " + mountpath);
            }
            if (!bAddVolume) continue;
            Trace.out("Add the new volume " + dgName + "." + volName);
            volumeInfoArr.add(new VolumeInfo(dgName, volName, volDevice, state, size, resize, redundancy, stripeColumns, stripeWidth, usage, mountpath));
        }
        return volumeInfoArr;
    }

    public void createVolumeMB(String dgName, String volName, int size) throws NotExistsException, CmdToolUtilException, AlreadyExistsException {
        this.doCreateVolume(dgName, volName, size, this.m_owner, StorageUnit.M);
    }

    public void createVolumeMB(String dgName, String volName, String user, int size) throws NotExistsException, CmdToolUtilException, AlreadyExistsException {
        this.doCreateVolume(dgName, volName, size, user, StorageUnit.M);
    }

    public void createVolume(String dgname, String volname, int size) throws NotExistsException, CmdToolUtilException, AlreadyExistsException {
        this.doCreateVolume(dgname, volname, size, null, StorageUnit.G);
    }

    public void createVolume(String dgname, String volname, int size, String user) throws NotExistsException, CmdToolUtilException, AlreadyExistsException {
        this.doCreateVolume(dgname, volname, size, user, StorageUnit.G);
    }

    public void doCreateVolume(String dgname, String volname, int size, String user) throws NotExistsException, CmdToolUtilException, AlreadyExistsException {
        this.doCreateVolume(dgname, volname, size, user, StorageUnit.G);
    }

    private void doCreateVolume(String dgname, String volname, int size, String user, StorageUnit volMeasure) throws NotExistsException, CmdToolUtilException, AlreadyExistsException {
        String sz = Integer.toString(size);
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_CREATE, ASMCMD_CRVOL_DGOPT, dgname, ASMCMD_CRVOL_SZOPT, sz + volMeasure.getValue(), volname} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_CREATE, ASMCMD_CRVOL_DGOPT, dgname, ASMCMD_CRVOL_SZOPT, sz + volMeasure.getValue(), volname};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, user, true, true);
        this.print_outputTrace(result.getResultString());
        String[] resultArr = result.getResultString();
        if (!result.getBooleanResult()) {
            if (resultArr != null && resultArr.length >= 1) {
                if (resultArr[1].startsWith(ASMCMD_MSG_VOL_INUSE)) {
                    Trace.out("Volume already exits ");
                    throw new AlreadyExistsException((MessageKey)PrCtMsgID.ASMCMD_VOL_IN_USE, volname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
                }
                if (resultArr[1].startsWith(ASMCMD_MSG_NO_SPACE)) {
                    Trace.out("Insufficient space to create volume . Error: " + resultArr[0]);
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_DG_NO_SPACE, dgname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
                }
                if (resultArr[1].startsWith(ASMCMD_MSG_NO_DSKGP)) {
                    Trace.out("Disk group does not exist. Error: " + resultArr[0]);
                    throw new NotExistsException((MessageKey)PrCtMsgID.ASMCMD_DG_NOT_EXIST, dgname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
                }
                Trace.out("m_cmdtool.execute failed with volume creation error for " + volname);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_CR_VOL_FAIL, volname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
            }
            Trace.out("m_cmdtool.execute failed with volume creation error for " + volname);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_CR_VOL_FAIL, volname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
        }
        boolean isVolCreated = false;
        List vol = null;
        int checkIndex = 1;
        int timeout = this.nativeSystem.isUnixSystem() ? 30 : 60;
        do {
            try {
                Trace.out("Check if volume resource for volume " + volname + " has been created");
                Trace.out("Check #" + checkIndex);
                vol = ASMFactory.getInstance().getVolumes(null, volname, null);
                isVolCreated = true;
            }
            catch (NotExistsException nee) {
                Trace.out("Volume resource for volume " + volname + " has not been created yet");
                if (++checkIndex > timeout) {
                    throw new CmdToolUtilException(nee);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    throw new CmdToolUtilException(ie);
                }
            }
            catch (SoftwareModuleException sme) {
                throw new CmdToolUtilException(sme);
            }
        } while (!isVolCreated);
    }

    public void deleteVolume(String volname, String dgname) throws NotExistsException, CmdToolUtilException {
        this.doDeleteVolume(volname, dgname, null);
    }

    public void deleteVolume(String volname, String dgname, String user) throws NotExistsException, CmdToolUtilException {
        this.doDeleteVolume(volname, dgname, user);
    }

    public void doDeleteVolume(String volname, String dgname, String user) throws NotExistsException, CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_DELETE, ASMCMD_CRVOL_DGOPT, dgname, volname} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_DELETE, ASMCMD_CRVOL_DGOPT, dgname, volname};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, user, true, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed to delete volume , " + volname);
            for (String errStr : errorString) {
                Trace.out("errStr: " + errStr);
                if (errStr.indexOf(ASMCMD_MSG_NO_VOLUME) == -1) continue;
                Trace.out("Volume does not exist. Error: " + errStr);
                throw new NotExistsException((MessageKey)PrCtMsgID.ASMCMD_VOLUME_NOT_EXIST, volname, dgname, Utils.getString(errorString, NEWLINE));
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_DEL_VOL_FAIL, volname, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            if (resultArr[0].startsWith(ASMCMD_MSG_NO_DSKGP)) {
                Trace.out("Disk group does not exist. Error: " + resultArr[0]);
                throw new NotExistsException((MessageKey)PrCtMsgID.ASMCMD_DG_NOT_EXIST, dgname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
            }
            if (resultArr[0].startsWith(ASMCMD_MSG_VOL_INUSE)) {
                Trace.out("Disk group does not exist. Error: " + resultArr[0]);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_VOL_IN_USE, volname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
            }
        }
    }

    public void resizeVolume(String dgname, String volname, int size) throws NotExistsException, CmdToolUtilException {
        String[] errorString;
        String sz = Integer.toString(size);
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_RESIZE, ASMCMD_CRVOL_DGOPT, dgname, ASMCMD_CRVOL_SZOPT, sz + "G", volname} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_RESIZE, ASMCMD_CRVOL_DGOPT, dgname, ASMCMD_CRVOL_SZOPT, sz + "G", volname};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true, false);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed with volume resize error for " + volname);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_RESIZE_VOL_FAIL, this.m_cmdtool.getSourceLocation(), volname, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            if (resultArr[0].startsWith(ASMCMD_MSG_NO_SPACE)) {
                Trace.out("Insufficient space to resize volume. Error: " + resultArr[0]);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_DG_NO_SPACE, dgname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
            }
            if (resultArr[0].startsWith(ASMCMD_MSG_NO_DSKGP)) {
                Trace.out("Disk group does not exist. Error: " + resultArr[0]);
                throw new NotExistsException((MessageKey)PrCtMsgID.ASMCMD_DG_NOT_EXIST, dgname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
            }
        }
    }

    public String getVolumeDevice(String dgname, String volname) throws NotExistsException, CmdToolUtilException {
        return this.doGetVolumeDevice(dgname, volname, null);
    }

    public String getVolumeDeviceACFS(String dgname, String volname) throws NotExistsException, CmdToolUtilException {
        return this.doGetVolumeDevice(dgname, volname, this.m_owner);
    }

    public String getVolumeDevice(String dgname, String volname, String user) throws NotExistsException, CmdToolUtilException {
        return this.doGetVolumeDevice(dgname, volname, user);
    }

    private String doGetVolumeDevice(String dgname, String volname, String user) throws NotExistsException, CmdToolUtilException {
        int row;
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_VOLINFO, ASMCMD_CRVOL_DGOPT, dgname, volname} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_VOLINFO, ASMCMD_CRVOL_DGOPT, dgname, volname};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, user, true, false);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed with specified vol name, " + volname);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_VOL_DEV_FAIL, volname, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        if (resultArr[0].startsWith(ASMCMD_MSG_NO_DEVICE)) {
            Trace.out("volume device does not exist. Error: " + resultArr[0]);
            throw new NotExistsException((MessageKey)PrCtMsgID.ASMCMD_VOL_DEVICE_NOT_EXIST, volname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
        }
        for (row = 0; row < resultArr.length && !resultArr[row].contains(ASMCMD_OUTPUT_VOLUME_DEVICE); ++row) {
        }
        String volDevice = this.parseOutput(null, result.getResultString(), row, 3);
        Trace.out("Volume Device = " + volDevice);
        return volDevice;
    }

    private String parseOutput(String nodename, String[] strArr, int row, int col) throws CmdToolUtilException {
        this.print_outputTrace(strArr);
        if (strArr == null || strArr.length <= row) {
            if (nodename == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_PARSE_OUTPUT_NODE_FAIL, nodename, this.m_cmdtool.getSourceLocation());
        }
        String[] values = strArr[row].split(DELIMITER);
        if (values.length <= col) {
            if (nodename == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_PARSE_VALUE_FAIL, strArr[row], this.m_cmdtool.getSourceLocation());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_PARSE_VALUE_NODE_FAIL, strArr[row], nodename, this.m_cmdtool.getSourceLocation());
        }
        Trace.out("Returned value from parseOutput = >" + values[col] + "<");
        return values[col];
    }

    private void print_outputTrace(String[] result) {
        if (result != null && result.length > 0) {
            for (int i = 0; i < result.length; ++i) {
                Trace.out("result[" + i + "] = " + result[i]);
            }
        }
    }

    public String getSPFileLocation() throws CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_SPFILE_GET_CMD} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_SPFILE_GET_CMD};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed while trying to retrieve SPFILE location");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_SPFILE_LOCATION_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr == null || resultArr.length == 0 || resultArr[0].trim().isEmpty()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_SPFILE_LOCATION_EMPTY, this.m_cmdtool.getSourceLocation());
        }
        this.print_outputTrace(resultArr);
        return resultArr[0];
    }

    public String getPWDFileLocation() throws CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_PWDFILE_GET_CMD, ASMCMD_PWDFILE_ASM_OPT} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_PWDFILE_GET_CMD, ASMCMD_PWDFILE_ASM_OPT};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed while trying to retrieve PWDFILE location");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_PWDFILE_LOCATION_FAIL, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr == null || resultArr.length == 0 || resultArr[0].trim().isEmpty()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_PWDFILE_LOCATION_EMPTY, new Object[0]);
        }
        this.print_outputTrace(resultArr);
        return resultArr[0];
    }

    public boolean checkASMFilePathExists(String filePath) throws CmdToolUtilException {
        return this.checkASMFilePathExists(filePath, false);
    }

    public boolean checkASMFilePathExists(String filePath, boolean asSysdba) throws CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? (asSysdba ? new String[]{ASMCMD_PRIVILEGE_PRE11202_OPT, ASMCMD_SYSDBA_PRIVLEGE, ASMCMD_LS_CMD, filePath} : new String[]{ASMCMD_LS_CMD, filePath}) : (asSysdba ? new String[]{ASMCMD_NOCP_OPT, ASMCMD_PRIVILEGE_OPT, ASMCMD_SYSDBA_PRIVLEGE, ASMCMD_LS_CMD, filePath} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_LS_CMD, filePath});
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed while checking existence of ASM path");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_LS_LOCATION_FAIL, filePath, Utils.getString(errorString, NEWLINE));
        }
        return result.getBooleanResult();
    }

    public List<String> getAllDiscoveryStrings() throws CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_DISCOVERY_STRING_CMD, ASMCMD_DISCOVERY_STRING_LOCATION} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_DISCOVERY_STRING_CMD, ASMCMD_DISCOVERY_STRING_LOCATION};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed while trying to retrieve discovery string ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_GET_DISCOVERY_STRING_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        List<String> resultList = Arrays.asList(resultArr);
        return resultList;
    }

    public List<ASMDGInfo> getDGInfo() throws CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_LSDG_CMD, ASMCMD_NOHDR_OPT} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_LSDG_CMD, ASMCMD_NOHDR_OPT};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed to get disk group information from lsdg");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_LSDG_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        ArrayList<ASMDGInfo> resultList = new ArrayList<ASMDGInfo>();
        for (String inline : resultArr) {
            ASMDGInfo resultElement = new ASMDGInfo(inline);
            resultList.add(resultElement);
        }
        return resultList;
    }

    public List<String> getASMDisks() throws CmdToolUtilException {
        String[] errorString;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_LSDISK_CMD, ASMCMD_LSDISK_LIBRARY_OPT, ASMCMD_NOHDR_OPT} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_LSDISK_CMD, ASMCMD_LSDISK_LIBRARY_OPT, ASMCMD_NOHDR_OPT};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute  failed to get list of disks running");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_LSDSK_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        List<String> resultList = Arrays.asList(resultArr);
        return resultList;
    }

    public Version getADVMCompatibility(String dgName) throws CmdToolUtilException {
        return this.doGetADVMCompatibility(dgName, null);
    }

    public Version getADVMCompatibility(String dgName, String username) throws CmdToolUtilException {
        return this.doGetADVMCompatibility(dgName, username);
    }

    private Version doGetADVMCompatibility(String dgName, String user) throws CmdToolUtilException {
        String[] errorString;
        String versionStr = null;
        Version version = null;
        String[] args = this.m_isPre121 ? new String[]{ASMCMD_LSATTR, ASMCMD_CRVOL_DGOPT, dgName, ASMCMD_LSATTR_NAME_VAL, ASMCMD_NOHDR_OPT, ASMCMD_COMPATIBLE_ADVM} : new String[]{ASMCMD_NOCP_OPT, ASMCMD_LSATTR, ASMCMD_CRVOL_DGOPT, dgName, ASMCMD_LSATTR_NAME_VAL, ASMCMD_NOHDR_OPT, ASMCMD_COMPATIBLE_ADVM};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, user, true, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed with specified diskgroup, " + dgName);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_ADVM_COMP_FAIL, dgName, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        if (resultArr != null && resultArr.length > 0) {
            try {
                int row;
                for (row = 0; row < resultArr.length && !resultArr[row].contains("compatible"); ++row) {
                }
                versionStr = this.parseOutput(null, resultArr, row, 1);
                Trace.out("Version string = " + versionStr);
                version = Version.getVersion(versionStr);
                return version;
            }
            catch (ConfigurationException ce) {
                Trace.out("Failed to get version with exception: " + ce.getMessage());
                throw new CmdToolUtilException(ce);
            }
        }
        Trace.out("compatible.advm attribute is not set");
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_ADVM_COMP_NOT_SET, dgName);
    }

    private Version getReleaseVersionObj() throws CmdToolUtilException {
        String versionStr = null;
        Version version = null;
        try {
            CRSCTLUtil crsctlUtil = new CRSCTLUtil(this.m_crsHome);
            ClusterInfo clusterInfo = new ClusterInfo(this.m_crsHome);
            if (crsctlUtil.isSIHA()) {
                versionStr = clusterInfo.getSIHAReleaseVersionString();
                Trace.out("Release SIHA version: " + versionStr);
            } else {
                versionStr = clusterInfo.getCRSReleaseVersionString();
                Trace.out("Release CRS version: " + versionStr);
            }
            version = Version.getVersion(versionStr);
        }
        catch (ClusterInfoException cie) {
            Trace.out("Failed to get Release version with exception: " + cie.getMessage());
            throw new CmdToolUtilException(cie);
        }
        catch (ConfigurationException ce) {
            Trace.out("Failed to get Release version with excepction: " + ce.getMessage());
            throw new CmdToolUtilException(ce);
        }
        return version;
    }

    public String getDGAttribute(String dgName, String attribute) throws CmdToolUtilException {
        String[] errorString;
        String attrVal = null;
        String[] args = this.m_isPre121 ? (Version.isPre11202(this.m_version) ? new String[]{ASMCMD_PRIVILEGE_PRE11202_OPT, ASMCMD_SYSDBA_PRIVLEGE, ASMCMD_LSATTR, ASMCMD_CRVOL_DGOPT, dgName, ASMCMD_LSATTR_NAME_VAL, ASMCMD_NOHDR_OPT, attribute} : new String[]{ASMCMD_PRIVILEGE_OPT, ASMCMD_SYSDBA_PRIVLEGE, ASMCMD_LSATTR, ASMCMD_CRVOL_DGOPT, dgName, ASMCMD_LSATTR_NAME_VAL, ASMCMD_NOHDR_OPT, attribute}) : new String[]{ASMCMD_NOCP_OPT, ASMCMD_PRIVILEGE_OPT, ASMCMD_SYSDBA_PRIVLEGE, ASMCMD_LSATTR, ASMCMD_CRVOL_DGOPT, dgName, ASMCMD_LSATTR_NAME_VAL, ASMCMD_NOHDR_OPT, attribute};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed with specified diskgroup, " + dgName);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_ATTRIBUTE_FAIL, dgName, attribute, this.ASMCMD + " " + Utils.getString(args, " "), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        if (resultArr != null && resultArr.length > 0) {
            int row;
            for (row = 0; row < resultArr.length && !resultArr[row].contains(attribute); ++row) {
            }
            attrVal = this.parseOutput(null, resultArr, row, 1);
            Trace.out("Value of attribute" + attribute + " = " + attrVal);
        } else {
            Trace.out("attribute " + attribute + " is not set");
        }
        return attrVal;
    }

    public HashMap<String, String> getDGAttributeMap(String dgName) throws CmdToolUtilException {
        String[] errorString;
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        String[] args = this.m_isPre121 ? (Version.isPre11202(this.m_version) ? new String[]{ASMCMD_PRIVILEGE_PRE11202_OPT, ASMCMD_SYSDBA_PRIVLEGE, ASMCMD_LSATTR, ASMCMD_CRVOL_DGOPT, dgName, ASMCMD_LSATTR_NAME_VAL, ASMCMD_NOHDR_OPT} : new String[]{ASMCMD_PRIVILEGE_OPT, ASMCMD_SYSDBA_PRIVLEGE, ASMCMD_LSATTR, ASMCMD_CRVOL_DGOPT, dgName, ASMCMD_LSATTR_NAME_VAL, ASMCMD_NOHDR_OPT}) : new String[]{ASMCMD_NOCP_OPT, ASMCMD_PRIVILEGE_OPT, ASMCMD_SYSDBA_PRIVLEGE, ASMCMD_LSATTR, ASMCMD_CRVOL_DGOPT, dgName, ASMCMD_LSATTR_NAME_VAL, ASMCMD_NOHDR_OPT};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed with specified diskgroup, " + dgName);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_ATTRIBUTE_LIST_FAIL, dgName, this.ASMCMD + " " + Utils.getString(args, " "), Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        if (resultArr != null && resultArr.length > 0) {
            String attrName = null;
            String attrVal = null;
            for (int row = 0; row < resultArr.length; ++row) {
                attrName = this.parseOutput(null, resultArr, row, 0);
                attrVal = this.parseOutput(null, resultArr, row, 1);
                attributeMap.put(attrName, attrVal);
            }
        }
        return attributeMap;
    }

    public void mkdir(String dirPath) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ASMCMD_MKDIR_CMD, dirPath};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            boolean succeeded = false;
            for (String s : errorString) {
                if (!s.contains(ASMCMD_MSG_ALIAS_EXISTS)) continue;
                Trace.out("Dir already exists");
                succeeded = true;
                break;
            }
            if (!succeeded) {
                Trace.out("m_cmdtool.execute failed while creating dir");
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_MKDIR_FAIL, dirPath, Utils.getString(errorString, NEWLINE));
            }
        }
    }

    public void rm(String path) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ASMCMD_RM_CMD, ASMCMD_FORCE_OPT, path};
        CommandResult result = this.m_cmdtool.execute(args, this.m_envs, true, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            boolean succeeded = false;
            for (String s : errorString) {
                if (!s.contains(ASMCMD_MSG_NOT_EXIST)) continue;
                Trace.out((Object)"%s does not exist", path);
                succeeded = true;
                break;
            }
            if (!succeeded) {
                Trace.out((Object)"m_cmdtool failed while deleting %s", path);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASMCMD_RM_FAIL, path, Utils.getString(errorString, NEWLINE));
            }
        }
    }

    public static enum StorageUnit {
        M("M"),
        G("G");

        private String m_value;

        private StorageUnit(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public static StorageUnit getMember(String value) throws CmdToolUtilException {
            for (StorageUnit member : StorageUnit.values()) {
                if (!member.getValue().equalsIgnoreCase(value.trim())) continue;
                return member;
            }
            Trace.out("No StorageUnit label member found for value " + value);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "asmcmdSU-MNF");
        }
    }
}

