/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ADVMUtil {
    private CmdToolUtil m_cmdtool;
    private static final String ADVMUTIL_NAME = "advmutil";
    private static final String ADVMUTIL = new SystemFactory().CreateSystem().getExeName("advmutil");
    private static final String ADVMUTIL_EXE_LOC = "bin";
    private final String[] ADVMUTIL_DEP = new String[]{ADVMUTIL};
    private static final String ADVMUTIL_ARG_VOLINFO = "volinfo";
    private static final String ADVMUTIL_ARG_CANONICAL = "canonical";
    private static final String DELIMITER = "\\s+";
    private static final String COL_DELIMITER = ":";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int VOLUME_POS = 8;
    private static final int DISKGROUP_POS = 7;

    public ADVMUtil() throws CmdToolUtilException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        this.m_cmdtool = new CmdToolUtil(ADVMUTIL, nativeSystem.getOFSUtilLocation(), this.ADVMUTIL_DEP);
    }

    public ADVMUtil(String crshome) throws CmdToolUtilException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        this.m_cmdtool = nativeSystem.isUnixSystem() ? new CmdToolUtil(ADVMUTIL, nativeSystem.getOFSUtilLocation(), this.ADVMUTIL_DEP) : new CmdToolUtil(ADVMUTIL, crshome + File.separator + ADVMUTIL_EXE_LOC, this.ADVMUTIL_DEP);
    }

    public String getVolume(String voldevice) throws CmdToolUtilException {
        String[] errorString;
        if (voldevice == null || voldevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        String[] args = new String[]{ADVMUTIL_ARG_VOLINFO, voldevice};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ADVMUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String volume = null;
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            Trace.out("length = " + resultArr.length);
            Trace.out(Utils.getString(resultArr, NEWLINE));
            Trace.out("resultArr[VOLUME_POS] = " + resultArr[8]);
            String[] values = resultArr[8].split(COL_DELIMITER);
            volume = values[1].trim();
        }
        return volume;
    }

    public String getDiskGroup(String voldevice) throws CmdToolUtilException {
        String[] errorString;
        if (voldevice == null || voldevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        String[] args = new String[]{ADVMUTIL_ARG_VOLINFO, voldevice};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ADVMUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String dg = null;
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            Trace.out("length = " + resultArr.length);
            Trace.out(Utils.getString(resultArr, NEWLINE));
            Trace.out("resultArr[DISKGROUP_POS] = " + resultArr[7]);
            String[] values = resultArr[7].split(COL_DELIMITER);
            dg = values[1].trim();
        }
        Trace.out("diskgroup = " + dg);
        return dg;
    }

    public String getCanonicalVolume(String voldevice) throws CmdToolUtilException {
        String[] errorString;
        if (voldevice == null || voldevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        String[] args = new String[]{ADVMUTIL_ARG_CANONICAL, voldevice};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ADVMUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        String canVol = voldevice;
        if (resultArr != null && resultArr.length > 0) {
            Trace.out("length = " + resultArr.length);
            Trace.out(Utils.getString(resultArr, NEWLINE));
            canVol = resultArr[0].trim();
            Trace.out("volume device in canonical form = " + canVol);
        }
        return canVol;
    }
}

