/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.checkpoints;

import java.util.HashMap;
import oracle.cluster.checkpoints.CheckPoint;
import oracle.cluster.checkpoints.CheckPointIndexSession;
import oracle.cluster.checkpoints.CheckPointProperty;
import oracle.cluster.checkpoints.RemoteCheckPointIndexSession;
import oracle.cluster.impl.checkpoints.CheckPointImpl;
import oracle.cluster.impl.checkpoints.CheckPointIndexSessionImpl;
import oracle.cluster.impl.checkpoints.CheckPointPropertyImpl;
import oracle.cluster.impl.checkpoints.RemoteCheckPointIndexSessionImpl;
import oracle.ops.mgmt.trace.Trace;

public class CheckPointFactory {
    private static HashMap m_indexSession = null;
    private static HashMap m_globalIndexSession = null;
    private static HashMap m_remote_indexSession = null;

    public static CheckPointIndexSession getIndexSession(String oracleBase, String component, boolean forGlobalCkpts) {
        HashMap indexSessionCache = null;
        if (forGlobalCkpts) {
            if (m_globalIndexSession == null) {
                m_globalIndexSession = new HashMap();
            }
            indexSessionCache = m_globalIndexSession;
        } else {
            if (m_indexSession == null) {
                m_indexSession = new HashMap();
            }
            indexSessionCache = m_indexSession;
        }
        Trace.out("Checkpoint:getting indexSession from checkpoint factory");
        if (indexSessionCache.containsKey(component)) {
            return (CheckPointIndexSession)indexSessionCache.get(component);
        }
        CheckPointIndexSessionImpl indexSession = new CheckPointIndexSessionImpl(oracleBase, component, forGlobalCkpts);
        indexSessionCache.put(component, indexSession);
        return indexSession;
    }

    public static RemoteCheckPointIndexSession getRemoteIndexSession(String node, String oracleBase, String component) {
        Trace.out("Checkpoint:getting remoteIndexSession from checkpoint factory");
        if (m_remote_indexSession != null) {
            if (m_remote_indexSession.containsKey(component)) {
                return (RemoteCheckPointIndexSession)m_remote_indexSession.get(component);
            }
            RemoteCheckPointIndexSessionImpl oicsRemoteIndexSess = new RemoteCheckPointIndexSessionImpl(node, oracleBase, component);
            m_remote_indexSession.put(component, oicsRemoteIndexSess);
            return oicsRemoteIndexSess;
        }
        m_remote_indexSession = new HashMap();
        RemoteCheckPointIndexSessionImpl oicsRemoteIndexSess = new RemoteCheckPointIndexSessionImpl(node, oracleBase, component);
        m_remote_indexSession.put(component, oicsRemoteIndexSess);
        return oicsRemoteIndexSess;
    }

    public static CheckPointProperty constructStringProperty(String propName, String propValue) {
        CheckPointPropertyImpl oCheckPointproperty = new CheckPointPropertyImpl(propName, 1, propValue);
        return oCheckPointproperty;
    }

    public static CheckPointProperty constructNumericProperty(String propName, int propValue) {
        CheckPointPropertyImpl oCheckPointproperty = new CheckPointPropertyImpl(propName, 2, new Integer(propValue));
        return oCheckPointproperty;
    }

    public static CheckPointProperty constructBooleanProperty(String propName, Boolean propValue) {
        CheckPointPropertyImpl oCheckPointproperty = new CheckPointPropertyImpl(propName, 3, propValue);
        return oCheckPointproperty;
    }

    public static CheckPointProperty constructStringListProperty(String propName, String[] propValue) {
        CheckPointPropertyImpl oCheckPointproperty = new CheckPointPropertyImpl(propName, 4, propValue);
        return oCheckPointproperty;
    }

    public static CheckPoint constructCheckPoint(int level, String checkpointname, String desc) {
        Trace.out("Checkpoint:constructing checkpoint with name:" + checkpointname + " in checkpoint factory");
        CheckPointImpl oCheckPoint = new CheckPointImpl(checkpointname, desc, level);
        return oCheckPoint;
    }
}

