/*
 * Decompiled with CFR 0.152.
 */
package netscape.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeJavaObject;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.Undefined;
import ice.mozilla.javascript.Wrapper;
import ice.pilots.applet.ThePilot;
import ice.scripters.js.CustomContext;
import ice.scripters.js.TheScripter;
import ice.storm.Viewport;
import java.applet.Applet;
import netscape.javascript.JSException;

public class JSObject {
    TheScripter _scripter;
    Scriptable _object;

    public static JSObject getWindow(Applet applet) {
        Viewport view;
        TheScripter scripter;
        ThePilot pilot = ThePilot.getAppletPilot(applet);
        if (pilot != null && (scripter = (TheScripter)pilot.getStorm().getScripter("ECMAScript")) != null && (view = pilot.getPilotViewport()) != null) {
            Viewport parent = view.getParent();
            if (parent != null) {
                view = parent;
            }
            Scriptable wrapper = scripter.getViewportWrapper(view);
            return new JSObject(scripter, wrapper);
        }
        return null;
    }

    public JSObject(TheScripter scripter, Scriptable object) {
        this._scripter = scripter;
        this._object = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMember(String name) {
        CustomContext context = this._scripter.enterContext();
        try {
            Object result = ScriptableObject.getProperty(this._object, name);
            Object object = this.wrapResult(result);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSlot(int index) {
        CustomContext context = this._scripter.enterContext();
        try {
            Object result = ScriptableObject.getProperty(this._object, index);
            Object object = this.wrapResult(result);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMember(String name, Object value) {
        CustomContext context = this._scripter.enterContext();
        try {
            value = this.unwrapArg(value);
            ScriptableObject.putProperty(this._object, name, value);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlot(int index, Object value) {
        CustomContext context = this._scripter.enterContext();
        try {
            value = this.unwrapArg(value);
            ScriptableObject.putProperty(this._object, index, value);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(String name) {
        CustomContext context = this._scripter.enterContext();
        try {
            ScriptableObject.deleteProperty(this._object, name);
        }
        finally {
            Context.exit();
        }
    }

    public Object call(String methodName, Object[] args) {
        CustomContext context = this._scripter.enterContext();
        try {
            args = this.unwrapArgs(args);
            try {
                Object result = ScriptableObject.callMethod(this._object, methodName, args);
                Object object = this.wrapResult(result);
                return object;
            }
            catch (JavaScriptException ex) {
                throw new JSException(ex);
            }
        }
        finally {
            Context.exit();
        }
    }

    public Object eval(String source) {
        CustomContext context = this._scripter.enterContext();
        try {
            Object result = context.evaluateString(this._object, source, "JSObject", 0, null);
            Object object = this.wrapResult(result);
            return object;
        }
        catch (JavaScriptException ex) {
            throw new JSException(ex);
        }
        finally {
            Context.exit();
        }
    }

    public String toString() {
        return this._object.toString();
    }

    private Object wrapResult(Object object) {
        if (object == Undefined.instance) {
            object = null;
        } else if (object instanceof Scriptable) {
            Object real;
            boolean converted = false;
            if (object instanceof Wrapper && (real = ((Wrapper)object).unwrap()) instanceof Applet) {
                object = real;
                converted = true;
            }
            if (!converted) {
                object = new JSObject(this._scripter, (Scriptable)object);
            }
        }
        return object;
    }

    private Object unwrapArg(Object arg) {
        if (arg instanceof JSObject) {
            arg = ((JSObject)arg)._object;
        } else if (arg instanceof Applet) {
            Scriptable scope = ScriptableObject.getTopLevelScope(this._object);
            arg = new NativeJavaObject(scope, arg, null);
        }
        return arg;
    }

    private Object[] unwrapArgs(Object[] args) {
        if (args == null) {
            args = ScriptRuntime.emptyArgs;
        } else {
            boolean copied = false;
            int i = args.length;
            while (i-- != 0) {
                Object arg = args[i];
                Object unwrapped = this.unwrapArg(arg);
                if (unwrapped == arg) continue;
                if (!copied) {
                    args = (Object[])args.clone();
                    copied = true;
                }
                args[i] = unwrapped;
            }
        }
        return args;
    }
}

