/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import ice.debug.Debug;
import ice.util.net.Cookie;
import ice.util.net.CookieSet;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class CookieManager
extends VetoableChangeSupport
implements CookieSet {
    boolean enabled = true;
    private Vector cookies = new Vector();
    private int maxCookieSize = 4096;
    private int maxNumberOfCookies = 1024;
    private int sizeOfAllCookies = -1;
    private int maxSizeOfAllCookies = 100000;
    private static CookieManager cookieManager = null;

    public static CookieManager getInstance() {
        if (cookieManager == null) {
            cookieManager = new CookieManager();
        }
        return cookieManager;
    }

    protected CookieManager() {
        super("Dummy");
    }

    public int getMaxTotalCookieSize() {
        return this.maxSizeOfAllCookies;
    }

    public void setMaxTotalCookieSize(int newSize) {
        this.maxSizeOfAllCookies = newSize;
    }

    public void setMaxCookieSize(int newSize) {
        this.maxCookieSize = newSize;
    }

    public int getMaxCookieSize() {
        return this.maxCookieSize;
    }

    public void setMaxNumberOfCookies(int maxCount) {
        this.maxNumberOfCookies = maxCount;
    }

    public int getMaxNumberOfCookies() {
        return this.maxNumberOfCookies;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Enumeration elements() {
        return this.cookies.elements();
    }

    public Cookie[] getAllCookies() {
        int n = this.cookies.size();
        if (n == 0) {
            return null;
        }
        Cookie[] tmpArray = new Cookie[n];
        for (int i = 0; i < n; ++i) {
            tmpArray[i] = (Cookie)this.cookies.elementAt(i);
        }
        return tmpArray;
    }

    protected boolean extractAllCookies(URL url, URLConnection uc) {
        if (!this.enabled) {
            return false;
        }
        boolean flag = false;
        String key = "";
        int i = 1;
        while (key != null) {
            key = uc.getHeaderFieldKey(i);
            String val = uc.getHeaderField(i);
            if (key != null && val != null && "set-cookie".equalsIgnoreCase(key)) {
                Cookie c;
                if (val.length() > this.maxCookieSize) {
                    return false;
                }
                if (this.cookies.size() >= this.maxNumberOfCookies) {
                    this.cookies.removeElementAt(0);
                }
                if ((c = Cookie.parseFromString(url, val)) != null) {
                    this.addCookie(c);
                    flag = true;
                }
            }
            ++i;
        }
        return flag;
    }

    public void removeAllCookies() {
        this.cookies.removeAllElements();
    }

    public void removeAllSessionCookies() {
        Cookie cookie = null;
        for (int i = 0; i < this.cookies.size(); ++i) {
            cookie = (Cookie)this.cookies.elementAt(i);
            if (!cookie.isSessionCookie()) continue;
            this.cookies.removeElementAt(i);
            --i;
        }
    }

    public void removeAllExpiredCookies() {
        Cookie cookie = null;
        for (int i = 0; i < this.cookies.size(); ++i) {
            cookie = (Cookie)this.cookies.elementAt(i);
            if (!cookie.isExpired()) continue;
            this.cookies.removeElementAt(i);
            --i;
        }
    }

    public synchronized void addCookie(Cookie c) {
        int n = this.cookies.size();
        for (int i = 0; i < n; ++i) {
            Cookie cc = (Cookie)this.cookies.elementAt(i);
            boolean domainIsEqualEnough = false;
            boolean pathIsEqualEnough = false;
            if (cc.getDomain().indexOf(c.getDomain()) != -1 || cc.getDomain().equals(c.getDomain())) {
                domainIsEqualEnough = true;
            }
            if (c.path == null) {
                pathIsEqualEnough = true;
            }
            if (c.path.equals(cc.path) || cc.path.indexOf(c.path) != -1) {
                pathIsEqualEnough = true;
            }
            if (!domainIsEqualEnough || !pathIsEqualEnough || !c.name.equals(cc.name)) continue;
            if (this.checkAccept(cc, c)) {
                this.cookies.setElementAt(c, i);
            }
            return;
        }
        if (this.checkAccept(null, c)) {
            boolean replace = false;
            boolean ditch = false;
            if (this.cookies.size() > this.maxNumberOfCookies) {
                replace = true;
            }
            if (c.size() > this.maxCookieSize) {
                ditch = true;
            }
            if (this.sizeOfAllCookies + c.size() > this.maxSizeOfAllCookies) {
                replace = true;
            }
            if (ditch) {
                return;
            }
            if (replace) {
                if (this.sizeOfAllCookies < 0) {
                    return;
                }
                Cookie k = (Cookie)this.cookies.elementAt(0);
                this.sizeOfAllCookies -= k.size();
                this.sizeOfAllCookies += c.size();
                this.cookies.setElementAt(c, 0);
                return;
            }
            if (this.sizeOfAllCookies < 0) {
                this.sizeOfAllCookies = 0;
            }
            this.sizeOfAllCookies += c.size();
            this.cookies.addElement(c);
        }
    }

    private boolean checkAccept(Cookie oldCookie, Cookie newCookie) {
        try {
            this.fireVetoableChange("Cookie", oldCookie, newCookie);
        }
        catch (PropertyVetoException e) {
            return false;
        }
        return true;
    }

    public void addCookie(String documentUrl, String s) {
        URL urlObj;
        block6: {
            urlObj = null;
            try {
                urlObj = new URL(documentUrl);
            }
            catch (MalformedURLException ex) {
                if (!Debug.ex) break block6;
                Debug.ex(ex);
            }
        }
        if (urlObj != null) {
            Cookie c = Cookie.parseFromString(urlObj, s);
            if (c != null) {
                this.addCookie(c);
            } else if (Debug.trace) {
                Debug.trace("Error: bad cookie str=" + s);
            }
        }
    }

    public String getCookieStr(String documentUrl) {
        URL urlObj;
        block3: {
            urlObj = null;
            try {
                urlObj = new URL(documentUrl);
            }
            catch (MalformedURLException ex) {
                if (!Debug.ex) break block3;
                Debug.ex(ex);
            }
        }
        if (urlObj != null) {
            String s = this.getCookieStr(urlObj);
            return s;
        }
        return null;
    }

    protected void applyAllCookies(URL url, URLConnection uc) {
        String str = this.getCookieStr(url);
        if (str != null && str.length() != 0) {
            ((HttpURLConnection)uc).disconnect();
            uc.setRequestProperty("Cookie", str);
        }
    }

    String getCookieStr(URL url) {
        String host;
        if (!this.enabled) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            int idx;
            String path = url.getFile();
            if (!path.endsWith("/") && (idx = path.lastIndexOf(47)) >= 0) {
                path = path.substring(0, idx + 1);
            }
            int size = this.cookies.size();
            for (int i = 0; i < size; ++i) {
                Cookie c = (Cookie)this.cookies.elementAt(i);
                if (!path.equals(c.getPath())) continue;
                return c.toString();
            }
        }
        if ((host = url.getHost()) == null) {
            return null;
        }
        String proto = url.getProtocol();
        if (!proto.equals("http") && !proto.equals("https")) {
            return null;
        }
        int n = this.cookies.size();
        if (n == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Date now = new Date();
        boolean afterFirstMatch = false;
        for (int i = 0; i != n; ++i) {
            Cookie c = (Cookie)this.cookies.elementAt(i);
            if (c.expires != null && c.expires.before(now) || !this.cookieDomainMatch(host, c.domain)) continue;
            c.use();
            if (afterFirstMatch) {
                sb.append("; ");
            } else {
                afterFirstMatch = true;
            }
            sb.append(c.name);
            sb.append('=');
            sb.append(c.value);
        }
        return sb.toString();
    }

    private boolean cookieDomainMatch(String host, String domain) {
        boolean match = false;
        int dl = domain.length();
        if (dl != 0) {
            int hl;
            if ('.' == domain.charAt(0)) {
                if (dl >= 2 && !(match = host.endsWith(domain)) && host.length() == dl - 1) {
                    match = domain.endsWith(host);
                }
            } else if (host.endsWith(domain) && ((hl = host.length()) == dl || '.' == host.charAt(hl - dl - 1))) {
                match = true;
            }
        }
        return match;
    }

    public synchronized void writeCookies(ObjectOutput out) {
        if (!this.enabled) {
            return;
        }
        try {
            Vector<Cookie> v = new Vector<Cookie>();
            for (int i = 0; i < this.cookies.size(); ++i) {
                Cookie c = (Cookie)this.cookies.elementAt(i);
                if (c.expires == null) {
                    v.addElement(c);
                }
                if (c.expires == null || !c.expires.after(new Date())) continue;
                v.addElement(c);
            }
            out.writeObject(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void readCookies(ObjectInput in) {
        if (!this.enabled) {
            return;
        }
        try {
            Vector v = (Vector)in.readObject();
            for (int i = 0; i < v.size(); ++i) {
                this.addCookie((Cookie)v.elementAt(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vc) {
        super.addVetoableChangeListener(vc);
    }
}

