/*
 * Decompiled with CFR 0.152.
 */
package ice.util.encoding;

public class Base64 {
    private static final byte[] BASE64_ALPHABET_ARRAY = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final String BASE64_ALPHABET_STRING = new String(BASE64_ALPHABET_ARRAY, 0, BASE64_ALPHABET_ARRAY.length);
    private static final byte PAD = 61;

    public static byte[] decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0 || !Base64.encoded(bytes)) {
            return bytes;
        }
        byte[] _bytes = new byte[bytes.length * 3 / 4 - (bytes[bytes.length - 2] == 61 ? 2 : (bytes[bytes.length - 1] == 61 ? 1 : 0))];
        int _index = 0;
        int i = 0;
        while (i < bytes.length) {
            int _group = (BASE64_ALPHABET_STRING.indexOf(bytes[i++]) & 0xFF) << 18 | (BASE64_ALPHABET_STRING.indexOf(bytes[i++]) & 0xFF) << 12 | (BASE64_ALPHABET_STRING.indexOf(bytes[i++]) & 0xFF) << 6 | BASE64_ALPHABET_STRING.indexOf(bytes[i++]) & 0xFF;
            _bytes[_index++] = (byte)(_group >>> 16);
            if (_index < _bytes.length) {
                _bytes[_index++] = (byte)(_group >>> 8 & 0xFF);
            }
            if (_index >= _bytes.length) continue;
            _bytes[_index++] = (byte)(_group & 0xFF);
        }
        return _bytes;
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        return new String(Base64.decode(string.getBytes()));
    }

    public static byte[] encode(byte[] bytes) {
        int _group;
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return bytes;
        }
        int _length = bytes.length;
        byte[] _bytes = new byte[(_length + 2) / 3 * 4];
        int _remainder = _length % 3;
        _length -= _remainder;
        int _index = 0;
        int _i = 0;
        while (_i < _length) {
            _group = (bytes[_i++] & 0xFF) << 16 | (bytes[_i++] & 0xFF) << 8 | bytes[_i++] & 0xFF;
            _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group >>> 18];
            _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group >>> 12 & 0x3F];
            _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group >>> 6 & 0x3F];
            _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group & 0x3F];
        }
        switch (_remainder) {
            case 0: {
                break;
            }
            case 1: {
                _group = (bytes[_i] & 0xFF) << 4;
                _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group >>> 6];
                _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group & 0x3F];
                _bytes[_index++] = 61;
                _bytes[_index] = 61;
                break;
            }
            case 2: {
                _group = ((bytes[_i++] & 0xFF) << 8 | bytes[_i] & 0xFF) << 2;
                _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group >>> 12];
                _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group >>> 6 & 0x3F];
                _bytes[_index++] = BASE64_ALPHABET_ARRAY[_group & 0x3F];
                _bytes[_index] = 61;
                break;
            }
        }
        return _bytes;
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        return new String(Base64.encode(string.getBytes()));
    }

    public static boolean encoded(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        if (bytes.length % 4 != 0) {
            return false;
        }
        boolean _paddingReached = false;
        for (int i = 0; i < bytes.length; ++i) {
            int _index = BASE64_ALPHABET_STRING.indexOf(bytes[i]);
            if (_index == -1 && bytes[i] != 61 || _index != -1 && _paddingReached) {
                return false;
            }
            if (bytes[i] != 61 || _paddingReached) continue;
            _paddingReached = true;
        }
        return true;
    }

    public static boolean encoded(String string) {
        if (string == null) {
            return false;
        }
        return Base64.encoded(string.getBytes());
    }
}

