/*
 * Decompiled with CFR 0.152.
 */
package ice.storm.print;

import ice.debug.Debug;
import ice.storm.print.PageDecoration;
import ice.util.Defs;
import ice.util.unit.Unit;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Serializable;
import java.util.Vector;

public class StormPageFormat
implements Cloneable,
Serializable {
    public static final int NA_LETTER = 0;
    public static final int TABLOID = 1;
    public static final int EXECUTIVE = 2;
    public static final int NA_LEGAL = 3;
    public static final int LEDGER = 4;
    public static final int ISO_4A = 5;
    public static final int ISO_2A = 6;
    public static final int ISO_A0 = 7;
    public static final int ISO_A1 = 8;
    public static final int ISO_A2 = 9;
    public static final int ISO_A3 = 10;
    public static final int ISO_A4 = 11;
    public static final int ISO_A5 = 12;
    public static final int ISO_A6 = 13;
    public static final int ISO_A7 = 14;
    public static final int ISO_A8 = 15;
    public static final int ISO_A9 = 16;
    public static final int ISO_A10 = 17;
    public static final int ISO_4B = 18;
    public static final int ISO_2B = 19;
    public static final int ISO_B0 = 20;
    public static final int ISO_B1 = 21;
    public static final int ISO_B2 = 22;
    public static final int ISO_B3 = 23;
    public static final int ISO_B4 = 24;
    public static final int ISO_B5 = 25;
    public static final int ISO_B6 = 26;
    public static final int ISO_B7 = 27;
    public static final int ISO_B8 = 28;
    public static final int ISO_B9 = 29;
    public static final int ISO_B10 = 30;
    public static final int ISO_C0 = 31;
    public static final int ISO_C1 = 32;
    public static final int ISO_C2 = 33;
    public static final int ISO_C3 = 34;
    public static final int ISO_C4 = 35;
    public static final int ISO_C5 = 36;
    public static final int ISO_C6 = 37;
    public static final int ISO_C7 = 38;
    public static final int ISO_C8 = 39;
    public static final int ISO_C9 = 40;
    public static final int ISO_C10 = 41;
    public static final int JIS_B0 = 42;
    public static final int JIS_B1 = 43;
    public static final int JIS_B2 = 44;
    public static final int JIS_B3 = 45;
    public static final int JIS_B4 = 46;
    public static final int JIS_B5 = 47;
    public static final int JIS_B6 = 48;
    public static final int JIS_B7 = 49;
    public static final int JIS_B8 = 50;
    public static final int JIS_B9 = 51;
    public static final int JIS_B10 = 52;
    public static final int[][] PAPER_SIZES = new int[][]{{612, 792}, {792, 1224}, {556, 756}, {612, 1008}, {792, 1224}, {4767, 6740}, {3370, 4767}, {2383, 3370}, {1683, 2383}, {1190, 1683}, {841, 1190}, {595, 841}, {419, 595}, {297, 419}, {209, 297}, {147, 209}, {104, 147}, {73, 104}, {5669, 8016}, {4008, 5669}, {2834, 4008}, {2004, 2834}, {1417, 2004}, {1000, 1417}, {708, 1000}, {498, 708}, {354, 498}, {249, 354}, {175, 249}, {124, 175}, {87, 124}, {2599, 3676}, {1836, 7372}, {1298, 1836}, {918, 1298}, {649, 918}, {459, 649}, {323, 459}, {229, 323}, {161, 229}, {113, 161}, {79, 113}, {2919, 4127}, {2063, 2919}, {1459, 2063}, {1031, 1459}, {728, 1031}, {515, 728}, {362, 515}, {257, 362}, {181, 257}, {127, 181}, {90, 127}};
    public static final String[][] PAPER_NAMES = new String[][]{{"LETTER", "NA_LETTER"}, {"TABLOID"}, {"EXECUTIVE"}, {"LEGAL"}, {"LEDGER"}, {"IS0_4A0", "IS0_4A", "4A", "JIS_4A0"}, {"IS0_2A0", "IS0_2A", "2A", "JIS_2A0"}, {"A0", "IS0_A0"}, {"A1", "IS0_A1"}, {"A2", "IS0_A2"}, {"A3", "IS0_A3"}, {"A4", "IS0_A4"}, {"A5", "IS0_A5"}, {"A6", "IS0_A6"}, {"A7", "IS0_A7"}, {"A8", "IS0_A8"}, {"A9", "IS0_A9"}, {"A10", "IS0_A10"}, {"4B", "IS0_4B"}, {"2B", "IS0_2B"}, {"B0", "IS0_B0"}, {"B1", "IS0_B1"}, {"B2", "IS0_B2"}, {"B3", "IS0_B3"}, {"B4", "IS0_B4"}, {"B5", "IS0_B5"}, {"B6", "IS0_B6"}, {"B7", "IS0_B7"}, {"B8", "IS0_B8"}, {"B9", "IS0_B9"}, {"B10", "IS0_B10"}, {"C0", "IS0_C0"}, {"C1", "IS0_C1"}, {"C2", "IS0_C2"}, {"C3", "IS0_C3"}, {"C4", "IS0_C4"}, {"C5", "IS0_C5"}, {"C6", "IS0_C6"}, {"C7", "IS0_C7"}, {"C8", "IS0_C8"}, {"C9", "IS0_C9"}, {"C10", "IS0_C10"}, {"JIS_A0"}, {"JIS_A1"}, {"JIS_A2"}, {"JIS_A3"}, {"JIS_A4"}, {"JIS_A5"}, {"JIS_A6"}, {"JIS_A7"}, {"JIS_A8"}, {"JIS_A9"}, {"JIS_A10"}};
    public static final String[] PAPER_DISPLAY_NAMES = new String[]{"Letter (8 1/2 x 11 in)", "Tabloid (11 x 17 in)", "Executive (7 1/4 x  10 1/2 in)", "Legal (8 1/2 x 14 in)", "Ledger (11 x 17 in)", "4A (1682 x 2378 mm)", "2A (1189 x 1682 mm)", "A0 (841 x 1189 mm)", "A1 (594 x 841 mm)", "A2 (420 x 594 mm)", "A3 (297 x 420 mm)", "A4 (210 x 297 mm)", "A5 (148 x 210 mm)", "A6 (105 x 148 mm)", "A7 (74 x 105 mm)", "A8 (52 x 74 mm)", "A9 (37 x 52 mm)", "A10 (26 x 37 mm)", "4B (2000 x 2828 mm)", "2B (1414 x 2000 mm)", "B0 (1000 x 1414 mm)", "B1 (707 x 1000 mm)", "B2 (500 x 707 mm)", "B3 (353 x 500 mm)", "B4 (250 x 353 mm)", "B5 (176 x 250 mm)", "B6 (125 x 176 mm)", "B7 (88 x 125 mm)", "B8 (62 x 88 mm)", "B9 (44 x 62 mm)", "B10 (31 x 44 mm)", "C0 (917 x 1297 mm)", "C1 (648 x 917 mm)", "C2 (458 x 648 mm)", "C3 (324 x 458 mm)", "C4 (229 x 324 mm)", "C5 (162 x 229 mm)", "C6 (114 x 162 mm)", "C7 (81 x 114 mm)", "C8 (57 x 81 mm)", "C9 (40 x 57 mm)", "C10 (28 x 40 mm)"};
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    public static final int PRINT_ALL_FRAMES = 1;
    public static final int PRINT_ACTIVE_FRAMES = 2;
    public static final int PRINT_FRAMES_PAGE = 3;
    public static final int UNIT_POINTS = 0;
    public static final int UNIT_MILLIMETERS = 1;
    public static final int UNIT_INCHES = 2;
    private int dialogUnit = 0;
    private double pageWidth = 612.0;
    private double pageHeight = 792.0;
    private int orientation = 1;
    private double topMargin = 54.0;
    private double leftMargin = 54.0;
    private double rightMargin = 54.0;
    private double bottomMargin = 54.0;
    private double imageableWidth = 540.0;
    private double imageableHeight = 720.0;
    private double pageGutterWidth = 0.0;
    private int framePrintFormat = 3;
    private boolean isBackgroundVisible = true;
    private Font headerFooterFont = new Font("Arial", 0, 10);
    private double scale = 1.0;
    private boolean isTextWrappingEnabled = true;
    private boolean isHtmlSmartPaging = true;
    private boolean isScaleToFitEnabled = false;
    protected Vector pageDecorations = new Vector(6);
    private int selectedViewportIndex = 0;
    private static final long serialVersionUID = 602L;
    private boolean printSelectedMode;
    private boolean printSelectionModeChange;
    private boolean isDirrty = true;
    private static boolean isTableWidthPropertyEnabled = false;

    public void setMargin(Unit size, int location) throws IllegalArgumentException {
        if (size.getPoints() < 0.0) {
            size.setPoints(0.0);
        }
        if (location == 2) {
            if (this.pageWidth <= this.rightMargin) {
                size.setPoints(0.0);
            } else if (size.getPoints() >= this.pageWidth - this.rightMargin) {
                size.setPoints(this.pageWidth - this.rightMargin - 1.0);
            }
            this.leftMargin = size.getPoints();
            this.recalculateImageableArea();
        } else if (location == 4) {
            if (this.pageWidth <= this.leftMargin) {
                size.setPoints(0.0);
            } else if (size.getPoints() >= this.pageWidth - this.leftMargin) {
                size.setPoints(this.pageWidth - this.leftMargin - 1.0);
            }
            this.rightMargin = size.getPoints();
            this.recalculateImageableArea();
        } else if (location == 1) {
            if (this.pageHeight <= this.bottomMargin) {
                size.setPoints(0.0);
            } else if (size.getPoints() >= this.pageHeight - this.bottomMargin) {
                size.setPoints(this.pageHeight - this.bottomMargin - 1.0);
            }
            this.topMargin = size.getPoints();
            this.recalculateImageableArea();
        } else if (location == 3) {
            if (this.pageHeight <= this.topMargin) {
                size.setPoints(0.0);
            } else if (size.getPoints() >= this.pageHeight - this.topMargin) {
                size.setPoints(this.pageHeight - this.topMargin - 1.0);
            }
            this.bottomMargin = size.getPoints();
            this.recalculateImageableArea();
        } else {
            throw new IllegalArgumentException("Unrecognized location");
        }
    }

    public void setOrientation(int orientation) throws IllegalArgumentException {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("Unknown orientation");
        }
        if (orientation == 1 && this.orientation != 1) {
            this.orientation = 1;
            this.setPageSize(this.pageHeight, this.pageWidth);
            this.isDirrty = true;
        } else if (orientation == 0 && this.orientation != 0) {
            this.orientation = 0;
            this.setPageSize(this.pageHeight, this.pageWidth);
            this.isDirrty = true;
        }
    }

    public void setOrientation(Dimension pageSize) {
        int orientation = StormPageFormat.findPageOrientation(pageSize);
        if (orientation == 0) {
            this.setOrientation(0);
        } else if (orientation == 1) {
            this.setOrientation(1);
        }
    }

    public void setPageSize(Unit pageWidth, Unit pageHeight) throws IllegalArgumentException {
        if (pageWidth.getPoints() < 0.0 || pageHeight.getPoints() < 0.0) {
            throw new IllegalArgumentException("Page dimesions must have width and height values greater than zero.");
        }
        if (this.pageWidth != pageWidth.getPoints() || this.pageHeight != pageHeight.getPoints()) {
            this.pageWidth = pageWidth.getPoints();
            this.pageHeight = pageHeight.getPoints();
            this.recalculateImageableArea();
        }
    }

    public void setPageSize(int pageSize) throws IllegalArgumentException {
        if (pageSize < 0 || pageSize >= PAPER_SIZES.length) {
            throw new IllegalArgumentException("Unknown paper size.");
        }
        this.setPageSize(PAPER_SIZES[pageSize][0], PAPER_SIZES[pageSize][1]);
    }

    private void setPageSize(double width, double height) {
        if (this.pageWidth != width || this.pageHeight != height) {
            this.pageWidth = width;
            this.pageHeight = height;
            this.recalculateImageableArea();
        }
    }

    public void setPageGutterWidth(Unit width) {
        if (width.getPoints() < 0.0) {
            width.setPoints(0.0);
        } else if (width.getPoints() > this.imageableWidth) {
            width.setPoints(this.imageableWidth - 1.0);
        }
        if (this.pageGutterWidth != width.getPoints()) {
            this.pageGutterWidth = width.getPoints();
            this.recalculateImageableArea();
        }
    }

    public void setBackgroundVisible(boolean isVisible) {
        if (this.isBackgroundVisible != isVisible) {
            this.isBackgroundVisible = isVisible;
            this.isDirrty = true;
        }
    }

    public void setTextWrapping(boolean isEnabled) {
        this.isTextWrappingEnabled = isEnabled;
        this.isDirrty = true;
    }

    public void setHtmlSmartPaging(boolean isEnabled) {
        this.isHtmlSmartPaging = isEnabled;
        if (!isTableWidthPropertyEnabled) {
            Defs.setSystemProperty("ice.pilots.html4.printResizeTables", new Boolean(this.isHtmlSmartPaging).toString());
        }
        this.isDirrty = true;
    }

    public void setPageSetupDialogUnit(int unit) {
        if (unit == 2 || unit == 1 || unit == 0) {
            this.dialogUnit = unit;
        }
    }

    public void setFramePrintFormat(int format) {
        if (format != 1 && format != 2 && format != 3) {
            throw new IllegalArgumentException("Unrecognized format");
        }
        this.framePrintFormat = format;
        this.selectedViewportIndex = 0;
    }

    public void setSelectedViewportIndex(int viewPortIndex) {
        this.selectedViewportIndex = viewPortIndex;
    }

    public void setHeaderFooterFont(Font font) {
        if (font == null) {
            throw new NullPointerException();
        }
        this.headerFooterFont = font;
    }

    public void setScale(double scale) {
        if (scale < 0.01) {
            scale = 0.01;
        } else if (scale > 9.0) {
            scale = 9.0;
        } else {
            this.scale = scale;
        }
        this.isDirrty = true;
    }

    public double getScale() {
        return this.scale;
    }

    public int getSelectedViewportIndex() {
        return this.selectedViewportIndex;
    }

    public double getMargin(int location) {
        if (location == 1) {
            return this.topMargin;
        }
        if (location == 3) {
            return this.bottomMargin;
        }
        if (location == 2) {
            return this.leftMargin;
        }
        if (location == 4) {
            return this.rightMargin;
        }
        throw new IllegalArgumentException("Unrecognized location");
    }

    public double getPageGutter() {
        return this.pageGutterWidth;
    }

    public final int getPageSetupDialogUnit() {
        return this.dialogUnit;
    }

    public String getPaperDisplayNames(int paper) {
        if (paper >= 0 && paper < PAPER_DISPLAY_NAMES.length) {
            return PAPER_DISPLAY_NAMES[paper];
        }
        return "Paper not found";
    }

    public Dimension getPaperSize(int paper) {
        if (paper >= 0 && paper < PAPER_SIZES.length) {
            return new Dimension(PAPER_SIZES[paper][0], PAPER_SIZES[paper][1]);
        }
        return null;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getPageWidth() {
        return this.pageWidth;
    }

    public double getPageHeight() {
        return this.pageHeight;
    }

    public double getImageableWidth() {
        return this.imageableWidth;
    }

    public double getImageableHeight() {
        return this.imageableHeight;
    }

    public int getFramePrintFormat() {
        return this.framePrintFormat;
    }

    public Font getHeaderFooterFont() {
        return this.headerFooterFont;
    }

    public boolean isBackgroundVisible() {
        return this.isBackgroundVisible;
    }

    public boolean isTextWrappingEnabled() {
        return this.isTextWrappingEnabled;
    }

    public boolean isScaleToFitEnabled() {
        return this.isScaleToFitEnabled;
    }

    public boolean isHtmlSmartPagingEnabled() {
        return this.isHtmlSmartPaging;
    }

    public void setPrintSelected(boolean isSelected) {
        if (this.printSelectedMode != isSelected) {
            this.setPrintSelectionModeChange(true);
        }
        this.printSelectedMode = isSelected;
    }

    public boolean isPrintSelected() {
        return this.printSelectedMode;
    }

    public boolean isPrintSelectionChanged() {
        return this.printSelectionModeChange;
    }

    public void setPrintSelectionModeChange(boolean modeChange) {
        this.printSelectionModeChange = modeChange;
    }

    public Object clone() {
        StormPageFormat newPage;
        try {
            newPage = (StormPageFormat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Debug.ex(e);
            newPage = null;
        }
        return newPage;
    }

    public boolean hasImageableAreaChanged() {
        return this.isDirrty;
    }

    public void setImageableAreaChangedFlag(boolean flag) {
        this.isDirrty = flag;
    }

    public static final int findPageOrientation(Dimension page) {
        int orientation = -1;
        for (int i = 0; i < PAPER_SIZES.length; ++i) {
            if (page.width == PAPER_SIZES[i][0] && page.height == PAPER_SIZES[i][1]) {
                orientation = 1;
                continue;
            }
            if (page.width != PAPER_SIZES[i][1] || page.height != PAPER_SIZES[i][0]) continue;
            orientation = 0;
        }
        return orientation;
    }

    public static final int findPageSize(Dimension pageDimension) {
        int index = -1;
        for (int i = 0; i < PAPER_SIZES.length; ++i) {
            if ((pageDimension.width != PAPER_SIZES[i][0] || pageDimension.height != PAPER_SIZES[i][1]) && (pageDimension.width != PAPER_SIZES[i][1] || pageDimension.height != PAPER_SIZES[i][0])) continue;
            index = i;
            break;
        }
        return index;
    }

    public void addDecoration(PageDecoration pageDecoration) {
        this.pageDecorations.addElement(pageDecoration);
    }

    public Vector getDecoration() {
        return this.pageDecorations;
    }

    public void removeAllDecorations() {
        this.pageDecorations = new Vector(6);
    }

    public void setScaleToFitEnabled(boolean value) {
        this.isScaleToFitEnabled = value;
    }

    private void recalculateImageableArea() {
        double newWidth = this.pageWidth - this.leftMargin - this.rightMargin - this.pageGutterWidth;
        double newHeight = this.pageHeight - this.topMargin - this.bottomMargin;
        if (this.imageableWidth != newWidth || this.imageableHeight != newHeight) {
            this.imageableWidth = newWidth;
            this.imageableHeight = newHeight;
            this.isDirrty = true;
        }
    }

    static {
        if (Defs.sysProperty("ice.pilots.html4.printResizeTables") == null) {
            Defs.setSystemProperty("ice.pilots.html4.printResizeTables", "true");
        } else {
            isTableWidthPropertyEnabled = true;
        }
    }
}

