/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.DynEnv;
import ice.util.Defs;
import ice.util.alg.HashArray;

public class DynamicObject {
    public static final Object NOT_FOUND = Defs.NOT_FOUND;
    public static final int SETD_NOT_FOUND = 0;
    public static final int SETD_OK = 1;
    public static final int SETD_IGNORE = 2;
    private HashArray slots;
    private static final int Method_toSource = -1;
    private static final int Method_toString = -2;

    protected Object getScriptDataLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashArray ensureSlots() {
        HashArray map = this.slots;
        if (map == null) {
            Object lock = this.getScriptDataLock();
            if (lock == null) {
                this.slots = map = new HashArray(lock);
            } else {
                Object object = lock;
                synchronized (object) {
                    map = this.slots;
                    if (map == null) {
                        this.slots = map = new HashArray(lock);
                    }
                }
            }
        }
        return map;
    }

    public Object javaReflectionTarget() {
        return null;
    }

    public boolean readOnlySlots() {
        return false;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DynamicObject.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        return Defs.NOT_FOUND;
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DynamicObject.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        return 0;
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DynamicObject.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, env);
        }
        return Defs.NOT_FOUND;
    }

    public DynamicObject getMethodPropertySource(String methodName, DynEnv env) {
        return null;
    }

    public Object getDynamicScopeParent() {
        return null;
    }

    private Object execDynamicMethod(int key_id, DynEnv env) {
        if (key_id == -2) {
            return this.script_toString(env);
        }
        if (key_id == -1) {
            return this.script_toSource(env);
        }
        Debug.bug();
        return null;
    }

    protected Object script_toSource(DynEnv env) {
        return env.onNotImplemented();
    }

    public String script_toString(DynEnv env) {
        Object toStringObj = this.javaReflectionTarget();
        if (toStringObj == null) {
            toStringObj = this;
        }
        return toStringObj.toString();
    }

    public boolean hasSlot(String name, DynEnv env) {
        return Defs.NOT_FOUND != this.getSlot(name, env);
    }

    public boolean hasSlot(int index, DynEnv env) {
        return Defs.NOT_FOUND != this.getSlot(index, env);
    }

    public Object getSlot(String name, DynEnv env) {
        HashArray.Entry entry;
        HashArray slots = this.slots;
        if (slots != null && (entry = slots.getEntry(name)) != null) {
            return entry.value;
        }
        return Defs.NOT_FOUND;
    }

    public Object getSlot(int index, DynEnv env) {
        HashArray.Entry entry;
        HashArray slots = this.slots;
        if (slots != null && (entry = slots.getEntry(index)) != null) {
            return entry.value;
        }
        return Defs.NOT_FOUND;
    }

    public void setSlot(String name, Object value, DynEnv env) {
        this.ensureSlots().setValue(name, value);
    }

    public void setSlot(int index, Object value, DynEnv env) {
        this.ensureSlots().setValue(index, value);
    }

    public void deleteSlot(String name) {
        HashArray slots = this.slots;
        if (slots != null) {
            slots.remove(name);
        }
    }

    public void deleteSlot(int index) {
        HashArray slots = this.slots;
        if (slots != null) {
            slots.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setScriptWrapperIfAbsent(Object key, Object value) {
        HashArray slots = this.ensureSlots();
        Object object = slots.synchronizationLock();
        synchronized (object) {
            HashArray.Entry entry = slots.ensureEntry(key);
            if (entry.value == null) {
                entry.value = value;
            }
            return entry.value;
        }
    }

    public Object getScriptWrapper(Object key) {
        HashArray slots = this.slots;
        return slots != null ? slots.get(key) : null;
    }

    public void unlinkAllSlots() {
        this.slots = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getEnumeratableIds(DynEnv env, int add_head_allocation) {
        HashArray slots = this.slots;
        if (slots != null) {
            Object object = slots.synchronizationLock();
            synchronized (object) {
                HashArray.Iterator iter = slots.newIterator();
                int entry_count = 0;
                iter.start();
                while (!iter.done()) {
                    HashArray.Entry entry = iter.entry();
                    if (entry.isIndex() || entry.key() instanceof String) {
                        ++entry_count;
                    }
                    iter.next();
                }
                if (entry_count != 0) {
                    int offset = add_head_allocation;
                    Object[] ids = new Object[offset + entry_count];
                    iter.start();
                    while (!iter.done()) {
                        Object id = null;
                        HashArray.Entry entry = iter.entry();
                        if (entry.isIndex()) {
                            id = env.wrapInt(entry.index());
                        } else {
                            Object key = entry.key();
                            if (key instanceof String) {
                                id = key;
                            }
                        }
                        if (id != null) {
                            ids[offset] = id;
                            ++offset;
                        }
                        iter.next();
                    }
                    return ids;
                }
            }
        }
        return add_head_allocation == 0 ? Defs.EMPTY_OBJECT_ARRAY : new Object[add_head_allocation];
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        if (s.length() == 8) {
            char c = s.charAt(3);
            if (c == 'o') {
                guess = "toSource";
                id = -1;
            } else if (c == 't') {
                guess = "toString";
                id = -2;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

