/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.print.jdk13;

import ice.pilots.html4.ThePilot;
import ice.ri.common.print.PrintHelper;
import ice.ri.common.print.PrintUtilities;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import ice.storm.print.jdk12.PageAttributesConverter;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Vector;

public class PrintHelper13
implements PrintHelper {
    private Viewport mainViewport;
    private int zoom;
    private boolean isFrameset;
    private Vector viewports;
    private StormPageFormat stormPageFormat;
    private JobAttributes jobAttributes;
    private int currentViewportPageCount;

    public PrintHelper13(Viewport viewport, StormPageFormat stormpageformat, JobAttributes jobAttributes) {
        this.stormPageFormat = stormpageformat;
        this.mainViewport = viewport;
        this.zoom = this.mainViewport.getZoom();
        this.viewports = new Vector(4, 2);
        this.mainViewport.getViewAndAllChildren(this.viewports);
        this.isFrameset = PrintUtilities.isFrameset(this.mainViewport);
        this.jobAttributes = jobAttributes;
    }

    public PrintHelper13(Viewport viewport, StormPageFormat stormPageFormat) {
        this(viewport, stormPageFormat, null);
    }

    public void print(Frame parent) {
        int aZoom;
        PageAttributes pageAttributes = new PageAttributes();
        pageAttributes = PageAttributesConverter.stormPageFormatConverter(this.stormPageFormat, pageAttributes);
        int pageCount = this.countTotalPages();
        if (pageCount >= 1) {
            if (this.jobAttributes == null) {
                this.jobAttributes = new JobAttributes();
                this.jobAttributes.setDialog(JobAttributes.DialogType.NATIVE);
            }
            this.jobAttributes.setPageRanges(new int[][]{{1, pageCount}});
            PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(parent, "Print", this.jobAttributes, pageAttributes);
            if (printJob != null) {
                this.stormPageFormat = PageAttributesConverter.pageAttributesConverter(pageAttributes, this.stormPageFormat);
                int copies = this.jobAttributes.getCopies();
                JobAttributes.DefaultSelectionType selectionType = this.jobAttributes.getDefaultSelection();
                int startPage = 1;
                int endPage = pageCount;
                if (selectionType == JobAttributes.DefaultSelectionType.RANGE) {
                    int[][] pageRange = this.jobAttributes.getPageRanges();
                    startPage = pageRange[0][0];
                    endPage = pageRange[0][1];
                } else if (selectionType == JobAttributes.DefaultSelectionType.SELECTION) {
                    this.stormPageFormat.setPrintSelected(true);
                }
                for (int i = 0; i < copies; ++i) {
                    if (!this.isFrameset || this.stormPageFormat.getFramePrintFormat() == 3) {
                        if (!this.stormPageFormat.isPrintSelected()) {
                            this.print(printJob, this.mainViewport, startPage, endPage);
                            break;
                        }
                        if (!this.isFrameset) {
                            if (!this.hasSelection(this.mainViewport)) break;
                            this.print(printJob, this.mainViewport, startPage, endPage);
                            break;
                        }
                        Viewport activeChildViewport = this.findActiveChildViewport(this.mainViewport);
                        if (!this.hasSelection(activeChildViewport)) break;
                        this.print(printJob, activeChildViewport, startPage, endPage);
                        break;
                    }
                    if (!this.isFrameset || this.stormPageFormat.getFramePrintFormat() != 1) continue;
                    int viewportCount = this.viewports.size();
                    int printedPage = 0;
                    int startIdx = startPage;
                    int pagesToPrint = endPage - startIdx + 1;
                    if (viewportCount <= 1) continue;
                    for (int j = 1; j < viewportCount && pagesToPrint > 0; ++j) {
                        Viewport thisViewport = (Viewport)this.viewports.elementAt(j);
                        if (this.stormPageFormat.isPrintSelected() && !this.isSelectionActive(thisViewport)) continue;
                        printedPage = this.print(printJob, (Viewport)this.viewports.elementAt(j), startIdx, pagesToPrint + startIdx - 1);
                        pagesToPrint -= printedPage;
                        if (printedPage == 0) {
                            startIdx -= this.currentViewportPageCount;
                            continue;
                        }
                        startIdx = 1;
                    }
                }
                this.stormPageFormat.setPrintSelected(false);
                printJob.finalize();
            }
            this.viewports.removeAllElements();
        }
        this.mainViewport.setZoom((aZoom = this.zoom - 1) > 0 ? aZoom : this.zoom + 1);
        this.mainViewport.setZoom(this.zoom);
    }

    private Viewport findActiveChildViewport(Viewport viewport) {
        Viewport active = null;
        Pilot p = viewport.getPilot();
        Viewport activeViewport = p.getStorm().getActiveViewport();
        if (activeViewport != null) {
            for (int i = 1; i < this.viewports.size(); ++i) {
                Viewport current = (Viewport)this.viewports.elementAt(i);
                if (activeViewport != current) continue;
                active = activeViewport;
                break;
            }
        }
        return active;
    }

    private int countTotalPages() {
        StormPrinter currentPrinter;
        int pageCount = 0;
        if (this.isFrameset && this.stormPageFormat.getFramePrintFormat() == 1) {
            int viewportCount = this.viewports.size();
            for (int j = 1; j < viewportCount; ++j) {
                Viewport currentView = (Viewport)this.viewports.elementAt(j);
                StormPrinter currentPrinter2 = currentView.getPilot().createPrinter();
                if (currentPrinter2 == null) continue;
                PrintUtilities.adjustScale(this.stormPageFormat, currentPrinter2.getDimension().width);
                currentPrinter2.setStormPageFormat(this.stormPageFormat);
                pageCount += currentPrinter2.getPageCount();
                currentPrinter2.dispose();
            }
        } else if (!(this.isFrameset && this.stormPageFormat.getFramePrintFormat() != 3 || (currentPrinter = this.mainViewport.getPilot().createPrinter()) == null)) {
            PrintUtilities.adjustScale(this.stormPageFormat, currentPrinter.getDimension().width);
            currentPrinter.setStormPageFormat(this.stormPageFormat);
            pageCount += currentPrinter.getPageCount();
            currentPrinter.dispose();
        }
        return pageCount;
    }

    private boolean hasSelection(Viewport viewport) {
        Pilot p;
        boolean hasSelection = false;
        if (viewport != null && (p = viewport.getPilot()) instanceof ThePilot) {
            ThePilot pp = (ThePilot)p;
            hasSelection = pp.isSelectionActive();
        }
        return hasSelection;
    }

    private boolean isSelectionActive(Viewport viewport) {
        ThePilot pp;
        Viewport activeViewport;
        boolean active = false;
        Pilot p = viewport.getPilot();
        if (p instanceof ThePilot && (activeViewport = (pp = (ThePilot)p).getStorm().getActiveViewport()) != null && activeViewport == viewport) {
            active = pp.isSelectionActive();
        }
        return active;
    }

    private int print(PrintJob printJob, Viewport current_viewport, int startPage, int endPage) {
        int pagePrintedToIndex = 0;
        if (printJob == null || current_viewport == null || startPage <= 0 || endPage <= 0 || startPage > endPage) {
            return pagePrintedToIndex;
        }
        StormPrinter currentPrinter = current_viewport.getPilot().createPrinter();
        if (currentPrinter != null) {
            PrintUtilities.refreshPageDecoration(current_viewport, this.stormPageFormat);
            PrintUtilities.adjustScale(this.stormPageFormat, currentPrinter.getDimension().width);
            currentPrinter.setStormPageFormat(this.stormPageFormat);
            this.currentViewportPageCount = currentPrinter.getPageCount();
            for (int page = startPage; page <= endPage && page <= this.currentViewportPageCount; ++page) {
                Graphics g = printJob.getGraphics();
                if (g == null) continue;
                currentPrinter.printPage(g, page - 1);
                ++pagePrintedToIndex;
            }
            currentPrinter.dispose();
        }
        return pagePrintedToIndex;
    }
}

