/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.swing.DocView;
import javax.accessibility.AccessibleHyperlink;

public class AccessibleLink
extends AccessibleHyperlink {
    protected DAnchorElement link;
    protected DocView docView;
    protected Html4DocumentAccess docAccess;

    public AccessibleLink(DAnchorElement link, DocView docView, Html4DocumentAccess docAccess) {
        this.link = link;
        this.docView = docView;
        this.docAccess = docAccess;
    }

    public boolean isValid() {
        ThePilot pilot = this.docView.getPilot();
        if (pilot == null) {
            return false;
        }
        DDocument doc = pilot.getDDocument();
        if (doc == null) {
            return false;
        }
        return doc.contains(this.link);
    }

    public int getAccessibleActionCount() {
        return 1;
    }

    public boolean doAccessibleAction(int actionIndex) {
        if (actionIndex == 0 && this.isValid()) {
            this.link.click();
            return true;
        }
        return false;
    }

    public String getAccessibleActionDescription(int actionIndex) {
        if (actionIndex == 0 && this.isValid()) {
            String innerText = this.link.getInnerText();
            if (innerText != null) {
                return innerText;
            }
            String alt = this.link.getAttribute("alt");
            if (alt != null) {
                return alt;
            }
        }
        return null;
    }

    public Object getAccessibleActionObject(int actionIndex) {
        if (actionIndex == 0 && this.isValid()) {
            return this.link.getAttribute("href");
        }
        return null;
    }

    public Object getAccessibleActionAnchor(int i) {
        return this.getAccessibleActionDescription(0);
    }

    public int getStartIndex() {
        int start = this.docAccess.getIndexOfNode(this.link);
        if (start < 0 || start > this.docAccess.getCount(1)) {
            return -1;
        }
        return start;
    }

    public int getEndIndex() {
        int start = this.getStartIndex();
        if (start == -1) {
            return -1;
        }
        String text = this.getAccessibleActionDescription(0);
        if (text == null) {
            return -1;
        }
        int end = start + text.length();
        if (end > this.docAccess.getCount(1)) {
            return -1;
        }
        return end;
    }
}

