/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

class FormInputUpload
extends Panel
implements ObjectPainter,
TextListener,
Movable,
ActionListener {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private TextField tfield = null;
    private Button button = null;
    private Frame fileframe = null;
    private FileDialog dialog = null;
    private int maxLength = 100;
    private String startValue;

    FormInputUpload(DocView docView, DElement e) {
        this.docView = docView;
        this.element = (DInputElement)e;
        this.tfield = new TextField();
        this.button = new Button("Browse");
        this.fileframe = new Frame();
        this.dialog = new FileDialog(this.fileframe);
        this.button.setBackground(Color.lightGray);
        this.checkAttributes();
        int sz = this.element.getAttributeAsInt("size");
        if (sz <= 0) {
            sz = 20;
        }
        this.tfield.setColumns(sz);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tfield, "Center");
        this.add((Component)this.button, "East");
        this.tfield.setBackground(Color.white);
        this.tfield.setFont(new Font("Monospaced", 0, 12));
        this.enableEvents(28L);
        this.tfield.addTextListener(this);
        this.button.addActionListener(this);
    }

    private void checkAttributes() {
        String s;
        this.tfield.setEditable(!this.element.getReadOnly());
        this.tfield.setEnabled(!this.element.getDisabled());
        int i = this.element.getMaxLength();
        if (i != 0) {
            this.maxLength = i;
        }
        if ((s = this.element.getValue()) != null && !s.equals(this.tfield.getText())) {
            this.tfield.setText(s);
            try {
                this.tfield.setCaretPosition(s.length());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    public void textValueChanged(TextEvent e) {
        String s = this.tfield.getText();
        if (s.length() > this.maxLength) {
            s = s.substring(0, this.maxLength);
            this.tfield.setText(s);
            try {
                this.tfield.setCaretPosition(this.maxLength);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        this.element.setValue(s);
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            return;
        }
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        if (!this.isValid()) {
            this.validate();
        }
        this.setVisible(visible);
    }

    public void actionPerformed(ActionEvent e) {
        this.dialog.show();
        String filename = this.dialog.getDirectory() + this.dialog.getFile();
        this.tfield.setText(filename);
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        int id = e.getID();
        if (id == 1004) {
            this.processFocusGained(e);
        } else if (id == 1005) {
            this.processFocusLost(e);
        }
        super.processFocusEvent(e);
    }

    private void processFocusGained(FocusEvent e) {
        if (this.startValue == null) {
            this.startValue = this.tfield.getText();
        }
    }

    private void processFocusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        String tmp = this.tfield.getText();
        if (!tmp.equals(this.startValue)) {
            this.element.dispatchChange();
        }
        this.startValue = null;
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
    }

    public int getClientHeight() {
        return this.getSize().height;
    }

    public int getClientWidth() {
        return this.getSize().width;
    }
}

