/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.OutlinePainter;
import ice.pilots.html4.TableCellBox;
import ice.pilots.html4.TextBox;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class InlineBox
extends CSSBox {
    int relX;
    int relY;
    protected CSSBox first;
    protected CSSBox last;
    private boolean redoDynamicActive;
    protected CSSBox lastProcessedChild = null;
    protected int lastPosition = 0;
    boolean restoreChild;
    boolean containsOnlyInlines = true;

    InlineBox(DElement element, CSSAttribs css, CSSLayout cssLayout, byte dynamic) {
        super(element, css, cssLayout);
        this.dynamic = dynamic;
        this.last = null;
        this.first = null;
    }

    CSSBox getLast() {
        return this.last;
    }

    void dispose() {
        CSSBox b = this.first;
        while (b != null) {
            CSSBox bn = b.next;
            b.dispose();
            b = bn;
        }
        this.last = null;
        this.first = null;
        super.dispose();
        DElement element = this.element;
        if (element != null) {
            element.hack_box = null;
            this.element = null;
        }
    }

    DNode getDomNode() {
        return this.element;
    }

    int getType() {
        return 0;
    }

    void propagateVisibility(short b, boolean self) {
        boolean propagate;
        boolean bl = propagate = self ? this.setVisibility(b) : true;
        if (propagate) {
            CSSBox bb = this.first;
            while (bb != null) {
                bb.propagateVisibility(b, true);
                bb = bb.next;
            }
        }
    }

    CSSBox getFirstChild() {
        return this.first;
    }

    BlockBox inline2Block() {
        this.css.display = 41;
        BlockBox newOne = new BlockBox(this.element, this.css, this.cssLayout, this.dynamic);
        newOne.element.hack_box = newOne;
        newOne.parentBox = this.parentBox;
        newOne.first = this.first;
        newOne.last = this.last;
        newOne.next = this.next;
        CSSBox b = newOne.first;
        while (b != null) {
            b.setParentBox(newOne);
            b = b.next;
        }
        CSSBox pp = this.parentBox;
        CSSBox child = pp.getFirstChild();
        Vector<CSSBox> vec = new Vector<CSSBox>();
        while (child != null) {
            CSSBox nextChild = child.next;
            child.next = null;
            if (child == this) {
                child = newOne;
            }
            vec.addElement(child);
            child = nextChild;
        }
        if (pp instanceof InlineBox) {
            ((InlineBox)pp).last = null;
            ((InlineBox)pp).first = null;
        }
        for (int i = 0; i < vec.size(); ++i) {
            pp = pp.addChild((CSSBox)vec.elementAt(i));
        }
        this.last = null;
        this.first = null;
        this.parentBox = null;
        this.cssLayout.boxList.substitute(this, newOne);
        this.cssLayout.substBoxes.put(this, newOne);
        return newOne;
    }

    CSSBox addChild(CSSBox box) {
        if (box.getType() != 0) {
            this.containsOnlyInlines = false;
        }
        if (box.getType() == 1 && !(this instanceof BlockBox)) {
            BlockBox newOne = this.inline2Block();
            newOne.addChild(box);
            return newOne;
        }
        if (this.first == null) {
            box.next = this.last;
            this.first = this.last = box;
        } else {
            box.next = this.last.next;
            this.last.next = box;
            this.last = box;
        }
        box.setParentBox(this);
        return this;
    }

    void findAbsolutePosition(Point p) {
        if (this.getType() == 0) {
            p.x += this.css.margin_left + this.css.border_left_width + this.css.padding_left;
            p.x += this.relX;
            p.y += this.relY;
        } else {
            p.x += this.css.text_indent;
        }
        super.findAbsolutePosition(p);
    }

    void findBoundingBox(Rectangle r) {
        BlockBox bb = null;
        int x = 0;
        CSSBox b = this;
        while (b.parentBox != null) {
            if (b.getType() == 0) {
                x += b.css.margin_left + b.css.border_left_width + b.css.padding_left;
                x += b.ox;
            } else {
                x += b.css.text_indent;
            }
            if (b.getType() == 1) {
                bb = (BlockBox)b;
                bb.recordBoundingBoxForInline(r, x, this.totalWidth);
                if (r.width == 0) {
                    r.height = 0;
                    r.width = 0;
                    r.y = 0;
                    r.x = 0;
                    bb.findBoundingBox(r);
                    break;
                }
                if (b.css.position == 126 || b.css.position == 6) break;
                Point p = new Point();
                b = b.parentBox;
                if (b != null) {
                    b.findAbsolutePosition(p);
                }
                r.x += p.x;
                r.y += p.y;
                r.x += this.relX;
                r.y += this.relY;
                break;
            }
            b = b.parentBox;
        }
    }

    CSSBox getBoxAt(int ex, int ey, Point rv) {
        int x1 = 0;
        x1 = this.getType() == 0 ? (x1 += this.css.margin_left + this.css.border_left_width + this.css.padding_left) : (x1 += this.css.text_indent);
        CSSBox b = this.first;
        while (b != null) {
            if (b.css.position != 125 || b instanceof TextBox) {
                if (ex >= x1 && ex < x1 + b.totalWidth) {
                    CSSBox box = b.getBoxAt(ex - x1, ey, rv);
                    if (box == null) break;
                    return box;
                }
                x1 += b.totalWidth;
            }
            b = b.next;
        }
        return super.getBoxAt(ex, ey, rv);
    }

    protected final boolean changeDynamicStyle(int type) {
        if (this.cssLayout == null) {
            return false;
        }
        CSSAttribs a = this.cssLayout.getDynamicStyle(this, type);
        if (a == null) {
            return false;
        }
        String prevBGImageUrl = this.css.background_image_url;
        this.css = a;
        if (this.css.background_image != null && this.css.background_image instanceof String && this.css.background_image_url != null && !this.css.background_image_url.equalsIgnoreCase(prevBGImageUrl)) {
            this.loadBackgroundImage(this.element.doc);
        }
        if (type == 0 || type == 4) {
            CSSBox b = this.first;
            while (b != null) {
                if (b instanceof InlineBox) {
                    ((InlineBox)b).changeDynamicStyle(type);
                }
                b = b.next;
            }
        }
        return true;
    }

    void applyDynamicStyle(int eventId) {
        if (this.dynamic > 0) {
            if (eventId == 5) {
                if (this.changeDynamicStyle(1)) {
                    this.reqRepaint();
                }
            } else if (eventId == 3) {
                if (this.changeDynamicStyle(2)) {
                    this.redoDynamicActive = true;
                    this.reqRepaint();
                }
            } else if (eventId == 4) {
                if (this.changeDynamicStyle(1)) {
                    this.reqRepaint();
                } else if (this.changeDynamicStyle(0)) {
                    this.reqRepaint();
                }
            } else if (eventId == 21) {
                if (this.changeDynamicStyle(4)) {
                    if (this.redoDynamicActive) {
                        this.changeDynamicStyle(2);
                        this.redoDynamicActive = false;
                    }
                    this.reqRepaint();
                }
            } else if (eventId == 7 || eventId == 22) {
                if (this.css.cursor >= 0) {
                    this.cssLayout.docPane.setCursor(0);
                }
                if (this.changeDynamicStyle(0)) {
                    this.redoDynamicActive = false;
                    this.reqRepaint();
                }
            }
        } else {
            super.applyDynamicStyle(eventId);
        }
    }

    int calcBreaks() {
        int leftX = 0;
        int rightX = 0;
        if (this.getType() == 0) {
            leftX += this.css.margin_left + this.css.border_left_width + this.css.padding_left;
            rightX += this.css.margin_right + this.css.border_right_width + this.css.padding_right;
        } else {
            leftX += this.css.text_indent;
        }
        this.totalWidth = leftX;
        this.numBreaks = 0;
        CSSBox b = this.first;
        while (b != null) {
            this.numBreaks += b.calcBreaks();
            b.ox = this.totalWidth;
            this.totalWidth += b.totalWidth;
            b = b.next;
        }
        this.totalWidth += rightX;
        return this.numBreaks;
    }

    int getBreaks(int[] breaks, int idx) {
        int leftX = 0;
        leftX = this.getType() == 0 ? (leftX += this.css.margin_left + this.css.border_left_width + this.css.padding_left) : (leftX += this.css.text_indent);
        int x = leftX;
        CSSBox b = this.first;
        while (b != null) {
            int n = b.getBreaks(breaks, idx);
            int i = 0;
            if (b == this.first && leftX > 0 && n > 0 && breaks[idx + 0] == 0) {
                ++i;
            }
            while (i < n) {
                if (breaks[idx + i] >= 0) {
                    int n2 = idx + i;
                    breaks[n2] = breaks[n2] + x;
                } else {
                    int n3 = idx + i;
                    breaks[n3] = breaks[n3] - x;
                }
                ++i;
            }
            x += b.totalWidth;
            idx += n;
            b = b.next;
        }
        return this.numBreaks;
    }

    long getChunkDescentAscent(int pxLineBoxStart, int aLineBoxWidth, LineBox aLineMetrics) {
        int itemp1;
        boolean isInline;
        boolean bl = isInline = this.getType() == 0;
        if (this.parentBox != null) {
            aLineMetrics._inheritedContentHeight = this instanceof TableCellBox ? this.css.font_size : this.parentBox.css.font_size;
        }
        int leftX = 0;
        if (isInline) {
            leftX += this.css.margin_left + this.css.border_left_width + this.css.padding_left;
        } else if (pxLineBoxStart + aLineBoxWidth <= (leftX += this.css.text_indent)) {
            return 0L;
        }
        int pxCursor = leftX;
        CSSBox box = this.first;
        if (this.restoreChild && this.lastProcessedChild != null) {
            box = this.lastProcessedChild;
            pxCursor = this.lastPosition;
        }
        while (box != null && (itemp1 = pxCursor + box.totalWidth) <= pxLineBoxStart && (pxCursor != pxLineBoxStart || box.totalWidth != 0)) {
            pxCursor += box.totalWidth;
            box = box.next;
        }
        if (box == null) {
            return 0L;
        }
        this.lastProcessedChild = box;
        this.lastPosition = pxCursor;
        this.restoreChild = pxLineBoxStart + aLineBoxWidth < this.totalWidth;
        int pxChunkStart = pxLineBoxStart - pxCursor;
        int pxChunkWidth = box.totalWidth - pxChunkStart;
        if (pxChunkWidth > aLineBoxWidth) {
            pxChunkWidth = aLineBoxWidth;
        }
        long dawrap = 0L;
        dawrap = box.getChunkDescentAscent(pxChunkStart, pxChunkWidth, aLineMetrics);
        aLineMetrics.treatInlineBox(dawrap, box.boxId, this.css.vertical_align_type);
        box = box.next;
        pxCursor += pxChunkWidth;
        aLineBoxWidth -= pxChunkWidth;
        while (aLineBoxWidth > 0 && box != null) {
            pxChunkWidth = box.totalWidth;
            if (pxChunkWidth > aLineBoxWidth) {
                pxChunkWidth = aLineBoxWidth;
            }
            dawrap = box.getChunkDescentAscent(0, pxChunkWidth, aLineMetrics);
            aLineMetrics.treatInlineBox(dawrap, box.boxId, this.css.vertical_align_type);
            aLineBoxWidth -= pxChunkWidth;
            pxCursor += pxChunkWidth;
            box = box.next;
        }
        return 0L;
    }

    void paintChunk(Graphics g, int x, int w, LineBox aLineBox, int aBoxId) {
        if ((this.css.misc & 1) != 0) {
            if (this.relX != 0 || this.relY != 0) {
                g = g.create();
                g.translate(this.relX, this.relY);
            }
            Rectangle clipBounds = g.getClipBounds();
            int sx = x;
            int sw = w;
            if (x == 0) {
                sx = this.css.margin_left;
                sw -= sx;
            }
            if (x + w == this.totalWidth) {
                sw -= this.css.margin_right;
            }
            if (this.hasMoreThanOneChild()) {
                FontMetrics fm = this.css.getFontMetrics();
                int ascent = fm.getAscent();
                int descent = fm.getDescent();
                int contentHeight = 2 + this.css.font_size + this.css.padding_top + this.css.padding_bottom;
                if (aLineBox != null) {
                    int topOfInlineBox = aLineBox.getNormalizedBaseline() - InlineBox.unwrapAscent(TextBox.calculateCompressedFontSize(ascent, descent, this.css)) - this.css.padding_top;
                    this.paintBackground(g, clipBounds, sx, topOfInlineBox + this.relY, sw, contentHeight, 0);
                    this.paintBorders(g, clipBounds, sx, topOfInlineBox - this.css.border_top_width, sw, contentHeight + this.css.border_top_width + this.css.border_bottom_width, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8 && x == 0, this.css.border_right_width > 0 && this.css.border_right_style != 8 && x + w == this.totalWidth);
                }
            }
        }
        this.paintChildren(g, x, w, aLineBox);
    }

    public boolean hasMoreThanOneChild() {
        CSSBox b = this.first;
        return b != null && b.next != null;
    }

    protected void paintChildren(Graphics g, int aStartX, int aWidth, LineBox aLineBox) {
        int bw;
        int leftX = 0;
        int rightX = 0;
        int yDeflection = 0;
        if (this.getType() == 0) {
            rightX += this.css.margin_right + this.css.border_right_width + this.css.padding_right;
            if (aStartX + aWidth <= (leftX += this.css.margin_left + this.css.border_left_width + this.css.padding_left)) {
                return;
            }
        } else if (aStartX + aWidth <= (leftX += this.css.text_indent)) {
            return;
        }
        if (aStartX + aWidth == this.totalWidth) {
            aWidth -= rightX;
        }
        if (aStartX == 0) {
            aWidth -= leftX;
        }
        int pxTemp = leftX;
        CSSBox b = this.first;
        while (b != null && pxTemp + b.totalWidth <= aStartX) {
            pxTemp += b.totalWidth;
            b = b.next;
        }
        if (b == null) {
            return;
        }
        int bx = aStartX - pxTemp;
        if (bx < 0) {
            bx = 0;
        }
        if ((bw = b.totalWidth - bx) > aWidth) {
            bw = aWidth;
        }
        OutlinePainter outlinePainter = this.cssLayout.outlinePainter;
        yDeflection = 0;
        if (!(b instanceof InlineBox) && aLineBox != null) {
            yDeflection = aLineBox.getYDeflectionOfChunk(b.boxId);
        }
        outlinePainter.translate(g, pxTemp, yDeflection);
        b.paintChunk(g, bx, bw, aLineBox, b.boxId);
        outlinePainter.translate(g, -pxTemp, -yDeflection);
        pxTemp += b.totalWidth;
        b = b.next;
        aWidth -= bw;
        while (aWidth > 0 && b != null) {
            bw = b.totalWidth;
            if (bw > aWidth) {
                bw = aWidth;
            }
            yDeflection = 0;
            if (!(b instanceof InlineBox) && aLineBox != null) {
                yDeflection = aLineBox.getYDeflectionOfChunk(b.boxId);
            }
            outlinePainter.translate(g, pxTemp, yDeflection);
            b.paintChunk(g, 0, bw, aLineBox, b.boxId);
            outlinePainter.translate(g, -pxTemp, -yDeflection);
            pxTemp += bw;
            aWidth -= bw;
            b = b.next;
        }
    }

    int getCount(int aType, Point p) {
        int returnVal = 0;
        CSSBox box = this.first;
        while (box != null) {
            returnVal += box.getCount(aType, p);
            box = box.next;
        }
        return returnVal;
    }

    CSSBox findChildByIndex_r(int aType, int aIndex, Point aPoint) {
        CSSBox box = this.first;
        while (box != null) {
            CSSBox returnVal = box.findChildByIndex_r(aType, aIndex, aPoint);
            if (returnVal != null) {
                return returnVal;
            }
            box = box.next;
        }
        return null;
    }
}

