/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.FramesetInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class FramesDivider
implements MouseListener,
MouseMotionListener {
    private FramesetInfo framesetInfo;
    private boolean isdraged = false;
    private Point pressedPoint;
    int x_width = 4;
    int y_width = 4;
    int moved_X = 0;
    int moved_Y = 0;
    Component component = null;

    FramesDivider(Component component) {
        this.component = component;
    }

    void dispose() {
        if (this.component != null) {
            this.component.removeMouseListener(this);
            this.component.removeMouseListener(this);
            Container p = this.component.getParent();
            if (p != null) {
                p.remove(this.component);
            }
        }
        this.framesetInfo = null;
        this.pressedPoint = null;
        this.component = null;
    }

    public void mouseEntered(MouseEvent e) {
        if (this.component != null) {
            if (this.framesetInfo.getOrientation() == 1) {
                Cursor N_RESIZE_CURSORCursor = new Cursor(8);
                this.component.setCursor(N_RESIZE_CURSORCursor);
            } else {
                Cursor E_RESIZE_CURSORCursor = new Cursor(11);
                this.component.setCursor(E_RESIZE_CURSORCursor);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.component != null) {
            Cursor hourglassCursor = new Cursor(13);
            this.component.setCursor(hourglassCursor);
            this.pressedPoint = e.getPoint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.component != null) {
            if (this.isdraged) {
                if (this.framesetInfo.getOrientation() == 1) {
                    this.framesetInfo.dividerMoved(e.getPoint().y - this.pressedPoint.y, this);
                } else {
                    this.framesetInfo.dividerMoved(e.getPoint().x - this.pressedPoint.x, this);
                }
            }
            Cursor normalCursor = new Cursor(0);
            this.component.setCursor(normalCursor);
            this.isdraged = false;
        }
    }

    Component getComponent() {
        return this.component;
    }

    void setProperty(String property, String value) {
        block7: {
            if (property.equalsIgnoreCase("frameborder")) {
                if (value.equalsIgnoreCase("no") || value.equalsIgnoreCase("0")) {
                    this.x_width = 0;
                    this.y_width = 0;
                }
            } else if (property.equalsIgnoreCase("border")) {
                value = value.trim();
                int l = value.length();
                for (int i = 0; i != l; ++i) {
                    char c = value.charAt(i);
                    if ('0' <= c && c <= '9') continue;
                    l = i;
                    value = value.substring(0, i);
                    break;
                }
                try {
                    this.y_width = this.x_width = Integer.parseInt(value);
                }
                catch (Exception ex) {
                    if (!Debug.trace) break block7;
                    Debug.trace("Bad frame border value: " + value);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.isdraged = true;
    }

    void setFramesetInfo(FramesetInfo framesetInfo) {
        this.framesetInfo = framesetInfo;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

