/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.ObjArray;
import ice.mozilla.javascript.ObjToIntMap;

public class VariableTable {
    private ObjArray itsVariables = new ObjArray();
    private ObjToIntMap itsVariableNames = new ObjToIntMap(11);
    private int varStart;

    public int size() {
        return this.itsVariables.size();
    }

    public int getParameterCount() {
        return this.varStart;
    }

    public Object getVariable(int index) {
        return this.itsVariables.get(index);
    }

    public boolean hasVariable(String name) {
        return this.itsVariableNames.has(name);
    }

    public Object getVariable(String name) {
        int vIndex = this.itsVariableNames.get(name, -1);
        if (vIndex != -1) {
            return this.itsVariables.get(vIndex);
        }
        return null;
    }

    public int getOrdinal(String name) {
        return this.itsVariableNames.get(name, -1);
    }

    public void getAllVariables(Object[] destination) {
        this.itsVariables.toArray(destination);
    }

    public void addParameter(String pName, Object paramObj) {
        if (this.varStart != this.itsVariables.size()) {
            Context.codeBug();
        }
        int pIndex = this.itsVariableNames.get(pName, -1);
        if (this.itsVariableNames.has(pName)) {
            String message = Context.getMessage1("msg.dup.parms", pName);
            Context.reportWarning(message, null, 0, null, 0);
        }
        int index = this.varStart++;
        this.itsVariables.add(paramObj);
        this.itsVariableNames.put(pName, index);
    }

    public void addLocal(String vName, Object varObj) {
        int vIndex = this.itsVariableNames.get(vName, -1);
        if (vIndex != -1) {
            return;
        }
        int index = this.itsVariables.size();
        this.itsVariables.add(varObj);
        this.itsVariableNames.put(vName, index);
    }

    public void removeLocal(String name) {
        int i = this.itsVariableNames.get(name, -1);
        if (i != -1) {
            this.itsVariables.remove(i);
            this.itsVariableNames.remove(name);
            ObjToIntMap.Iterator iter = this.itsVariableNames.newIterator();
            iter.start();
            while (!iter.done()) {
                int v = iter.getValue();
                if (v > i) {
                    iter.setValue(v - 1);
                }
                iter.next();
            }
        }
    }
}

