/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.FunctionNode;
import ice.mozilla.javascript.IRFactory;
import ice.mozilla.javascript.NativeGlobal;
import ice.mozilla.javascript.Node;
import ice.mozilla.javascript.ObjArray;
import ice.mozilla.javascript.ObjToIntMap;
import ice.mozilla.javascript.PreorderNodeIterator;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.TokenStream;
import ice.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected ObjArray loops;
    protected ObjArray loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    public IRFactory createIRFactory(TokenStream ts, Scriptable scope) {
        return new IRFactory(ts, scope);
    }

    public Node transform(Node tree, Node enclosing, TokenStream ts, Scriptable scope) {
        Node node;
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        boolean bl = this.inFunction = tree.getType() == 110;
        if (!this.inFunction) {
            this.addVariables(tree, this.getVariableTable(tree));
        }
        this.irFactory = this.createIRFactory(ts, scope);
        boolean hasFinally = false;
        PreorderNodeIterator iterator = tree.getPreorderIterator();
        block22: while ((node = iterator.nextNode()) != null) {
            int type = node.getType();
            block0 : switch (type) {
                case 110: {
                    if (node == tree) {
                        VariableTable vars = this.getVariableTable(tree);
                        this.addVariables(tree, vars);
                        Node stmts = node.getLastChild();
                        Node lastStmt = stmts.getLastChild();
                        if (lastStmt != null && lastStmt.getType() == 5) continue block22;
                        stmts.addChildToBack(new Node(5));
                        break;
                    }
                    FunctionNode fnNode = (FunctionNode)node.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                        fnNode.setCheckThis(true);
                    }
                    this.addParameters(fnNode);
                    NodeTransformer inner = this.newInstance();
                    fnNode = (FunctionNode)inner.transform(fnNode, tree, ts, scope);
                    node.putProp(5, fnNode);
                    ObjArray fns = (ObjArray)tree.getProp(5);
                    if (fns == null) {
                        fns = new ObjArray();
                        tree.putProp(5, fns);
                    }
                    fns.add(fnNode);
                    break;
                }
                case 136: {
                    Node next;
                    Node child = node.getFirstChild();
                    node.removeChild(child);
                    String id = child.getString();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        String otherId;
                        Node n = (Node)this.loops.get(i);
                        if (n.getType() != 136 || !id.equals(otherId = (String)n.getProp(20))) continue;
                        String message = Context.getMessage1("msg.dup.label", id);
                        this.reportMessage(Context.getContext(), message, node, tree, true, scope);
                        break block0;
                    }
                    node.putProp(20, id);
                    Node breakTarget = new Node(137);
                    Node parent = iterator.getCurrentParent();
                    for (next = node.getNext(); next != null && (next.getType() == 136 || next.getType() == 137); next = next.getNext()) {
                    }
                    if (next == null) break;
                    parent.addChildAfter(breakTarget, next);
                    node.putProp(2, breakTarget);
                    if (next.getType() == 138) {
                        node.putProp(3, next.getProp(3));
                    }
                    this.loops.push(node);
                    this.loopEnds.push(breakTarget);
                    break;
                }
                case 115: {
                    Node breakTarget = new Node(137);
                    Node parent = iterator.getCurrentParent();
                    parent.addChildAfter(breakTarget, node);
                    Node sib = node;
                    Node child = node.getFirstChild().next;
                    while (child != null) {
                        Node next = child.next;
                        node.removeChild(child);
                        parent.addChildAfter(child, sib);
                        sib = child;
                        child = next;
                    }
                    node.putProp(2, breakTarget);
                    this.loops.push(node);
                    this.loopEnds.push(breakTarget);
                    node.putProp(13, new ObjArray());
                    break;
                }
                case 116: 
                case 117: {
                    Node sw = (Node)this.loops.peek();
                    if (type == 116) {
                        ObjArray cases = (ObjArray)sw.getProp(13);
                        cases.add(node);
                        break;
                    }
                    sw.putProp(14, node);
                    break;
                }
                case 144: {
                    int localCount = tree.getIntProp(22, 0);
                    tree.putIntProp(22, localCount + 1);
                    break;
                }
                case 138: {
                    this.loops.push(node);
                    this.loopEnds.push(node.getProp(2));
                    break;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    this.loops.push(node);
                    Node leave = node.getNext();
                    if (leave.getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 75: {
                    Node finallytarget = (Node)node.getProp(21);
                    if (finallytarget != null) {
                        hasFinally = true;
                        this.loops.push(node);
                        this.loopEnds.push(finallytarget);
                    }
                    int localCount = tree.getIntProp(22, 0);
                    tree.putIntProp(22, localCount + 1);
                    break;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    if (!hasFinally) break;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype == 75) {
                            Node jsrnode = new Node(143);
                            Object jsrtarget = n.getProp(21);
                            jsrnode.putProp(1, jsrtarget);
                            iterator.addBeforeCurrent(jsrnode);
                            continue;
                        }
                        if (elemtype != 124) continue;
                        Node leave = new Node(4);
                        iterator.addBeforeCurrent(leave);
                    }
                    continue block22;
                }
                case 121: 
                case 122: {
                    Node target;
                    Node loop = null;
                    boolean labelled = node.hasChildren();
                    String id = null;
                    if (labelled) {
                        Node child = node.getFirstChild();
                        id = child.getString();
                        node.removeChild(child);
                    }
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype == 124) {
                            Node leave = new Node(4);
                            iterator.addBeforeCurrent(leave);
                            continue;
                        }
                        if (elemtype == 75) {
                            Node jsrFinally = new Node(143);
                            Object jsrTarget = n.getProp(21);
                            jsrFinally.putProp(1, jsrTarget);
                            iterator.addBeforeCurrent(jsrFinally);
                            continue;
                        }
                        if (!labelled && (elemtype == 138 || elemtype == 115 && type == 121)) {
                            loop = n;
                            break;
                        }
                        if (!labelled || elemtype != 136 || !id.equals((String)n.getProp(20))) continue;
                        loop = n;
                        break;
                    }
                    int propType = type == 121 ? 2 : 3;
                    Node node2 = target = loop == null ? null : (Node)loop.getProp(propType);
                    if (loop == null || target == null) {
                        String message;
                        if (!labelled) {
                            message = type == 122 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (loop != null) {
                            message = Context.getMessage0("msg.continue.nonloop");
                        } else {
                            Object[] errArgs = new Object[]{id};
                            message = Context.getMessage("msg.undef.label", errArgs);
                        }
                        this.reportMessage(Context.getContext(), message, node, tree, true, scope);
                        node.setType(128);
                        break;
                    }
                    node.setType(6);
                    node.putProp(1, target);
                    break;
                }
                case 43: {
                    if (this.isSpecialCallName(tree, node)) {
                        node.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall(node, tree);
                    break;
                }
                case 30: {
                    if (this.isSpecialCallName(tree, node)) {
                        node.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew(node, tree);
                    break;
                }
                case 108: {
                    Node right = node.getLastChild();
                    right.setType(46);
                    break;
                }
                case 140: {
                    node.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    ObjArray regexps = (ObjArray)tree.getProp(12);
                    if (regexps == null) {
                        regexps = new ObjArray();
                        tree.putProp(12, regexps);
                    }
                    regexps.add(node);
                    Node n = new Node(56);
                    iterator.replaceCurrent(n);
                    n.putProp(12, node);
                    break;
                }
                case 123: {
                    Node result = new Node(133);
                    for (Node cursor = node.getFirstChild(); cursor != null; cursor = cursor.getNext()) {
                        Node n = cursor;
                        if (!n.hasChildren()) continue;
                        Node init = n.getFirstChild();
                        n.removeChild(init);
                        Node asn = (Node)this.irFactory.createAssignment(128, n, init, null, false);
                        Node pop = new Node(57, asn, node.getLineno());
                        result.addChildToBack(pop);
                    }
                    iterator.replaceCurrent(result);
                    break;
                }
                case 10: 
                case 31: {
                    VariableTable vars;
                    Node bind;
                    if (!this.inFunction || this.inWithStatement() || (bind = node.getFirstChild()) == null || bind.getType() != 61) break;
                    String name = bind.getString();
                    Context cx = Context.getCurrentContext();
                    if (cx != null && cx.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if (!(vars = this.getVariableTable(tree)).hasVariable(name)) break;
                    if (type == 10) {
                        node.setType(73);
                        bind.setType(46);
                        break;
                    }
                    Node n = new Node(109, 51);
                    iterator.replaceCurrent(n);
                    break;
                }
                case 39: {
                    if (!this.inFunction) break;
                    Node n = node.getFirstChild().getNext();
                    String name = n == null ? "" : n.getString();
                    Context cx = Context.getCurrentContext();
                    if ((cx == null || !cx.isActivationNeeded(name)) && (!name.equals("length") || Context.getContext().getLanguageVersion() != 120)) continue block22;
                    ((FunctionNode)tree).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    VariableTable vars;
                    if (!this.inFunction || this.inWithStatement()) break;
                    String name = node.getString();
                    Context cx = Context.getCurrentContext();
                    if (cx != null && cx.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if (!(vars = this.getVariableTable(tree)).hasVariable(name)) break;
                    node.setType(72);
                    break;
                }
            }
        }
        return tree;
    }

    protected void addVariables(Node tree, VariableTable vars) {
        String name;
        Node node;
        boolean inFunction = tree.getType() == 110;
        PreorderNodeIterator iterator = tree.getPreorderIterator();
        ObjToIntMap fNames = null;
        while ((node = iterator.nextNode()) != null) {
            int nodeType = node.getType();
            if (inFunction && nodeType == 110 && node != tree && ((FunctionNode)node.getProp(5)).getFunctionType() == 3) {
                name = node.getString();
                if (name == null) continue;
                vars.removeLocal(name);
                if (fNames == null) {
                    fNames = new ObjToIntMap();
                }
                fNames.put(name, 0);
            }
            if (nodeType != 123) continue;
            for (Node cursor = node.getFirstChild(); cursor != null; cursor = cursor.getNext()) {
                String name2 = cursor.getString();
                if (fNames != null && fNames.has(name2)) continue;
                vars.addLocal(name2, this.createVariableObject(name2, false));
            }
        }
        if (inFunction) {
            FunctionNode fn = (FunctionNode)tree;
            name = fn.getFunctionName();
            if (fn.getFunctionType() == 2 && name != null && name.length() > 0 && vars.hasVariable(name)) {
                vars.addLocal(name, this.createVariableObject(name, false));
                Node block = tree.getLastChild();
                Node setFn = new Node(57, new Node(73, Node.newString(name), new Node(109, 87)));
                block.addChildrenToFront(setFn);
            }
        }
    }

    protected void addParameters(FunctionNode fnNode) {
        VariableTable vars = fnNode.getVariableTable();
        Node args = fnNode.getFirstChild();
        if (args.getType() == 94 && vars.getParameterCount() == 0) {
            for (Node cursor = args.getFirstChild(); cursor != null; cursor = cursor.getNext()) {
                String arg = cursor.getString();
                vars.addParameter(arg, this.createVariableObject(arg, true));
            }
        }
    }

    protected Object createVariableObject(String name, boolean isParameter) {
        return name;
    }

    protected void visitNew(Node node, Node tree) {
    }

    protected void visitCall(Node node, Node tree) {
        Node left = node.getFirstChild();
        int argCount = 0;
        Node arg = left.getNext();
        while (arg != null) {
            arg = arg.getNext();
            ++argCount;
        }
        boolean addGetThis = false;
        if (left.getType() == 44) {
            VariableTable vars = this.getVariableTable(tree);
            String name = left.getString();
            if (this.inFunction && vars.hasVariable(name) && !this.inWithStatement()) {
                left.setType(72);
            } else {
                node.removeChild(left);
                left.setType(71);
                Node str = left.cloneNode();
                str.setType(46);
                Node getProp = new Node(39, left, str);
                node.addChildToFront(getProp);
                left = getProp;
                boolean bl = addGetThis = this.inWithStatement() || !this.inFunction;
            }
        }
        if (left.getType() != 39 && left.getType() != 41) {
            node.removeChild(left);
            Node tmp = this.irFactory.createNewTemp(left);
            Node use = this.irFactory.createUseTemp(tmp);
            use.putProp(6, tmp);
            Node parent = new Node(141, use);
            node.addChildToFront(parent);
            node.addChildToFront(tmp);
            return;
        }
        Node leftLeft = left.getFirstChild();
        left.removeChild(leftLeft);
        Node tmp = this.irFactory.createNewTemp(leftLeft);
        left.addChildToFront(tmp);
        Node use = this.irFactory.createUseTemp(tmp);
        use.putProp(6, tmp);
        if (addGetThis) {
            use = new Node(68, use);
        }
        node.addChildAfter(use, left);
    }

    protected boolean inWithStatement() {
        for (int i = this.loops.size() - 1; i >= 0; --i) {
            Node n = (Node)this.loops.get(i);
            if (n.getType() != 124) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecialCallName(Node tree, Node node) {
        Node left = node.getFirstChild();
        boolean isSpecial = false;
        if (left.getType() == 44) {
            String name = left.getString();
            isSpecial = name.equals("eval") || name.equals("With");
        } else if (left.getType() == 39) {
            String name = left.getLastChild().getString();
            isSpecial = name.equals("exec");
        }
        if (isSpecial) {
            if (this.inFunction) {
                ((FunctionNode)tree).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node tree) {
        if (this.inFunction) {
            return ((FunctionNode)tree).getVariableTable();
        }
        VariableTable result = (VariableTable)tree.getProp(10);
        if (result == null) {
            result = this.createVariableTable();
            tree.putProp(10, result);
        }
        return result;
    }

    protected void reportMessage(Context cx, String msg, Node stmt, Node tree, boolean isError, Scriptable scope) {
        Object prop;
        int lineno = stmt.getLineno();
        Object object = prop = tree == null ? null : tree.getProp(16);
        if (isError) {
            if (scope != null) {
                throw NativeGlobal.constructError(cx, "SyntaxError", msg, scope, (String)prop, lineno, 0, null);
            }
            Context.reportError(msg, (String)prop, lineno, null, 0);
        } else {
            Context.reportWarning(msg, (String)prop, lineno, null, 0);
        }
    }
}

