/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeFunction;
import ice.mozilla.javascript.NativeJavaObject;
import ice.mozilla.javascript.ObjArray;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;
import ice.mozilla.javascript.Wrapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class NativeJavaMethod
extends NativeFunction
implements Function {
    static final int PREFERENCE_EQUAL = 0;
    static final int PREFERENCE_FIRST_ARG = 1;
    static final int PREFERENCE_SECOND_ARG = 2;
    static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    Method[] methods;
    private static final Method method_setAccessible = NativeJavaMethod.getMethod(Method.class, "setAccessible", new Class[]{Boolean.TYPE});

    public NativeJavaMethod() {
        this.functionName = null;
    }

    public NativeJavaMethod(Method[] methods) {
        this.methods = methods;
        this.functionName = methods[0].getName();
    }

    public NativeJavaMethod(Method method, String name) {
        this.methods = new Method[1];
        this.methods[0] = method;
        this.functionName = name;
    }

    public void add(Method method) {
        if (this.functionName == null) {
            this.functionName = method.getName();
        } else if (!this.functionName.equals(method.getName())) {
            throw new RuntimeException("internal method name mismatch");
        }
        int len = this.methods == null ? 0 : this.methods.length;
        Method[] newMeths = new Method[len + 1];
        for (int i = 0; i < len; ++i) {
            newMeths[i] = this.methods[i];
        }
        newMeths[len] = method;
        this.methods = newMeths;
    }

    static String scriptSignature(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> type = value.getClass();
        if (type == ScriptRuntime.UndefinedClass) {
            return "undefined";
        }
        if (type == ScriptRuntime.BooleanClass) {
            return "boolean";
        }
        if (type == ScriptRuntime.StringClass) {
            return "string";
        }
        if (ScriptRuntime.NumberClass.isAssignableFrom(type)) {
            return "number";
        }
        if (value instanceof Wrapper) {
            return ((Wrapper)value).unwrap().getClass().getName();
        }
        if (value instanceof Scriptable) {
            if (value instanceof Function) {
                return "function";
            }
            return "object";
        }
        return NativeJavaMethod.javaSignature(type);
    }

    static String scriptSignature(Object[] values) {
        StringBuffer sig = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                sig.append(',');
            }
            sig.append(NativeJavaMethod.scriptSignature(values[i]));
        }
        return sig.toString();
    }

    static String javaSignature(Class type) {
        if (type == null) {
            return "null";
        }
        if (type.isArray()) {
            return NativeJavaMethod.javaSignature(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    static String javaSignature(Class[] types) {
        StringBuffer sig = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                sig.append(',');
            }
            sig.append(NativeJavaMethod.javaSignature(types[i]));
        }
        return sig.toString();
    }

    static String signature(Member member) {
        if (member instanceof Method) {
            Class[] paramTypes = ((Method)member).getParameterTypes();
            return member.getName() + "(" + NativeJavaMethod.javaSignature(paramTypes) + ")";
        }
        Class[] paramTypes = ((Constructor)member).getParameterTypes();
        return "(" + NativeJavaMethod.javaSignature(paramTypes) + ")";
    }

    public String decompile(Context cx, int indent, boolean justbody) {
        StringBuffer sb = new StringBuffer();
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() {");
        }
        sb.append("/*\n");
        this.toString(sb);
        sb.append(justbody ? "*/\n" : "*/}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb);
        return sb.toString();
    }

    private void toString(StringBuffer sb) {
        for (int i = 0; i < this.methods.length; ++i) {
            sb.append(NativeJavaMethod.javaSignature(this.methods[i].getReturnType()));
            sb.append(' ');
            sb.append(NativeJavaMethod.signature(this.methods[i]));
            sb.append('\n');
        }
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        Object javaObject;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        Method meth = (Method)NativeJavaMethod.findFunction(this.methods, args);
        if (meth == null) {
            Class<?> c = this.methods[0].getDeclaringClass();
            String sig = c.getName() + "." + this.functionName + "(" + NativeJavaMethod.scriptSignature(args) + ")";
            throw Context.reportRuntimeError1("msg.java.no_such_method", sig);
        }
        Class<?>[] paramTypes = meth.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            args[i] = NativeJavaObject.coerceType(paramTypes[i], args[i], true);
        }
        if (Modifier.isStatic(meth.getModifiers())) {
            javaObject = null;
        } else {
            Scriptable o = thisObj;
            while (!(o instanceof Wrapper)) {
                if ((o = o.getPrototype()) != null) continue;
                throw Context.reportRuntimeError1("msg.nonjava.method", this.functionName);
            }
            javaObject = ((Wrapper)((Object)o)).unwrap();
        }
        try {
            Object retval;
            try {
                retval = meth.invoke(javaObject, args);
            }
            catch (IllegalAccessException e) {
                retval = NativeJavaMethod.retryIllegalAccessInvoke(meth, javaObject, args, e);
            }
            Class<?> staticType = meth.getReturnType();
            Object wrapped = cx.getWrapFactory().wrap(cx, scope, retval, staticType);
            if (wrapped == Undefined.instance) {
                return wrapped;
            }
            if (wrapped == null && staticType == Void.TYPE) {
                return Undefined.instance;
            }
            return wrapped;
        }
        catch (IllegalAccessException accessEx) {
            throw Context.reportRuntimeError("While attempting to call \"" + meth.getName() + "\" in class \"" + meth.getDeclaringClass().getName() + "\" receieved " + accessEx.toString());
        }
        catch (InvocationTargetException e) {
            throw JavaScriptException.wrapException(cx, scope, e);
        }
    }

    static Object retryIllegalAccessInvoke(Method method, Object obj, Object[] args, IllegalAccessException illegalAccess) throws IllegalAccessException, InvocationTargetException {
        if (Modifier.isPublic(method.getModifiers())) {
            String name = method.getName();
            Class<?>[] parms = method.getParameterTypes();
            Class<?> c = method.getDeclaringClass();
            Class<?>[] intfs = c.getInterfaces();
            for (int i = 0; i < intfs.length; ++i) {
                c = intfs[i];
                try {
                    Method m = c.getMethod(name, parms);
                    return m.invoke(obj, args);
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
                catch (IllegalAccessException ex) {
                    // empty catch block
                }
            }
        }
        if (method_setAccessible != null) {
            Object[] args_wrapper = new Object[]{Boolean.TRUE};
            try {
                method_setAccessible.invoke((Object)method, args_wrapper);
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            return method.invoke(obj, args);
        }
        throw illegalAccess;
    }

    static Member findFunction(Member[] methodsOrCtors, Object[] args) {
        int preference;
        Class[] paramTypes;
        Member member;
        int i;
        if (methodsOrCtors.length == 0) {
            return null;
        }
        boolean hasMethods = methodsOrCtors[0] instanceof Method;
        for (int i2 = 0; i2 < args.length; ++i2) {
            Object arg = args[i2];
            if (!(arg instanceof Wrapper) || (arg = ((Wrapper)arg).unwrap()) instanceof Number) continue;
            args[i2] = arg;
        }
        Member bestFit = null;
        Class[] bestFitTypes = null;
        ObjArray ambiguousMethods = null;
        for (i = 0; i < methodsOrCtors.length; ++i) {
            member = methodsOrCtors[i];
            Class[] classArray = paramTypes = hasMethods ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
            if (paramTypes.length != args.length) continue;
            if (bestFitTypes == null) {
                int j;
                for (j = 0; j < paramTypes.length && NativeJavaObject.canConvert(args[j], paramTypes[j]); ++j) {
                }
                if (j != paramTypes.length) continue;
                bestFit = member;
                bestFitTypes = paramTypes;
                continue;
            }
            preference = NativeJavaMethod.preferSignature(args, paramTypes, bestFitTypes);
            if (preference == 3) {
                if (ambiguousMethods == null) {
                    ambiguousMethods = new ObjArray();
                }
                ambiguousMethods.add(member);
                continue;
            }
            if (preference == 1) {
                bestFit = member;
                bestFitTypes = paramTypes;
                continue;
            }
            if (preference != 0 || !Modifier.isStatic(bestFit.getModifiers()) || !bestFit.getDeclaringClass().isAssignableFrom(member.getDeclaringClass())) continue;
            bestFit = member;
            bestFitTypes = paramTypes;
        }
        if (ambiguousMethods == null) {
            return bestFit;
        }
        for (i = ambiguousMethods.size() - 1; i >= 0; --i) {
            member = (Member)ambiguousMethods.get(i);
            paramTypes = hasMethods ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
            preference = NativeJavaMethod.preferSignature(args, paramTypes, bestFitTypes);
            if (preference == 1) {
                bestFit = member;
                bestFitTypes = paramTypes;
                ambiguousMethods.remove(i);
                continue;
            }
            if (preference != 2) continue;
            ambiguousMethods.remove(i);
        }
        if (ambiguousMethods.size() > 0) {
            String errMsg;
            StringBuffer buf = new StringBuffer();
            boolean isCtor = bestFit instanceof Constructor;
            ambiguousMethods.add(bestFit);
            for (int i3 = 0; i3 < ambiguousMethods.size(); ++i3) {
                if (i3 != 0) {
                    buf.append(", ");
                }
                Member member2 = (Member)ambiguousMethods.get(i3);
                if (!isCtor) {
                    Class<?> rtnType = ((Method)member2).getReturnType();
                    buf.append(rtnType);
                    buf.append(' ');
                }
                buf.append(NativeJavaMethod.signature(member2));
            }
            if (isCtor) {
                Object[] errArgs = new Object[]{bestFit.getName(), NativeJavaMethod.scriptSignature(args), buf.toString()};
                errMsg = Context.getMessage("msg.constructor.ambiguous", errArgs);
            } else {
                Object[] errArgs = new Object[]{bestFit.getDeclaringClass().getName(), bestFit.getName(), NativeJavaMethod.scriptSignature(args), buf.toString()};
                errMsg = Context.getMessage("msg.method.ambiguous", errArgs);
            }
            throw Context.reportRuntimeError(errMsg);
        }
        return bestFit;
    }

    public static int preferSignature(Object[] args, Class[] sig1, Class[] sig2) {
        Class type2;
        Class type1;
        int preference = 0;
        for (int j = 0; j < args.length && ((type1 = sig1[j]) == (type2 = sig2[j]) || (preference |= NativeJavaMethod.preferConversion(args[j], type1, type2)) != 3); ++j) {
        }
        return preference;
    }

    public static int preferConversion(Object fromObj, Class toClass1, Class toClass2) {
        int rank1 = NativeJavaObject.getConversionWeight(fromObj, toClass1);
        int rank2 = NativeJavaObject.getConversionWeight(fromObj, toClass2);
        if (rank1 == 0 && rank2 == 0) {
            if (toClass1.isAssignableFrom(toClass2)) {
                return 2;
            }
            if (toClass2.isAssignableFrom(toClass1)) {
                return 1;
            }
        } else {
            if (rank1 < rank2) {
                return 1;
            }
            if (rank1 > rank2) {
                return 2;
            }
        }
        return 3;
    }

    Method[] getMethods() {
        return this.methods;
    }

    private static Method getMethod(Class cl, String name, Class[] signature) {
        try {
            return cl.getMethod(name, signature);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static void printDebug(String msg, Member member, Object[] args) {
    }
}

