/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.ClassDefinitionException;
import ice.mozilla.javascript.FunctionObject;
import ice.mozilla.javascript.PropertyException;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.WrappedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class LazilyLoadedCtor {
    private static Method getter;
    private static Method setter;
    private String ctorName;
    private String className;
    private boolean sealed;
    private boolean isReplaced;

    public LazilyLoadedCtor(ScriptableObject scope, String ctorName, String className, boolean sealed) {
        this.className = className;
        this.ctorName = ctorName;
        this.sealed = sealed;
        if (getter == null) {
            Method[] all = FunctionObject.getMethodList(this.getClass());
            getter = FunctionObject.findMethods(all, "getProperty")[0];
            setter = FunctionObject.findMethods(all, "setProperty")[0];
        }
        try {
            scope.defineProperty(ctorName, this, getter, setter, 2);
        }
        catch (PropertyException e) {
            throw WrappedException.wrapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(ScriptableObject obj) {
        ScriptableObject scriptableObject = obj;
        synchronized (scriptableObject) {
            if (!this.isReplaced) {
                boolean removeOnError = false;
                Class<?> cl = null;
                try {
                    cl = Class.forName(this.className);
                }
                catch (ClassNotFoundException ex) {
                    removeOnError = true;
                }
                catch (SecurityException ex) {
                    removeOnError = true;
                }
                if (cl != null) {
                    try {
                        ScriptableObject.defineClass(obj, cl, this.sealed);
                        this.isReplaced = true;
                    }
                    catch (InstantiationException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (ClassDefinitionException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (PropertyException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (SecurityException ex) {
                        removeOnError = true;
                    }
                }
                if (removeOnError) {
                    obj.delete(this.ctorName);
                    return Scriptable.NOT_FOUND;
                }
            }
        }
        return obj.get(this.ctorName, (Scriptable)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(ScriptableObject obj, Object val) {
        ScriptableObject scriptableObject = obj;
        synchronized (scriptableObject) {
            this.isReplaced = true;
            return val;
        }
    }
}

