/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.arm;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.cdbg.CFrame;

public abstract class ARMThreadContext
implements ThreadContext {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.debugger.DEBUG") != null;
    public static final int ARM_NPRGREG = 16;
    public static final int AARCH64_NPRGREG = 34;
    private final Arch arch;
    private long[] data;

    public ARMThreadContext(String cpu) {
        this.arch = Arch.getArch(cpu);
        this.data = new long[this.arch.NPRGREG];
    }

    @Override
    public int getNumRegisters() {
        return this.arch.NPRGREG;
    }

    @Override
    public String getRegisterName(int index) {
        return this.arch.REG_NAMES[index];
    }

    @Override
    public void setRegister(int index, long value) {
        this.data[index] = value;
        if (DEBUG) {
            System.out.println(this.getRegisterName(index) + ": 0x" + Long.toHexString(value));
        }
    }

    @Override
    public long getRegister(int index) {
        return this.data[index];
    }

    public int getSPRegisterIndex() {
        return this.arch.R_SP;
    }

    public int getFPRegisterIndex() {
        return this.arch.R_FP;
    }

    public int getPCRegisterIndex() {
        return this.arch.R_PC;
    }

    @Override
    public abstract void setRegisterAsAddress(int var1, Address var2);

    @Override
    public abstract Address getRegisterAsAddress(int var1);

    @Override
    public abstract CFrame getTopFrame(Debugger var1);

    public static enum Arch {
        ARM(11, 13, 15, 16, new String[]{"R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "FP", "R12", "SP", "LR", "PC"}),
        AARCH64(29, 31, 32, 34, new String[]{"R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15", "R16", "R17", "R18", "R19", "R20", "R21", "R22", "R23", "R24", "R25", "R26", "R27", "R28", "FP", "LR", "SP", "PC", "PSTATE"});

        public final int R_FP;
        public final int R_SP;
        public final int R_PC;
        public final int NPRGREG;
        public final String[] REG_NAMES;

        private Arch(int rFP, int rSP, int rPC, int nprgreg, String[] regNames) {
            this.R_FP = rFP;
            this.R_SP = rSP;
            this.R_PC = rPC;
            this.NPRGREG = nprgreg;
            this.REG_NAMES = regNames;
        }

        public static Arch getArch(String cpu) {
            if (cpu.equals("aarch64")) {
                return AARCH64;
            }
            return ARM;
        }
    }
}

