/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import oracle.jvm.hotspot.jfr.Producer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class JFRProducers
extends VMObject {
    private static AddressField producersField;
    private static Producer producer;
    private static CIntegerField numProducersField;
    private static CIntegerField totalSizeField;

    public JFRProducers(Address addr) {
        super(addr);
        producer = (Producer)VMObjectFactory.newObject(Producer.class, producersField.getValue(addr));
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrProducers");
        producersField = type.getAddressField("_producers");
        numProducersField = type.getCIntegerField("_num_producers");
        totalSizeField = type.getCIntegerField("_totalsize");
    }

    public Producer getProducer() {
        return producer;
    }

    public long getNumProducers() {
        return numProducersField.getValue(this.addr);
    }

    public Producer getNextProducer(Producer pd) {
        return (Producer)VMObjectFactory.newObject(Producer.class, pd.getNext());
    }

    public int getDescriptorSize() {
        return (int)totalSizeField.getValue(this.addr);
    }

    public void write_producers(JFRStreamWriter sw) {
        int num_of_producers = (int)this.getNumProducers();
        sw.write(num_of_producers);
        Producer nextProducer = null;
        Producer pd = this.getProducer();
        while (pd != null) {
            sw.write(pd.getDescValue());
            pd = nextProducer = this.getNextProducer(pd);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JFRProducers.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

