/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.prov.ssh.RunCommand;
import oracle.sysman.prov.ssh.SSHSetupData;
import oracle.sysman.prov.ssh.SSHSetupTasks;
import oracle.sysman.prov.ssh.SSHSetupUtil;
import oracle.sysman.prov.ssh.TectiaSSHSetup;

public class TectiaSSHTasks
extends SSHSetupData
implements SSHSetupTasks {
    private String identification;
    private String localFQDN;
    private String localHost;
    private String localIpAddress;
    private String remoteHostKeysDir;
    private String localHostKeysDir;

    public TectiaSSHTasks(String host, TectiaSSHSetup setupObj) {
        super.init(host, setupObj);
        this.localFQDN = setupObj.localFQDN;
        this.localHost = OiixNetOps.getMachineName((String)this.localFQDN);
        this.localIpAddress = setupObj.localIpAddress;
        this.identification = setupObj.identification;
        this.remoteHostKeysDir = setupObj.getRemoteHostKeysDir();
        this.localHostKeysDir = setupObj.getLocalHostKeysDir();
    }

    @Override
    public boolean sshKeyGen() {
        boolean publicKeyExists;
        OiiolTextLogger.appendText((String)("TectiaSSH: Creating keys on remote Host " + this.host));
        OiiolTextLogger.appendText((String)("to setup SSH on Host " + this.host));
        RunCommand cmd = new RunCommand(this.host, this.info.getUsername(), this.info.getPassword(), this.sshPort, true);
        cmd.setSshHome(this.localSSHDir);
        if (this.info.reuseKey() && (publicKeyExists = SSHSetupUtil.checkFileExistsOnRemoteNode(this.host, this.remotePubKey + " " + this.remotePrivateKey + " " + this.identification, this.username, this.password, this.sshPort, this.remotePaths, true))) {
            OiiolTextLogger.appendText((String)("Public-Private Key Pair already exists on node: " + this.host));
            return true;
        }
        String r_command = this.remotePaths.getValue("RM_PATH") + " " + this.remotePubKey;
        if (!this.setupObj.runCommandHelper(this.host, r_command, cmd)) {
            return false;
        }
        r_command = this.remotePaths.getValue("RM_PATH") + " " + this.remotePrivateKey;
        if (!this.setupObj.runCommandHelper(this.host, r_command, cmd)) {
            return false;
        }
        r_command = this.remotePaths.getValue("SSH2_KEYGEN_PATH") + " " + this.remotePaths.getValue("SSH2_KEYGEN_ARGS") + " " + this.remotePaths.getValue("SSH2_KEYGEN_ARGS_NO_PASSPHRASE") + " " + "\"" + this.remotePrivateKey + "\"";
        if (!this.setupObj.runCommandHelper(this.host, r_command, cmd)) {
            OiiolTextLogger.appendText((String)("SSH key generation failed on the node '" + this.host + "'"));
            return false;
        }
        r_command = this.remotePaths.getValue("SHELL_PATH") + " " + this.remotePaths.getValue("SHELL_ARGS") + " \"echo idKey " + OiixPathOps.getFileName((String)this.remotePrivateKey) + " > " + this.identification + "\"";
        if (!this.setupObj.runCommandHelper(this.host, r_command, cmd)) {
            OiiolTextLogger.appendText((String)("Private key mapping failed on the node '" + this.host + "'"));
            return false;
        }
        return true;
    }

    @Override
    public boolean sharePublicKeys() {
        if (this.host.equals(this.localFQDN) || this.host.equals(this.localHost) || this.host.equals(this.localIpAddress)) {
            return true;
        }
        RunCommand cmd = null;
        String localPublicKey = null;
        String remotePubKey = null;
        String[] remoteHosts = this.info.getRemoteHosts();
        String username = this.info.getUsername();
        String password = this.info.getPassword();
        RunCommand permission = new RunCommand(this.host, username, password, this.sshPort, true, true);
        int loopCount = this.setupObj.calculateLoopCount();
        cmd = new RunCommand(this.host, username, password, this.sshPort, true, true);
        cmd.setSshHome(this.remoteSSHDir);
        this.backUpDeleteOldKeys(this.host, this.remoteAuthorization, cmd);
        cmd = new RunCommand(this.localFQDN, username, password, this.sshPort, true, true);
        cmd.setSshHome(this.localSSHDir);
        for (int j = 0; j < loopCount; ++j) {
            localPublicKey = SSHSetupUtil.getNativePath(this.localSSHDir, "identity." + remoteHosts[j] + ".ssh2.pub");
            remotePubKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, "identity." + remoteHosts[j] + ".ssh2.pub");
            boolean publicKeyExists = SSHSetupUtil.checkFileExistsOnRemoteNode(this.host, remotePubKey, username, password, this.sshPort, this.remotePaths, true);
            if (publicKeyExists) {
                OiiolTextLogger.appendText((String)(" The public key file of the node '" + remoteHosts[j] + "' is already present in the node '" + this.host + "'"));
                continue;
            }
            String scpCommand = this.remoteScpPath + " " + "-oAllowedAuthentications=\"password\" -q -p" + " " + " -P" + " " + this.sshPort + " " + localPublicKey + " " + username + "@" + this.host + ":" + this.remoteSSHDir;
            if (!this.setupObj.runCommandHelper(this.localFQDN, scpCommand, cmd)) continue;
            this.setupObj.changeRemoteFilePermission(this.host, localPublicKey, "644", permission);
        }
        cmd = new RunCommand(this.localFQDN, username, password, this.sshPort, true, true);
        cmd.setSshHome(this.localSSHDir);
        String scpCommand = this.remoteScpPath + " " + "-oAllowedAuthentications=\"password\" -q -p" + " " + " -P" + " " + this.sshPort + " " + this.localAuthorization + " " + username + "@" + this.host + ":" + this.remoteSSHDir;
        if (!this.setupObj.runCommandHelper(this.localFQDN, scpCommand, cmd)) {
            OiiolTextLogger.appendText((String)(" Copying of " + this.localAuthorization + " file to the node: " + this.host + " failed."));
            return false;
        }
        this.setupObj.changeRemoteSSHPermissions(this.host, this.localAuthorization, this.setupObj.remoteHome, this.remoteSSHDir, permission);
        OiiolTextLogger.appendText((String)(" Copied the file: " + this.localAuthorization + " to the host: " + this.host));
        return true;
    }

    @Override
    public synchronized boolean shareHostKeys() {
        OiiolTextLogger.appendText((String)("LocalFQDN = " + this.localFQDN + " LocalHostName = " + this.localHost + " LocalIPAddress = " + this.localIpAddress + " RemoteHost = " + this.host));
        if (this.host.equals(this.localFQDN) || this.host.equals(this.localHost) || this.host.equals(this.localIpAddress)) {
            return true;
        }
        String username = this.info.getUsername();
        String password = this.info.getPassword();
        RunCommand cmd = new RunCommand(this.host, username, password, this.sshPort, true);
        cmd.setSshHome(this.localSSHDir);
        HashSet<String> newNodes = new HashSet<String>();
        newNodes.addAll(Arrays.asList(this.info.getNewNodes()));
        if (newNodes.contains(this.host)) {
            OiiolTextLogger.appendText((String)(this.host + " is a new node"));
            if (!this.setupObj.createRemoteDir(this.host, cmd, this.remoteHostKeysDir)) {
                OiiolTextLogger.appendText((String)("Creation of hostkeys directory on '" + this.host + "' failed"));
                return false;
            }
        }
        InetAddress inetAddr = null;
        String fullHostName = "";
        String hostName = "";
        String hostKeyFile = null;
        String fullHostNameKeyFile = null;
        String ipKeyFile = null;
        String[] remoteHosts = this.info.getRemoteHosts();
        boolean errorOccurred = false;
        for (int j = 0; j < remoteHosts.length; ++j) {
            try {
                inetAddr = InetAddress.getByName(remoteHosts[j]);
                fullHostName = inetAddr.getHostName();
                hostName = SSHSetupUtil.getHostName(fullHostName);
                fullHostName = SSHSetupUtil.getFullHostName(inetAddr);
                hostKeyFile = SSHSetupUtil.getNativePath(this.localHostKeysDir, "key_" + String.valueOf(this.sshPort) + "_" + hostName + ".pub");
                fullHostNameKeyFile = SSHSetupUtil.getNativePath(this.localHostKeysDir, "key_" + String.valueOf(this.sshPort) + "_" + fullHostName + ".pub");
                ipKeyFile = SSHSetupUtil.getNativePath(this.localHostKeysDir, "key_" + String.valueOf(this.sshPort) + "_" + inetAddr.getHostAddress() + ".pub");
                boolean hostKeyExists = SSHSetupUtil.checkFileExistsOnRemoteNode(this.host, hostKeyFile + " " + this.remotePrivateKey + " " + ipKeyFile, username, password, this.sshPort, this.remotePaths, true);
                if (hostKeyExists) {
                    OiiolTextLogger.appendText((String)(" All the host key files of " + remoteHosts[j] + " are present on " + this.host));
                    continue;
                }
                cmd = new RunCommand(this.localFQDN, username, password, this.sshPort, true, true);
                cmd.setSshHome(this.localSSHDir);
                String scpCommand = this.remoteScpPath + " " + "-oAllowedAuthentications=\"password\" -q -p" + " " + " -P" + " " + this.sshPort + " " + hostKeyFile + " " + username + "@" + this.host + ":" + this.remoteHostKeysDir;
                if (!this.setupObj.runCommandHelper(this.localFQDN, scpCommand, cmd)) continue;
                OiiolTextLogger.appendText((String)(" SCP command-1: '" + scpCommand + "' succeeded"));
                scpCommand = this.remoteScpPath + " " + "-oAllowedAuthentications=\"password\" -q -p" + " " + " -P" + " " + this.sshPort + " " + fullHostNameKeyFile + " " + username + "@" + this.host + ":" + this.remoteHostKeysDir;
                if (!this.setupObj.runCommandHelper(this.localFQDN, scpCommand, cmd)) continue;
                OiiolTextLogger.appendText((String)(" SCP command-2: '" + scpCommand + "' succeeded"));
                scpCommand = this.remoteScpPath + " " + "-oAllowedAuthentications=\"password\" -q -p" + " " + " -P" + " " + this.sshPort + " " + ipKeyFile + " " + username + "@" + this.host + ":" + this.remoteHostKeysDir;
                if (!this.setupObj.runCommandHelper(this.localFQDN, scpCommand, cmd)) continue;
                OiiolTextLogger.appendText((String)(" SCP command-3: '" + scpCommand + "' succeeded"));
                continue;
            }
            catch (UnknownHostException uhe) {
                OiiolTextLogger.appendException((Throwable)uhe);
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            OiiolTextLogger.appendText((String)(" Some of the hostfiles are not copied from local node to the node: " + this.host));
        } else {
            OiiolTextLogger.appendText((String)(" Successfully copied all the hostfiles from local node to the node: " + this.host));
        }
        return true;
    }

    public String getLocalHostKeysDir() {
        return this.localHostKeysDir;
    }

    public void setLocalHostKeysDir(String localHostKeysDir) {
        this.localHostKeysDir = localHostKeysDir;
    }

    public String getRemoteHostKeysDir() {
        return this.remoteHostKeysDir;
    }

    public void setRemoteHostKeysDir(String remoteHostKeysDir) {
        this.remoteHostKeysDir = remoteHostKeysDir;
    }

    private void backUpDeleteOldKeys(String remoteNode, String keyFile, RunCommand cmd) {
        String r_command = null;
        r_command = this.remotePaths.getValue("CP_PATH") + " " + this.remotePaths.getValue("CP_ARGS_2") + " " + keyFile + " " + keyFile + ".ri.bak";
        this.setupObj.runCommandHelper(remoteNode, r_command, cmd);
        r_command = this.remotePaths.getValue("RM_PATH") + " " + this.remotePaths.getValue("RM_F_ARGS") + " " + keyFile;
        this.setupObj.runCommandHelper(remoteNode, r_command, cmd);
    }
}

