/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.concurrent.Callable;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.ssh.BaseSSHSetup;
import oracle.sysman.prov.ssh.FileCopyJob;
import oracle.sysman.prov.ssh.FileLockException;
import oracle.sysman.prov.ssh.RunCommand;
import oracle.sysman.prov.ssh.SSHKeyGenJob;
import oracle.sysman.prov.ssh.SSHSetupException;
import oracle.sysman.prov.ssh.SSHSetupInfo;
import oracle.sysman.prov.ssh.SSHSetupTasks;
import oracle.sysman.prov.ssh.SSHSetupUtil;
import oracle.sysman.prov.ssh.TectiaSSHTasks;
import oracle.sysman.prov.ssh.UndoSSHSetupException;

public class TectiaSSHSetup
extends BaseSSHSetup {
    private String localHostKeysDir = null;
    private String remoteHostKeysDir = null;

    public TectiaSSHSetup(SSHSetupInfo info) throws SSHSetupException {
        super(info);
        this.localSSHDir = SSHSetupUtil.getNativePath(info.getHome(), ".ssh2");
    }

    @Override
    protected void initialize() throws SSHSetupException {
        super.initialize();
        if (!SSHSetupUtil.isTectiaServer(this.info.getRemoteHosts(), this.sshPort)) {
            throw new SSHSetupException("Different type of ssh daemon running on the machines");
        }
        if (this.info.getLocalSshDir() == null || this.info.getLocalSshDir().equals("")) {
            this.info.setLocalSshDir(SSHSetupUtil.getNativePath(this.info.getHome(), ".ssh2"));
        }
        this.remoteSSHDir = SSHSetupUtil.getNativePath(this.remoteHome, ".ssh2");
        this.identification = SSHSetupUtil.getNativePath(this.remoteSSHDir, "identification");
        this.remotePubKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, "identity.pub");
        this.remotePrivateKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, "identity");
        this.localPubKey = SSHSetupUtil.getNativePath(this.info.getLocalSshDir(), "identity.pub");
        this.localPrivateKey = SSHSetupUtil.getNativePath(this.info.getLocalSshDir(), "identity");
        this.remoteScpPath = this.remotePaths.getValue("SCP2_PATH");
        this.localScpPath = this.localPaths.getValue("SCP2_PATH");
        this.remoteHostKeysDir = SSHSetupUtil.getNativePath(this.remoteSSHDir, "hostkeys");
        this.localHostKeysDir = SSHSetupUtil.getNativePath(this.info.getLocalSshDir(), "hostkeys");
        this.remoteAuthorization = SSHSetupUtil.getNativePath(this.remoteSSHDir, "authorization");
        this.localAuthorization = SSHSetupUtil.getNativePath(this.info.getLocalSshDir(), "authorization");
    }

    @Override
    protected void postSSHTasks() throws FatalException, ClusterException {
    }

    @Override
    protected void changePermissionOnSSH() throws ClusterException, FatalException {
        super.setUserHomeDirectoryPermissionOnLocalNode();
        this.setPermissionsOnSshDir(OiixPathOps.getStandardForm((String)this.localSSHDir));
    }

    protected void setPermissionsOnSshDir(String dir) throws FatalException, ClusterException {
        this.changePermission(dir, null, "755");
        this.changePermission(dir, "identity.pub", "644");
        this.changePermission(dir, "hostkeys", "755");
        this.changePermission(dir, "identity", "600");
        this.changePermission(dir, "authorization", "644");
        this.changePermission(dir, "identification", "644");
        String[] remoteHosts = this.info.getRemoteHosts();
        for (int i = 0; i < remoteHosts.length; ++i) {
            this.changePermission(dir, "identity." + remoteHosts[i] + ".ssh2.pub", "644");
        }
    }

    @Override
    protected void establishConnectionAsUser() throws SSHSetupException, ClusterException, FatalException {
    }

    @Override
    protected void setUpSSHFromLocal() throws SSHSetupException, ClusterException, FatalException {
        this.generateKeys();
        this.addToAuthorizationFile();
        this.addToIdentificationFile();
        this.remoteHosts = this.info.getRemoteHosts();
        this.generateHostKeys();
        for (int j = 0; j < this.connectionCount; ++j) {
            if (this.remoteHosts[j].equals(this.localFQDN)) continue;
            this.performRemoteSSHSetup(this.remoteHosts[j]);
        }
    }

    private void generateKeys() throws SSHSetupException, FatalException, ClusterException {
        File f1 = new File(this.localPrivateKey);
        File f2 = new File(this.localPubKey);
        if (f1.exists() && f2.exists() && !this.info.isOflag()) {
            OiiolTextLogger.appendText((String)"User selected : no, using Old keys");
        } else {
            if (this.info.isOflag()) {
                OiiolTextLogger.appendText((String)"User selected : yes, generating new Keys");
            } else {
                OiiolTextLogger.appendText((String)"Public, Private keys don't exist, generating new Keys");
            }
            if (f1.exists() && f2.exists() && this.info.isOflag()) {
                SSHSetupUtil.backupAndDeleteFile(this.localPrivateKey, true);
                SSHSetupUtil.backupAndDeleteFile(this.localPubKey, true);
            } else {
                f1.delete();
                f2.delete();
            }
            OiiolTextLogger.appendText((String)("[" + this.localHost + "]"));
            OiiolTextLogger.appendText((String)"Generating new keys");
            try {
                String args = null;
                args = null == this.info.getPassphrase() ? this.localPaths.getValue("SSH2_KEYGEN_ARGS") + " " + this.localPaths.getValue("SSH2_KEYGEN_ARGS_NO_PASSPHRASE") : this.localPaths.getValue("SSH2_KEYGEN_ARGS") + " " + this.localPaths.getValue("SSH2_KEYGEN_ARGS_PASSPHRASE") + " " + this.info.getPassphrase();
                String cmd = this.localPaths.getValue("SSH2_KEYGEN_PATH") + " " + args + " " + "\"" + this.localPrivateKey + "\"";
                SSHSetupUtil.runCmdOnLocalNodeHelper(cmd);
            }
            catch (Exception e) {
                this.processSSHException(e, "Key Generation", false, this.localSSHDir);
            }
        }
    }

    protected void addToAuthorizationFile() throws SSHSetupException {
        if (this.sharedHome || this.sameUser) {
            if (new File(this.localAuthorization).exists() && this.info.isOflag()) {
                SSHSetupUtil.backupAndDeleteFile(this.localAuthorization, this.info.isNoDelete());
            }
            try {
                OiixFileOps.appendLine((String)this.localAuthorization, (String)("Key " + OiixPathOps.getFileName((String)this.localPubKey)));
            }
            catch (IOException e) {
                this.processSSHException(e, "Append authorization", true, this.localSSHDir);
            }
        }
    }

    private void addToIdentificationFile() throws SSHSetupException {
        String identification = SSHSetupUtil.getNativePath(this.localSSHDir, "identification");
        if (new File(identification).exists() && this.info.isOflag()) {
            SSHSetupUtil.backupAndDeleteFile(identification, this.info.isNoDelete());
        }
        try {
            String str = "IdKey " + OiixPathOps.getFileName((String)this.localPrivateKey);
            String[] contents = null;
            try {
                contents = SSHSetupUtil.readFile(identification);
            }
            catch (CommandException e) {
                this.commandResults.put("LocalHost", "Read File " + identification);
                this.commandExceptions.put("LocalHost", new CommandException("LocalHost", e.getMessage()));
            }
            boolean idFound = false;
            if (null != contents) {
                for (int i = 0; i < contents.length; ++i) {
                    if (!str.equals(contents[i])) continue;
                    idFound = true;
                }
            }
            if (!idFound) {
                OiixFileOps.appendLine((String)identification, (String)str);
            }
        }
        catch (IOException e) {
            this.processSSHException(e, "Append identification", true, this.localSSHDir);
        }
    }

    protected void generateHostKeys() {
        File fHostKeys = new File(this.localHostKeysDir);
        if (fHostKeys.exists() ? fHostKeys.isFile() : !fHostKeys.mkdir()) {
            // empty if block
        }
        HashSet taskBackup = new HashSet();
        taskBackup.addAll(this.listofTasks);
        this.listofTasks.clear();
        for (int i = 0; i < this.remoteHosts.length; ++i) {
            CopyHostKeys copyFile = new CopyHostKeys(this.remoteHosts[i]);
            this.listofTasks.add(copyFile);
        }
        if (super.executeTasks()) {
            OiiolTextLogger.appendText((String)"Copying of host key files from all the nodes to local completed");
        } else {
            OiiolTextLogger.appendText((String)"Copying of the host key failed for some nodes");
        }
        this.listofTasks.clear();
        this.listofTasks.addAll(taskBackup);
        taskBackup.clear();
        taskBackup = null;
    }

    protected void performRemoteSSHSetup(String remoteNode) {
        RunCommand cmd = new RunCommand(remoteNode, this.info.getUsername(), this.info.getPassword(), this.sshPort, true);
        cmd.setSshHome(this.localSSHDir);
        if (!this.createRemoteDir(remoteNode, cmd, this.remoteSSHDir)) {
            return;
        }
        String r_pub = "identity." + this.localFQDN + ".ssh2.pub";
        String r_pub_key = SSHSetupUtil.getNativePath(this.remoteSSHDir, r_pub);
        if (!this.removeFile2(remoteNode, cmd, r_pub_key, true)) {
            return;
        }
        String[] pubKeySSH2 = null;
        try {
            pubKeySSH2 = SSHSetupUtil.readFile(this.localPubKey);
        }
        catch (CommandException e) {
            this.commandResults.put("LocalHost", "Read File " + this.localPubKey);
            this.commandExceptions.put("LocalHost", new CommandException("LocalHost", e.getMessage()));
        }
        if (pubKeySSH2 == null) {
            return;
        }
        for (int i = 0; i < pubKeySSH2.length; ++i) {
            if (pubKeySSH2[i].startsWith("Comment") || this.r_shellCmd(remoteNode, cmd, pubKeySSH2[i], r_pub_key)) continue;
            return;
        }
        this.changeRemoteFilePermission(remoteNode, r_pub_key, "644", cmd);
        if (!this.remoteFileCopy(remoteNode, cmd, this.remoteAuthorization, this.remoteAuthorization + ".ri.bak")) {
            return;
        }
        if (!this.removeFile2(remoteNode, cmd, this.remoteAuthorization, true)) {
            return;
        }
        String r_command = this.remotePaths.getValue("CAT_PATH") + " " + "\"" + this.remoteAuthorization + "\"";
        String str = "Key " + OiixPathOps.getFileName((String)r_pub_key);
        if (!(this.runCommandHelper(remoteNode, r_command, cmd) && cmd.getOutput().indexOf(str) != -1 || this.r_shellCmd(remoteNode, cmd, str, this.remoteAuthorization))) {
            return;
        }
        this.changeRemoteSSHPermissions(remoteNode, this.remoteAuthorization, this.remoteHome, this.remoteSSHDir, cmd);
    }

    @Override
    protected void setupN2NConnectivity() throws FatalException, ClusterException {
        this.sshKeyGen();
        this.setupSSHKeys();
        this.generateHostKeys();
        this.updateHostkeys();
        this.updatePublickeys();
    }

    protected void sshKeyGen() {
        if (this.info.reuseKey()) {
            this.remoteHosts = this.info.getNewNodes();
            super.calculateNewLoopCount_AddNewNodes();
        } else {
            this.remoteHosts = this.info.getRemoteHosts();
        }
        for (int i = 0; i < this.connectionCount; ++i) {
            TectiaSSHTasks taskObj = new TectiaSSHTasks(this.remoteHosts[i], this);
            taskObj.setLocalHostKeysDir(this.localHostKeysDir);
            taskObj.setRemoteHostKeysDir(this.remoteHostKeysDir);
            this.taskMap.put(this.remoteHosts[i], taskObj);
            SSHKeyGenJob sshkeygen = new SSHKeyGenJob(taskObj);
            this.listofTasks.add(sshkeygen);
        }
        if (super.executeTasks()) {
            OiiolTextLogger.appendText((String)"Keygen was successful for all the new nodes.");
        }
    }

    protected void setupSSHKeys() throws ClusterException, FatalException {
        String pubKeySSH2 = null;
        if (new File(this.localAuthorization).exists()) {
            SSHSetupUtil.backupAndDeleteFile(this.localAuthorization, this.info.isOflag());
            OiiolTextLogger.appendText((String)"Backed up existing authorization file");
        }
        String appendCmd = this.localPaths.getValue("SHELL_PATH") + " " + this.localPaths.getValue("SHELL_ARGS") + " " + "\"echo Key " + OiixPathOps.getFileName((String)this.localPubKey) + " >> " + this.localAuthorization + "\"";
        SSHSetupUtil.runCmdOnLocalNodeHelper(appendCmd);
        for (int i = 0; i < this.connectionCount; ++i) {
            pubKeySSH2 = SSHSetupUtil.getNativePath(this.localSSHDir, "identity." + this.remoteHosts[i] + ".ssh2.pub");
            if (new File(pubKeySSH2).exists()) {
                SSHSetupUtil.backupAndDeleteFile(pubKeySSH2, false);
            }
            if (this.remoteHosts[i].equals(this.localFQDN)) {
                this.copyPublicKeyInLocal(pubKeySSH2);
            } else {
                this.copyPublicKey(this.remoteHosts[i], pubKeySSH2);
            }
            appendCmd = this.localPaths.getValue("SHELL_PATH") + " " + this.localPaths.getValue("SHELL_ARGS") + " " + "\"echo Key " + OiixPathOps.getFileName((String)pubKeySSH2) + " >> " + this.localAuthorization + "\"";
            SSHSetupUtil.runCmdOnLocalNodeHelper(appendCmd);
        }
    }

    protected boolean copyPublicKey(String remoteHost, String newName) {
        RunCommand cmd = new RunCommand(remoteHost, this.info.getUsername(), this.info.getPassword(), this.sshPort, true, true);
        cmd.setSshHome(this.localSSHDir);
        if (!this.r_catCmd(remoteHost, cmd, "\"" + this.remotePubKey + "\"")) {
            return false;
        }
        SSHSetupUtil.writeStringToFile(newName, cmd.getOutput(), false);
        return true;
    }

    protected void copyPublicKeyInLocal(String newName) throws ClusterException, FatalException {
        String command = this.localPaths.getValue("CAT_PATH") + " " + this.localPubKey + " >> " + newName;
        SSHSetupUtil.runCmdOnLocalNodeHelper(command);
    }

    protected void updateHostkeys() throws ClusterException, FatalException {
        String[] remoteHosts = this.info.getRemoteHosts();
        this.listofTasks.clear();
        this.setupFileCopyTasks(remoteHosts, remoteHosts.length, true);
        if (super.executeTasks()) {
            OiiolTextLogger.appendText((String)"Copying of host key files from local node to all other nodes completed ");
        } else {
            OiiolTextLogger.appendText((String)"Copying of host key files from local node failed ");
        }
    }

    protected void updatePublickeys() throws ClusterException, FatalException {
        String[] remoteHosts = this.info.getRemoteHosts();
        this.connectionCount = super.calculateLoopCount();
        this.setupFileCopyTasks(remoteHosts, this.connectionCount, false);
        if (super.executeTasks()) {
            OiiolTextLogger.appendText((String)("Completed the copying of all the public keys &  " + this.localAuthorization + " from local node to all the nodes successfully."));
        } else {
            OiiolTextLogger.appendText((String)"Copying of public keys related files failed from the local node");
        }
    }

    @Override
    protected void validateInstalledSSH() throws FatalException, ClusterException, SSHSetupException {
        try {
            this.validateRemoteHosts(this.info.getRemoteHosts(), this.info.getUsername());
        }
        catch (FileLockException fle) {
            throw new SSHSetupException((Throwable)((Object)fle));
        }
    }

    protected boolean validateRemoteBinaries(String[] remoteHosts, String username) throws SSHSetupException {
        RunCommand cmd = null;
        String remoteHostKey = null;
        String password = this.info.getPassword();
        String shPath = this.remotePaths.getValue("SH_PATH");
        String shArgs = this.remotePaths.getValue("SH_ARGS");
        String sshKeygen = this.remotePaths.getValue("SSH2_KEYGEN_PATH");
        String hostKeyLoc = this.remotePaths.getValue("SSH2_HOST_KEY_LOC");
        String cmd2 = this.remotePaths.getValue("TRUE");
        String cmd2Value = this.remotePaths.getValue("CMD2");
        String h_cmd = shPath + " " + shArgs + " '" + cmd2 + "'";
        OiiolTextLogger.appendText((String)("shPath = " + shPath + " shArgs = " + shArgs + " sshKeygen = " + sshKeygen + " hostKeyLoc = " + hostKeyLoc + " hostKeyPub = " + "hostkey.pub" + " cmd2 = " + cmd2 + " cmd2Value = " + cmd2Value + " h_cmd = " + h_cmd));
        for (int i = 0; i < remoteHosts.length; ++i) {
            cmd = new RunCommand(remoteHosts[i], username, password, this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            OiiolTextLogger.appendText((String)"Checking SH args");
            OiiolTextLogger.appendText((String)("Command " + h_cmd));
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd)) {
                return false;
            }
            if (cmd.getExitCode() != 0) {
                throw new SSHSetupException("Existence check failed for " + shPath + " on node: " + remoteHosts[i] + ". Please check whether the file exists." + "If the file exists, please correct the shell path given in the properties file used.");
            }
            cmd = new RunCommand(remoteHosts[i], username, password, this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            remoteHostKey = SSHSetupUtil.remotePublicKey(hostKeyLoc, "hostkey.pub");
            cmd2 = MessageFormat.format(cmd2Value, "", remoteHostKey, "", "", "-f");
            h_cmd = shPath + " " + shArgs + " '" + cmd2 + "'";
            OiiolTextLogger.appendText((String)"Checking hostkey");
            OiiolTextLogger.appendText((String)("Command " + h_cmd));
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd)) {
                return false;
            }
            if (cmd.getExitCode() != 0) {
                throw new SSHSetupException("Unable to find " + remoteHostKey + " on node: " + remoteHosts[i] + ". Please check whether the file exists or " + "the user '" + System.getProperty("user.name") + "' has sufficient privilege to access this file.");
            }
            cmd = new RunCommand(remoteHosts[i], username, password, this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            cmd2 = MessageFormat.format(cmd2Value, "", sshKeygen, "", "", "-f");
            h_cmd = shPath + " " + shArgs + " '" + cmd2 + "'";
            OiiolTextLogger.appendText((String)"Checking ssh keygen");
            OiiolTextLogger.appendText((String)("Command " + h_cmd));
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd)) {
                return false;
            }
            if (cmd.getExitCode() == 0) continue;
            throw new SSHSetupException("Unable to find " + sshKeygen + " on node: " + remoteHosts[i] + ". Please check whether the file exists or " + "the user has sufficient privilege to access this file.");
        }
        return true;
    }

    @Override
    public void tearDownSSH() throws UndoSSHSetupException, ClusterException, FatalException {
        try {
            this.sshDeleteOperation = true;
            this.initialize();
            if (this.sharedHome) {
                this.removeLocalSSH2Setup();
            } else {
                this.removeRemoteSSHSetup();
            }
        }
        catch (SSHSetupException e) {
            throw new UndoSSHSetupException((Exception)((Object)e));
        }
    }

    protected String getLocalHostKeysDir() {
        return this.localHostKeysDir;
    }

    protected String getRemoteHostKeysDir() {
        return this.remoteHostKeysDir;
    }

    private void removeLocalSSH2Setup() {
        OiiolTextLogger.appendText((String)" Inside 'removeLocalSSH2Setup' method.");
        String localTemp = this.localAuthorization + ".tmp";
        SSHSetupUtil.backupAndDeleteFile(this.localAuthorization, true);
        if (!this.removeEntryFromAuthorizationFile(this.localAuthorization)) {
            return;
        }
        try {
            SSHSetupUtil.copyFile(this.localAuthorization + ".tmp", this.localAuthorization);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Throwable)e);
            try {
                SSHSetupUtil.copyFile(this.localAuthorization + ".ri.bak", this.localAuthorization);
            }
            catch (IOException e1) {
                OiiolTextLogger.appendException((Throwable)e1);
            }
            return;
        }
        SSHSetupUtil.deleteFile(localTemp);
        SSHSetupUtil.deleteFile(this.localAuthorization + ".ri.bak");
        String hostKeysFile = "key_" + String.valueOf(this.sshPort) + "_" + this.localFQDN + ".pub";
        SSHSetupUtil.deleteFile(SSHSetupUtil.getNativePath(this.localHostKeysDir, hostKeysFile));
        SSHSetupUtil.deleteFile(SSHSetupUtil.getNativePath(this.localSSHDir, "identity." + this.localFQDN + ".ssh2.pub"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeEntryFromAuthorizationFile(String fileName) {
        String tempAuthFile = fileName + ".tmp";
        BufferedWriter bw = null;
        BufferedReader br = null;
        String currentLine = null;
        try {
            br = new BufferedReader(new FileReader(fileName));
            bw = new BufferedWriter(new FileWriter(tempAuthFile));
            String localpubKeyFileName = "identity." + this.localFQDN + ".ssh2.pub";
            while ((currentLine = br.readLine()) != null) {
                if (currentLine.contains(localpubKeyFileName)) continue;
                bw.write(currentLine + "\n");
            }
            SSHSetupUtil.deleteFile(fileName);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            OiiolTextLogger.appendException((Throwable)e);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Throwable)e);
        }
        finally {
            try {
                if (null != br) {
                    br.close();
                }
                if (null != bw) {
                    bw.close();
                }
            }
            catch (IOException e) {
                OiiolTextLogger.appendException((Throwable)e);
            }
        }
        return false;
    }

    private void removeRemoteSSHSetup() {
        String[] remoteNode = this.info.getRemoteHosts();
        OiiolTextLogger.appendText((String)" Inside 'removeRemoteSSHSetup' method.");
        for (int i = 0; i < this.connectionCount; ++i) {
            RunCommand cmd = new RunCommand(this.localFQDN, this.info.getUsername(), this.info.getPassword(), this.sshPort, true, true);
            cmd.setSshHome(this.localSSHDir);
            String localTemp = SSHSetupUtil.getNativePath(this.localSSHDir, "authorization." + remoteNode[i]);
            String localTemp1 = localTemp + ".tmp";
            String scpCommand = this.localScpPath + " " + "-oAllowedAuthentications=\"password\" -q -p" + " " + " -P" + " " + this.sshPort + " " + this.info.getUsername() + "@" + remoteNode[i] + ":" + this.remoteAuthorization + " " + localTemp;
            if (!this.runCommandHelper(this.localFQDN, scpCommand, cmd) || !this.removeEntryFromAuthorizationFile(localTemp) || !this.runCommandHelper(this.localFQDN, scpCommand = this.localScpPath + " " + "-oAllowedAuthentications=\"password\" -q -p" + " " + " -P" + " " + this.sshPort + " " + localTemp1 + " " + this.info.getUsername() + "@" + remoteNode[i] + ":" + this.remoteAuthorization, cmd)) continue;
            SSHSetupUtil.deleteFile(localTemp1);
            String pubKeyFileName = "identity." + this.localFQDN + ".ssh2.pub";
            String pubKeyFile = null;
            String hostKeyPath = null;
            cmd = new RunCommand(remoteNode[i], this.info.getUsername(), this.info.getPassword(), this.sshPort, true, true);
            cmd.setSshHome(this.localSSHDir);
            if (remoteNode[i].equals(this.localFQDN)) {
                pubKeyFile = OiixPathOps.concatPath((String)this.localSSHDir, (String)pubKeyFileName);
                hostKeyPath = SSHSetupUtil.getNativePath(this.localHostKeysDir, "key_" + String.valueOf(this.sshPort) + "_" + this.localFQDN + ".pub");
                SSHSetupUtil.deleteFile(hostKeyPath);
                SSHSetupUtil.deleteFile(pubKeyFile);
                SSHSetupUtil.deleteFile(SSHSetupUtil.getNativePath(this.localSSHDir, "identification"));
                continue;
            }
            hostKeyPath = SSHSetupUtil.getNativePath(this.remoteHostKeysDir, "key_" + String.valueOf(this.sshPort) + "_" + this.localFQDN + ".pub");
            pubKeyFile = OiixPathOps.concatPath((String)this.remoteSSHDir, (String)pubKeyFileName);
            if (SSHSetupUtil.removeRemoteFileHelper(cmd, pubKeyFile, this.remotePaths)) {
                OiiolTextLogger.appendText((String)("Deleted the file : " + pubKeyFile + "  from the host : " + remoteNode[i]));
            }
            if (!SSHSetupUtil.removeRemoteFileHelper(cmd, hostKeyPath, this.remotePaths)) continue;
            OiiolTextLogger.appendText((String)("Deleted the file : " + hostKeyPath + "  from the host : " + remoteNode[i]));
        }
    }

    private void validateRemoteHosts(String[] remoteHosts, String username) throws FileLockException, SSHSetupException {
        OiiolTextLogger.appendText((String)"Validating remote binaries..");
        try {
            if (this.validateRemoteBinaries(remoteHosts, username)) {
                OiiolTextLogger.appendText((String)"Remote binaries check succeeded");
            }
        }
        catch (SSHSetupException e) {
            OiiolTextLogger.appendText((String)e.getMessage());
            throw e;
        }
    }

    private void setupFileCopyTasks(String[] remoteHosts, int count, boolean createCopyTaskForAllNodes) {
        FileCopyJob copyTask = null;
        for (int i = 0; i < count; ++i) {
            boolean createCopyTask = false;
            SSHSetupTasks task = null;
            if (this.taskMap.containsKey(remoteHosts[i])) {
                task = this.taskMap.get(remoteHosts[i]);
            } else {
                task = new TectiaSSHTasks(remoteHosts[i], this);
                this.taskMap.put(remoteHosts[i], task);
                createCopyTask = true;
            }
            if (!createCopyTask && !createCopyTaskForAllNodes) continue;
            copyTask = new FileCopyJob(task, true);
            this.listofTasks.add(copyTask);
        }
    }

    class CopyHostKeys
    implements Callable<Boolean> {
        String nodeName;

        private CopyHostKeys(String string) {
            this.nodeName = string;
        }

        @Override
        public Boolean call() {
            try {
                InetAddress inetAddr = InetAddress.getByName(this.nodeName);
                String fullHostName = inetAddr.getHostName();
                String hostName = SSHSetupUtil.getHostName(fullHostName);
                fullHostName = SSHSetupUtil.getFullHostName(inetAddr);
                String hostkeyFileName = "key_" + String.valueOf(TectiaSSHSetup.this.sshPort) + "_" + hostName + ".pub";
                String hostKeyFile = SSHSetupUtil.getNativePath(TectiaSSHSetup.this.localHostKeysDir, hostkeyFileName);
                hostkeyFileName = "key_" + String.valueOf(TectiaSSHSetup.this.sshPort) + "_" + fullHostName + ".pub";
                String fullHostNameKeyFile = SSHSetupUtil.getNativePath(TectiaSSHSetup.this.localHostKeysDir, hostkeyFileName);
                String ipKeyFile = SSHSetupUtil.getNativePath(TectiaSSHSetup.this.localHostKeysDir, "key_" + String.valueOf(TectiaSSHSetup.this.sshPort) + "_" + inetAddr.getHostAddress() + ".pub");
                if (new File(hostKeyFile).exists()) {
                    SSHSetupUtil.backupAndDeleteFile(hostKeyFile, false);
                }
                if (new File(fullHostNameKeyFile).exists()) {
                    SSHSetupUtil.backupAndDeleteFile(fullHostNameKeyFile, false);
                }
                if (new File(ipKeyFile).exists()) {
                    SSHSetupUtil.backupAndDeleteFile(ipKeyFile, false);
                }
                RunCommand cmd = new RunCommand(this.nodeName, TectiaSSHSetup.this.info.getUsername(), TectiaSSHSetup.this.info.getPassword(), TectiaSSHSetup.this.sshPort, true, true);
                cmd.setSshHome(TectiaSSHSetup.this.localSSHDir);
                if (!TectiaSSHSetup.this.r_catCmd(this.nodeName, cmd, "\"" + SSHSetupUtil.remotePublicKey(TectiaSSHSetup.this.remotePaths.getValue("SSH2_HOST_KEY_LOC"), "hostkey.pub") + "\"")) {
                    OiiolTextLogger.appendText((String)("Copying of the host key failed for the node : " + this.nodeName));
                    return new Boolean(false);
                }
                SSHSetupUtil.writeStringToFile(hostKeyFile, cmd.getOutput(), false);
                SSHSetupUtil.writeStringToFile(fullHostNameKeyFile, cmd.getOutput(), false);
                SSHSetupUtil.writeStringToFile(ipKeyFile, cmd.getOutput(), false);
                return new Boolean(true);
            }
            catch (UnknownHostException e) {
                OiiolTextLogger.appendText((String)("Copying of the host key failed for the node : " + this.nodeName + " .Exception is :" + e.getMessage()));
                return new Boolean(false);
            }
        }
    }
}

