/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterBaseOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.SharedDeviceException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Commands;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Platform;
import oracle.sysman.prov.ssh.RunCommand;
import oracle.sysman.prov.ssh.SSHSetupException;

public class SSHSetupUtil {
    protected static String getNativePathForSSHKeyGen(String sshDir, String file) {
        String path = SSHSetupUtil.constructPath(sshDir, file);
        return OiixPathOps.getNativeForm((String)path);
    }

    protected static String getNativePath(String sshDir, String file) {
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)file));
    }

    private static String constructPath(String parentDir, String file) {
        char firstChar;
        if (null == parentDir) {
            parentDir = "";
        }
        if (null != file && file.length() > 0 && ((firstChar = file.charAt(0)) == '/' || firstChar == File.separatorChar)) {
            file = file.substring(1);
        }
        parentDir = parentDir + File.separator;
        return parentDir + file;
    }

    protected static String remotePublicKey(String hostKeyLoc, String hostKeyPub) {
        return SSHSetupUtil.getNativePath(hostKeyLoc, hostKeyPub);
    }

    protected static String getSystemUserName() {
        return System.getProperty("user.name");
    }

    protected static void setOUILoc(String ouiLoc) {
        System.setProperty("oracle.installer.oui_loc", ouiLoc);
    }

    public static boolean mvfileHelper(String srcFilePath, String destFilePath, Paths localPaths) throws IOException {
        String command = null;
        File srcFile = new File(srcFilePath);
        if (srcFile.exists()) {
            OiiolTextLogger.appendText((String)("Restoring " + srcFilePath + " to " + destFilePath));
            command = SSHSetupUtil.mvCmd(srcFilePath, destFilePath, false, localPaths);
            try {
                SSHSetupUtil.runCmdOnLocalNodeHelper(command);
                return true;
            }
            catch (FatalException fe) {
                SSHSetupUtil.copyFile(srcFilePath, destFilePath);
                SSHSetupUtil.deleteFile(srcFilePath);
            }
            catch (ClusterException ce) {
                SSHSetupUtil.copyFile(srcFilePath, destFilePath);
                SSHSetupUtil.deleteFile(srcFilePath);
            }
            return true;
        }
        return false;
    }

    public static void backupAndDeleteFile(String filename, boolean noDelete) {
        try {
            OiixFileOps.backUpFile((String)filename, (String)(filename + ".ri.bak"));
            if (!noDelete) {
                File f = new File(filename);
                f.delete();
            }
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Throwable)e);
        }
    }

    public static boolean isSharedHome(boolean sameUser, String[] remoteHosts, String username, String homeDir, Paths remotePaths, Paths localPath, String password, int sshPort) {
        boolean sharedCase = true;
        if (sameUser) {
            if (OiixUtil.isNullOrBlank((String)homeDir, (boolean)true)) {
                homeDir = System.getProperty("user.home");
            }
            try {
                SSHSetupUtil.validateSharedPath(remoteHosts, username, homeDir, remotePaths, localPath, password, sshPort);
            }
            catch (SharedDeviceException sde) {
                sharedCase = false;
            }
        } else {
            sharedCase = false;
        }
        return sharedCase;
    }

    public static String getFullHostName(InetAddress inetAddr) {
        if (inetAddr == null) {
            return "";
        }
        String fullHostName = inetAddr.getHostName();
        int idx = fullHostName.indexOf(46);
        if (idx == -1) {
            fullHostName = inetAddr.getCanonicalHostName();
        }
        return fullHostName;
    }

    public static String getHostName(String fullHostName) {
        int idx = fullHostName.indexOf(46);
        String hostName = "";
        hostName = idx == -1 ? fullHostName : fullHostName.substring(0, idx);
        return hostName;
    }

    protected static String getLocalPropertiesPath() {
        String propertiesDir = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        if (OiixUtil.isNullOrBlank((String)propertiesDir, (boolean)true)) {
            String oui_loc = System.getProperty("oracle.installer.oui_loc");
            String propDir = OiixPathOps.concatPath((String)OiixPathOps.getStandardForm((String)oui_loc), (String)"prov/resources");
            propertiesDir = OiixPathOps.getNativeForm((String)propDir);
            OiiolTextLogger.appendText((String)("Setting to Default m_PropertiesDir = " + propertiesDir));
            System.setProperty("oracle.sysman.prov.PathsPropertiesLoc", propertiesDir);
        }
        return propertiesDir;
    }

    protected static String getRemotePropertiesPath() {
        return System.getProperty("oracle.sysman.prov.RemotePathsPropertiesLoc");
    }

    protected static void loadPropertiesToEnv(String propFile) {
        Properties temp = null;
        try {
            FileInputStream fs = new FileInputStream(propFile);
            temp = new Properties();
            temp.load(fs);
            fs.close();
        }
        catch (IOException fs) {
            // empty catch block
        }
        if (temp != null) {
            Enumeration<?> propNames = temp.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propval = (String)temp.get(propName);
                if (System.getProperty(propName) != null) continue;
                OiiolTextLogger.appendText((String)("Setting " + propName + " to " + propval));
                System.setProperty(propName, propval);
            }
        }
    }

    protected static void logPlatformids() {
        int[] plats = Platform.getPlatforms();
        OiiolTextLogger.writeToLogAndConsole((String)"Supported Platform id's\n");
        for (int i = 0; i < plats.length; ++i) {
            OiiolTextLogger.writeToLogAndConsole((String)(plats[i] + " " + Platform.getPlatformDirectoryName((int)plats[i])));
        }
    }

    protected static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    protected static String decryptObfuscatedPassword(String m_sObfuscatedPassword) throws FatalException {
        try {
            return Formatter.hexStringMD5ToNormalString((String)m_sObfuscatedPassword, (String)"UTF8");
        }
        catch (Exception e) {
            OiiolTextLogger.writeToLogAndConsole((String)"Password seems to be incorrect.");
            OiiolTextLogger.appendException((Throwable)e);
            throw new FatalException("PROV-16044", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16044", null));
        }
    }

    protected static void initLogFile(String logFile) throws IOException, FatalException {
        if (logFile == null) {
            Object[] args = new String[]{"logFile parameter is null"};
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001", (Object[])args));
        }
        if (logFile.trim().length() == 0) {
            Object[] args = new String[]{"logFile parameter Empty String with length 0"};
            throw new FatalException("PROV-16048", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16048", (Object[])args));
        }
        SSHSetupUtil.logLogDetails(logFile);
    }

    private static void logLogDetails(String logFile) throws IOException {
        try {
            String _logFile = OiixPathOps.getStandardForm((String)logFile);
            String logDir = OiixPathOps.getParentDir((String)_logFile);
            String logfile = OiixPathOps.getFileName((String)_logFile);
            int idx = logfile.lastIndexOf(46);
            String logfilename = "";
            String logfileextn = "";
            if (idx != -1) {
                logfilename = logfile.substring(0, idx);
                logfileextn = logfile.substring(idx, logfile.length());
            } else {
                logfilename = logfile;
            }
            OiiolTextLogger.setLogLoc((String)logDir, (String)logfilename, (String)logfileextn);
            System.out.println("Logfile Location : " + OiiolTextLogger.getCurLogFileName());
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Throwable)e);
            throw e;
        }
    }

    protected static String addPassword(String command, char[] password) {
        String[] arrcommand = command.split(" ");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arrcommand.length; ++i) {
            String str = arrcommand[i];
            if (str.equals("-q")) {
                sb.append("--password");
                sb.append(" ");
                sb.append(password);
                sb.append(" ");
            }
            sb.append(str);
            sb.append(" ");
        }
        return sb.toString();
    }

    protected static boolean isTectiaClient() throws FatalException, ClusterException {
        return SSHSetupUtil.findSSHClientType("Tectia");
    }

    protected static boolean isSunSSHClient() throws FatalException, ClusterException {
        return SSHSetupUtil.findSSHClientType("Sun_SSH");
    }

    protected static boolean isOpenSSHClient() throws FatalException, ClusterException {
        return SSHSetupUtil.findSSHClientType("OpenSSH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean findSSHClientType(String type) {
        ClusterBaseOps baseops = null;
        boolean value = false;
        try {
            baseops = ClusterBaseOps.getInstance();
            if (type.indexOf("Sun_SSH") != -1) {
                value = baseops.isSunSSHClient();
            } else if (type.indexOf("Tectia") != -1) {
                value = baseops.isClientSSH2();
            } else if (type.indexOf("OpenSSH") != -1) {
                value = baseops.isOpenSSHClient();
            }
            baseops.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            baseops.shutdown();
        }
        return value;
    }

    protected static boolean isTectiaServer(String[] remoteHosts, int sshPort) throws SSHSetupException {
        boolean tectia = true;
        for (int i = 0; i < remoteHosts.length; ++i) {
            OiiolTextLogger.appendText((String)("Identifying SSH type in [" + remoteHosts[i] + "] "));
            try {
                if (ClusterBaseOps.isServerSSH2((String)remoteHosts[i], (int)sshPort)) continue;
                String error = "Different type of ssh daemon running in node: " + remoteHosts[i] + " and not tectia ssh server!!!";
                OiiolTextLogger.appendText((String)error, (int)OiiolTextLogger.LOG_SEVERE);
                throw new SSHSetupException(error);
            }
            catch (FatalException e) {
                OiiolTextLogger.appendText((String)("Unable to determine type of ssh daemon running in node: " + remoteHosts[i]), (int)OiiolTextLogger.LOG_WARNING);
                OiiolTextLogger.appendException((Throwable)e);
                throw new SSHSetupException(e);
            }
        }
        return tectia;
    }

    protected static boolean isOpenSSHServer(String[] remoteHosts, int sshPort, boolean sunSSH) throws SSHSetupException {
        return SSHSetupUtil.checkOpenSSHStatus(remoteHosts, sshPort, sunSSH);
    }

    private static boolean checkOpenSSHStatus(String[] remoteHosts, int sshPort, boolean checkForSunSSH) throws SSHSetupException {
        boolean status = false;
        for (int i = 0; i < remoteHosts.length; ++i) {
            OiiolTextLogger.appendText((String)("Identifying OpenSSH type in [" + remoteHosts[i] + "] "));
            try {
                status = checkForSunSSH ? ClusterBaseOps.isSunSSHServer((String)remoteHosts[i], (int)sshPort) : ClusterBaseOps.isPlainOpenSSHServer((String)remoteHosts[i], (int)sshPort);
                if (status) continue;
                String error = "Different type of ssh daemon running in node: " + remoteHosts[i];
                OiiolTextLogger.appendText((String)error, (int)OiiolTextLogger.LOG_SEVERE);
                throw new SSHSetupException(error);
            }
            catch (FatalException e) {
                OiiolTextLogger.appendText((String)("Unable to determine type of ssh daemon running in node: " + remoteHosts[i]), (int)OiiolTextLogger.LOG_WARNING);
                OiiolTextLogger.appendException((Throwable)e);
                throw new SSHSetupException(e);
            }
        }
        return status;
    }

    public static void validateSharedPath(String[] remoteNodes, String username, String dirPath, Paths remotePaths, Paths localPath, String password, int sshPort) throws SharedDeviceException {
        if (remoteNodes.length == 0) {
            OiiolTextLogger.appendText((String)"Remote Nodes is NULL");
            Object[] args = new String[]{"Remote Nodes is NULL"};
            throw new SharedDeviceException("PROV-16024", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16024", (Object[])args), null);
        }
        String path = SSHSetupUtil.getNativePath(dirPath, "CFSFileName");
        path = "\"" + path + "\"";
        File fp = null;
        FileOutputStream fout = null;
        String str = new String("ssh");
        try {
            OiiolTextLogger.appendText((String)("Path is : " + path));
            fp = new File(path);
        }
        catch (NullPointerException ne) {
            Object[] args = new String[]{"PASS A VALID PATH FOR dirPath"};
            OiiolTextLogger.appendText((String)"dirPath is null");
            throw new SharedDeviceException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001", (Object[])args), null);
        }
        try {
            fout = new FileOutputStream(fp);
        }
        catch (FileNotFoundException fne) {
            Object[] args = new String[]{"Unable to create File in dirPath"};
            OiiolTextLogger.appendText((String)("File not found in path : " + path));
            throw new SharedDeviceException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])args), null);
        }
        PrintWriter pw = new PrintWriter(fout, true);
        pw.println(str);
        try {
            fout.close();
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Throwable)e);
            Object[] args = new String[]{"Unable to write to file"};
            OiiolTextLogger.appendText((String)("Unable to write to file : " + path));
            SSHSetupUtil.deleteFile(path);
            throw new SharedDeviceException("PROV-16026", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16026", (Object[])args), null);
        }
        pw.close();
        for (int i = 0; i < remoteNodes.length; ++i) {
            RunCommand cmd = new RunCommand(remoteNodes[i], username, password, sshPort);
            String remotecmd = remotePaths.getValue("CAT_PATH") + " " + path;
            try {
                cmd.runCommand(remotecmd);
            }
            catch (CommandException cme) {
                SSHSetupUtil.deleteFile(path);
                throw new SharedDeviceException("PROV-16011", cme.getMessage(), null);
            }
            int exitVal = cmd.getExitCode();
            if (exitVal == 0) {
                String m_out = cmd.getOutput();
                if (m_out.indexOf("ssh") != -1) continue;
                OiiolTextLogger.appendText((String)"CFS_FILE is empty");
                SSHSetupUtil.deleteFile(path);
                throw new SharedDeviceException("PROV-16031", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_SHARED_DEVICE", (Object[])new Object[]{path, remoteNodes[i]}), null);
            }
            String error = cmd.getOutput();
            Integer exitCode = new Integer(cmd.getExitCode());
            String s_exitCode = exitCode.toString();
            String err_msg = "The command exited with " + s_exitCode + " and command output is " + error;
            SSHSetupUtil.deleteFile(path);
            throw new SharedDeviceException("PROV-16031", err_msg, null);
        }
        try {
            SSHSetupUtil.runCmdOnLocalNodeHelper(SSHSetupUtil.removeCmd(path, false, localPath));
        }
        catch (ClusterException ce) {
            throw new SharedDeviceException(ce);
        }
        catch (FatalException fe) {
            throw new SharedDeviceException("PROV-16031", fe.getMessage(), null);
        }
    }

    protected static void deleteFile(String filePath) {
        if (!OiixUtil.isNullOrBlank((String)filePath, (boolean)true)) {
            OiiolTextLogger.appendText((String)("Deleting " + filePath));
            File path = new File(filePath);
            if (path.exists()) {
                path.delete();
            }
        }
    }

    protected static Paths getLocalPath(int localPlatId) throws FatalException {
        Commands commands = new Commands();
        return commands.createInstance(localPlatId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Paths getRemotePath(int remotePlatId, String localProperties, String remoteProperties) throws FatalException {
        Paths remotePaths = null;
        Commands commands = new Commands();
        try {
            OiiolTextLogger.appendText((String)("m_PropertiesDir = " + localProperties + ", r_PropertiesDir = " + remoteProperties));
            if (remoteProperties == null) {
                OiiolTextLogger.appendText((String)"SSHSetup: Creating remotePaths using PATH_PROPERTIES_LOC_PROPERTY");
                if (localProperties == null) throw new FatalException("PROV-16049", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16049"));
                return commands.createInstance(remotePlatId, localProperties);
            }
            OiiolTextLogger.appendText((String)"SSHSetup: Creating remotePaths using REMOTE_PATH_PROPERTIES_LOC_PROPERTY");
            return commands.createInstance(remotePlatId, remoteProperties);
        }
        catch (FatalException e) {
            OiiolTextLogger.appendException((Throwable)e);
            OiiolTextLogger.writeToLogAndConsole((String)"The Platform id that you are supplying is not supported. Refer to Logs for further details with name <logfile>prefixed with latest timestamp");
            OiiolTextLogger.writeToLogAndConsole((String)e.getMessage());
            SSHSetupUtil.logPlatformids();
            throw e;
        }
    }

    protected static int setSSHPortNumber(Paths remotePaths) {
        int sshPort = 22;
        String remoteSshPort = remotePaths.getValue("SSH_PORT");
        try {
            if (!OiixUtil.isNullOrBlank((String)remoteSshPort, (boolean)true)) {
                sshPort = Integer.parseInt(remoteSshPort);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sshPort;
    }

    protected static boolean fileExists(String filename) {
        if (OiixUtil.isNullOrBlank((String)filename, (boolean)true)) {
            return false;
        }
        File fp = new File(OiixPathOps.getNativeForm((String)filename));
        return fp.exists();
    }

    protected static void runCmdOnLocalNodeHelper(String command) throws ClusterException, FatalException {
        ClusterBaseOps baseops = null;
        try {
            baseops = ClusterBaseOps.getInstance();
            baseops.runCmdOnLocalNode(command);
            baseops.shutdown();
        }
        catch (ClusterException ce) {
            throw ce;
        }
        catch (FatalException fe) {
            throw fe;
        }
        finally {
            baseops.shutdown();
        }
    }

    protected static boolean removeRemoteFileHelper(String remoteNode, String username, String r_filePath, String m_sPassword, int m_sshPort, Paths path) {
        RunCommand cmd = new RunCommand(remoteNode, username, m_sPassword, m_sshPort);
        String remotecmd = SSHSetupUtil.removeCmd(r_filePath, true, path);
        try {
            cmd.runCommand(remotecmd);
        }
        catch (CommandException ce) {
            return false;
        }
        return true;
    }

    protected static boolean removeRemoteFileHelper(RunCommand cmd, String r_filePath, Paths path) {
        String remotecmd = SSHSetupUtil.removeCmd(r_filePath, true, path);
        try {
            cmd.runCommand(remotecmd);
        }
        catch (CommandException ce) {
            return false;
        }
        return true;
    }

    protected static String removeCmd(String file, boolean remote, Paths path) {
        return path.getValue("RM_PATH") + " " + path.getValue("RM_F_ARGS") + " " + file;
    }

    protected static String mvCmd(String src, String dest, boolean remote, Paths path) {
        return path.getValue("MV_PATH") + " " + path.getValue("MV_ARGS") + " " + "'" + src + "'" + " " + "'" + dest + "'";
    }

    protected static String[] readFile(String filePath) throws CommandException {
        FileInputStream fi = null;
        BufferedReader bfi = null;
        ArrayList<String> file_c = new ArrayList<String>();
        String line = null;
        File fp = new File(filePath);
        try {
            fi = new FileInputStream(fp);
        }
        catch (FileNotFoundException fnde) {
            OiiolTextLogger.appendText((String)("Reading " + filePath + " File not found"));
            OiiolTextLogger.appendException((Throwable)fnde);
            return null;
        }
        bfi = new BufferedReader(new InputStreamReader(fi));
        while (true) {
            try {
                line = bfi.readLine();
            }
            catch (IOException ioe) {
                throw new CommandException("LocalHost", "Read File " + filePath, (Throwable)ioe);
            }
            if (line == null) break;
            if (line.trim().length() <= 0) continue;
            file_c.add(line);
        }
        try {
            bfi.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (!file_c.isEmpty()) {
            String[] file = file_c.toArray(new String[0]);
            return file;
        }
        return null;
    }

    protected static void writeStringToFile(String filepath, String str, boolean append) {
        try {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(filepath, append);
            }
            catch (FileNotFoundException e) {
                OiiolTextLogger.appendException((Throwable)e);
            }
            PrintWriter pw = new PrintWriter(fos, true);
            pw.println(str);
            try {
                fos.close();
            }
            catch (IOException e) {
                OiiolTextLogger.appendException((Throwable)e);
            }
            pw.close();
        }
        catch (Exception e) {
            OiiolTextLogger.appendException((Throwable)e);
        }
    }

    public static void copyFile(String source, String destination) throws IOException {
        File src = new File(source);
        File dest = new File(destination);
        FileInputStream inStream = null;
        OutputStream outStream = null;
        try {
            int length;
            inStream = new FileInputStream(src);
            outStream = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                outStream.write(buffer, 0, length);
            }
        }
        catch (FileNotFoundException e) {
            OiiolTextLogger.appendException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Throwable)e);
            throw e;
        }
        finally {
            try {
                ((InputStream)inStream).close();
                outStream.close();
            }
            catch (IOException e) {
                OiiolTextLogger.appendException((Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkFileExistsOnRemoteNode(String nodeName, String file, String userName, String password, int sshPort, Paths path, boolean isTectia) {
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
            OiiolTextLogger.appendText((String)("Checking whether the file '" + file + "' is already existing on the host: " + nodeName), (int)OiiolTextLogger.LOG_GENERAL);
        }
        RunCommand cmd = null;
        cmd = isTectia ? new RunCommand(nodeName, userName, password, sshPort, false, true) : new RunCommand(nodeName, userName, password, sshPort);
        String command = path.getValue("LS_PATH") + " " + file;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
            OiiolTextLogger.appendText((String)("Command used to check file existence  is :" + command), (int)OiiolTextLogger.LOG_GENERAL);
        }
        try {
            cmd.runCommand(command);
            if (cmd.getExitCode() == 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (CommandException ce) {
            boolean bl = false;
            return bl;
        }
        finally {
            cmd = null;
        }
        return false;
    }

    public static boolean isNonEmpty(String[] arr) {
        return null != arr && arr.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleException(String host, String command, CommandException ce, Map commandResults, Map commandExceptions) {
        Map map = commandResults;
        synchronized (map) {
            if (commandResults.get(host) == null) {
                commandResults.put(host, command);
            }
        }
        map = commandExceptions;
        synchronized (map) {
            if (commandExceptions.get(host) == null) {
                commandExceptions.put(host, ce);
            }
        }
    }
}

