/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.ssh.PlainOpenSSHSetup;
import oracle.sysman.prov.ssh.SSHEquivalence;
import oracle.sysman.prov.ssh.SSHSetupException;
import oracle.sysman.prov.ssh.SSHSetupInfo;
import oracle.sysman.prov.ssh.SSHSetupUtil;
import oracle.sysman.prov.ssh.SunSSHSetup;
import oracle.sysman.prov.ssh.TectiaSSHSetup;
import oracle.sysman.prov.ssh.UndoSSHSetupException;

public class SSHSetupFactory {
    private static SSHEquivalence setupObject = null;

    public static SSHEquivalence getInstance(SSHSetupInfo info) throws FatalException, ClusterException, SSHSetupException, UndoSSHSetupException {
        if (setupObject == null) {
            boolean isTectia = SSHSetupUtil.isTectiaClient();
            if (isTectia) {
                setupObject = new TectiaSSHSetup(info);
            } else if (SSHSetupUtil.isSunSSHClient()) {
                setupObject = new SunSSHSetup(info);
            } else if (SSHSetupUtil.isOpenSSHClient()) {
                setupObject = new PlainOpenSSHSetup(info);
            } else {
                throw new SSHSetupException(" Unable to determine the SSH client type on the local node");
            }
        }
        return setupObject;
    }

    public static SSHEquivalence getInstance() {
        return setupObject;
    }
}

