/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import java.io.IOException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Platform;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;
import oracle.sysman.prov.remoteinterfaces.nativesystem.UserPreferences;
import oracle.sysman.prov.ssh.SSHEquivalence;
import oracle.sysman.prov.ssh.SSHSetupException;
import oracle.sysman.prov.ssh.SSHSetupFactory;
import oracle.sysman.prov.ssh.SSHSetupInfo;
import oracle.sysman.prov.ssh.SSHSetupUtil;
import oracle.sysman.prov.ssh.UndoSSHSetupException;

public class SSHSetup {
    private static SSHSetupInfo info = null;
    private static String home = null;
    private String m_sLogFile = null;
    Paths m_localPaths = null;
    Paths m_remotePaths = null;
    static int m_localPlatId;
    static int m_remotePlatId;
    private String m_PropertiesDir = null;
    private String m_rPropertiesDir = null;

    public SSHSetup() {
    }

    public SSHSetup(String logFile) throws FatalException, IOException {
        this.sshSetupHelper(logFile);
    }

    public SSHSetup(String sPassword, boolean bOfuscated, String logFile) throws FatalException, IOException {
        this.sshSetupHelper(sPassword, bOfuscated);
        this.sshSetupHelper(logFile);
    }

    public SSHSetup(String sPassword, boolean bOfuscated, String logFile, UserPreferences userPrefs) throws FatalException, IOException {
        this.setRemotePathsLoc(userPrefs.getPreference("REMOTE_PATH_PROPERTIES_LOC"));
        int remotePlatID = Integer.parseInt(userPrefs.getPreference("REMOTENODES_PLATFORM"));
        SSHSetup.setRemotePlatformId(remotePlatID);
        this.sshSetupHelper(sPassword, bOfuscated);
        this.sshSetupHelper(logFile);
    }

    public SSHSetup(String sPassword, String sPassphrase, boolean bOfuscated, String logFile) throws FatalException, IOException {
        this.sshSetupHelper(sPassword, bOfuscated);
        this.sshSetupHelper(logFile);
        info.setPassphrase(sPassphrase);
    }

    private void sshSetupHelper(String logFile) throws FatalException, IOException {
        SSHSetupUtil.initLogFile(logFile);
        info.setLogFile(OiixPathOps.getNativeForm((String)OiixPathOps.getStandardForm((String)logFile)));
        this.initEnvironment();
    }

    private void sshSetupHelper(String sPassword, boolean bOfuscated) throws FatalException {
        String password = null;
        password = bOfuscated ? SSHSetupUtil.decryptObfuscatedPassword(sPassword) : sPassword;
        info.setPassword(password);
    }

    private void initEnvironment() throws FatalException {
        this.setPlatforms();
        this.setProperties();
    }

    private void setPlatforms() {
        int localPlatId = SystemFactory.s_localPlatId;
        info.setLocalPlatId(localPlatId);
        info.setRemotePlatId(localPlatId);
    }

    private void setProperties() {
        info.setLocalPropertiesDir(SSHSetupUtil.getLocalPropertiesPath());
        info.setRemotePropertiesDir(SSHSetupUtil.getRemotePropertiesPath());
    }

    public static void setRemotePlatformId(int remotePlatId) {
        m_remotePlatId = remotePlatId;
        info.setRemotePlatId(remotePlatId);
    }

    public static void setOUILoc(String ouiLoc) {
        System.setProperty("oracle.installer.oui_loc", ouiLoc);
    }

    public void setnoDelete() {
    }

    private void setRemotePathsLoc(String remotePathsLoc) {
        if (null != remotePathsLoc) {
            info.setRemotePropertiesDir(remotePathsLoc);
        }
    }

    private void logPlatformids() {
        int[] plats = Platform.getPlatforms();
        OiiolTextLogger.writeToLogAndConsole((String)"Supported Platform id's\n");
        for (int i = 0; i < plats.length; ++i) {
            OiiolTextLogger.writeToLogAndConsole((String)(plats[i] + " " + Platform.getPlatformDirectoryName((int)plats[i])));
        }
    }

    public void setLogFile(String sLogFile) {
        this.m_sLogFile = OiixPathOps.getNativeForm((String)OiixPathOps.getStandardForm((String)sLogFile));
    }

    private static void setUserHomeDir() {
        if (null == home) {
            SSHSetup.setHomeDir(System.getProperty("user.home"));
        }
    }

    public synchronized void setupConnectivity(boolean oflag, String[] remoteHosts, String username, boolean sharedHome) throws SSHSetupException, ClusterException, FatalException {
        this.setupConnectivity(oflag, remoteHosts, username, sharedHome, false);
    }

    public synchronized void setupConnectivity(boolean oflag, String[] remoteHosts, String username, boolean sharedHome, boolean advanced) throws SSHSetupException, ClusterException, FatalException {
        this.setupConnectivity(oflag, remoteHosts, username, sharedHome, false, null, null, null);
    }

    public synchronized void setupConnectivity(boolean oflag, String[] remoteHosts, String username, boolean advanced, String asUser, String asUserGrp, String sshLocalDir) throws SSHSetupException, ClusterException, FatalException {
        boolean sharedHome = false;
        info.setCalculateSharedHome(true);
        this.setupConnectivity(oflag, remoteHosts, username, sharedHome, advanced, asUser, asUserGrp, sshLocalDir);
    }

    private void populateSetup(boolean oflag, String[] existingNodes, String[] newNodes, String username, boolean sharedHome, String sshLocalDir, boolean advanced, String asUser, String asUserGrp) throws SSHSetupException {
        info.setOflag(oflag);
        if (!SSHSetupUtil.isNonEmpty(existingNodes) && !SSHSetupUtil.isNonEmpty(newNodes) || SSHSetupUtil.isNonEmpty(existingNodes) && !SSHSetupUtil.isNonEmpty(newNodes)) {
            throw new SSHSetupException("Invalid Node Lists !!");
        }
        if (SSHSetupUtil.isNonEmpty(existingNodes)) {
            info.setExistingNodes(existingNodes);
        }
        if (oflag) {
            info.setReuseKey(true);
        }
        info.setNewNodes(newNodes);
        info.computeCompleteNodeList();
        info.setUsername(username);
        info.setSshLocalDir(sshLocalDir);
        info.setAdvanced(advanced);
        info.setAsUser(asUser);
        info.setAsUserGrp(asUserGrp);
        info.setSharedHome(sharedHome);
        if (null != home) {
            info.setHome(home);
        } else {
            info.setHome(System.getProperty("user.home"));
        }
    }

    public synchronized void setupConnectivity(boolean oflag, String[] remoteHosts, String username, boolean sharedHome, boolean advanced, String asUser, String asUserGrp, String sshLocalDir) throws SSHSetupException, ClusterException, FatalException {
        this.setupConnectivity(oflag, null, remoteHosts, username, sharedHome, advanced, asUser, asUserGrp, sshLocalDir);
    }

    public synchronized void setupConnectivity(boolean oflag, String[] existingNodes, String[] newNodes, String username, boolean sharedHome, boolean advanced, String asUser, String asUserGrp, String sshLocalDir) throws SSHSetupException, ClusterException, FatalException {
        this.populateSetup(oflag, existingNodes, newNodes, username, sharedHome, sshLocalDir, advanced, asUser, asUserGrp);
        try {
            SSHEquivalence ssh = SSHSetupFactory.getInstance(info);
            ssh.setUpSSH();
        }
        catch (ClusterException ce) {
            throw ce;
        }
        catch (FatalException fe) {
            throw fe;
        }
        catch (SSHSetupException se) {
            throw se;
        }
        catch (Throwable te) {
            te.printStackTrace();
        }
    }

    public static void setHomeDir(String userHomeDir) {
        home = OiixPathOps.getNativeForm((String)OiixPathOps.getStandardForm((String)userHomeDir));
    }

    public synchronized void dropSSHSetup(String[] remoteNodes, String username) throws UndoSSHSetupException, ClusterException, FatalException {
        this.dropSSHSetup(remoteNodes, username, null);
    }

    public synchronized void dropSSHSetup(String[] remoteNodes, String username, String sshLocalDir) throws UndoSSHSetupException, ClusterException, FatalException {
        if (remoteNodes.length == 0 || username == null) {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"PROV-16001", (String)"PROV-16001", null));
        }
        this.populateSetup(false, remoteNodes, username, false, sshLocalDir);
        try {
            SSHEquivalence ssh = SSHSetupFactory.getInstance();
            if (null != ssh) {
                ssh = null;
            }
            ssh = SSHSetupFactory.getInstance(info);
            ssh.tearDownSSH();
        }
        catch (UndoSSHSetupException uce) {
            throw uce;
        }
        catch (Throwable te) {
            throw new FatalException(te);
        }
    }

    private void populateSetup(boolean b, String[] remoteNodes, String username, boolean c, String sshLocalDir) {
        info.setOflag(b);
        info.setRemoteHosts(remoteNodes);
        info.setUsername(username);
        info.setSshLocalDir(sshLocalDir);
        info.setSharedHome(true);
        if (null != home) {
            info.setHome(home);
        } else {
            info.setHome(System.getProperty("user.home"));
        }
    }

    static {
        m_remotePlatId = m_localPlatId = SystemFactory.s_localPlatId;
        String s_sPropertiesDir = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        if (s_sPropertiesDir != null) {
            String sysProFile = OiixPathOps.concatPath((String)s_sPropertiesDir, (String)"ssh_system.properties");
            String absPath = OiixPathOps.getNativeForm((String)sysProFile);
            SSHSetupUtil.loadPropertiesToEnv(absPath);
        }
        info = new SSHSetupInfo();
    }
}

