/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.prov.ssh.FileLockException;
import oracle.sysman.prov.ssh.SSHSetupUtil;

public class SSHDirectoryLocker {
    protected void getLock(String lock_comment, String sshDir) throws FileLockException {
        int locksleep_time = this.getLockSleepTime();
        String lock_loc = this.getLockLocation(sshDir);
        File lock = new File(lock_loc);
        OiiolTextLogger.appendText((String)"Trying to get Lock ....");
        if (lock.exists()) {
            for (int lockretry_cnt = this.getLockRetryCount(); lockretry_cnt != 0; --lockretry_cnt) {
                try {
                    OiiolTextLogger.appendText((String)("Sleeping for " + locksleep_time + " ms"));
                    Thread.sleep(locksleep_time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!lock.exists()) break;
                OiiolTextLogger.appendText((String)("Trying to get Lock ...." + lockretry_cnt));
            }
        }
        if (lock.exists()) {
            Object[] args = new String[]{"LocalHost", lock_loc};
            OiiolTextLogger.appendText((String)("FailedNodes " + args[0] + " lock_loc " + args[1]));
            String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16046", (Object[])args);
            throw new FileLockException("PROV-16046", errorMessage);
        }
        try {
            lock.createNewFile();
            if (!OiixUtil.isNullOrBlank((String)lock_comment, (boolean)true)) {
                BufferedWriter bufferWritter = new BufferedWriter(new FileWriter(lock.getName(), true));
                bufferWritter.write(lock_comment);
                bufferWritter.close();
            }
        }
        catch (IOException ioe) {
            throw new FileLockException(ioe);
        }
        OiiolTextLogger.appendText((String)"Lock Acquired");
    }

    private int getLockRetryCount() {
        int lock_retry_count = 120;
        String lock_count = System.getProperty("oracle.sysman.prov.ssh.lock_retry_count");
        if (lock_count != null) {
            OiiolTextLogger.appendText((String)("lock_count " + lock_count));
            lock_retry_count = Integer.getInteger("oracle.sysman.prov.ssh.lock_retry_count");
        }
        OiiolTextLogger.appendText((String)("Lock Retry Count " + lock_retry_count));
        return lock_retry_count;
    }

    private int getLockSleepTime() {
        int lock_sleep_time = 30000;
        String lock_stime = System.getProperty("oracle.sysman.prov.ssh.lock_sleep_time");
        if (lock_stime != null) {
            lock_sleep_time = Integer.getInteger("oracle.sysman.prov.ssh.lock_sleep_time");
            lock_sleep_time = 1000 * lock_sleep_time;
        }
        OiiolTextLogger.appendText((String)("Lock Sleep Time " + lock_sleep_time));
        return lock_sleep_time;
    }

    private String getLockLocation(String sshDir) {
        File sshDir_d = new File(sshDir);
        if (!sshDir_d.exists()) {
            sshDir_d.mkdir();
        }
        String lock = SSHSetupUtil.getNativePath(sshDir, "lock");
        OiiolTextLogger.appendText((String)("Lock Location : " + lock));
        return lock;
    }

    protected void releaseLock(String sshDir) throws FileLockException {
        String lock_loc = this.getLockLocation(sshDir);
        File lock = new File(lock_loc);
        OiiolTextLogger.appendText((String)"Releasing Lock...");
        if (lock.exists()) {
            if (!lock.delete()) {
                String failedNodes = "LocalHost";
                throw new FileLockException("PROV-16047", OiixResourceBundle.getString((String)"PROV-16047", (String)"PROV-16047", (Object[])new String[]{failedNodes, lock_loc}));
            }
            OiiolTextLogger.appendText((String)"Lock Released");
        }
    }
}

