/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Commands;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;
import oracle.sysman.prov.ssh.ProxyInfo;
import oracle.sysman.prov.ssh.RunCommandLogger;
import oracle.sysman.prov.ssh.RunCommandUserInfo;
import oracle.sysman.prov.ssh.SSHSetupUtil;

public class RunCommand {
    private String m_privateKey = null;
    private int m_exitVal = 0;
    private String m_out = null;
    private String m_user = null;
    private String m_host = null;
    private UserInfo ui = null;
    private String error = "An error occured which will cause the program to abort. Refer to latest Log file that was supplied while running the program. The Log file would created by name logfilename-<currentdatetime>";
    private String r_error = null;
    private int m_port = 22;
    private boolean m_bLog = true;
    private boolean pty = false;
    private int timeout = 0;
    private String scpPath = null;
    private boolean scpTectia = false;
    private String sshHome = null;
    private static final String sshAuthFailErrorString = "Auth fail";
    private static final String sshAuthCancelErrorString = "Auth cancel";
    private ProxyInfo proxyInfo = null;
    private int commandRetryCount = 2;
    private Paths localPath = null;

    protected String getSshHome() {
        return this.sshHome;
    }

    protected void setSshHome(String sshHome) {
        this.sshHome = sshHome;
    }

    private String getIdentityLoc() {
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getsshDir(), (String)"id_rsa"));
    }

    private String getIdentityLoc2() {
        if (null != this.sshHome) {
            File file = new File(OiixPathOps.concatPath((String)this.sshHome, (String)"identity"));
            String openSSHConvertedFile = file.getAbsolutePath() + ".open-ssh";
            if (new File(openSSHConvertedFile).exists()) {
                return openSSHConvertedFile;
            }
            if (file.exists()) {
                try {
                    String l_command = this.localPath.getValue("SSH_KEYGEN_PATH") + " " + this.localPath.getValue("SSH_KEYGEN_CONVERT_TO_OPENSSH_ARGS") + " " + this.localPath.getValue("SSH_KEYGEN_ARGS_KEYFILE") + " " + file.getAbsolutePath() + " > " + openSSHConvertedFile;
                    SSHSetupUtil.runCmdOnLocalNodeHelper(l_command);
                    return openSSHConvertedFile;
                }
                catch (FatalException e) {
                    OiiolTextLogger.appendException((Throwable)e);
                }
                catch (ClusterException e) {
                    OiiolTextLogger.appendException((Throwable)e);
                }
            }
        }
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getsshDir(), (String)"identity"));
    }

    private String getIdDsaLoc() {
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getsshDir(), (String)"id_dsa"));
    }

    private String getsshDir() {
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getHomeDir(), (String)".ssh"));
    }

    private String getHomeDir() {
        String home = System.getProperty("user.home").trim();
        return home;
    }

    public RunCommand(String host, String user, String password) {
        this.m_host = host;
        this.m_user = user;
        this.initialiseLocalPath();
        this.ui = new RunCommandUserInfo(password);
    }

    public RunCommand(String host, String user, String password, String passphrase, boolean confirm) {
        this(host, user, password);
        this.initialiseLocalPath();
    }

    public RunCommand(String host, String user, String password, int sshport) {
        this(host, user, password);
        this.m_port = sshport;
        this.initialiseLocalPath();
    }

    public RunCommand(String host, String user, String password, boolean bLog) {
        this(host, user, password);
        this.m_bLog = bLog;
        this.initialiseLocalPath();
    }

    public RunCommand(String host, String user, String password, int sshport, boolean bLog) {
        this(host, user, password, sshport);
        this.m_bLog = bLog;
        this.initialiseLocalPath();
    }

    public RunCommand(String host, String user, String password, int sshport, boolean bLog, boolean tectia) {
        this(host, user, password, sshport, bLog);
        this.scpTectia = tectia;
        this.initialiseLocalPath();
    }

    public RunCommand(String host, String user, String password, int sshport, String privateKey) {
        this(host, user, password, sshport);
        this.m_privateKey = privateKey;
        this.initialiseLocalPath();
    }

    private void cleanup(Channel ch, Session sess) {
        if (ch != null) {
            ch.disconnect();
        }
        if (sess != null) {
            sess.disconnect();
        }
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public void runCommand(String command) throws CommandException {
        Channel channel = null;
        Session session = null;
        for (int iterCount = 1; iterCount <= this.commandRetryCount; ++iterCount) {
            try {
                session = this.getJschSession(true, true);
                if (this.scpTectia) {
                    char[] password = this.ui.getPassword().toCharArray();
                    command = SSHSetupUtil.addPassword(command, password);
                }
                channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                if (this.pty) {
                    ((ChannelExec)channel).setPty(this.pty);
                }
                ByteArrayOutputStream bo = this.setByteArrayOutStream(channel);
                InputStream in = channel.getInputStream();
                channel.connect();
                this.logCmdHost(command);
                StringBuffer buf = this.getOutMessage(channel, bo, in);
                this.cleanup(channel, session);
                this.m_out = buf.toString();
                break;
            }
            catch (Exception e) {
                this.processException(channel, session, iterCount, e);
                continue;
            }
        }
        this.logOutMsg();
    }

    private void processException(Channel channel, Session session, int iterCount, Exception e) throws CommandException {
        if (iterCount == this.commandRetryCount) {
            this.handleException(channel, session, e);
        }
        try {
            this.cleanup(channel, session);
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logCmdHost(String command) {
        if (this.m_bLog) {
            OiiolTextLogger.appendText((String)("[" + this.m_host + "]"));
            OiiolTextLogger.appendText((String)command);
        }
    }

    private StringBuffer getOutMessage(Channel channel, ByteArrayOutputStream bo, InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        byte[] tmp = new byte[1024];
        while (true) {
            if (in.available() > 0) {
                int i = in.read(tmp, 0, 1024);
                if (i < 0) {
                    int buflen = buf.length();
                    buf.deleteCharAt(buflen - 1);
                } else {
                    buf.append(new String(tmp, 0, i));
                    continue;
                }
            }
            this.removeNewLineChar(buf);
            if (channel.isClosed()) break;
            this.waitForComplete();
        }
        this.logExitStatus(channel, bo);
        return buf;
    }

    private StringBuffer removeNewLineChar(StringBuffer buf) {
        String ls;
        char line_sep_char;
        char isNewLine;
        int buflen = buf.length();
        if (buflen > 0 && (isNewLine = buf.charAt(buflen - 1)) == (line_sep_char = (ls = System.getProperty("line.separator")).charAt(0))) {
            buf.deleteCharAt(buflen - 1);
        }
        return buf;
    }

    private void logExitStatus(Channel channel, ByteArrayOutputStream bo) {
        this.m_exitVal = channel.getExitStatus();
        if (this.m_bLog) {
            OiiolTextLogger.appendText((String)("Exit-status: " + channel.getExitStatus()));
            this.r_error = bo.toString();
            if (this.r_error != null) {
                OiiolTextLogger.appendText((String)("Error: " + this.r_error));
            }
        }
    }

    private void waitForComplete() {
        block2: {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ee) {
                if (!this.m_bLog) break block2;
                OiiolTextLogger.writeToLogAndConsole((String)this.error);
                OiiolTextLogger.appendException((Throwable)ee);
            }
        }
    }

    public String getOutput() {
        return this.getOutput(true);
    }

    public String getOutput(boolean bIgnore) {
        if (!bIgnore) {
            return this.m_out;
        }
        if (this.m_out == null) {
            return this.m_out;
        }
        String temp = "";
        try {
            Commands co = new Commands();
            temp = co.replaceErrString(this.m_out);
        }
        catch (FatalException fatalException) {
            // empty catch block
        }
        return temp + "\n";
    }

    public int getExitCode() {
        return this.m_exitVal;
    }

    public String getError() {
        return this.getError(true);
    }

    public String getError(boolean bIgnore) {
        if (!bIgnore) {
            return this.r_error;
        }
        if (this.r_error == null) {
            return this.r_error;
        }
        String temp = "";
        try {
            Commands co = new Commands();
            temp = co.replaceErrString(this.r_error);
        }
        catch (FatalException fatalException) {
            // empty catch block
        }
        return temp + "\n";
    }

    private void addJschKeys(JSch jsch) {
        String[] keyListArr;
        this.addKey(jsch, this.m_privateKey, false);
        ArrayList keyFileList = new ArrayList();
        String keyListFromProperty = System.getProperty("oracle.sysman.prov.remoteinterfaces.identitylist");
        String id_rsa = this.getIdentityLoc();
        String identity = this.getIdentityLoc2();
        String id_dsa = this.getIdDsaLoc();
        this.addKey(jsch, id_rsa, true);
        this.addKey(jsch, identity, true);
        this.addKey(jsch, id_dsa, true);
        if (keyListFromProperty != null && !keyListFromProperty.trim().equals("") && (keyListArr = keyListFromProperty.trim().split(",")) != null) {
            for (int i = 0; i < keyListArr.length; ++i) {
                this.addKey(jsch, keyListArr[i], true);
            }
        }
    }

    private void addKey(JSch jsch, String key, boolean isFile) {
        block7: {
            if (key != null && key.trim().length() > 0) {
                if (isFile && !new File(key.trim()).exists()) {
                    return;
                }
                try {
                    if (isFile) {
                        jsch.addIdentity(key);
                    } else {
                        jsch.addIdentity(null, key.getBytes(), null, null);
                    }
                    if (this.m_bLog && isFile) {
                        OiiolTextLogger.appendText((String)("Adding Identity " + key));
                    }
                }
                catch (Exception e) {
                    if (!this.m_bLog) break block7;
                    OiiolTextLogger.appendException((Throwable)e);
                }
            }
        }
    }

    public void runCommand(String command, String cmdArgs, String cmdInput) throws CommandException {
        Channel channel = null;
        Session session = null;
        String SPACE = " ";
        for (int iterCount = 1; iterCount <= this.commandRetryCount; ++iterCount) {
            try {
                session = this.getJschSession(true, false);
                if (this.scpTectia) {
                    char[] password = this.ui.getPassword().toCharArray();
                    command = SSHSetupUtil.addPassword(command, password);
                }
                channel = session.openChannel("exec");
                String rcommand = command;
                if (cmdArgs != null) {
                    rcommand = command + SPACE + cmdArgs;
                }
                ((ChannelExec)channel).setCommand(rcommand);
                if (this.pty) {
                    ((ChannelExec)channel).setPty(this.pty);
                }
                byte[] cmdbuf = cmdInput.getBytes();
                ByteArrayInputStream bi = new ByteArrayInputStream(cmdbuf);
                channel.setInputStream((InputStream)bi);
                ByteArrayOutputStream bo = this.setByteArrayOutStream(channel);
                InputStream in = channel.getInputStream();
                channel.connect();
                this.logCmdHost(rcommand);
                StringBuffer buf = this.getOutMessage(channel, bo, in);
                this.cleanup(channel, session);
                this.m_out = buf.toString();
                break;
            }
            catch (Exception e) {
                this.processException(channel, session, iterCount, e);
                continue;
            }
        }
        this.logOutMsg();
    }

    private ByteArrayOutputStream setByteArrayOutStream(Channel channel) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ((ChannelExec)channel).setErrStream((OutputStream)bo);
        return bo;
    }

    private void logOutMsg() {
        if (this.m_bLog) {
            OiiolTextLogger.appendText((String)this.m_out);
            OiiolTextLogger.appendText((String)"");
        }
    }

    public void runCommand(String command, String cmdArgs, int interval, boolean ignoreInputPrompt, String input1Prompt, String cmdInput1, String input2Prompt, String cmdInput2) throws CommandException {
        Channel channel = null;
        Session session = null;
        String SPACE = " ";
        for (int iterCount = 1; iterCount <= this.commandRetryCount; ++iterCount) {
            try {
                session = this.getJschSession(true, false);
                if (this.scpTectia) {
                    char[] password = this.ui.getPassword().toCharArray();
                    command = SSHSetupUtil.addPassword(command, password);
                }
                channel = session.openChannel("exec");
                String rcommand = command;
                if (cmdArgs != null) {
                    rcommand = command + SPACE + cmdArgs;
                }
                ((ChannelExec)channel).setCommand(rcommand);
                if (this.pty) {
                    ((ChannelExec)channel).setPty(this.pty);
                }
                ByteArrayOutputStream bo = this.setByteArrayOutStream(channel);
                InputStream in = channel.getInputStream();
                OutputStream out = channel.getOutputStream();
                channel.connect();
                this.flushCmdInput(interval, cmdInput1, cmdInput2, out);
                this.logCmdHost(rcommand);
                StringBuffer buf = this.getOutMsg(interval, ignoreInputPrompt, input1Prompt, cmdInput1, input2Prompt, cmdInput2, channel, bo, in, out);
                this.cleanup(channel, session);
                this.m_out = buf.toString();
                break;
            }
            catch (Exception e) {
                this.processException(channel, session, iterCount, e);
                continue;
            }
        }
        this.logOutMsg();
    }

    private StringBuffer getOutMsg(int interval, boolean ignoreInputPrompt, String input1Prompt, String cmdInput1, String input2Prompt, String cmdInput2, Channel channel, ByteArrayOutputStream bo, InputStream in, OutputStream out) throws IOException {
        StringBuffer buf = new StringBuffer();
        byte[] tmp = new byte[1024];
        boolean cmdInput1AlreadyPumped = false;
        boolean cmdInput2AlreadyPumped = false;
        while (true) {
            if (in.available() > 0) {
                int i = in.read(tmp, 0, 1024);
                if (i < 0) {
                    int buflen = buf.length();
                    buf.deleteCharAt(buflen - 1);
                } else {
                    buf.append(new String(tmp, 0, i));
                    if (interval > 0) continue;
                    if (ignoreInputPrompt) {
                        if (cmdInput1 != null && !cmdInput1.trim().equals("") && !cmdInput1AlreadyPumped) {
                            out.write(cmdInput1.getBytes());
                            out.flush();
                            cmdInput1AlreadyPumped = true;
                            continue;
                        }
                        if (cmdInput2 == null || cmdInput2.trim().equals("") || cmdInput2AlreadyPumped) continue;
                        out.write(cmdInput2.getBytes());
                        out.flush();
                        cmdInput2AlreadyPumped = true;
                        continue;
                    }
                    if (input2Prompt != null && cmdInput2 != null && !cmdInput2.trim().equals("") && new String(tmp, 0, i).trim().indexOf(input2Prompt) >= 0) {
                        out.write(cmdInput2.getBytes());
                        out.flush();
                        continue;
                    }
                    if (input1Prompt == null || cmdInput1 == null || cmdInput1.trim().equals("") || new String(tmp, 0, i).trim().indexOf(input1Prompt) < 0) continue;
                    out.write(cmdInput1.getBytes());
                    out.flush();
                    continue;
                }
            }
            buf = this.removeNewLineChar(buf);
            if (channel.isClosed()) break;
            this.waitForComplete();
        }
        this.logExitStatus(channel, bo);
        return buf;
    }

    private void flushCmdInput(int interval, String cmdInput1, String cmdInput2, OutputStream out) throws InterruptedException, IOException {
        if (interval > 0) {
            if (cmdInput1 != null && !cmdInput1.trim().equals("")) {
                Thread.sleep(interval);
                out.write(cmdInput1.getBytes());
                out.flush();
            }
            if (cmdInput2 != null && !cmdInput2.trim().equals("")) {
                Thread.sleep(interval);
                out.write(cmdInput2.getBytes());
                out.flush();
            }
        }
    }

    public void setPty(boolean pty) {
        this.pty = pty;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void scpTo(String localFile, String remoteFile) throws CommandException {
        if (this.m_bLog) {
            ClusterLogger.log((String)("Copy localfile: " + localFile + " to remotefile: " + remoteFile + "remote node: " + this.m_host + "\n"), (Level)ClusterLogger.LOG_INFO);
        }
        Channel channel = null;
        Session session = null;
        int iterCount = 1;
        if (iterCount <= this.commandRetryCount) {
            try {
                int len;
                session = this.getJschSession(false, false);
                String scpcmd = this.getScpCmd();
                String command = scpcmd + " -p -t " + remoteFile;
                channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                if (this.checkAck(in) != 0) {
                    System.out.println("No proper acknowledgement");
                    this.cleanup(channel, session);
                    return;
                }
                long filesize = new File(localFile).length();
                command = "C0644 " + filesize + " ";
                command = localFile.lastIndexOf(47) > 0 ? command + localFile.substring(localFile.lastIndexOf(47) + 1) : command + localFile;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                if (this.checkAck(in) != 0) {
                    System.out.println("No proper acknowledgement");
                    this.cleanup(channel, session);
                    return;
                }
                FileInputStream fis = new FileInputStream(localFile);
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                    out.flush();
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                this.closeStreams(out, fis);
                if (this.checkAck(in) != 0) {
                    this.cleanup(channel, session);
                    return;
                }
            }
            catch (Exception ex) {
                this.cleanup(channel, session);
                throw new CommandException(this.m_host, "PROV-16011", ex.getMessage(), (Throwable)ex);
            }
        }
        this.cleanup(channel, session);
    }

    private void closeStreams(OutputStream out, FileInputStream fis) throws IOException {
        if (null != out) {
            out.close();
            out = null;
        }
        if (null != fis) {
            fis.close();
            fis = null;
        }
    }

    protected String getScpCmd() {
        if (null == this.scpPath || this.scpPath.trim().length() == 0) {
            this.scpPath = "scp";
        }
        return this.scpPath;
    }

    public void scpFrom(String localFile, String remoteFile) throws CommandException {
        Channel channel = null;
        Session session = null;
        if (this.m_bLog) {
            ClusterLogger.log((String)("Copy remotefile: " + remoteFile + " to localfile: " + localFile + "\n"), (Level)ClusterLogger.LOG_INFO);
        }
        String prefix = new File(localFile).isDirectory() ? localFile + File.separator : null;
        int iterCount = 1;
        if (iterCount <= this.commandRetryCount) {
            try {
                int c;
                session = this.getJschSession(false, false);
                String scpcmd = this.getScpCmd();
                String command = scpcmd + " -f " + remoteFile;
                channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                byte[] buf = new byte[1024];
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                while ((c = this.checkAck(in)) == 67) {
                    int foo;
                    in.read(buf, 0, 5);
                    long filesize = 0L;
                    while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                        filesize = filesize * 10L + (long)(buf[0] - 48);
                    }
                    String file = null;
                    int i = 0;
                    while (true) {
                        in.read(buf, i, 1);
                        if (buf[i] == 10) break;
                        ++i;
                    }
                    file = new String(buf, 0, i);
                    buf[0] = 0;
                    out.write(buf, 0, 1);
                    out.flush();
                    FileOutputStream fos = new FileOutputStream(prefix == null ? localFile : prefix + file);
                    do {
                        foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                        if ((foo = in.read(buf, 0, foo)) < 0) break;
                        fos.write(buf, 0, foo);
                    } while ((filesize -= (long)foo) != 0L);
                    fos.close();
                    fos = null;
                    if (this.checkAck(in) != 0) {
                        this.cleanup(channel, session);
                        return;
                    }
                    buf[0] = 0;
                    out.write(buf, 0, 1);
                    out.flush();
                }
            }
            catch (Exception ex) {
                this.cleanup(channel, session);
                throw new CommandException(this.m_host, "PROV-16011", ex.getMessage(), (Throwable)ex);
            }
        }
        this.cleanup(channel, session);
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                ClusterLogger.log((String)sb.toString(), (Level)ClusterLogger.LOG_INFO);
            }
            if (b == 2) {
                ClusterLogger.log((String)sb.toString(), (Level)ClusterLogger.LOG_INFO, (boolean)true);
            }
        }
        return b;
    }

    public void setScpPath(String scpPath) {
        this.scpPath = scpPath;
    }

    private void handleException(Channel channel, Session session, Exception e) throws CommandException {
        String message = null;
        String failedNodes = this.m_host;
        this.cleanup(channel, session);
        if (this.m_bLog) {
            if (null != this.m_out) {
                OiiolTextLogger.appendText((String)this.m_out);
            }
            OiiolTextLogger.appendException((Throwable)e);
            message = this.setSSHErrorMessage(e);
            if (message != null) {
                OiiolTextLogger.writeToLogAndConsole((String)message);
                throw new CommandException(failedNodes, "PROV-16011", message);
            }
            OiiolTextLogger.writeToLogAndConsole((String)this.error);
            throw new CommandException(failedNodes, "PROV-16011", e.getMessage());
        }
    }

    private String setSSHErrorMessage(Exception e) {
        String errorMsg = null;
        if (e instanceof JSchException) {
            if (e.getMessage().trim().startsWith(sshAuthFailErrorString)) {
                errorMsg = "SSH authentication failed.Please verify the SSH username and password used.JschException: " + e.getMessage();
            } else if (e.getMessage().trim().startsWith(sshAuthCancelErrorString)) {
                errorMsg = "SSH authentication failed.Please verify the username/password/private-key used.JschException: " + e.getMessage();
            }
        }
        return errorMsg;
    }

    private Session getJschSession(boolean setLogger, boolean setTimeOut) throws JSchException {
        JSch jsch = new JSch();
        this.addJschKeys(jsch);
        if (setLogger && Boolean.getBoolean("oracle.sysman.prov.logJschDebug")) {
            JSch.setLogger((Logger)new RunCommandLogger());
        }
        Session session = jsch.getSession(this.m_user, this.m_host, this.m_port);
        if (null != this.proxyInfo) {
            this.setProxyInSession(session);
        }
        this.setConfigProperties(session);
        session.setUserInfo(this.ui);
        if (setTimeOut && this.timeout > 0) {
            session.connect(this.timeout);
        } else {
            session.connect();
        }
        return session;
    }

    private void setConfigProperties(Session session) {
        Properties configProps = new Properties();
        configProps.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
        configProps.put("StrictHostKeyChecking", "no");
        session.setConfig(configProps);
    }

    private void setProxyInSession(Session jschSession) throws IllegalArgumentException {
        ProxyHTTP sshProxy;
        if (OiixUtil.isNullOrBlank((String)this.proxyInfo.getHost(), (boolean)false)) {
            OiiolTextLogger.appendText((String)"Proxy Host is empty/null");
            throw new IllegalArgumentException("ProxyHost should not be empty.");
        }
        if (this.proxyInfo.getPort() <= 0) {
            OiiolTextLogger.appendText((String)"Proxy Port is invalid and must be positive value");
            throw new IllegalArgumentException("ProxyPort must be a positivie value");
        }
        boolean useAuthentication = !OiixUtil.isNullOrBlank((String)this.proxyInfo.getUserName(), (boolean)true) && !OiixUtil.isNullOrBlank((String)this.proxyInfo.getPassword(), (boolean)true);
        OiiolTextLogger.appendText((String)("Whether proxy authentication is required:  " + useAuthentication));
        switch (this.proxyInfo.getType()) {
            case 1: {
                sshProxy = new ProxyHTTP(this.proxyInfo.getHost(), this.proxyInfo.getPort());
                if (!useAuthentication) break;
                sshProxy.setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
                break;
            }
            case 2: {
                sshProxy = new ProxySOCKS4(this.proxyInfo.getHost(), this.proxyInfo.getPort());
                if (!useAuthentication) break;
                ((ProxySOCKS4)sshProxy).setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
                break;
            }
            case 3: {
                sshProxy = new ProxySOCKS5(this.proxyInfo.getHost(), this.proxyInfo.getPort());
                if (!useAuthentication) break;
                ((ProxySOCKS5)sshProxy).setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported proxy type");
            }
        }
        jschSession.setProxy((Proxy)sshProxy);
        OiiolTextLogger.appendText((String)"Successfully set proxy to the session");
    }

    private void initialiseLocalPath() {
        try {
            this.localPath = SSHSetupUtil.getLocalPath(SystemFactory.s_localPlatId);
            this.commandRetryCount = Integer.parseInt(this.localPath.getValue("COMMAND_RETRY_COUNT"));
        }
        catch (FatalException fe) {
            OiiolTextLogger.appendException((Throwable)fe);
            this.commandRetryCount = 2;
        }
        catch (NumberFormatException nfe) {
            OiiolTextLogger.appendException((Throwable)nfe);
            this.commandRetryCount = 2;
        }
        catch (Exception nfe) {
            OiiolTextLogger.appendException((Throwable)nfe);
            this.commandRetryCount = 2;
        }
    }
}

