/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.prov.ssh.CopyFile;
import oracle.sysman.prov.ssh.OpenSSHSetup;
import oracle.sysman.prov.ssh.RunCommand;
import oracle.sysman.prov.ssh.SSHSetupData;
import oracle.sysman.prov.ssh.SSHSetupTasks;
import oracle.sysman.prov.ssh.SSHSetupUtil;

public class OpenSSHTasks
extends SSHSetupData
implements SSHSetupTasks {
    private String localKnownHost;
    private String remoteKnownHost;
    private String authType;

    public OpenSSHTasks(String host, OpenSSHSetup setupObj) {
        super.init(host, setupObj);
        this.authType = setupObj.authType;
        this.remoteScpPath = setupObj.remoteScpPath;
        this.localKnownHost = setupObj.getLocalKnownHosts();
        this.remoteKnownHost = setupObj.getRemoteKnownHosts();
    }

    @Override
    public boolean sshKeyGen() {
        return this.openSSHKeyGeneration();
    }

    @Override
    public boolean sharePublicKeys() {
        return this.copyFile(this.localAuthorization, this.remoteAuthorization);
    }

    @Override
    public boolean shareHostKeys() {
        return this.copyFile(this.localKnownHost, this.remoteKnownHost);
    }

    private boolean copyFile(String source, String destination) {
        CopyFile copyCmd = new CopyFile(this.host, this.info.getUsername(), this.info.getPassword(), this.remoteScpPath, this.sshPort);
        OiiolTextLogger.appendText((String)("Advanced: Copying " + source + " to " + destination + " on node " + this.host));
        return this.setupObj.scptoHelper(source, destination, copyCmd, this.host);
    }

    private boolean openSSHKeyGeneration() {
        boolean publicKeyExists;
        if (this.info.reuseKey() && (publicKeyExists = SSHSetupUtil.checkFileExistsOnRemoteNode(this.host, this.remotePubKey + " " + this.remotePrivateKey, this.info.getUsername(), this.info.getPassword(), this.sshPort, this.remotePaths, false))) {
            OiiolTextLogger.appendText((String)("Public-Private Key Pair already exists on node: " + this.host));
            return true;
        }
        OiiolTextLogger.appendText((String)("Creating keys on remote Host " + this.host));
        OiiolTextLogger.appendText((String)("to setup SSH on Host " + this.host));
        RunCommand cmd = new RunCommand(this.host, this.info.getUsername(), this.info.getPassword(), this.sshPort);
        cmd.setSshHome(this.localSSHDir);
        String command = this.remotePaths.getValue("RM_PATH") + " " + this.remotePubKey;
        this.setupObj.runCommandHelper(this.host, command, cmd);
        command = this.remotePaths.getValue("RM_PATH") + " " + this.remotePrivateKey;
        this.setupObj.runCommandHelper(this.host, command, cmd);
        command = this.remotePaths.getValue("SSH_KEYGEN_PATH") + " ";
        command = "DSA".equals(this.authType) ? command + "-t dsa " : command + "-t rsa ";
        command = command + this.remotePaths.getValue("SSH_KEYGEN_ARGS_KEYFILE") + " " + this.remotePrivateKey + " " + this.remotePaths.getValue("SSH_KEYGEN_ARGS_PASSPHRASE") + " " + "''" + " " + "-q";
        if ("DSA".equals(this.authType)) {
            command = command + " -b 1024 ";
        }
        if (this.setupObj.runCommandHelper(this.host, command, cmd)) {
            OiiolTextLogger.appendText((String)("SSH Keygen successful on node: " + this.host));
            return true;
        }
        OiiolTextLogger.appendText((String)("SSH Keygen failed on node: " + this.host));
        return false;
    }
}

