/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.ssh.BaseSSHSetup;
import oracle.sysman.prov.ssh.CopyFile;
import oracle.sysman.prov.ssh.FileCopyJob;
import oracle.sysman.prov.ssh.FileLockException;
import oracle.sysman.prov.ssh.OpenSSHTasks;
import oracle.sysman.prov.ssh.RunCommand;
import oracle.sysman.prov.ssh.SSHKeyGenJob;
import oracle.sysman.prov.ssh.SSHSetupException;
import oracle.sysman.prov.ssh.SSHSetupInfo;
import oracle.sysman.prov.ssh.SSHSetupTasks;
import oracle.sysman.prov.ssh.SSHSetupUtil;
import oracle.sysman.prov.ssh.UndoSSHSetupException;

public abstract class OpenSSHSetup
extends BaseSSHSetup {
    protected String localKnownHosts = null;
    protected String remoteKnownHosts = null;
    protected String config = null;
    protected String remoteConfig = null;
    protected String sshConfigfile = "/etc/ssh/ssh_config";
    protected String localHostKeyFile = null;
    protected String remoteHostKeyFile = null;
    List<FileCopyJob> filecopyTasks = new ArrayList<FileCopyJob>();

    public OpenSSHSetup(SSHSetupInfo info) throws SSHSetupException {
        super(info);
        this.localSSHDir = SSHSetupUtil.getNativePath(info.getHome(), ".ssh");
    }

    @Override
    protected void initialize() throws SSHSetupException {
        super.initialize();
        if (OiixUtil.isNullOrBlank((String)this.info.getLocalSshDir(), (boolean)true)) {
            this.info.setLocalSshDir(SSHSetupUtil.getNativePath(this.info.getHome(), ".ssh"));
        }
        String localSshDir = this.localSSHDir;
        this.remoteSSHDir = SSHSetupUtil.getNativePath(this.remoteHome, ".ssh");
        this.remotePubKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, "id_rsa.pub");
        this.remotePrivateKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, "id_rsa");
        this.remoteScpPath = this.remotePaths.getValue("SCP_PATH");
        this.remoteKnownHosts = SSHSetupUtil.getNativePath(this.remoteSSHDir, "known_hosts");
        this.remoteAuthorization = SSHSetupUtil.getNativePath(this.remoteSSHDir, "authorized_keys");
        this.identification = SSHSetupUtil.getNativePath(this.remoteSSHDir, "identification");
        this.config = SSHSetupUtil.getNativePath(localSshDir, "config");
        this.remoteConfig = SSHSetupUtil.getNativePath(this.remoteSSHDir, "config");
        this.localAuthorization = SSHSetupUtil.getNativePath(localSshDir, "authorized_keys");
        this.localKnownHosts = SSHSetupUtil.getNativePath(localSshDir, "known_hosts");
        this.localScpPath = this.localPaths.getValue("SCP_PATH");
        this.localPubKey = SSHSetupUtil.getNativePath(localSshDir, "id_rsa.pub");
        this.localPrivateKey = SSHSetupUtil.getNativePath(localSshDir, "id_rsa");
        this.sshConfigfile = SSHSetupUtil.getNativePath(this.remotePaths.getValue("SSH_HOST_KEY_LOC"), "ssh_config");
        try {
            if (!new File(this.sshConfigfile).exists()) {
                this.sshConfigfile = this.remotePaths.getValue("SSH_CONFIG_FILE_PATH");
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendException((Throwable)e);
        }
        if ("RSA".equals(this.authType)) {
            this.localPubKey = SSHSetupUtil.getNativePath(localSshDir, "id_rsa.pub");
            this.localPrivateKey = SSHSetupUtil.getNativePath(localSshDir, "id_rsa");
            this.remotePubKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, "id_rsa.pub");
            this.constructPrivateKeyFilePath("id_rsa");
            this.remoteHostKeyFile = SSHSetupUtil.getNativePath(this.remotePaths.getValue("SSH_HOST_KEY_LOC"), "ssh_host_rsa_key.pub");
            this.localHostKeyFile = SSHSetupUtil.getNativePath(this.localPaths.getValue("SSH_HOST_KEY_LOC"), "ssh_host_rsa_key.pub");
        } else {
            this.localPubKey = SSHSetupUtil.getNativePath(localSshDir, "id_dsa.pub");
            this.localPrivateKey = SSHSetupUtil.getNativePath(localSshDir, "id_dsa");
            this.remotePubKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, "id_dsa.pub");
            this.constructPrivateKeyFilePath("id_dsa");
            this.remoteHostKeyFile = SSHSetupUtil.getNativePath(this.remotePaths.getValue("SSH_HOST_KEY_LOC"), "ssh_host_dsa_key.pub");
            this.localHostKeyFile = SSHSetupUtil.getNativePath(this.localPaths.getValue("SSH_HOST_KEY_LOC"), "ssh_host_dsa_key.pub");
        }
    }

    @Override
    protected void postSSHTasks() throws FatalException, ClusterException {
    }

    @Override
    protected void changePermissionOnSSH() throws ClusterException, FatalException {
        super.setUserHomeDirectoryPermissionOnLocalNode();
        this.setPermissionsOnSshDir(OiixPathOps.getStandardForm((String)this.info.getLocalSshDir()));
    }

    @Override
    public void establishConnectionAsUser() throws SSHSetupException, ClusterException, FatalException {
        String sshLocalDir = this.info.getSshLocalDir();
        String localSshDir = this.info.getLocalSshDir();
        if (this.info.getAsUser() != null && sshLocalDir != null) {
            String localDirStd;
            String homeD = OiixPathOps.getNativeForm((String)this.info.getHome());
            File fp = new File(sshLocalDir);
            String sshLocalDir_Parent = OiixPathOps.getNativeForm((String)fp.getParent());
            OiiolTextLogger.appendText((String)("Home Dir : " + homeD + " sshLocalDir_Parent " + sshLocalDir_Parent));
            if (this.info.getAsUser() != null && !sshLocalDir_Parent.equals(homeD)) {
                localDirStd = OiixPathOps.getStandardForm((String)sshLocalDir);
                File fSshLocalDir = new File(sshLocalDir);
                if (fSshLocalDir.exists()) {
                    OiixFileOps.recdelete((File)fSshLocalDir);
                }
                if (!fSshLocalDir.mkdirs()) {
                    this.createLocalDir(localDirStd);
                }
                this.copyKeys();
                this.setPermissionsOnSshDir(localDirStd);
                this.setPermissionsOnSshDir(OiixPathOps.getStandardForm((String)localSshDir));
            }
            if (this.info.getAsUserGrp() == null) {
                this.info.setAsUserGrp("");
            }
            localDirStd = OiixPathOps.getStandardForm((String)localSshDir);
            String l_command = this.localPaths.getValue("CHOWN_PATH") + " -R " + this.info.getAsUser() + " '" + localDirStd + "'";
            SSHSetupUtil.runCmdOnLocalNodeHelper(l_command);
        }
    }

    @Override
    protected void setUpSSHFromLocal() throws SSHSetupException, ClusterException, FatalException {
        this.generateKeys();
        this.addToAuthorizationFile();
        this.addToConfigFile();
        this.remoteHosts = this.info.getRemoteHosts();
        for (int j = 0; j < this.connectionCount; ++j) {
            this.performRemoteSSHSetup(this.remoteHosts[j]);
        }
        this.generateHostKeys();
    }

    @Override
    protected void setupN2NConnectivity() throws FatalException, ClusterException {
        this.sshKeyGen();
        this.setupSSHKeys();
        this.generateHostKeys();
        this.updateHostkeys();
        this.updatePublickeys();
    }

    @Override
    protected void validateInstalledSSH() throws FatalException, ClusterException, SSHSetupException {
        try {
            this.validateRemoteHosts(this.info.getRemoteHosts(), this.info.getUsername());
        }
        catch (FileLockException fle) {
            throw new SSHSetupException((Throwable)((Object)fle));
        }
        this.validateRemoteScp(this.info.getRemoteHosts(), this.info.getUsername());
    }

    private void validateRemoteHosts(String[] remoteHosts, String username) throws FileLockException, SSHSetupException {
        OiiolTextLogger.appendText((String)"Validating remote binaries..");
        try {
            if (this.validateRemoteBinaries(remoteHosts, username)) {
                OiiolTextLogger.appendText((String)"Remote binaries check succeeded");
            }
            this.validateProtocolVersion(this.info.getRemoteHosts(), username);
            OiiolTextLogger.appendText((String)"Protocol version check succeeded");
        }
        catch (SSHSetupException e) {
            OiiolTextLogger.appendText((String)e.getMessage());
            throw e;
        }
    }

    protected boolean validateRemoteBinaries(String[] remoteHosts, String username) throws SSHSetupException {
        RunCommand cmd = null;
        boolean isRsa = true;
        String shPath = this.remotePaths.getValue("SH_PATH");
        String shArgs = this.remotePaths.getValue("SH_ARGS");
        String sshKeygen = this.remotePaths.getValue("SSH_KEYGEN_PATH");
        String hostKeyLoc = this.remotePaths.getValue("SSH_HOST_KEY_LOC");
        String hostKeyPub = isRsa ? "ssh_host_rsa_key.pub" : "ssh_host_dsa_key.pub";
        String cmd2 = this.remotePaths.getValue("TRUE");
        String cmd2Value = this.remotePaths.getValue("CMD2");
        String h_cmd = shPath + " " + shArgs + " '" + cmd2 + "'";
        OiiolTextLogger.appendText((String)("shPath = " + shPath + " shArgs = " + shArgs + " sshKeygen = " + sshKeygen + " hostKeyLoc = " + hostKeyLoc + " hostKeyPub = " + hostKeyPub + " cmd2 = " + cmd2 + " cmd2Value = " + cmd2Value + " h_cmd = " + h_cmd));
        for (int i = 0; i < remoteHosts.length; ++i) {
            cmd = new RunCommand(remoteHosts[i], username, this.info.getPassword(), this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            OiiolTextLogger.appendText((String)"Checking SH args");
            OiiolTextLogger.appendText((String)("Command " + h_cmd));
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd)) {
                return false;
            }
            if (cmd.getExitCode() != 0) {
                throw new SSHSetupException("Existence check failed for " + shPath + " on node: " + remoteHosts[i] + ". Please check whether the file exists or not." + " If the file exists, please correct the shell path configured in the properties file used.");
            }
            cmd = new RunCommand(remoteHosts[i], username, this.info.getPassword(), this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            cmd2 = MessageFormat.format(cmd2Value, "", this.remoteHostKeyFile, "", "", "-f");
            h_cmd = shPath + " " + shArgs + " '" + cmd2 + "'";
            OiiolTextLogger.appendText((String)"Checking hostkey");
            OiiolTextLogger.appendText((String)("Command " + h_cmd));
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd)) {
                return false;
            }
            if (cmd.getExitCode() != 0) {
                throw new SSHSetupException("Unable to find " + this.remoteHostKeyFile + " on node: " + remoteHosts[i] + ". Please check whether the file exists or the user '" + System.getProperty("user.name") + "' has sufficient privilege to access the file !!!");
            }
            cmd = new RunCommand(remoteHosts[i], username, this.info.getPassword(), this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            cmd2 = MessageFormat.format(cmd2Value, "", sshKeygen, "", "", "-f");
            h_cmd = shPath + " " + shArgs + " '" + cmd2 + "'";
            OiiolTextLogger.appendText((String)"Checking ssh keygen");
            OiiolTextLogger.appendText((String)("Command " + h_cmd));
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd)) {
                return false;
            }
            if (cmd.getExitCode() == 0) continue;
            throw new SSHSetupException("Unable to find " + sshKeygen + " on node: " + remoteHosts[i] + ". Please check whether the file exists or the user has sufficient privilege to access the file.");
        }
        return true;
    }

    protected String getLocalKnownHosts() {
        return this.localKnownHosts;
    }

    protected String getRemoteKnownHosts() {
        return this.remoteKnownHosts;
    }

    private void validateProtocolVersion(String[] remoteHosts, String username) throws SSHSetupException {
        OiiolTextLogger.appendText((String)("Validating OpenSSH protocol version on the remote nodes. The file '" + this.sshConfigfile + "' should exist on the remote node"));
        RunCommand cmd = null;
        String cmd2 = null;
        String commandOutcome = null;
        String temp = null;
        String commandProtocol = "cat " + this.sshConfigfile + " | grep Protocol";
        String protocol1 = "Protocol 1";
        for (int i = 0; i < remoteHosts.length; ++i) {
            cmd = new RunCommand(remoteHosts[i], username, this.info.getPassword(), this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            cmd2 = this.remotePaths.getValue("SH_PATH") + " " + this.remotePaths.getValue("SH_ARGS") + " '" + commandProtocol + "'";
            commandOutcome = !this.runCommandHelper(remoteHosts[i], cmd2, cmd) ? cmd.getError() : cmd.getOutput();
            if (commandOutcome != null) {
                commandOutcome = commandOutcome.trim();
            }
            if (temp != null && !commandOutcome.startsWith("#") && commandOutcome.equals(protocol1) && !temp.equals(commandOutcome)) {
                throw new SSHSetupException("Protocol version different between nodes");
            }
            temp = commandOutcome;
        }
        if (commandOutcome.equals(protocol1)) {
            String localSshDir = this.info.getLocalSshDir();
            this.localPubKey = SSHSetupUtil.getNativePath(localSshDir, "identity.pub");
            this.localPrivateKey = SSHSetupUtil.getNativePath(localSshDir, "identity");
            this.remotePubKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, "identity.pub");
            this.constructPrivateKeyFilePath("identity");
        }
    }

    protected boolean validateRemoteScp(String[] remoteHosts, String username) throws SSHSetupException {
        if (remoteHosts == null) {
            OiiolTextLogger.appendText((String)" SSHSetup.validateRemoteScp: remoteHosts is NULL....");
            return false;
        }
        if (OiixUtil.isNullOrBlank((String)username, (boolean)true)) {
            OiiolTextLogger.appendText((String)" SSHSetup.validateRemoteScp: username is Empty....");
        }
        for (int i = 0; i < remoteHosts.length; ++i) {
            String remoteScpPath = this.remotePaths.getValue("SCP_PATH");
            String shPath = this.remotePaths.getValue("SH_PATH");
            String shArgs = this.remotePaths.getValue("SH_ARGS");
            String cmd2 = MessageFormat.format(this.remotePaths.getValue("CMD2"), "", remoteScpPath, "", "", "-x");
            String h_cmd = shPath + " " + shArgs + " '" + cmd2 + "'";
            RunCommand cmd = new RunCommand(remoteHosts[i], username, this.info.getPassword(), this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd)) {
                return false;
            }
            if (cmd.getExitCode() == 0) continue;
            throw new SSHSetupException("Unable to find " + remoteScpPath + " on node: " + remoteHosts[i]);
        }
        return true;
    }

    protected void sshKeyGen() {
        if (this.info.reuseKey()) {
            this.remoteHosts = this.info.getNewNodes();
            super.calculateNewLoopCount_AddNewNodes();
        } else {
            this.remoteHosts = this.info.getRemoteHosts();
        }
        for (int i = 0; i < this.connectionCount; ++i) {
            OpenSSHTasks taskObj = new OpenSSHTasks(this.remoteHosts[i], this);
            this.taskMap.put(this.remoteHosts[i], taskObj);
            SSHKeyGenJob sshkeygen = new SSHKeyGenJob(taskObj);
            this.listofTasks.add(sshkeygen);
        }
        if (super.executeTasks()) {
            OiiolTextLogger.appendText((String)("Completed the ssh keygen on all the nodes. No.of nodes = " + this.connectionCount));
        } else {
            OiiolTextLogger.appendText((String)"SSH keygen failed on some of the nodes");
        }
    }

    protected void setupSSHKeys() throws ClusterException, FatalException {
        String localtmp = null;
        String pubKeySSH2 = null;
        CopyFile copyCmd = null;
        String username = this.info.getUsername();
        String password = this.info.getPassword();
        String localSshDir = this.info.getLocalSshDir();
        if (new File(this.localAuthorization).exists()) {
            SSHSetupUtil.backupAndDeleteFile(this.localAuthorization, this.info.isOflag());
        }
        for (int i = 0; i < this.connectionCount; ++i) {
            copyCmd = new CopyFile(this.remoteHosts[i], username, password, this.remoteScpPath, this.sshPort);
            localtmp = SSHSetupUtil.getNativePath(localSshDir, "identity.pub." + this.remoteHosts[i]);
            pubKeySSH2 = SSHSetupUtil.getNativePath(localSshDir, "identity." + this.remoteHosts[i] + ".ssh2.pub");
            if (!this.scpfromHelper(this.remotePubKey, localtmp, copyCmd, this.remoteHosts[i])) continue;
            if (!new File(localtmp).exists()) {
                this.openSSHKeyGen(pubKeySSH2, localtmp);
            }
            String catcmd = this.localPaths.getValue("CAT_PATH") + " " + "'" + localtmp + "'" + " >> " + "'" + this.localAuthorization + "'";
            SSHSetupUtil.runCmdOnLocalNodeHelper(catcmd);
            String rmCmd = SSHSetupUtil.removeCmd("'" + localtmp + "'", false, this.localPaths);
            SSHSetupUtil.runCmdOnLocalNodeHelper(rmCmd);
        }
    }

    protected void generateHostKeys() {
        RunCommand cmd = null;
        InetAddress inetAddr = null;
        String hostkey = null;
        String hostname = null;
        String fullHostname = null;
        String ip = null;
        String str = "";
        String command = null;
        int idx = -1;
        String username = this.info.getUsername();
        String password = this.info.getPassword();
        if (new File(this.localKnownHosts).exists()) {
            SSHSetupUtil.backupAndDeleteFile(this.localKnownHosts, this.info.isOflag());
        }
        for (int i = 0; i < this.remoteHosts.length; ++i) {
            cmd = new RunCommand(this.remoteHosts[i], username, password, this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            command = this.prepareCommand();
            if (!this.r_catCmd(this.remoteHosts[i], cmd, command)) continue;
            hostkey = cmd.getOutput();
            idx = -1;
            try {
                inetAddr = InetAddress.getByName(this.remoteHosts[i]);
                fullHostname = inetAddr.getHostName();
                idx = fullHostname.indexOf(46);
                if (idx == -1) {
                    hostname = fullHostname;
                    fullHostname = inetAddr.getCanonicalHostName();
                } else {
                    hostname = fullHostname.substring(0, idx);
                }
                OiiolTextLogger.appendText((String)("Hostname : " + hostname));
                OiiolTextLogger.appendText((String)("FullHostname : " + fullHostname));
                ip = inetAddr.getHostAddress();
                OiiolTextLogger.appendText((String)("IP address : " + ip + "\n"));
                str = str + hostname + "," + ip + " " + hostkey + "\n";
                str = str + fullHostname + " " + hostkey + "\n";
                continue;
            }
            catch (UnknownHostException e) {
                OiiolTextLogger.appendException((Throwable)e);
            }
        }
        SSHSetupUtil.writeStringToFile(this.localKnownHosts, str, true);
    }

    protected String prepareCommand() {
        String command = "\"";
        command = this.authType.equals("RSA") ? command + SSHSetupUtil.getNativePath(this.remotePaths.getValue("SSH_HOST_KEY_LOC"), "ssh_host_rsa_key.pub") : command + SSHSetupUtil.getNativePath(this.remotePaths.getValue("SSH_HOST_KEY_LOC"), "ssh_host_dsa_key.pub");
        command = command + "\"";
        return command;
    }

    protected void updateHostkeys() {
        String serverPubKeyFile = SSHSetupUtil.getNativePath(this.localPaths.getValue("SSH_HOST_KEY_LOC"), this.authType.equals("RSA") ? "ssh_host_rsa_key.pub" : "ssh_host_dsa_key.pub");
        String[] remoteHosts = this.info.getRemoteHosts();
        this.listofTasks.clear();
        try {
            String hostkey = OiixFunctionOps.implodeList((String[])SSHSetupUtil.readFile(serverPubKeyFile), (String)"\n");
            SSHSetupUtil.writeStringToFile(this.localKnownHosts, hostkey, true);
            this.setupFileCopyTasks(remoteHosts, remoteHosts.length, true);
            if (super.executeTasks()) {
                OiiolTextLogger.appendText((String)("Completed the copying of : " + this.localKnownHosts + " from local node to all the nodes successfully."));
            } else {
                OiiolTextLogger.appendText((String)("Copying of :" + this.localKnownHosts + " file to some of the nodes failed"));
            }
        }
        catch (CommandException e) {
            this.commandResults.put("LocalHost", "Read File " + serverPubKeyFile);
            this.commandExceptions.put("LocalHost", new CommandException("LocalHost", e.getMessage()));
        }
    }

    protected void updatePublickeys() {
        String[] remoteHosts = this.info.getRemoteHosts();
        this.connectionCount = super.calculateLoopCount();
        this.setupFileCopyTasks(remoteHosts, this.connectionCount, false);
        if (super.executeTasks()) {
            OiiolTextLogger.appendText((String)("Completed the copying of : " + this.localAuthorization + " from local node to all the nodes successfully."));
        } else {
            OiiolTextLogger.appendText((String)("Failed the copying of : " + this.localAuthorization + " from local node to some of the remote nodes"));
        }
        this.listofTasks.clear();
    }

    private void copyKeys() throws SSHSetupException {
        String localDirStd = OiixPathOps.getStandardForm((String)this.info.getSshLocalDir());
        String identity1 = SSHSetupUtil.getNativePath(localDirStd, "id_rsa");
        String identitypub1 = SSHSetupUtil.getNativePath(localDirStd, "id_rsa.pub");
        String authkeys1 = SSHSetupUtil.getNativePath(localDirStd, "authorized_keys");
        String known_hosts1 = SSHSetupUtil.getNativePath(localDirStd, "known_hosts");
        String config1 = SSHSetupUtil.getNativePath(localDirStd, "config");
        try {
            OiixFileOps.copyFile((String)this.localPrivateKey, (String)identity1, (boolean)true, (boolean)false);
            OiixFileOps.copyFile((String)this.localPubKey, (String)identitypub1, (boolean)true, (boolean)false);
            OiixFileOps.copyFile((String)this.localAuthorization, (String)authkeys1, (boolean)true, (boolean)false);
            OiixFileOps.copyFile((String)this.localKnownHosts, (String)known_hosts1, (boolean)true, (boolean)false);
            OiixFileOps.copyFile((String)this.config, (String)config1, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            this.processSSHException(e, "Unable to copy files to sshlocalDir", false, this.info.getSshLocalDir());
        }
    }

    protected void setPermissionsOnSshDir(String dir) throws FatalException, ClusterException {
        this.changePermission(dir, null, "755");
        this.changePermission(dir, "id_rsa.pub", "644");
        this.changePermission(dir, "authorized_keys", "644");
        this.changePermission(dir, "known_hosts", "644");
        this.changePermission(dir, "config", "644");
        this.changePermission(dir, "id_rsa", "600");
    }

    protected void generateKeys() throws SSHSetupException, FatalException, ClusterException {
        File f1 = new File(this.localPrivateKey);
        File f2 = new File(this.localPubKey);
        if (f1.exists() && f2.exists() && !this.info.isOflag()) {
            OiiolTextLogger.appendText((String)"User selected : no, using Old keys");
        } else {
            if (this.info.isOflag()) {
                OiiolTextLogger.appendText((String)"User selected : yes, generating new Keys");
            } else {
                OiiolTextLogger.appendText((String)"Public, Private keys don't exist, generating new Keys");
            }
            if (f1.exists()) {
                SSHSetupUtil.backupAndDeleteFile(this.localPrivateKey, false);
            }
            if (f2.exists()) {
                SSHSetupUtil.backupAndDeleteFile(this.localPubKey, false);
            }
            OiiolTextLogger.appendText((String)"");
            OiiolTextLogger.appendText((String)"Generating new keys");
            try {
                JSch jsch = new JSch();
                int type = this.authType.equals("DSA") ? 1 : 2;
                KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)type);
                kpair.setPassphrase(this.info.getPassphrase());
                kpair.writePrivateKey(this.localPrivateKey);
                kpair.writePublicKey(this.localPubKey, "");
                kpair.dispose();
            }
            catch (Exception e) {
                this.processSSHException(e, "Key Generation", false, this.info.getLocalSshDir());
            }
        }
    }

    protected void addToAuthorizationFile() throws SSHSetupException {
        if (new File(this.localAuthorization).exists()) {
            SSHSetupUtil.backupAndDeleteFile(this.localAuthorization, !this.info.isOflag());
        }
        try {
            OiixFileOps.appendFile((String)this.localAuthorization, (String)this.localPubKey);
        }
        catch (IOException e) {
            this.processSSHException(e, "Append authorized_keys", false, this.info.getLocalSshDir());
        }
    }

    private void addToConfigFile() {
        if (new File(this.config).exists()) {
            SSHSetupUtil.backupAndDeleteFile(this.config, !this.info.isOflag());
        }
        String str = "Host *\nForwardX11 no\n";
        SSHSetupUtil.writeStringToFile(this.config, str, false);
    }

    protected void performRemoteSSHSetup(String remoteNode) {
        String username = this.info.getUsername();
        String password = this.info.getPassword();
        RunCommand cmd = new RunCommand(remoteNode, username, password, this.sshPort);
        cmd.setSshHome(this.localSSHDir);
        if (!this.createRemoteDir(remoteNode, cmd, this.remoteSSHDir)) {
            return;
        }
        String scratchPath = SSHSetupUtil.getNativePath(this.remoteSSHDir, "id_rsa.pub");
        String scratchFile = scratchPath + remoteNode;
        if (!this.removeFile2(remoteNode, cmd, scratchFile, true)) {
            return;
        }
        CopyFile copyCmd = new CopyFile(remoteNode, username, password, this.remoteScpPath, this.sshPort);
        scratchFile = "\"" + scratchFile + "\"";
        if (!this.scptoHelper(this.localPubKey, scratchFile, copyCmd, remoteNode)) {
            return;
        }
        if (!this.remoteFileCopy(remoteNode, cmd, this.remoteAuthorization, this.remoteAuthorization + ".ri.bak")) {
            return;
        }
        String file = scratchFile + " >> " + "\"" + this.remoteAuthorization + "\"";
        if (!this.r_catCmd(remoteNode, cmd, file)) {
            return;
        }
        if (!this.removeFile2(remoteNode, cmd, scratchFile, false)) {
            return;
        }
        if (!this.changeRemoteSSHPermissions(remoteNode, this.remoteAuthorization, this.remoteHome, this.remoteSSHDir, cmd)) {
            return;
        }
        if (!remoteNode.equals(this.localFQDN)) {
            if (!this.backupRemoteConfigFile(remoteNode, cmd, this.remoteConfig)) {
                return;
            }
            if (!this.scptoHelper(this.config, "\"" + this.remoteConfig + "\"", copyCmd, remoteNode)) {
                return;
            }
        }
    }

    @Override
    public void tearDownSSH() throws UndoSSHSetupException, ClusterException, FatalException {
        try {
            this.sshDeleteOperation = true;
            this.initialize();
            String sshLocalDir = this.info.getSshLocalDir();
            if (sshLocalDir != null) {
                if (this.sharedHome) {
                    this.removeLocalSSHSetup(sshLocalDir);
                    if (!sshLocalDir.equals(this.localSSHDir)) {
                        this.removeLocalSSHSetup(this.localSSHDir);
                    }
                } else {
                    this.removeLocalSSHSetup(sshLocalDir);
                    this.removeRemoteSSHSetup(sshLocalDir);
                    if (!sshLocalDir.equals(this.localSSHDir)) {
                        this.removeLocalSSHSetup(this.localSSHDir);
                        this.removeRemoteSSHSetup(this.localSSHDir);
                    }
                }
            } else if (this.sharedHome) {
                this.removeLocalSSHSetup(this.localSSHDir);
            } else {
                this.removeRemoteSSHSetup(this.localSSHDir);
            }
        }
        catch (SSHSetupException e) {
            throw new UndoSSHSetupException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new UndoSSHSetupException(e);
        }
    }

    private void removeRemoteSSHSetup(String sshHome) throws FatalException, IOException {
        String[] remoteNodes = this.info.getRemoteHosts();
        for (int i = 0; i < this.connectionCount; ++i) {
            CopyFile copyCmd = new CopyFile(remoteNodes[i], this.info.getUsername(), this.info.getPassword(), this.remoteScpPath, this.sshPort);
            RunCommand cmd = new RunCommand(remoteNodes[i], this.info.getUsername(), this.info.getPassword(), this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            String localtmp = SSHSetupUtil.getNativePath(sshHome, "authorized_keys." + remoteNodes[i]);
            String localtmp1 = SSHSetupUtil.getNativePath(sshHome, "authorized_keys." + remoteNodes[i] + ".inprogress");
            if (!this.scpfromHelper(this.remoteAuthorization, localtmp, copyCmd, remoteNodes[i])) {
                SSHSetupUtil.deleteFile(localtmp);
                continue;
            }
            String l_pubkeyFile = SSHSetupUtil.getNativePath(sshHome, "id_rsa.pub");
            if (!new File(localtmp).exists() || !new File(l_pubkeyFile).exists()) {
                SSHSetupUtil.deleteFile(localtmp);
                continue;
            }
            try {
                String[] pubkeyFile = SSHSetupUtil.readFile(l_pubkeyFile);
                String[] r_authkeysFile = SSHSetupUtil.readFile(localtmp);
                SSHSetupUtil.deleteFile(localtmp);
                this.updateAuthKeys(pubkeyFile, r_authkeysFile, localtmp1, sshHome);
            }
            catch (CommandException e) {
                throw new FatalException(e.getMessage());
            }
            if (!this.scptoHelper(localtmp1, this.remoteAuthorization, copyCmd, remoteNodes[i])) {
                SSHSetupUtil.deleteFile(localtmp);
                continue;
            }
            this.changeRemoteFilePermission(remoteNodes[i], this.remoteAuthorization, "644", cmd);
            SSHSetupUtil.deleteFile(localtmp);
            SSHSetupUtil.deleteFile(localtmp1);
            localtmp = SSHSetupUtil.getNativePath(sshHome, "known_hosts." + remoteNodes[i]);
            if (!this.scpfromHelper(this.remoteKnownHosts, localtmp, copyCmd, remoteNodes[i])) {
                SSHSetupUtil.deleteFile(localtmp);
                continue;
            }
            String known_hosts_tmp = SSHSetupUtil.getNativePath(sshHome, "known_hosts.tmp");
            try {
                if (!new File(localtmp).exists()) continue;
                this.updateKnownHosts(known_hosts_tmp, this.info.getRemoteHosts(), localtmp);
                SSHSetupUtil.deleteFile(localtmp);
                this.scptoHelper(known_hosts_tmp, this.remoteKnownHosts, copyCmd, remoteNodes[i]);
                SSHSetupUtil.deleteFile(known_hosts_tmp);
                this.changeRemoteFilePermission(remoteNodes[i], this.remoteKnownHosts, "644", cmd);
                continue;
            }
            catch (CommandException e) {
                throw new FatalException(e.getMessage());
            }
        }
    }

    private void removeLocalSSHSetup(String sshHome) throws FatalException {
        String known_hosts = SSHSetupUtil.getNativePath(sshHome, "known_hosts");
        String known_hosts_tmp = SSHSetupUtil.getNativePath(sshHome, "known_hosts.tmp");
        OiiolTextLogger.appendText((String)"removeLocalSSHSetup : Updating known_hosts");
        try {
            this.updateKnownHosts(known_hosts_tmp, this.info.getRemoteHosts(), known_hosts);
            SSHSetupUtil.deleteFile(known_hosts);
            SSHSetupUtil.copyFile(known_hosts_tmp, known_hosts);
            SSHSetupUtil.deleteFile(known_hosts_tmp);
            String authorized_keys = SSHSetupUtil.getNativePath(sshHome, "authorized_keys");
            String[] authkeys_file = SSHSetupUtil.readFile(authorized_keys);
            if (authkeys_file == null) {
                return;
            }
            String pubkey = SSHSetupUtil.getNativePath(sshHome, "id_rsa.pub");
            String[] pubkeyFile = SSHSetupUtil.readFile(pubkey);
            OiiolTextLogger.appendText((String)"removeLocalSSHSetup : Updating authorized_keys");
            this.updateAuthKeys(pubkeyFile, authkeys_file, authorized_keys, sshHome);
        }
        catch (CommandException e) {
            throw new FatalException(e.getMessage());
        }
        catch (IOException e) {
            throw new FatalException(e.getMessage());
        }
    }

    private void updateAuthKeys(String[] pubkeyFile, String[] authkeys_file, String authorized_keys, String sshHome) throws CommandException, IOException {
        if (pubkeyFile != null && authkeys_file != null) {
            String r_authkeys_tmp_path = SSHSetupUtil.getNativePath(sshHome, "authorized_keys.tmp");
            File r_authkeys_tmp = new File(r_authkeys_tmp_path);
            try {
                r_authkeys_tmp.createNewFile();
            }
            catch (IOException e) {
                throw new CommandException(e.getMessage());
            }
            boolean firstline = true;
            for (int i = 0; i < authkeys_file.length; ++i) {
                if (authkeys_file[i].indexOf(pubkeyFile[0]) != -1) continue;
                if (firstline) {
                    SSHSetupUtil.writeStringToFile(r_authkeys_tmp_path, authkeys_file[i], false);
                    firstline = false;
                    continue;
                }
                SSHSetupUtil.writeStringToFile(r_authkeys_tmp_path, authkeys_file[i], true);
            }
            SSHSetupUtil.deleteFile(authorized_keys);
            SSHSetupUtil.copyFile(r_authkeys_tmp_path, authorized_keys);
            SSHSetupUtil.deleteFile(r_authkeys_tmp_path);
        }
    }

    private void updateKnownHosts(String known_hosts_tmp, String[] remoteNodes, String known_hosts) throws CommandException {
        OiiolTextLogger.appendText((String)("updateKnownHosts : remoteNodes length" + remoteNodes.length));
        String[] file = SSHSetupUtil.readFile(known_hosts);
        int outLoopCount = remoteNodes.length;
        int inLoopCount = file.length;
        OiiolTextLogger.appendText((String)("inLoopCount " + inLoopCount + " OutLoopCount " + outLoopCount));
        if (file != null) {
            File tmp = new File(known_hosts_tmp);
            try {
                tmp.createNewFile();
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException((Throwable)ioe);
                return;
            }
            boolean firstline = true;
            boolean found = false;
            for (int i = 0; i < file.length; ++i) {
                found = false;
                if (file[i].indexOf(this.localHost) != -1) {
                    found = true;
                }
                if (found) continue;
                if (firstline) {
                    SSHSetupUtil.writeStringToFile(known_hosts_tmp, file[i], false);
                    firstline = false;
                    continue;
                }
                SSHSetupUtil.writeStringToFile(known_hosts_tmp, file[i], true);
            }
        }
    }

    private void constructPrivateKeyFilePath(String fileName) {
        if (this.remoteHome.endsWith(File.separator)) {
            String sshDir = SSHSetupUtil.getNativePathForSSHKeyGen(this.remoteHome, ".ssh");
            this.remotePrivateKey = SSHSetupUtil.getNativePath(sshDir, fileName);
        } else {
            this.remotePrivateKey = SSHSetupUtil.getNativePath(this.remoteSSHDir, fileName);
        }
    }

    private void setupFileCopyTasks(String[] remoteHosts, int count, boolean createCopyTaskForAllNodes) {
        FileCopyJob copyTask = null;
        for (int i = 0; i < count; ++i) {
            boolean createCopyTask = false;
            SSHSetupTasks task = null;
            if (this.taskMap.containsKey(remoteHosts[i])) {
                task = this.taskMap.get(remoteHosts[i]);
            } else {
                task = new OpenSSHTasks(remoteHosts[i], this);
                this.taskMap.put(remoteHosts[i], task);
                createCopyTask = true;
            }
            if (!createCopyTask && !createCopyTaskForAllNodes) continue;
            copyTask = new FileCopyJob(task, true);
            this.listofTasks.add(copyTask);
        }
    }
}

