/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Commands;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;
import oracle.sysman.prov.ssh.RunCommandLogger;
import oracle.sysman.prov.ssh.RunCommandUserInfo;
import oracle.sysman.prov.ssh.SSHSetupUtil;

public class CopyFile {
    String m_user = null;
    String m_host = null;
    String m_scpCmd = "scp";
    int m_port = 22;
    UserInfo ui = null;
    boolean m_bLog = true;
    private int commandRetryCount = 2;

    public CopyFile(String host, String user, String password) {
        this(host, user, password, "scp", 22);
        this.init();
    }

    public CopyFile(String host, String user, String password, String pathToRemoteScp, int sshport) {
        this(host, user, password, pathToRemoteScp, sshport, true);
        this.init();
    }

    public CopyFile(String host, String user, String password, boolean bLog) {
        this(host, user, password, "scp", 22, true);
        this.init();
    }

    public CopyFile(String host, String user, String password, String pathToRemoteScp, int sshport, boolean bLog) {
        this.m_host = host;
        this.m_user = user;
        this.ui = new RunCommandUserInfo(password);
        if (null != pathToRemoteScp && !pathToRemoteScp.trim().equals("")) {
            this.m_scpCmd = pathToRemoteScp;
        }
        this.m_port = sshport;
        this.m_bLog = bLog;
        this.init();
    }

    private void cleanup(Channel ch, Session sess) {
        if (ch != null) {
            ch.disconnect();
        }
        if (sess != null) {
            sess.disconnect();
        }
    }

    public void scpTo(String localFile, String remoteFile) throws CommandException {
        if (this.m_bLog) {
            OiiolTextLogger.appendText((String)("Copy localfile: " + localFile + " to remotefile: " + remoteFile + "\n"));
        }
        Channel channel = null;
        Session session = null;
        JSch jsch = null;
        for (int iterCount = 1; iterCount <= this.commandRetryCount; ++iterCount) {
            try {
                int len;
                int i;
                jsch = new JSch();
                session = this.getJschSession(jsch);
                String command = this.m_scpCmd + " -p -t " + remoteFile;
                channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                StringBuffer buffer = new StringBuffer();
                while ((i = in.read()) != 0) {
                    buffer.append((char)i);
                    if (buffer.length() < 65536) continue;
                    OiiolTextLogger.appendText((String)"CopyFile: no acknowledgement received from remote node", (int)OiiolTextLogger.LOG_WARNING);
                    if (Boolean.getBoolean("oracle.sysman.prov.logJschDebug") && this.m_bLog) {
                        OiiolTextLogger.appendText((String)"CopyFile: dumping the contents of inputstream");
                        OiiolTextLogger.appendText((String)buffer.toString());
                    }
                    this.cleanup(channel, session);
                    return;
                }
                Commands co = new Commands();
                String ignoreBuffer = "";
                String[] result = OiixFunctionOps.explodeString((String)buffer.toString(), (String)"\n");
                for (int i2 = 0; i2 < result.length; ++i2) {
                    if (co.ignoreErrString(result[i2])) continue;
                    ignoreBuffer = ignoreBuffer + result[i2];
                }
                byte[] res = (ignoreBuffer = ignoreBuffer + "\u0000").getBytes();
                in = new ByteArrayInputStream(res);
                if (this.checkAck(in) != 0) {
                    OiiolTextLogger.appendText((String)"CopyFile: no acknowledgement received, exiting", (int)OiiolTextLogger.LOG_WARNING);
                    this.cleanup(channel, session);
                    return;
                }
                in = channel.getInputStream();
                long filesize = new File(localFile).length();
                command = "C0644 " + filesize + " ";
                command = localFile.lastIndexOf(47) > 0 ? command + localFile.substring(localFile.lastIndexOf(47) + 1) : command + localFile;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                if (this.checkAck(in) != 0) {
                    this.cleanup(channel, session);
                    return;
                }
                FileInputStream fis = new FileInputStream(localFile);
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                    out.flush();
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                if (this.checkAck(in) != 0) {
                    this.cleanup(channel, session);
                    return;
                }
                break;
            }
            catch (Exception ex) {
                this.processException(channel, session, ex, iterCount, jsch);
                continue;
            }
        }
        this.cleanup(channel, session);
    }

    private void processException(Channel channel, Session session, Exception e, int iterCount, JSch jsch) throws CommandException {
        this.cleanup(channel, session);
        jsch = null;
        if (iterCount == this.commandRetryCount) {
            throw new CommandException(this.m_host, "PROV-16011", e.getMessage(), (Throwable)e);
        }
    }

    private Session getJschSession(JSch jsch) throws JSchException {
        if (Boolean.getBoolean("oracle.sysman.prov.logJschDebug")) {
            JSch.setLogger((Logger)new RunCommandLogger());
        }
        Session session = jsch.getSession(this.m_user, this.m_host, this.m_port);
        Properties configProps = new Properties();
        configProps.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
        session.setConfig(configProps);
        session.setUserInfo(this.ui);
        session.connect();
        return session;
    }

    public void scpFrom(String remoteFile, String localFile) throws CommandException {
        Channel channel = null;
        Session session = null;
        JSch jsch = null;
        if (this.m_bLog) {
            OiiolTextLogger.appendText((String)("Copy remotefile: " + remoteFile + " to localfile: " + localFile + "\n"));
        }
        String prefix = null;
        if (new File(localFile).isDirectory()) {
            prefix = localFile + File.separator;
        }
        for (int iterCount = 1; iterCount <= this.commandRetryCount; ++iterCount) {
            try {
                int c;
                jsch = new JSch();
                session = this.getJschSession(jsch);
                String command = this.m_scpCmd + " -f " + remoteFile;
                channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                byte[] buf = new byte[1024];
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                while ((c = this.checkAck(in)) == 67) {
                    int foo;
                    in.read(buf, 0, 5);
                    long filesize = 0L;
                    while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                        filesize = filesize * 10L + (long)(buf[0] - 48);
                    }
                    String file = null;
                    int i = 0;
                    while (true) {
                        in.read(buf, i, 1);
                        if (buf[i] == 10) break;
                        ++i;
                    }
                    file = new String(buf, 0, i);
                    buf[0] = 0;
                    out.write(buf, 0, 1);
                    out.flush();
                    FileOutputStream fos = new FileOutputStream(prefix == null ? localFile : prefix + file);
                    do {
                        foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                        if ((foo = in.read(buf, 0, foo)) < 0) break;
                        fos.write(buf, 0, foo);
                    } while ((filesize -= (long)foo) != 0L);
                    fos.close();
                    if (this.checkAck(in) != 0) {
                        this.cleanup(channel, session);
                        return;
                    }
                    buf[0] = 0;
                    out.write(buf, 0, 1);
                    out.flush();
                }
                break;
            }
            catch (Exception ex) {
                this.processException(channel, session, ex, iterCount, jsch);
                continue;
            }
        }
        this.cleanup(channel, session);
    }

    int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1 && this.m_bLog) {
                OiiolTextLogger.appendText((String)sb.toString());
            }
            if (b == 2 && this.m_bLog) {
                OiiolTextLogger.appendText((String)sb.toString());
            }
        }
        return b;
    }

    private void init() {
        try {
            Paths localPath = SSHSetupUtil.getLocalPath(SystemFactory.s_localPlatId);
            this.commandRetryCount = Integer.parseInt(localPath.getValue("COMMAND_RETRY_COUNT"));
        }
        catch (FatalException fe) {
            this.commandRetryCount = 2;
            OiiolTextLogger.appendException((Throwable)fe);
        }
        catch (NumberFormatException nfe) {
            OiiolTextLogger.appendException((Throwable)nfe);
            this.commandRetryCount = 2;
        }
    }
}

