/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import java.io.File;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.ssh.CopyFile;
import oracle.sysman.prov.ssh.FileLockException;
import oracle.sysman.prov.ssh.RunCommand;
import oracle.sysman.prov.ssh.SSHDirectoryLocker;
import oracle.sysman.prov.ssh.SSHEquivalence;
import oracle.sysman.prov.ssh.SSHSetupException;
import oracle.sysman.prov.ssh.SSHSetupInfo;
import oracle.sysman.prov.ssh.SSHSetupTasks;
import oracle.sysman.prov.ssh.SSHSetupUtil;
import oracle.sysman.prov.ssh.UndoSSHSetupException;

public abstract class BaseSSHSetup
implements SSHEquivalence {
    protected String remoteHome = null;
    protected String localHome = null;
    protected int connectionCount = 0;
    protected String sameUserSameHost = null;
    protected String remoteSSHDir = null;
    protected String remotePubKey = null;
    protected String remotePrivateKey = null;
    protected String remoteScpPath = null;
    protected String identification = null;
    protected String remoteAuthorization = null;
    protected String localAuthorization = null;
    protected String localPubKey = null;
    protected String localPrivateKey = null;
    protected String localScpPath = null;
    protected String localSSHDir = null;
    protected String[] remoteHosts;
    protected SSHSetupInfo info = null;
    protected String authType = null;
    protected Map commandResults = null;
    protected Map commandExceptions = null;
    protected boolean sameUser = false;
    protected Paths localPaths = null;
    protected Paths remotePaths = null;
    protected String localFQDN = null;
    protected String localHost = "";
    protected String localIpAddress = "";
    protected int sshPort = 22;
    private final String PROPERTY_USER_HOME = "user.home";
    Set listofTasks = new HashSet();
    protected SSHDirectoryLocker lock = new SSHDirectoryLocker();
    protected boolean sharedHome = false;
    protected boolean sshDeleteOperation = false;
    ExecutorService executor;
    Map<String, SSHSetupTasks> taskMap;

    public BaseSSHSetup(SSHSetupInfo info) throws SSHSetupException {
        this.info = info;
    }

    @Override
    public void setUpSSH() throws SSHSetupException, ClusterException, FatalException {
        try {
            this.initialize();
            this.validateInstalledSSH();
            this.acquireLockOnDirectory();
            this.setupConnectivity();
            this.establishConnectionAsUser();
            this.reportExceptions();
            this.postSSHTasks();
        }
        catch (Throwable te) {
            throw new SSHSetupException(te);
        }
        finally {
            this.releaseLockOnDirectory();
        }
    }

    protected void createLocalSSHDir() throws ClusterException, FatalException {
        File f = new File(this.localSSHDir);
        if (!f.exists() && !f.mkdirs()) {
            if (!this.sshDeleteOperation) {
                this.createLocalDir(this.localSSHDir);
            } else {
                throw new FatalException("  Local SSH directory '" + this.localSSHDir + "' doesn't exists!! Exiting...");
            }
        }
    }

    public void acquireLockOnDirectory() throws SSHSetupException {
        try {
            this.lock.getLock("", this.localSSHDir);
        }
        catch (Throwable fle) {
            throw new SSHSetupException(fle);
        }
    }

    public void releaseLockOnDirectory() throws SSHSetupException {
        try {
            this.lock.releaseLock(this.localSSHDir);
        }
        catch (FileLockException fle) {
            throw new SSHSetupException((Throwable)((Object)fle));
        }
    }

    public void reportExceptions() throws SSHSetupException, ClusterException, FatalException {
        this.throwException();
    }

    public void setupConnectivity() throws SSHSetupException, ClusterException, FatalException {
        boolean flag = false;
        if (!this.info.isAdvanced()) {
            flag = true;
        }
        if (!flag) {
            this.setupN2NConnectivity();
            this.cleanUp();
        } else {
            this.setUpSSHFromLocal();
        }
        this.changePermissionOnSSH();
    }

    protected abstract void changePermissionOnSSH() throws ClusterException, FatalException;

    protected abstract void establishConnectionAsUser() throws SSHSetupException, ClusterException, FatalException;

    protected abstract void setUpSSHFromLocal() throws SSHSetupException, ClusterException, FatalException;

    protected abstract void setupN2NConnectivity() throws FatalException, ClusterException;

    protected abstract void validateInstalledSSH() throws FatalException, ClusterException, SSHSetupException;

    protected abstract void postSSHTasks() throws FatalException, ClusterException;

    protected void setHome(String home) {
        this.localHome = home.trim();
    }

    protected void initialize() throws SSHSetupException {
        this.initializelibrary();
        try {
            this.localPaths = SSHSetupUtil.getLocalPath(this.info.getLocalPlatId());
            this.remotePaths = SSHSetupUtil.getRemotePath(this.info.getRemotePlatId(), this.info.getLocalPropertiesDir(), this.info.getRemotePropertiesDir());
        }
        catch (FatalException fe) {
            throw new SSHSetupException(fe);
        }
        this.sshPort = SSHSetupUtil.setSSHPortNumber(this.remotePaths);
        this.sameUser = this.info.getUsername().equals(SSHSetupUtil.getSystemUserName());
        this.initMap();
        this.remoteHome = this.findRemoteHomes();
        if (this.info.isSharedHome()) {
            this.sharedHome = SSHSetupUtil.isSharedHome(this.sameUser, this.info.getRemoteHosts(), this.info.getUsername(), this.info.getHome(), this.remotePaths, this.localPaths, this.info.getPassword(), this.sshPort);
        }
        this.connectionCount = this.calculateLoopCount();
        this.sameUserSameHost = this.getSameUserSameHost();
        this.localFQDN = OiixNetOps.getFullHostName();
        this.localHost = OiixNetOps.getMachineName((String)this.localFQDN);
        try {
            this.localIpAddress = OiixNetOps.getIPAddressForHostName((String)this.localHost);
        }
        catch (UnknownHostException uhe) {
            OiiolTextLogger.appendException((Throwable)uhe);
            this.localIpAddress = "";
        }
        try {
            this.createLocalSSHDir();
        }
        catch (ClusterException e) {
            throw new SSHSetupException(e.getMessage());
        }
        catch (FatalException e) {
            throw new SSHSetupException(e.getMessage());
        }
        this.initAuthType();
        this.taskMap = new HashMap<String, SSHSetupTasks>();
        this.executor = Executors.newCachedThreadPool();
    }

    protected void setUserHomeDirectoryPermissionOnLocalNode() throws ClusterException, FatalException {
        String l_command = this.localPaths.getValue("CHMOD_PATH") + " 750 '" + this.info.getHome() + "'";
        OiiolTextLogger.appendText((String)"Changing user home directory permission on local node...\n");
        SSHSetupUtil.runCmdOnLocalNodeHelper(l_command);
    }

    protected void initializelibrary() throws SSHSetupException {
        String lib_loc = System.getProperty("oracle.installer.library_loc");
        if (lib_loc == null) {
            String oui_loc = System.getProperty("oracle.installer.oui_loc");
            if (oui_loc == null) {
                Object[] args = new String[]{"Set oui_loc System Property to <ORACLE_HOME>/oui"};
                throw new SSHSetupException("PROV-16043", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16043", (Object[])args));
            }
            lib_loc = SSHSetupUtil.getNativePath(OiixPathOps.getStandardForm((String)oui_loc), "lib/" + OiixPlatform.getCurrentPlatformDirectoryName());
        }
        System.setProperty("oracle.installer.library_loc", OiixPathOps.getNativeForm((String)lib_loc));
        OiiolTextLogger.appendText((String)("LIBRARY_LOC = " + System.getProperty("oracle.installer.library_loc")));
    }

    protected String findRemoteHomes() throws SSHSetupException {
        RunCommand cmd = this.findRemoteHome();
        return cmd.getOutput().trim();
    }

    protected synchronized int calculateLoopCount() {
        int loopCount;
        String[] remoteHosts = this.info.getRemoteHosts();
        int n = loopCount = this.sharedHome && this.sameUser ? 0 : remoteHosts.length;
        if (!this.sameUser && this.isRemoteHomeShared() && remoteHosts.length > 1) {
            loopCount = 1;
        }
        return loopCount;
    }

    protected String getSameUserSameHost() {
        String sameUserSameHost = "";
        String[] remoteHosts = this.info.getRemoteHosts();
        if (this.sameUser) {
            for (int i = 0; i < remoteHosts.length; ++i) {
                if (remoteHosts[i] == null || !remoteHosts[i].equals(this.localFQDN) && !remoteHosts[i].equals(this.localHost)) continue;
                sameUserSameHost = remoteHosts[i];
                break;
            }
        }
        return sameUserSameHost;
    }

    protected boolean isRemoteHomeShared() {
        String username = this.info.getUsername();
        String password = this.info.getPassword();
        Object[] remoteNodes = this.info.getRemoteHosts();
        if (OiixUtil.isEmpty((Object[])remoteNodes)) {
            OiiolTextLogger.appendText((String)"Remote Nodes is NULL");
            return false;
        }
        if (remoteNodes.length == 1) {
            return true;
        }
        String path = SSHSetupUtil.getNativePath(this.remoteHome, "CFSFileName.tmp");
        path = "\"" + path + "\"";
        RunCommand cmd = new RunCommand((String)remoteNodes[0], username, password, this.sshPort);
        cmd.setSshHome(this.localSSHDir);
        String remotecmd = this.remotePaths.getValue("TOUCH_PATH") + " " + path;
        try {
            cmd.runCommand(remotecmd);
        }
        catch (CommandException cme) {
            SSHSetupUtil.removeRemoteFileHelper((String)remoteNodes[0], username, path, password, this.sshPort, this.remotePaths);
            return false;
        }
        for (int i = 1; i < remoteNodes.length; ++i) {
            cmd = new RunCommand((String)remoteNodes[i], username, password, this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            remotecmd = this.remotePaths.getValue("CAT_PATH") + " " + path;
            try {
                cmd.runCommand(remotecmd);
            }
            catch (CommandException cme) {
                SSHSetupUtil.removeRemoteFileHelper((String)remoteNodes[0], username, path, password, this.sshPort, this.remotePaths);
                return false;
            }
            int exitVal = cmd.getExitCode();
            if (exitVal == 0) continue;
            SSHSetupUtil.removeRemoteFileHelper((String)remoteNodes[0], username, path, password, this.sshPort, this.remotePaths);
            return false;
        }
        return SSHSetupUtil.removeRemoteFileHelper((String)remoteNodes[0], username, path, password, this.sshPort, this.remotePaths);
    }

    protected boolean changeRemoteSSHPermissions(String node, String authorization, String home, String sshDir, RunCommand cmd) {
        if (!this.changeRemoteFilePermission(node, authorization, " 644 ", cmd)) {
            this.debugLog("Failed to change the permission of the file '" + authorization + "' on the host: " + node);
            return false;
        }
        if (!this.changeRemoteFilePermission(node, home, " og-w ", cmd)) {
            this.debugLog("Failed to change the permission of  '" + home + "' on the host: " + node);
            return false;
        }
        if (!this.changeRemoteFilePermission(node, sshDir, " og-w ", cmd)) {
            this.debugLog("Failed to change the permission of  '" + sshDir + "' on the host: " + node);
            return false;
        }
        return true;
    }

    protected void initMap() {
        if (this.commandResults == null) {
            this.commandResults = new ConcurrentHashMap();
        } else {
            this.commandResults.clear();
        }
        if (this.commandExceptions == null) {
            this.commandExceptions = new ConcurrentHashMap();
        } else {
            this.commandExceptions.clear();
        }
    }

    protected void changePermission(String dir, String file, String permission) throws ClusterException, FatalException {
        String string = file = OiixUtil.isNullOrBlank((String)file, (boolean)true) ? dir : SSHSetupUtil.getNativePath(dir, file);
        if (SSHSetupUtil.fileExists(file)) {
            String cmd = this.localPaths.getValue("CHMOD_PATH") + " " + permission + " " + "'" + file + "'";
            SSHSetupUtil.runCmdOnLocalNodeHelper(cmd);
        }
    }

    protected void createLocalDir(String dir) throws ClusterException, FatalException {
        String mkDirCmd = this.localPaths.getValue("MKDIR_PATH") + " " + this.localPaths.getValue("MKDIR_ARGS") + " '" + dir + "'";
        SSHSetupUtil.runCmdOnLocalNodeHelper(mkDirCmd);
    }

    protected boolean backupRemoteConfigFile(String remoteNode, RunCommand cmd, String remoteConfig) {
        String r_command = this.remotePaths.getValue("MV_PATH_2") + " " + this.remotePaths.getValue("MV_ARGS_2") + " " + "\"" + remoteConfig + "\"" + " " + "\"" + remoteConfig + ".ri.bak" + "\"";
        return this.runCommandHelper(remoteNode, r_command, cmd);
    }

    protected boolean remoteFileCopy(String remoteNode, RunCommand cmd, String src, String dest) {
        String r_command = this.remotePaths.getValue("CP_PATH_2") + " " + this.remotePaths.getValue("CP_ARGS_2") + " " + "\"" + src + "\"" + " " + "\"" + dest + "\"";
        return this.runCommandHelper(remoteNode, r_command, cmd);
    }

    protected boolean removeFile2(String remoteNode, RunCommand cmd, String file, boolean addQuote) {
        String rmCmd2 = this.remotePaths.getValue("RM_PATH_2") + " " + this.remotePaths.getValue("RM_ARGS_2") + " " + (addQuote ? "\"" + file + "\"" : file);
        return this.runCommandHelper(remoteNode, rmCmd2, cmd);
    }

    protected boolean changeRemoteFilePermission(String node, String file, String permission, RunCommand cmd) {
        String r_command = this.remotePaths.getValue("CHMOD_PATH") + " " + permission + " " + "\"" + file + "\"";
        return this.runCommandHelper(node, r_command, cmd);
    }

    protected boolean r_catCmd(String remoteHost, RunCommand cmd, String file) {
        String r_command = this.remotePaths.getValue("CAT_PATH") + " " + file;
        return this.runCommandHelper(remoteHost, r_command, cmd);
    }

    protected boolean r_shellCmd(String remoteNode, RunCommand cmd, String src, String dest) {
        String r_command = this.remotePaths.getValue("SHELL_PATH") + " " + this.remotePaths.getValue("SHELL_ARGS") + " " + "\"" + "echo " + src + " >> " + dest + "\"";
        return this.runCommandHelper(remoteNode, r_command, cmd);
    }

    protected boolean runCommandHelper(String remoteNode, String command, RunCommand cmd) {
        try {
            cmd.runCommand(command);
            this.debugLog("Command executed: " + command + ". Output of the command: " + cmd.getOutput() + ". ### Status of command execution is successful on '" + remoteNode + "'");
        }
        catch (CommandException ce) {
            if (this.commandResults.get(remoteNode) == null) {
                this.commandResults.put(remoteNode, command);
            }
            if (this.commandExceptions.get(remoteNode) == null) {
                this.commandExceptions.put(remoteNode, ce);
            }
            OiiolTextLogger.appendErrorText((String)("Execution of the command : " + command + " failed on '" + remoteNode + "'"), (int)OiiolTextLogger.LOG_BASIC);
            return false;
        }
        return true;
    }

    protected boolean createRemoteDir(String remoteNode, RunCommand cmd, String remoteDir) {
        String mkDirCmd = this.remotePaths.getValue("MKDIR_PATH") + " " + this.remotePaths.getValue("MKDIR_ARGS") + " " + "\"" + remoteDir + "\"";
        return this.runCommandHelper(remoteNode, mkDirCmd, cmd);
    }

    protected void processSSHException(Exception e, String note, boolean addException, String sshDir) throws SSHSetupException {
        OiiolTextLogger.appendException((Throwable)e);
        this.commandResults.put("LocalHost", note);
        this.commandExceptions.put("LocalHost", new CommandException("LocalHost", e.getMessage(), (Throwable)(addException ? e : null)));
        throw new SSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
    }

    protected void throwException() throws SSHSetupException {
        if (this.commandResults.size() >= 1) {
            throw new SSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
        }
    }

    protected void throwExceptionForUndo() throws UndoSSHSetupException {
        if (this.commandResults.size() >= 1) {
            throw new UndoSSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
        }
    }

    protected void openSSHKeyGen(String scratchFile, String scratchFile2) throws ClusterException, FatalException {
        String l_command = this.localPaths.getValue("SSH_KEYGEN_PATH") + " " + this.localPaths.getValue("SSH_KEYGEN_CONVERT_TO_OPENSSH_ARGS") + " " + this.localPaths.getValue("SSH_KEYGEN_ARGS_KEYFILE") + " " + scratchFile + " > " + scratchFile2;
        SSHSetupUtil.runCmdOnLocalNodeHelper(l_command);
    }

    protected boolean scptoHelper(String src, String dest, CopyFile copyCmd, String remoteNode) {
        try {
            this.debugLog("Copying the file " + src + " to the node: " + remoteNode);
            copyCmd.scpTo(src, dest);
            this.debugLog("Copied the file " + src + " to the node: " + remoteNode + " to the location: " + dest);
        }
        catch (CommandException ce) {
            if (this.commandResults.get(remoteNode) == null) {
                this.commandResults.put(remoteNode, "SCP_TO");
            }
            if (this.commandExceptions.get(remoteNode) == null) {
                this.commandExceptions.put(remoteNode, ce);
            }
            OiiolTextLogger.appendErrorText((String)("Copying of the file " + src + " to the node :" + remoteNode + " failed"), (int)OiiolTextLogger.LOG_BASIC);
            return false;
        }
        return true;
    }

    protected boolean scpfromHelper(String src, String dest, CopyFile copyCmd, String remoteNode) {
        try {
            this.debugLog("Copying the file " + src + " from the node: " + remoteNode);
            copyCmd.scpFrom(src, dest);
            this.debugLog("Copied the file " + src + " from the node: " + remoteNode + " to the location: " + dest);
        }
        catch (CommandException ce) {
            if (this.commandResults.get(remoteNode) == null) {
                this.commandResults.put(remoteNode, "SCP_TO");
            }
            if (this.commandExceptions.get(remoteNode) == null) {
                this.commandExceptions.put(remoteNode, ce);
            }
            OiiolTextLogger.appendErrorText((String)("Copying of the file " + src + " from the node :" + remoteNode + " failed"), (int)OiiolTextLogger.LOG_BASIC);
            return false;
        }
        return true;
    }

    protected String[] getNodesToIterate() {
        if (this.info.reuseKey()) {
            return this.info.getNewNodes();
        }
        return this.info.getRemoteHosts();
    }

    protected void calculateNewLoopCount_AddNewNodes() {
        String[] newNodes;
        if (this.info.reuseKey() && this.connectionCount > 1 && null != (newNodes = this.info.getNewNodes())) {
            this.connectionCount = newNodes.length;
        }
    }

    protected boolean executeTasks() {
        try {
            this.executor.invokeAll(this.listofTasks);
            return true;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            OiiolTextLogger.appendErrorText((String)("Exception occurred while command execution :" + e.getMessage()), (int)OiiolTextLogger.LOG_BASIC);
            return false;
        }
    }

    void cleanUp() {
        this.taskMap.clear();
        this.taskMap = null;
        this.shutDownThreadPool();
    }

    private RunCommand findRemoteHome() throws SSHSetupException {
        String[] remoteHosts = this.info.getRemoteHosts();
        RunCommand cmd = null;
        String command = "echo $HOME";
        String homeDir = "";
        String prevHomeDir = "";
        for (int i = 0; i < remoteHosts.length; ++i) {
            cmd = new RunCommand(remoteHosts[i], this.info.getUsername(), this.info.getPassword(), this.sshPort);
            cmd.setSshHome(this.localSSHDir);
            if (cmd != null && this.runCommandHelper(remoteHosts[i], command, cmd)) {
                homeDir = cmd.getOutput().trim();
            }
            if (!(homeDir == null || prevHomeDir == null || homeDir.equals("") || prevHomeDir.equals("") || homeDir.equals(prevHomeDir))) {
                throw new SSHSetupException("User home directories are not consistent  among the remote nodes: " + remoteHosts[i] + " and " + remoteHosts[i - 1] + ".Please make it consistent");
            }
            prevHomeDir = homeDir;
        }
        if (this.commandExceptions.keySet().size() != 0) {
            throw new SSHSetupException("Error while finding the remote home directories. Please verify the username,password,permission of the user and the hostname(s).\nCheck the SSH setup logfile for details.");
        }
        return cmd;
    }

    private void shutDownThreadPool() {
        if (null != this.executor) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private void initAuthType() {
        this.authType = System.getProperty("oracle.sysman.prov.ssh.ssh_auth_algo");
        if (this.authType == null || this.authType.equals("") || !"RSA".equals(this.authType) && !"DSA".equals(this.authType)) {
            this.authType = "RSA";
        }
    }

    private void debugLog(String message) {
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
            OiiolTextLogger.appendText((String)message, (int)OiiolTextLogger.LOG_GENERAL);
        }
    }
}

