/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.asm.operation.ha.ASMOperationImpl;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class ASMModifyDepOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    private String m_asmInstanceResource;
    private boolean m_bModify;

    public ASMModifyDepOperation(String dbInstanceResource, String asmInstanceResource, boolean bModify, Version version) throws HAOperationException {
        super("crs_profile", dbInstanceResource, version);
        this.m_asmInstanceResource = asmInstanceResource;
        this.m_bModify = bModify;
    }

    public String getASMInstanceResource() {
        return this.m_asmInstanceResource;
    }

    public boolean getModify() {
        return this.m_bModify;
    }

    public OperationResult run() {
        Trace.out((String)("HAModifyDepOperation.run Instance resource" + this.m_resourceName));
        Trace.out((String)("HAModifyDepOperation.run ASM resource" + this.m_asmInstanceResource));
        HAOperationResult result = ASMOperationImpl.modify(this);
        Trace.out((String)"Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out((String)("OUTPUT> " + output[i]));
            }
        } else {
            Trace.out((String)"No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out((String)("ERROR> " + error));
        } else {
            Trace.out((String)"No error from the HA Operation");
        }
        return result;
    }
}

