/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.io.Serializable;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.ASMTree;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class RemoveASMInstancesOnNodeOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -8079111542450212257L;
    private String m_node;

    public RemoveASMInstancesOnNodeOperation(String node, Version version) {
        super(true, version);
        this.m_node = node;
    }

    public String getNode() {
        return this.m_node;
    }

    public OperationResult run() {
        ASMConfigurationResult result;
        try {
            ASMTree asmTree = ASMTree.init(this.getVersion());
            asmTree.removeAllInstancesConfiguration(this.m_node);
            result = new ASMConfigurationResult(0);
        }
        catch (ASMConfigurationException e) {
            result = new ASMConfigurationResult(1, (Exception)((Object)e));
        }
        Trace.out((String)("result status " + result.getStatus()));
        return result;
    }
}

