/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.io.Serializable;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.ASMTree;
import oracle.ops.mgmt.asm.operation.RemoveASMInstancesOnNodeOperation;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class RemoveASMInstanceConfigOperation
extends RemoveASMInstancesOnNodeOperation
implements Serializable {
    static final long serialVersionUID = -8079111542450212257L;
    private String m_instance;

    public RemoveASMInstanceConfigOperation(String instance, String node, Version version) {
        super(node, version);
        this.m_instance = instance;
    }

    public String getInstance() {
        return this.m_instance;
    }

    @Override
    public OperationResult run() {
        ASMConfigurationResult result;
        try {
            ASMTree asmTree = ASMTree.init(this.getVersion());
            asmTree.removeASMInstanceConfiguration(this.m_instance, this.getNode());
            result = new ASMConfigurationResult(0);
        }
        catch (ASMConfigurationException e) {
            result = new ASMConfigurationResult(1, (Exception)((Object)e));
        }
        Trace.out((String)("result status " + result.getStatus()));
        return result;
    }
}

