/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.io.Serializable;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.ASMTree;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class GetASMInstanceNodeListOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -7298492198926649893L;
    private String m_instance;

    public GetASMInstanceNodeListOperation(String instance, Version version) {
        super(true, version);
        this.m_instance = instance;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public OperationResult run() {
        ASMConfigurationResult result;
        try {
            ASMTree asmTree = ASMTree.init(this.getVersion());
            String[] nodes = asmTree.getASMInstanceNodes(this.m_instance);
            Trace.out((String)("Got nodes=" + nodes));
            result = new ASMConfigurationResult(0);
            result.setResult(nodes);
        }
        catch (ASMConfigurationException e) {
            result = new ASMConfigurationResult(1, (Exception)((Object)e));
        }
        Trace.out((String)("result status " + result.getStatus()));
        return result;
    }
}

