/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.io.Serializable;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.ASMTree;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class ASMInstanceSPFileOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -7298492198926649893L;
    private String m_instance;
    private String m_node;
    private String m_spfile;

    public ASMInstanceSPFileOperation(String instance, String node, String spfile, Version version) {
        super(true, version);
        this.m_instance = instance;
        this.m_node = node;
        this.m_spfile = spfile;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public String getNode() {
        return this.m_node;
    }

    public String getSPFile() {
        return this.m_spfile;
    }

    public OperationResult run() {
        ASMConfigurationResult result;
        try {
            ASMTree asmTree = ASMTree.init(this.getVersion());
            asmTree.setASMInstanceSPFile(this.m_instance, this.m_node, this.m_spfile);
            result = new ASMConfigurationResult(0);
        }
        catch (ASMConfigurationException e) {
            result = new ASMConfigurationResult(1, (Exception)((Object)e));
        }
        Trace.out((String)("result status " + result.getStatus()));
        return result;
    }
}

