/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.io.Serializable;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.operation.ASMConfigurationResult;
import oracle.ops.mgmt.asm.operation.ASMTree;
import oracle.ops.mgmt.asm.operation.GetASMInstanceConfigOperation;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class ASMInstanceExistOperation
extends GetASMInstanceConfigOperation
implements Serializable {
    public ASMInstanceExistOperation(String instance, String node, Version version) {
        super(instance, node, version);
    }

    @Override
    public OperationResult run() {
        ASMConfigurationResult result;
        try {
            ASMTree asmTree = ASMTree.init(this.getVersion());
            Boolean bExists = asmTree.isASMInstanceExists(this.getInstance(), this.getNode());
            Trace.out((String)("Existence for ASM instance = " + bExists));
            result = new ASMConfigurationResult(0);
            result.setResult(bExists);
        }
        catch (ASMConfigurationException e) {
            result = new ASMConfigurationResult(1, (Exception)((Object)e));
        }
        Trace.out((String)("result status " + result.getStatus()));
        return result;
    }
}

