/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.asm.operation;

import java.util.Enumeration;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;
import oracle.ops.mgmt.trace.Trace;

class ASMInstanceConfiguration
implements OCRKeyLiterals {
    public static final int ASM_CONFIG_MEMBER_COUNT = 8;
    private String m_instance;
    private String m_node;
    private String m_oracleHome;
    private String m_startOpt;
    private String m_spfile;
    private boolean m_bEnabled;
    private Version m_version;
    private String[] m_env;
    private static Vector s_memberList = new Vector(8);

    public ASMInstanceConfiguration(String instance, String node, String ohome, String spfile, String startOpt, boolean bEnabled, Version version, String[] env) {
        this.m_instance = instance;
        this.m_node = node;
        this.m_oracleHome = ohome;
        this.m_spfile = spfile;
        this.m_startOpt = startOpt;
        this.m_bEnabled = bEnabled;
        this.m_version = version;
        this.m_env = env;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public void setInstance(String instance) {
        this.m_instance = instance;
    }

    public String getNode() {
        return this.m_node;
    }

    public void setNode(String node) {
        this.m_node = node;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public void setOracleHome(String oracleHome) {
        this.m_oracleHome = oracleHome;
    }

    public String[] getEnv() {
        return this.m_env;
    }

    public void setEnv(String[] env) {
        this.m_env = env;
    }

    public String getStartOption() {
        return this.m_startOpt;
    }

    public void setStartOption(String startOpt) {
        this.m_startOpt = startOpt;
    }

    public String getSPFile() {
        return this.m_spfile;
    }

    public void setSPFile(String spfile) {
        this.m_spfile = spfile;
    }

    public void setEnabled(boolean bEnabled) {
        this.m_bEnabled = bEnabled;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public void setVersion(Version version) {
        this.m_version = version;
    }

    public static Enumeration getMemberEnum() {
        return s_memberList.elements();
    }

    public static Enumeration getSubKeyEnum() {
        Vector<String> vSubKeys = new Vector<String>(s_memberList.size() - 2);
        Enumeration e = s_memberList.elements();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equalsIgnoreCase("INSTANCE") || key.equalsIgnoreCase("NODE")) continue;
            vSubKeys.addElement(key);
        }
        return vSubKeys.elements();
    }

    public Object getValue(String member) {
        if (member.equalsIgnoreCase("INSTANCE")) {
            return this.m_instance;
        }
        if (member.equalsIgnoreCase("NODE")) {
            return this.m_node;
        }
        if (member.equalsIgnoreCase("ORACLE_HOME")) {
            return this.m_oracleHome;
        }
        if (member.equalsIgnoreCase("SPFILE")) {
            return this.m_spfile;
        }
        if (member.equalsIgnoreCase("START_OPTIONS")) {
            return this.m_startOpt;
        }
        if (member.equalsIgnoreCase("ENABLED")) {
            return new Boolean(this.m_bEnabled);
        }
        if (member.equalsIgnoreCase("VERSION")) {
            return this.m_version;
        }
        if (member.equalsIgnoreCase("ENVIRONMENT")) {
            return this.m_env;
        }
        Trace.out((String)("getValue: Unknown ASM instance configuration member:" + member));
        return null;
    }

    public void setValue(String member, Object value) {
        if (member.equalsIgnoreCase("INSTANCE")) {
            this.setInstance((String)value);
        } else if (member.equalsIgnoreCase("NODE")) {
            this.setNode((String)value);
        } else if (member.equalsIgnoreCase("ORACLE_HOME")) {
            this.setOracleHome((String)value);
        } else if (member.equalsIgnoreCase("SPFILE")) {
            this.setSPFile((String)value);
        } else if (member.equalsIgnoreCase("START_OPTIONS")) {
            this.setStartOption((String)value);
        } else if (member.equalsIgnoreCase("ENABLED")) {
            this.setEnabled((Boolean)value);
        } else if (member.equalsIgnoreCase("VERSION")) {
            this.setVersion((Version)value);
        } else if (member.equalsIgnoreCase("ENVIRONMENT")) {
            this.setEnv((String[])value);
        }
    }

    public void print() {
        if (Trace.isLevelEnabled((int)5)) {
            Enumeration e = ASMInstanceConfiguration.getMemberEnum();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object value = this.getValue(name);
                if (value instanceof String[]) {
                    String[] env = (String[])value;
                    if (env == null) {
                        Trace.out((String)(name + "=" + env));
                        continue;
                    }
                    for (int i = 0; i < env.length; ++i) {
                        Trace.out((String)(name + "[" + i + "]=" + env[i]));
                    }
                    continue;
                }
                Trace.out((String)(name + "=" + value));
            }
        }
    }

    static {
        s_memberList.addElement("INSTANCE".toLowerCase());
        s_memberList.addElement("NODE".toLowerCase());
        s_memberList.addElement("ORACLE_HOME");
        s_memberList.addElement("START_OPTIONS");
        s_memberList.addElement("SPFILE");
        s_memberList.addElement("ENABLED");
        s_memberList.addElement("VERSION");
        s_memberList.addElement("ENVIRONMENT");
    }
}

