/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ClusterASM;
import oracle.cluster.asm.IOServer;
import oracle.cluster.asm.IOServerInstance;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.BaseASMImpl;
import oracle.cluster.impl.asm.IOServerInstanceImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.ListenerImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class IOServerImpl
extends BaseASMImpl
implements IOServer {
    static final String CRS_2653_MSG = "CRS-2653";

    IOServerImpl(ResourceAttribute nameAttr) throws ASMException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.IOServer.NAME.name())) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.IOServer.NAME.name(), nameAttr.getName());
        }
        String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        Trace.out((String)("values.length is " + values.length + ", values[0]=" + values[0] + ", values[1]=" + values[1]));
        if (values.length != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.IOSERVER.toString().equalsIgnoreCase(values[1])) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.IOServer.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = values[1];
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException notExistsException) {
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    void create(String spfile, int count, Version version) throws AlreadyExistsException, ASMException {
        this.create(spfile, count, null, version);
    }

    void create(int count, Listener lsnr, Version version) throws AlreadyExistsException, ASMException {
        this.create(null, count, lsnr, version);
    }

    void create(String spfile, int count, Listener lsnr, Version version) throws AlreadyExistsException, ASMException {
        Trace.out((String)"Create IOServer");
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute asmTypeAttr = crsFactory.create(ResourceType.IOServer.NAME.name(), ResourceType.IOServer.NAME.toString());
            List attrList = crsFactory.getResourceTypeEntity(asmTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile((List)attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(asmTypeAttr.getName())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.IOServer.CARDINALITY.name())) {
                    if (count == -1) {
                        attr.setValue("%CRS_HUB_SIZE%");
                    } else if (count != 3) {
                        attr.setValue(String.valueOf(count));
                        continue;
                    }
                }
                if (spfile != null && attr.getName().equalsIgnoreCase(ResourceType.IOServer.SPFILE.name())) {
                    attr.setValue(spfile);
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.IOServer.USR_ORA_INST_NAME.name())) {
                    boolean n0Exists = false;
                    n0Exists = new ClusterUtil().isNodeNum0Exists();
                    if (n0Exists) {
                        attr.setValue(ResourceType.IOServer.defaultInstNameNode0Exist());
                    }
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.IOServer.ACTIONS.name())) continue;
                Trace.out((String)("Creating ACTIONS attribute for IOServer using template: " + attr.getValue()));
                CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                String actionAttrValue = cf.createActionsAttr(this.m_name, null, attr.getValue());
                attr.setValue(actionAttrValue);
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            ClusterASM clusterasm = ASMFactoryImpl.getInstance().getClusterASM();
            ResourceAttribute asmAttr = crsFactory.create(ResourceType.ClusterASM.NAME.name(), clusterasm.getName());
            ResourceDependency hardStartDep1 = crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            ResourceDependency weakDep1 = crsFactory.createResourceDependency(crsFactory.create(ResourceType.Listener.NAME.name(), lsnr != null ? lsnr.getName() : ListenerImpl.getResourceName((String)ResourceLiterals.LISTENER.name())), ResourceDependency.DepType.WEAK_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency pullupDep = crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            ResourceDependency attractionDep = crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.ATTRACTION_DEP, new ResourceDependency.DepModifier[0]);
            ResourceAttribute startDepAttr = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{hardStartDep1, weakDep1, pullupDep, attractionDep}));
            ResourceDependency hardStopDep = crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP});
            ResourceDependency shutdownDep = crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.SHUTDOWN_MODIFIER_DEP});
            ResourceAttribute stopDepAttr = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{hardStopDep, shutdownDep}));
            List listeners = null;
            try {
                listeners = NodeAppsFactory.getInstance().getASMListeners();
                for (Listener listener : listeners) {
                    ResourceAttribute resAttr = crsFactory.create(ResourceType.Listener.NAME.name(), listener.getName());
                    ResourceDependency.updateDependencyAttr((ResourceAttribute)startDepAttr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (boolean)true);
                    ResourceDependency.updateDependencyAttr((ResourceAttribute)startDepAttr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)true);
                    ResourceDependency.updateDependencyAttr((ResourceAttribute)stopDepAttr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier)ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP, (boolean)true);
                }
            }
            catch (NotExistsException e) {
                Trace.out((String)"There is no asm listener registered. Not an error");
            }
            attrList.add(startDepAttr);
            attrList.add(stopDepAttr);
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
            if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions((ResourcePermissions)perm);
            }
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.IOSERVER_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
        catch (NotExistsException e) {
            throw new ASMException((MessageKey)PrCaMsgID.IOSERVER_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
        catch (SoftwareModuleException e) {
            throw new ASMException((MessageKey)PrCaMsgID.IOSERVER_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
        catch (ClusterUtilException e) {
            throw new ASMException((MessageKey)PrCaMsgID.IOSERVER_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
    }

    @Override
    public void start(List<Node> nodes, List<StartOptions> startupOptions) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        if (nodes == null || nodes.size() == 0) {
            super.start();
            return;
        }
        if (startupOptions == null || startupOptions.size() == 0) {
            this.start(nodes);
            return;
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StartOptions[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_OPEN_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.start(nodes, options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_STOP_MODE.name(), StopOptions.ABORT.toString())};
                this.m_crsResource.stop(true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(false);
        }
    }

    @Override
    public void stop(List<Node> nodeList, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"nodeList"});
        }
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_STOP_MODE.name(), StopOptions.ABORT.toString())};
                this.m_crsResource.stop(nodeList, true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(nodeList, false);
        }
    }

    @Override
    public void stop(List<Node> nodeList, List<StopOptions> stopOptions, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null || nodeList.size() == 0) {
            this.stop(force);
            return;
        }
        if (stopOptions == null || stopOptions.size() == 0) {
            this.stop(nodeList, force);
            return;
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StopOptions[] soarr = stopOptions.toArray(new StopOptions[stopOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_STOP_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.stop(nodeList, force, options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    @Override
    public void stop(ArrayList<StopOptions> stopOptions, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (stopOptions == null || stopOptions.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"stopOptions", stopOptions});
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StopOptions[] soarr = stopOptions.toArray(new StopOptions[stopOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_STOP_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.stop(force, options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    @Override
    public String getSPFile() throws ASMException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.Database.SPFILE.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_SPFILE_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void setSPFile(String spfile) throws ASMException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.SPFILE.name(), spfile));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_SPFILE_FAILED, e, spfile, this.getUserAssignedName());
        }
    }

    @Override
    public int getCount() throws ASMException {
        int count = -1;
        try {
            Trace.out((String)("m_crsResource = " + this.m_crsResource));
            String countStr = this.m_crsResource.getAttribute(ResourceType.IOServer.CARDINALITY.name()).getValue();
            if (!countStr.equals("%CRS_HUB_SIZE%")) {
                count = Integer.valueOf(countStr);
            }
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        return count;
    }

    @Override
    public void setCount(int count) throws ASMException {
        this.setCount(count, false);
    }

    @Override
    public void setCount(int count, boolean forceFlag) throws ASMException {
        if (count < 1 && count != -1) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "count", count);
        }
        try {
            String countStr = "%CRS_HUB_SIZE%";
            if (count != -1) {
                countStr = String.valueOf(count);
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.IOServer.CARDINALITY.name(), countStr), forceFlag);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    @Override
    public void setListener(Listener listener) throws ASMException {
        this.setListener(listener, false);
    }

    @Override
    public void setListener(Listener listener, boolean forceFlag) throws ASMException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            Listener lsnr = this.listener();
            Trace.out((String)("current value=" + attr.getValue()));
            attr.setValue(attr.getValue().replaceAll(lsnr.getName(), listener.getName()));
            Trace.out((String)("new value=" + attr.getValue()));
            this.m_crsResource.update(attr, forceFlag);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    @Override
    public List<IOServerInstance> instances() throws AlreadyStoppedException, ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.IOServer.NAME.toString());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, FilterFactoryImpl.getFilter4RunningResource((CRSResource)this.m_crsResource, null));
            List<IOServerInstance> iosInstList = this.getInstances(finalFilter);
            if (iosInstList.size() == 0) {
                throw new AlreadyStoppedException((MessageKey)PrCaMsgID.NO_RUNNING_IOSINSTANCE, new Object[]{this.getUserAssignedName()});
            }
            return iosInstList;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_IOSINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public List<IOServerInstance> allInstances() throws ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.IOServer.NAME.toString());
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.IOServer.NAME.name(), this.getName());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, nameFilter);
            return this.getInstances(finalFilter);
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_IOSINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    private List<IOServerInstance> getInstances(Filter filter) throws ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String nodeAttr = ResourceLiterals.CRS_LAST_SERVER.toString();
            String instAttr = ResourceType.IOServer.USR_ORA_INST_NAME.name();
            String stateAttr = ResourceLiterals.STATE_ATTR_NAME.toString();
            Map resultData = null;
            try {
                resultData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, true, filter, new String[]{nodeAttr, instAttr, stateAttr});
            }
            catch (CRSException e) {
                Trace.out((String)("Got exception with evalFlag = true (not an error): " + e.getMessage()));
                Trace.out((String)"Query CRS again with evalFlag = false");
                resultData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, false, filter, new String[]{nodeAttr, instAttr, stateAttr});
            }
            ServerFactoryImpl sfImpl = ServerFactoryImpl.getInstance();
            LinkedList<IOServerInstance> iosInstList = new LinkedList<IOServerInstance>();
            for (String riID : resultData.keySet()) {
                Map result = (Map)resultData.get(riID);
                String instName = (String)result.get(instAttr);
                String nodeName = (String)result.get(nodeAttr);
                String state = (String)result.get(stateAttr);
                if (instName != null && instName.contains(ResourceLiterals.CRS_CSS_NODENUMBER.toString())) {
                    Filter idFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.ID.name(), riID);
                    try {
                        Map resultDataDetail = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, true, idFilter, new String[]{nodeAttr, instAttr, stateAttr});
                        result = (Map)resultDataDetail.get(riID);
                        instName = (String)result.get(instAttr);
                        nodeName = (String)result.get(nodeAttr);
                        state = (String)result.get(stateAttr);
                    }
                    catch (CRSException e) {
                        if (e.getMessage().contains(CRS_2653_MSG)) {
                            Trace.out((String)("Not an error. Instance name is not assigned to instance " + riID));
                        }
                        throw e;
                    }
                }
                Trace.out((String)("Instance id = " + riID + ", state = " + state));
                iosInstList.add(new IOServerInstanceImpl(this, riID, instName, sfImpl.getNode(nodeName, false), state));
            }
            return iosInstList;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_IOSINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_IOSINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_IOSINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    public static String getResourceName() {
        return ResourceLiterals.IOSERVER_RES_NAME.toString();
    }
}

