/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.asm.ClusterASM;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.UpgradePhase;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.ASMImpl;
import oracle.cluster.impl.asm.ASMInstanceImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.ListenerImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.OCRInfo;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class ClusterASMImpl
extends ASMImpl
implements ClusterASM {
    ClusterASMImpl(ResourceAttribute nameAttr) throws ASMException {
        super(nameAttr);
        String attVal = nameAttr.getValue();
        if (!attVal.equals(ClusterASMImpl.getResourceName())) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ClusterASM.NAME.name(), ClusterASMImpl.getResourceName(), attVal);
        }
    }

    @Override
    void create(Version version) throws AlreadyExistsException, ASMException {
        this.create(null, 3, version);
    }

    void create(String pwfile, int count, Version version) throws AlreadyExistsException, ASMException {
        this.create(pwfile, count, null, version);
    }

    void create(String pwfile, int count, String serverCategory, Version version) throws AlreadyExistsException, ASMException {
        Trace.out((String)("Create helper for Cluster ASM, Cardinality=" + count));
        try {
            String[] ocrLocationPaths;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute asmTypeAttr = crsFactory.create(ResourceLiterals.NAME.name(), ResourceLiterals.ASM_CLUSTER_TYPE.toString());
            if (crsFactory.isRegistered(ResourceLiterals.ASM_RES_NAME.toString(), CRSEntity.Type.Resource)) {
                Trace.out((String)"Forcing AlreadyExistsException for ora.asm...");
                throw new AlreadyExistsException((MessageKey)PrCaMsgID.ASM_ALREADY_EXISTS, new Object[0]);
            }
            ClusterASMImpl.deleteASMType();
            ClusterASMImpl.createASMType(false);
            List attrList = crsFactory.getResourceTypeEntity(asmTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile((List)attrList);
            for (ResourceAttribute attr : attrList) {
                Trace.out((String)("Profile:" + attr.getName() + "=" + attr.getValue()));
                if (attr.getName().equalsIgnoreCase(asmTypeAttr.getName())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    Trace.out((String)("SETTING:" + attr.getName() + "=" + attr.getValue()));
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceLiterals.TYPE.name())) {
                    attr.setValue(ResourceLiterals.ASM_TYPE.toString());
                    Trace.out((String)("SETTING:" + attr.getName() + "=" + attr.getValue()));
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ClusterASM.PWFILE.name()) && pwfile != null) {
                    attr.setValue(pwfile);
                    Trace.out((String)("SETTING:" + attr.getName() + "=" + attr.getValue()));
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ClusterASM.CARDINALITY.name())) {
                    if (count == -1) {
                        attr.setValue("%CRS_HUB_SIZE%");
                    } else {
                        attr.setValue(String.valueOf(count));
                    }
                    Trace.out((String)("SETTING:" + attr.getName() + "=" + attr.getValue()));
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ClusterASM.SERVER_CATEGORY.name()) && serverCategory != null) {
                    attr.setValue(serverCategory);
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ClusterASM.INSTANCE_FAILOVER.name()) && count == -1) {
                    attr.setValue(ResourceLiterals.DISABLED_VALUE.toString());
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ClusterASM.ACTIONS.name())) {
                    Trace.out((String)("Creating ACTIONS attribute for ASM using template: " + attr.getValue()));
                    CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                    String actionAttrValue = cf.createActionsAttr(this.m_name, null, attr.getValue());
                    attr.setValue(actionAttrValue);
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.ClusterASM.ALIAS_NAME.name())) continue;
                if (count != -1) {
                    attr.setValue("");
                    continue;
                }
                boolean n0Exists = false;
                try {
                    n0Exists = new ClusterUtil().isNodeNum0Exists();
                    Trace.out((String)("n0Exists = " + n0Exists));
                }
                catch (ClusterUtilException ce) {
                    throw new CRSException((MessageKey)PrCrMsgID.NODE_NUM0_CHECK_FAILED, (Throwable)ce, new Object[0]);
                }
                if (n0Exists) {
                    attr.setValue(ResourceType.LocalASM.defaultValNode0Exist((String)ResourceType.LocalASM.ALIAS_NAME.name()));
                    continue;
                }
                attr.setValue(ResourceType.ClusterASM.ALIAS_NAME.toString());
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            ResourceDependency weakDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.Listener.NAME.name(), ListenerImpl.getResourceName((String)ResourceLiterals.LISTENER.name())), ResourceDependency.DepType.WEAK_DEP, new ResourceDependency.DepModifier[0]);
            ResourceAttribute startDepAttr = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{weakDep}));
            ResourceAttribute stopDepAttr = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), "");
            List listeners = null;
            try {
                listeners = NodeAppsFactory.getInstance().getASMListeners();
                for (Listener listener : listeners) {
                    ResourceAttribute resAttr = crsFactory.create(ResourceType.Listener.NAME.name(), listener.getName());
                    ResourceDependency.updateDependencyAttr((ResourceAttribute)startDepAttr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.PULLUP_DEP, (boolean)true);
                    ResourceDependency.updateDependencyAttr((ResourceAttribute)startDepAttr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (boolean)true);
                    ResourceDependency.updateDependencyAttr((ResourceAttribute)stopDepAttr, (ResourceAttribute)resAttr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP, (ResourceDependency.DepModifier)ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP, (boolean)true);
                }
            }
            catch (NotExistsException e) {
                Trace.out((String)"There is no asm listener registered. Not an error");
            }
            if (ASMFactoryImpl.getUpgradePhase() != UpgradePhase.FIRST) {
                ResourceAttribute asmSiteTypeAttr = crsFactory.create(ResourceLiterals.NAME.name(), ResourceLiterals.ASM_TYPE.toString());
                ResourceDependency.updateDependencyAttrModifier((boolean)true, (ResourceAttribute)startDepAttr, (ResourceAttribute)asmSiteTypeAttr, (ResourceDependency.DepType)ResourceDependency.DepType.DISPERSION_ACTIVE_DEP, (ResourceDependency.DepModifier[])new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.SITE_MODIFIER_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP});
            }
            attrList.add(startDepAttr);
            attrList.add(stopDepAttr);
            boolean isOCRonASM = false;
            try {
                OCRInfo ocrInfo = ClusterInfo.getOCRLocations((Version)new Version());
                ocrLocationPaths = ocrInfo.getPaths();
            }
            catch (ClusterInfoException cie) {
                throw new ASMException((MessageKey)PrCaMsgID.CLUSTERASM_OCRONASM_CHECK_FAIL, cie, this.getUserAssignedName(), this.m_nameAttr.getValue());
            }
            NativeSystem system = new SystemFactory().CreateSystem();
            for (int i = 0; i < ocrLocationPaths.length; ++i) {
                Trace.out((String)("ocrLocationPaths[" + i + "]=" + ocrLocationPaths[i]));
                if (!system.isPathOnASM(ocrLocationPaths[i])) continue;
                Trace.out((String)("ocrLocationPaths[" + i + "] is on ASM"));
                isOCRonASM = true;
                break;
            }
            if (isOCRonASM) {
                attrList.add(crsFactory.create(ResourceType.LocalResource.AUTO_START.name(), CRSResource.AutoStart.ALWAYS.toString()));
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
            if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions((ResourcePermissions)perm);
            }
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.CLUSTERASM_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
        catch (SoftwareModuleException e) {
            throw new ASMException((MessageKey)PrCaMsgID.CLUSTERASM_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
    }

    @Override
    public int getCount() throws ASMException {
        int count = -1;
        try {
            Trace.out((String)("m_crsResource = " + this.m_crsResource));
            String countStr = this.m_crsResource.getAttribute(ResourceType.IOServer.CARDINALITY.name()).getValue();
            if (!countStr.equals("%CRS_HUB_SIZE%")) {
                count = Integer.valueOf(countStr);
            }
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        return count;
    }

    @Override
    public void setCount(int count) throws ASMException {
        this.setCount(count, false);
    }

    @Override
    public void setCount(int count, boolean forceFlag) throws ASMException {
        if (count <= 1 && count != -1) {
            throw new ASMException((MessageKey)PrCaMsgID.TOO_SMALL_COUNT_FOR_ASM, count);
        }
        if (count >= 1024) {
            throw new ASMException((MessageKey)PrCaMsgID.TOO_LARGE_COUNT_FOR_ASM, count);
        }
        try {
            boolean n0Exists;
            List<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (Cluster.isCluster()) {
                n0Exists = false;
                try {
                    n0Exists = new ClusterUtil().isNodeNum0Exists();
                    Trace.out((String)("n0Exists = " + n0Exists));
                }
                catch (ClusterUtilException ce) {
                    throw new CRSException((MessageKey)PrCrMsgID.NODE_NUM0_CHECK_FAILED, (Throwable)ce, new Object[0]);
                }
                if (n0Exists) {
                    attrList = ResourceType.LocalASM.modifyAttrForAsmWithNode0(attrList);
                }
            }
            if (count == -1) {
                attrList.add(crsFactory.create(ResourceType.ClusterASM.INSTANCE_FAILOVER.name(), ResourceLiterals.DISABLED_VALUE.toString()));
                attrList.add(crsFactory.create(ResourceType.ClusterASM.CARDINALITY.name(), "%CRS_HUB_SIZE%"));
                n0Exists = false;
                try {
                    n0Exists = new ClusterUtil().isNodeNum0Exists();
                    Trace.out((String)("n0Exists = " + n0Exists));
                }
                catch (ClusterUtilException ce) {
                    throw new CRSException((MessageKey)PrCrMsgID.NODE_NUM0_CHECK_FAILED, (Throwable)ce, new Object[0]);
                }
                if (n0Exists) {
                    attrList.add(crsFactory.create(ResourceType.ClusterASM.ALIAS_NAME.name(), ResourceType.LocalASM.defaultValNode0Exist((String)ResourceType.LocalASM.ALIAS_NAME.name())));
                } else {
                    attrList.add(crsFactory.create(ResourceType.ClusterASM.ALIAS_NAME.name(), ResourceType.ClusterASM.ALIAS_NAME.toString()));
                }
            } else {
                String pwfile;
                NativeSystem system = new SystemFactory().CreateSystem();
                if (!system.isPathOnASM(pwfile = this.m_crsResource.getAttribute(ResourceType.ClusterASM.PWFILE.name()).getValue())) {
                    throw new ASMException((MessageKey)PrCaMsgID.PWFILE_NOT_ON_ASM, pwfile);
                }
                attrList.add(crsFactory.create(ResourceType.ClusterASM.INSTANCE_FAILOVER.name(), ResourceLiterals.ENABLED_VALUE.toString()));
                attrList.add(crsFactory.create(ResourceType.ClusterASM.CARDINALITY.name(), String.valueOf(count)));
                attrList.add(crsFactory.create(ResourceType.ClusterASM.ALIAS_NAME.name(), ""));
            }
            this.m_crsResource.update(forceFlag, attrList.toArray(new ResourceAttribute[attrList.size()]));
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    @Override
    public List<ASMInstance> allInstances() throws ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ClusterASM.NAME.name(), this.getName());
            return this.getInstances(nameFilter, false);
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public List<ASMInstance> instances() throws AlreadyStoppedException, ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ClusterASM.NAME.name(), this.getName());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, nameFilter, FilterFactoryImpl.getFilter4RunningResource((CRSResource)this.m_crsResource, null));
            List<ASMInstance> asmInstList = this.getInstances(finalFilter, true);
            if (asmInstList.size() == 0) {
                throw new AlreadyStoppedException((MessageKey)PrCaMsgID.NO_RUNNING_ASMINSTANCE, new Object[]{this.getUserAssignedName()});
            }
            return asmInstList;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    private List<ASMInstance> getInstances(Filter filter, boolean evalFlag) throws ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String nodeAttr = ResourceLiterals.CRS_LAST_SERVER.toString();
            String instAttr = ResourceType.ClusterASM.USR_ORA_INST_NAME.name();
            String stateAttr = ResourceLiterals.STATE_ATTR_NAME.toString();
            Map resultData = null;
            try {
                resultData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, true, filter, new String[]{nodeAttr, instAttr, stateAttr});
            }
            catch (CRSException e) {
                Trace.out((String)("Got exception in searchEntities with parameters evalFlag = true, CRS_LAST_SERVER,USR_ORA_INST_NAME (not an error): " + e.getMessage()));
                Trace.out((String)"Query CRS again with evalFlag = false");
                resultData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, false, filter, new String[0]);
            }
            ServerFactoryImpl sfImpl = ServerFactoryImpl.getInstance();
            LinkedList<ASMInstance> asmInstList = new LinkedList<ASMInstance>();
            for (String riID : resultData.keySet()) {
                Map result = (Map)resultData.get(riID);
                String instName = (String)result.get(instAttr);
                String nodeName = (String)result.get(nodeAttr);
                String state = (String)result.get(stateAttr);
                Trace.out((String)("riID=" + riID + ", instName=" + instName + ",nodeName=" + nodeName + ", state=" + state));
                if (instName != null && instName.contains(ResourceLiterals.CRS_CSS_NODENUMBER.toString())) {
                    Filter idFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.ID.name(), riID);
                    try {
                        Map resultDataDetail = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, true, idFilter, new String[]{nodeAttr, instAttr, stateAttr});
                        result = (Map)resultDataDetail.get(riID);
                        instName = (String)result.get(instAttr);
                        nodeName = (String)result.get(nodeAttr);
                        state = (String)result.get(stateAttr);
                    }
                    catch (CRSException e) {
                        if (e.getMessage().contains("CRS-2653")) {
                            Trace.out((String)("Not an error. Instance name is not assigned to instance " + riID));
                        }
                        throw e;
                    }
                }
                Trace.out((String)("Instance id = " + riID + ", instName=" + instName + ",nodeName=" + nodeName + ", state = " + state));
                asmInstList.add(new ASMInstanceImpl(this, riID, instName, sfImpl.getNode(nodeName, false), state));
            }
            return asmInstList;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void start(List<Node> nodes, List<StartOptions> startupOptions) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        if (!(nodes != null && nodes.size() != 0 || startupOptions != null && startupOptions.size() != 0)) {
            super.start();
            return;
        }
        if (startupOptions == null || startupOptions.size() == 0) {
            this.start(nodes);
            return;
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StartOptions[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_OPEN_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            if (nodes == null || nodes.size() == 0) {
                this.m_crsResource.start(options);
            } else {
                this.m_crsResource.start(nodes, options);
            }
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    @Override
    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_STOP_MODE.name(), StopOptions.ABORT.toString())};
                this.m_crsResource.stop(true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(false);
        }
    }

    @Override
    public void stop(List<Node> nodeList, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"nodeList"});
        }
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_STOP_MODE.name(), StopOptions.ABORT.toString())};
                this.m_crsResource.stop(nodeList, true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(nodeList, false);
        }
    }

    @Override
    public void stop(List<Node> nodeList, List<StopOptions> stopOptions, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null && stopOptions == null) {
            this.stop(force);
            return;
        }
        if (stopOptions == null) {
            this.stop(nodeList, force);
            return;
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StopOptions[] soarr = stopOptions.toArray(new StopOptions[stopOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.ClusterASM.USR_ORA_STOP_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            if (nodeList == null) {
                this.m_crsResource.stop(force, options);
            } else {
                this.m_crsResource.stop(nodeList, force, options);
            }
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    @Override
    public List<Listener> ASMListeners() throws ASMException {
        String lsnrName = null;
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.ASMListener.NAME.toString()));
            ArrayList<Listener> lsnrList = new ArrayList<Listener>(resList.size());
            NotExistsException ne = null;
            for (ResourceAttribute attr : resList) {
                try {
                    lsnrName = ListenerImpl.getUserAssignedName((String)attr.getValue());
                    lsnrList.add(NodeAppsFactory.getInstance().getListener(lsnrName));
                }
                catch (NotExistsException e) {
                    Trace.out((String)("Some one just removed listener resource=" + attr.getValue()));
                    ne = e;
                }
            }
            if (lsnrList.size() == 0) {
                Trace.out((String)("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.ASMListener.NAME.toString()));
                if (ne == null) {
                    ne = new NotExistsException((MessageKey)PrCnMsgID.CLUSTER_ASM_LSNR_NOT_EXIST, new Object[0]);
                }
                throw ne;
            }
            return Collections.unmodifiableList(lsnrList);
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
        catch (ListenerException e) {
            throw new ASMException(e);
        }
        catch (NotExistsException e) {
            throw new ASMException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    public static String getResourceName() {
        return ResourceLiterals.CLUSTER_ASM_RES_NAME.toString();
    }
}

