/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.AsmBaseFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.CCMB;
import oracle.cluster.asm.FSEnums;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.asm.Volume;
import oracle.cluster.asm.VolumeException;
import oracle.cluster.cmdtools.ADVMUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceNames;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.RuntimeResourceType;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.server.ServerPoolImpl;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class AsmBaseFileSystemImpl
extends SoftwareModuleImpl
implements AsmBaseFileSystem {
    protected ResourceAttribute m_nameAttr;
    protected String m_dgName;
    protected String m_volName;

    AsmBaseFileSystemImpl(ResourceAttribute nameAttr) throws AsmClusterFileSystemException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.BaseFileSystem.NAME.name())) {
            throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.AsmClusterFileSystem.NAME.name(), nameAttr.getName());
        }
        Trace.out((String)("resource attribute NAME = " + nameAttr.getValue()));
        String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        boolean validName = values.length == 4;
        validName = validName && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.'));
        boolean bl = validName = validName && (ResourceLiterals.ACFS.toString().equalsIgnoreCase(values[values.length - 1]) || ResourceLiterals.FS.toString().equalsIgnoreCase(values[values.length - 1]));
        if (!validName) {
            throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.AsmClusterFileSystem.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = values[1] + '.' + values[2];
        this.m_dgName = values[1];
        this.m_volName = values[2];
        Trace.out((String)("m_name = " + this.m_name + ", m_displayName = " + this.m_displayName + ", disk group name = " + this.m_dgName + ", volume name = " + this.m_volName));
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException nee) {
            Trace.out((String)("Filesysteml resource \"" + nameAttr.getValue() + "\" is not yet created, which is ok"));
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException(crse);
        }
    }

    @Override
    public String getDiskGroup() {
        return ASMFactory.isDBAASCluster() ? "" : this.m_dgName;
    }

    @Override
    public String getVolumeDevice() throws AsmClusterFileSystemException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.VOLUME_DEVICE.name()).getValue();
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_VOLUME_DEVICE_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String getCanonicalVolumeDevice() throws AsmClusterFileSystemException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.CANONICAL_VOLUME_DEVICE.name()).getValue();
        }
        catch (CRSException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_CANONICAL_VOL_DEVICE_FAILED, e, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String getVolumeName() {
        return ASMFactory.isDBAASCluster() ? "" : this.m_volName;
    }

    @Override
    public String getMountPoint() throws AsmClusterFileSystemException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.MOUNTPOINT_PATH.name()).getValue();
        }
        catch (CRSException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_MOUNTPOINT_FAILED, e, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String getFSOptions() throws AsmClusterFileSystemException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.FS_OPTIONS.name()).getValue();
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_FS_OPTIONS_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String getFSDescription() throws AsmClusterFileSystemException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.FS_DESCRIPTION.name()).getValue();
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_FS_DESCRIPTION_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String getNodeNames() throws AsmClusterFileSystemException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.HOSTING_MEMBERS.name()).getValue();
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_HOSTING_MEMBERS_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String getServerPools() throws AsmClusterFileSystemException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.SERVER_POOLS.name()).getValue();
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_SERVER_POOLS_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String getApplicationID() throws AsmClusterFileSystemException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.APPLICATION_ID.name()).getValue();
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_APPLICATION_ID_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String[] getAuxVolumes() throws AsmClusterFileSystemException {
        try {
            String auxVolStr = this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.AUX_VOLUMES.name()).getValue();
            Trace.out((String)"Returning auxiliary volume device array");
            return auxVolStr.split(",");
        }
        catch (CRSException crse) {
            Trace.out((String)("Get auxiliary volumes failed: " + crse.getMessage()));
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_AUXILIARY_VOLUMES_FAILED, crse, this.m_name);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, AsmClusterFileSystemException {
        try {
            Trace.out((String)"calling parent's crsResource");
            return super.crsResource();
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException(sme);
        }
    }

    @Override
    public boolean isLocalResource() throws AsmClusterFileSystemException {
        try {
            String typeAttrValue = this.m_crsResource.getAttribute(ResourceLiterals.TYPE.name()).getValue();
            boolean isLocal = typeAttrValue.equals(ResourceType.AsmClusterFileSystem.NAME.toString()) || typeAttrValue.equals(ResourceType.DBAASFSLocal.NAME.toString());
            return isLocal;
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_TYPE_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public String getMountOwner() throws AsmClusterFileSystemException {
        try {
            ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
            String mountOwner = "";
            List users = perm.getUsers();
            if (users.size() > 0) {
                mountOwner = (String)users.get(users.size() - 1);
            } else {
                Trace.out((String)"No mount owner is configured");
            }
            return mountOwner;
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_FS_USERS_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public List<String> getMountUsers() throws AsmClusterFileSystemException {
        List<String> users = this.doGetUsers(false);
        if (users.isEmpty()) {
            Trace.out((String)"No mount users configured");
        }
        return users;
    }

    @Override
    public String[] getUsers() throws AsmClusterFileSystemException {
        List<String> userList = this.doGetUsers(true);
        return userList.toArray(new String[userList.size()]);
    }

    private List<String> doGetUsers(boolean all) throws AsmClusterFileSystemException {
        try {
            ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
            List users = perm.getUsers();
            if (!all && users.size() > 0) {
                users.remove(users.size() - 1);
            }
            return users;
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.GET_FS_USERS_FAILED, crse, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public void setUser(String user) throws AsmClusterFileSystemException {
        ArrayList<String> users = new ArrayList<String>(1);
        users.add(user);
        this.setUsers(users);
    }

    @Override
    public void setUser(String[] user) throws AsmClusterFileSystemException {
        this.setUsers(user != null ? Arrays.asList(user) : null);
    }

    @Override
    public void setMountOwner(String user) throws AsmClusterFileSystemException, NotExistsException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SET_FS_USER_FAILED, sme, this.m_dgName, this.m_volName);
        }
        if (user == null || user.isEmpty()) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mount owner", user);
        }
        this.assertUsers(user);
        try {
            ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
            List user_list = perm.getUsers();
            perm.setPerm(ResourceType.ACL.USER, user, new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE});
            this.m_crsResource.setPermissions((ResourcePermissions)perm);
        }
        catch (CRSException cre) {
            throw new AsmClusterFileSystemException(cre);
        }
    }

    public void setUsers(List<String> users) throws AsmClusterFileSystemException {
        String prefix = null;
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SET_FS_USER_FAILED, sme, this.m_dgName, this.m_volName);
        }
        if (users == null || users.isEmpty()) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "users", users);
        }
        String firstUser = users.get(0).trim();
        if (firstUser.startsWith("/+") || firstUser.startsWith("/-")) {
            if (users.size() > 1) {
                Trace.out((String)"Unable to add/remove a list of users using prefixes");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_REMOVE_APPEND_USER_LIST, true);
            }
            prefix = firstUser.substring(0, 2);
            firstUser = firstUser.substring(2);
        }
        try {
            if (prefix != null) {
                if (!new Util().isUserValid(firstUser)) {
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_USER, firstUser);
                }
                if (prefix.equals("/+")) {
                    Trace.out((String)("Adding user " + firstUser + " to ACL"));
                    this.addUser(firstUser.trim());
                } else {
                    Trace.out((String)("Removing user " + firstUser + " from ACL"));
                    this.removeUser(firstUser.trim());
                }
            } else {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                List user_list = perm.getUsers();
                String mountOwner = user_list.isEmpty() ? "" : (String)user_list.get(user_list.size() - 1);
                this.assertUsers(mountOwner, users);
                for (String currUser : user_list) {
                    perm.setPerm(ResourceType.ACL.USER, currUser, new ResourceType.ACL_PERM[0]);
                }
                for (String user : users) {
                    if (!new Util().isUserValid(user)) {
                        throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_USER, user);
                    }
                    Trace.out((String)("Setting user information, user=" + user));
                    perm.setPerm(ResourceType.ACL.USER, user.trim(), new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE});
                }
                if (!mountOwner.isEmpty()) {
                    perm.setPerm(ResourceType.ACL.USER, mountOwner, new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE});
                }
                this.m_crsResource.setPermissions((ResourcePermissions)perm);
            }
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SET_FS_USER_FAILED, crse, this.m_dgName, this.m_volName);
        }
        catch (UtilException ue) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SET_FS_USER_FAILED, ue, this.m_dgName, this.m_volName);
        }
        catch (AlreadyExistsException ae) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SET_FS_USER_FAILED, ae, this.m_dgName, this.m_volName);
        }
        catch (NotExistsException nee) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SET_FS_USER_FAILED, nee, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public void addUser(String user) throws AlreadyExistsException, AsmClusterFileSystemException {
        try {
            this.addRemoveMountUser(user, false);
        }
        catch (NotExistsException aee) {
            throw new AsmClusterFileSystemException(aee);
        }
    }

    @Override
    public void removeUser(String user) throws NotExistsException, AsmClusterFileSystemException {
        try {
            this.addRemoveMountUser(user, true);
        }
        catch (AlreadyExistsException aee) {
            throw new AsmClusterFileSystemException(aee);
        }
    }

    private void addRemoveMountUser(String user, boolean isRemove) throws NotExistsException, AlreadyExistsException, AsmClusterFileSystemException {
        block10: {
            try {
                NodeAppsFactoryImpl.getInstance().assertRoot();
            }
            catch (SoftwareModuleException sme) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SET_FS_USER_FAILED, sme, this.m_dgName, this.m_volName);
            }
            if (user == null || user.trim().isEmpty()) {
                throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mount user", user);
            }
            try {
                String mountOwner;
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                List users = perm.getUsers();
                String string = mountOwner = users.size() > 0 ? (String)users.get(users.size() - 1) : "";
                if (isRemove) {
                    if (users.contains(user)) {
                        Trace.out((String)("Removing mount user information, user=" + user));
                        perm.setPerm(ResourceType.ACL.USER, user, new ResourceType.ACL_PERM[0]);
                        this.m_crsResource.setPermissions((ResourcePermissions)perm);
                        break block10;
                    }
                    Trace.out((String)("User " + user + " not found in ACL"));
                    throw new NotExistsException((MessageKey)PrCcMsgID.USER_NOT_PRESENT, new Object[]{user});
                }
                if (!users.contains(user)) {
                    Trace.out((String)("Adding mount user information, user=" + user));
                    if (users.isEmpty()) {
                        perm.setPerm(ResourceType.ACL.USER, user, new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE});
                    } else {
                        perm.setPerm(ResourceType.ACL.USER, mountOwner, new ResourceType.ACL_PERM[0]);
                        perm.setPerm(ResourceType.ACL.USER, user, new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE});
                        perm.setPerm(ResourceType.ACL.USER, mountOwner, new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE});
                    }
                    this.m_crsResource.setPermissions((ResourcePermissions)perm);
                    break block10;
                }
                Trace.out((String)("User " + user + " already in ACL"));
                throw new AlreadyExistsException((MessageKey)PrCcMsgID.USER_ALREADY_ADDED, new Object[]{user});
            }
            catch (CRSException crse) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SET_FS_USER_FAILED, crse, this.m_dgName, this.m_volName);
            }
        }
    }

    @Override
    public void setCategory(ServerCategory cat) throws AsmClusterFileSystemException {
        try {
            String nodes;
            if (this.isLocalResource()) {
                Trace.out((String)("Setting SERVER_CATEGORY to " + cat.getName()));
                ResourceAttribute attr = new ResourceAttribute(ResourceType.BaseFileSystem.SERVER_CATEGORY.name(), cat.getName());
                this.m_crsResource.update(false, new ResourceAttribute[]{attr});
            }
            if ((nodes = this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.HOSTING_MEMBERS.name()).getValue()) != null && !nodes.isEmpty()) {
                ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>(2);
                Trace.out((String)"Cleaning HOSTING_MEMBERS value");
                attrList.add(new ResourceAttribute(ResourceType.BaseFileSystem.HOSTING_MEMBERS.name(), ""));
                Trace.out((String)("Setting SERVER_CATEGORY to " + cat.getName()));
                attrList.add(new ResourceAttribute(ResourceType.BaseFileSystem.SERVER_CATEGORY.name(), cat.getName()));
                this.m_crsResource.update(false, attrList.toArray(new ResourceAttribute[attrList.size()]));
            } else {
                String[] srvPoolNames;
                for (String srvPoolName : srvPoolNames = this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.SERVER_POOLS.name()).getValue().split(" ")) {
                    ServerPoolImpl srvPool = (ServerPoolImpl)ServerFactory.getInstance().getServerPool(srvPoolName);
                    CRSEntity res = srvPool.crsEntity();
                    ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>(2);
                    Trace.out((String)"Cleaning SERVER_NAMES value");
                    attrList.add(new ResourceAttribute(ResourceType.ServerPool.SERVER_NAMES.name(), ""));
                    Trace.out((String)("Setting SERVER_CATEGORY to " + cat.getName()));
                    attrList.add(new ResourceAttribute(ResourceType.BaseFileSystem.SERVER_CATEGORY.name(), cat.getName()));
                    res.update(attrList);
                }
            }
        }
        catch (CRSException ce) {
            throw new AsmClusterFileSystemException(ce);
        }
        catch (ServerGroupException sge) {
            throw new AsmClusterFileSystemException(sge);
        }
        catch (ServerException se) {
            throw new AsmClusterFileSystemException(se);
        }
        catch (NotExistsException nee) {
            throw new AsmClusterFileSystemException(nee);
        }
        catch (AlreadyExistsException aee) {
            throw new AsmClusterFileSystemException(aee);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, AsmClusterFileSystemException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_REMOVE_FAILED, sme, this.m_dgName, this.m_volName);
        }
    }

    @Override
    public void relocate(boolean force) throws NotRunningException, RelocateException, AsmClusterFileSystemException {
        try {
            if (!this.isClusterResource()) {
                Trace.out((String)"Resource is not node local ACFS/FS");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_RELOCATE_FS, new Object[0]);
            }
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate(force);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode, boolean force) throws NotRunningException, RelocateException, AsmClusterFileSystemException {
        try {
            if (!this.isClusterResource()) {
                Trace.out((String)"Resource is not node local ACFS/FS");
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_RELOCATE_FS, new Object[0]);
            }
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode, force);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    @Override
    public void createClusterResource(FileSystemOptionalArgs fsOptionalArgs, Version version) throws AlreadyExistsException, AsmClusterFileSystemException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException(sme);
        }
        try {
            boolean isUsersDefined;
            String fsOptions;
            String resourceType;
            List<ResourceAttribute> attrList = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            FSEnums.FSTypeEnum fsType = fsOptionalArgs.getFSType();
            boolean isACFS = fsType == FSEnums.FSTypeEnum.ACFS;
            String applicationID = fsOptionalArgs.getApplicationID();
            ResourceAttribute existingResourceNameAttr = null;
            if (applicationID != null) {
                resourceType = "ora." + applicationID + '_' + ResourceLiterals.FS.toString() + '.' + ResourceLiterals.TYPE.toString();
                Trace.out((String)("Checking for " + resourceType));
                if (!crsFactory.isRegistered(resourceType, CRSEntity.Type.ResourceType)) {
                    Class baseTypeClass = isACFS ? (fsOptionalArgs.isClientCluster() ? ResourceType.DBAASFSCluster.class : ResourceType.ACFSCluster.class) : ResourceType.FS.class;
                    Trace.out((String)("Rescource type \"" + resourceType + "\" does not exist. Creating it now."));
                    RuntimeResourceType appIDRrsourceType = new RuntimeResourceType(resourceType, baseTypeClass, null);
                    attrList = appIDRrsourceType.getAttributes();
                    crsFactory.create(CRSEntity.Type.ResourceType, attrList);
                } else {
                    Trace.out((String)("Rescource type \"" + resourceType + "\" already exists"));
                    existingResourceNameAttr = new ResourceAttribute(ResourceType.BaseFileSystem.NAME.name(), resourceType);
                }
            } else if (isACFS) {
                resourceType = fsOptionalArgs.isClientCluster() ? ResourceType.DBAASFSCluster.NAME.toString() : ResourceType.ACFSCluster.NAME.toString();
                Trace.out((String)("Resource type is " + resourceType));
                existingResourceNameAttr = new ResourceAttribute(ResourceType.ACFSCluster.NAME.name(), resourceType);
            } else {
                resourceType = ResourceType.FS.NAME.toString();
                Trace.out((String)("Resource type is " + resourceType));
                existingResourceNameAttr = new ResourceAttribute(ResourceType.FS.NAME.name(), resourceType);
            }
            if (existingResourceNameAttr != null && applicationID != null) {
                if (isACFS) {
                    if (attrList != null) {
                        for (ResourceAttribute attr : attrList) {
                            if (!attr.getName().equalsIgnoreCase(ResourceType.FS.FS_TYPE.name())) continue;
                            Trace.out((String)("The existing filesystem for application with ID \"" + applicationID + "\" is non-ACFS"));
                            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.APPID_RES_FSTYPE_CONFLICT, applicationID, FSEnums.FSTypeEnum.ACFS.getValue().toUpperCase());
                        }
                    }
                } else {
                    ResourceAttribute fstypeAttr = new ResourceAttribute(ResourceType.FS.FS_TYPE.name(), fsType.getValue().toUpperCase());
                    if (attrList != null && !attrList.contains(fstypeAttr)) {
                        Trace.out((String)("The existing filesystem for application with ID \"" + applicationID + "\" is non-" + fsType.getValue().toUpperCase() + " filesystem"));
                        throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.APPID_RES_FSTYPE_CONFLICT, applicationID, fsType.getValue());
                    }
                }
            }
            attrList = new ArrayList();
            String[] nodeNames = fsOptionalArgs.getNodeNames();
            String[] serverPools = fsOptionalArgs.getServerPools();
            String[] auxvolumes = fsOptionalArgs.getAuxVolumes();
            ResourceAttribute attr = new ResourceAttribute(ResourceType.BaseFileSystem.NAME.name(), this.m_nameAttr.getValue());
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceLiterals.TYPE.name(), resourceType);
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            String description = fsOptionalArgs.getDescription();
            if (description != null) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.FS_DESCRIPTION.name(), description);
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            String mountPointPath = fsOptionalArgs.getMountPointPath().trim();
            AsmBaseFileSystemImpl.validateMountPointPath(mountPointPath);
            attr = new ResourceAttribute(ResourceType.BaseFileSystem.MOUNTPOINT_PATH.name(), mountPointPath);
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceType.AsmClusterFileSystem.INTERNAL_MOUNTPOINT_PATH.name(), ASMFactoryImpl.getInternalMountPoint(mountPointPath));
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            FSEnums.AutostartEnum autostart = fsOptionalArgs.getAutostart();
            if (autostart != null) {
                attr = new ResourceAttribute(ResourceType.ClusterResource.AUTO_START.name(), autostart.getValue());
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            if (nodeNames != null) {
                this.validateNodes(nodeNames);
                String hosting_members = this.convertStringArrayToString(nodeNames);
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.HOSTING_MEMBERS.name(), hosting_members);
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
                attrList.add(new ResourceAttribute(ResourceType.ACFSCluster.SERVER_CATEGORY.name(), ""));
            }
            if (serverPools != null) {
                serverPools = this.validateServerCategoryAndRetrieveServerPoolNames(serverPools, ResourceLiterals.HUB_CATEGORY.toString());
                String server_pools = this.convertStringArrayToString(serverPools);
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.SERVER_POOLS.name(), server_pools);
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
                attrList.add(new ResourceAttribute(ResourceType.ACFSCluster.SERVER_CATEGORY.name(), ""));
            }
            if (applicationID != null) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.APPLICATION_ID.name(), applicationID);
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            attr = new ResourceAttribute(ResourceType.BaseFileSystem.CARDINALITY.name(), String.valueOf(1));
            attrList.add(attr);
            Trace.out((String)("Setting resource attribute " + attr.getName() + "=" + attr.getValue() + " (fixed value)"));
            attr = new ResourceAttribute(ResourceType.BaseFileSystem.VOLUME_DEVICE.name(), fsOptionalArgs.getVolumeDevicePath());
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            String crsHome = new Util().getCRSHome();
            ADVMUtil advmutil = new ADVMUtil(crsHome);
            String volumeDeviceCanonicalPath = advmutil.getCanonicalVolume(fsOptionalArgs.getVolumeDevicePath());
            attr = new ResourceAttribute(ResourceType.BaseFileSystem.CANONICAL_VOLUME_DEVICE.name(), volumeDeviceCanonicalPath);
            Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
            attrList.add(attr);
            if (fsOptionalArgs.getAuxVolumes() != null && fsOptionalArgs.getAuxVolumes().length > 0) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.AUX_VOLUMES.name(), Utils.getString((String[])fsOptionalArgs.getAuxVolumes(), (String)","));
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            if (!isACFS) {
                attr = new ResourceAttribute(ResourceType.FS.FS_TYPE.name(), fsType.getValue().toUpperCase());
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            if ((fsOptions = fsOptionalArgs.getFSOptions()) != null) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.FS_OPTIONS.name(), fsOptions);
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            if (fsOptionalArgs.getGHCreated()) {
                Trace.out((String)"File system created in Gridhomes");
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.GH_CREATED.name(), "true");
                Trace.out((String)("   Resource attribute: " + attr.getName() + "=" + attr.getValue()));
                attrList.add(attr);
            }
            Trace.out((String)"Adding Version attribute");
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            Volume volume = null;
            ASMFactoryImpl afImpl = ASMFactoryImpl.getInstance();
            if (!fsOptionalArgs.isClientCluster()) {
                try {
                    List<Volume> volList = afImpl.getVolumes(fsOptionalArgs.getVolumeDevicePath(), fsOptionalArgs.getVolumeName(), fsOptionalArgs.getDiskGroupName());
                    if (volList.size() != 1) {
                        Object[] args = new Object[]{fsOptionalArgs.getVolumeName(), fsOptionalArgs.getDiskGroupName()};
                        throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.NOT_SINGLE_VOLUME_ERROR, args);
                    }
                    volume = volList.get(0);
                }
                catch (VolumeException ve) {
                    throw new AsmClusterFileSystemException((Throwable)((Object)ve));
                }
                catch (NotExistsException nee) {
                    throw new AsmClusterFileSystemException(nee);
                }
            }
            AsmBaseFileSystem parentFS = this.getNestedFS(mountPointPath);
            attrList.addAll(fsOptionalArgs.isClientCluster() ? this.generateDBAASFSDependencies(parentFS) : this.generateFSDependencies(volume, auxvolumes, parentFS));
            Trace.out((String)"Generating ACL attribute");
            boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
            String[] users = fsOptionalArgs.getUsers();
            boolean bl = isUsersDefined = users != null && users.length > 0;
            if (isUnix) {
                attrList.add(this.generateACL(fsOptionalArgs.getMountOwner(), fsOptionalArgs.getUsers() != null ? Arrays.asList(fsOptionalArgs.getUsers()) : null));
            } else if (isUsersDefined) {
                for (String user : users) {
                    if (new Util().isUserValid(user)) continue;
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_USER, user);
                }
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            Trace.out((String)"Successfully created filesystem cluster resource");
            if (!isUnix && isUsersDefined) {
                this.setUser(users);
            }
        }
        catch (AlreadyExistsException aee) {
            throw new AlreadyExistsException((MessageKey)PrCaMsgID.FS_ALREADY_EXISTS, new Object[]{this.m_dgName, this.m_volName, aee});
        }
        catch (CmdToolUtilException e) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_RES_ADD_FAILED, crse, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (NotExistsException nee) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_RES_ADD_FAILED, nee, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_RES_ADD_FAILED, sme, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (UtilException ue) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_RES_ADD_FAILED, ue, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
    }

    @Override
    public void modifyClusterResource(FileSystemOptionalArgs fsOptionalArgs) throws AsmClusterFileSystemException {
        try {
            FSEnums.AutostartEnum autostart;
            String description;
            String fsOptions;
            String[] serverPools;
            String[] nodeNames;
            ResourceAttribute attr;
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            String fsType = this.m_crsResource.getAttribute(ResourceType.FS.FS_TYPE.name()).getValue();
            boolean isACFS = fsType.equalsIgnoreCase(FSEnums.FSTypeEnum.ACFS.toString());
            String mountPointPath = fsOptionalArgs.getMountPointPath();
            if (mountPointPath != null) {
                if (this.isRunning()) {
                    Trace.out((String)"Resource is running, unable to modify the mount point path.");
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.FS_RUNNING_MOD_MTPT, new Object[0]);
                }
                mountPointPath = mountPointPath.trim();
                AsmBaseFileSystemImpl.validateMountPointPath(mountPointPath);
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.MOUNTPOINT_PATH.name(), mountPointPath);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            if ((nodeNames = fsOptionalArgs.getNodeNames()) != null) {
                this.validateNodes(nodeNames);
                String existingNodeListStr = this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.HOSTING_MEMBERS.name()).getValue();
                if (existingNodeListStr != null && existingNodeListStr.trim().length() > 0) {
                    StringTokenizer nodeListTokenizer = new StringTokenizer(existingNodeListStr, ",");
                    ArrayList<String> existingNodeList = new ArrayList<String>(nodeListTokenizer.countTokens());
                    while (nodeListTokenizer.hasMoreTokens()) {
                        String nd = nodeListTokenizer.nextToken().trim();
                        Trace.out((String)("Adding node " + nd + " to existing nodelist"));
                        existingNodeList.add(oracle.cluster.impl.util.Utils.convertToCSSNodeName((String)nd));
                    }
                    for (int i = 0; i < nodeNames.length; ++i) {
                        Trace.out((String)("Removing node " + nodeNames[i] + " from existing nodelist"));
                        existingNodeList.remove(nodeNames[i]);
                    }
                    for (String currNode : existingNodeList) {
                        Trace.out((String)("Current node from nodelist: " + currNode));
                        if (!this.m_crsResource.isRunning(currNode)) continue;
                        throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.MODIFY_HOSTING_MEMBERS_ERROR, currNode);
                    }
                }
                String hosting_members = this.convertStringArrayToString(nodeNames);
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.HOSTING_MEMBERS.name(), hosting_members);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
                attrList.add(new ResourceAttribute(ResourceType.ACFSCluster.SERVER_CATEGORY.name(), ""));
            }
            if ((serverPools = fsOptionalArgs.getServerPools()) != null) {
                serverPools = this.validateServerCategoryAndRetrieveServerPoolNames(serverPools, ResourceLiterals.HUB_CATEGORY.toString());
                String server_pools = this.convertStringArrayToString(serverPools);
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.SERVER_POOLS.name(), server_pools);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
                attrList.add(new ResourceAttribute(ResourceType.ACFSCluster.SERVER_CATEGORY.name(), ""));
            }
            if ((fsOptions = fsOptionalArgs.getFSOptions()) != null) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.FS_OPTIONS.name(), fsOptions);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            if ((description = fsOptionalArgs.getDescription()) != null) {
                attr = new ResourceAttribute(ResourceType.BaseFileSystem.FS_DESCRIPTION.name(), description);
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            if ((autostart = fsOptionalArgs.getAutostart()) != null) {
                attr = new ResourceAttribute(ResourceType.ClusterResource.AUTO_START.name(), autostart.getValue());
                Trace.out((String)("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\""));
                attrList.add(attr);
            }
            if (fsOptionalArgs.getMountOwner() != null && !fsOptionalArgs.getMountOwner().isEmpty()) {
                this.setMountOwner(fsOptionalArgs.getMountOwner());
            }
            if (fsOptionalArgs.getUsers() != null && fsOptionalArgs.getUsers().length > 0) {
                this.setUsers(Arrays.asList(fsOptionalArgs.getUsers()));
            }
            boolean forceFlag = fsOptionalArgs.getForceFlag();
            if (attrList.size() > 0) {
                if (forceFlag) {
                    this.m_crsResource.update(true, attrList.toArray(new ResourceAttribute[attrList.size()]));
                } else {
                    this.m_crsResource.update(false, attrList.toArray(new ResourceAttribute[attrList.size()]));
                }
            }
        }
        catch (CRSException crse) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.MODIFY_FILESYSTEM_FAILED, crse, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.MODIFY_FILESYSTEM_FAILED, sme, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
        catch (NotExistsException nee) {
            throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.MODIFY_FILESYSTEM_FAILED, nee, this.m_nameAttr.getValue(), this.m_dgName, this.m_volName);
        }
    }

    public static String getResourceName(String dgName, String volName) throws CRSException {
        return ResourceNames.getACFSResourceName((String)dgName, (String)volName);
    }

    public static final String[] getUserAssignedNames(String acfsResName) throws AsmClusterFileSystemException {
        if (acfsResName == null || acfsResName.trim().length() == 0) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgResName");
        }
        String[] values = acfsResName.split(Pattern.quote(String.valueOf('.')));
        if (values.length != 4 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.ACFS.toString().equalsIgnoreCase(values[values.length - 1])) {
            throw new AsmClusterFileSystemException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.AsmClusterFileSystem.NAME.name(), acfsResName);
        }
        String[] acfsValues = new String[]{values[1], values[2]};
        return acfsValues;
    }

    public boolean isClusterResource() {
        try {
            this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.CARDINALITY.name());
            return true;
        }
        catch (CRSException crse) {
            Trace.out((String)("Attribute \"" + ResourceType.BaseFileSystem.CARDINALITY.name() + "\" does not exist. Therefore it is not a filesystem cluster resource."));
            return false;
        }
    }

    @Override
    public boolean isGHCreated() throws AsmClusterFileSystemException {
        try {
            String ghCreated = this.m_crsResource.getAttribute(ResourceType.BaseFileSystem.GH_CREATED.name()).getValue();
            Trace.out((String)("Gridhomes created resource flag:" + ghCreated));
            return ghCreated.equals("true");
        }
        catch (CRSException cse) {
            throw new AsmClusterFileSystemException(cse);
        }
    }

    private void validateNodes(String[] nodeNames) throws AsmClusterFileSystemException {
        ServerFactoryImpl serverFactoryImpl;
        try {
            serverFactoryImpl = ServerFactoryImpl.getInstance();
        }
        catch (ServerException se) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.FAILED_TO_VERIFY_MEMBERSHIP, se, new Object[0]);
        }
        for (int i = 0; i < nodeNames.length; ++i) {
            try {
                serverFactoryImpl.getNode(nodeNames[i]);
                continue;
            }
            catch (NodeException ne) {
                throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.NODE_VALIDATION_ERROR, nodeNames[i]);
            }
        }
    }

    protected String convertStringArrayToString(String[] strArray) {
        StringBuilder strBuilder = new StringBuilder("");
        for (int i = 0; i < strArray.length - 1; ++i) {
            strBuilder.append(strArray[i]);
            strBuilder.append(" ");
        }
        if (strArray.length >= 1) {
            strBuilder.append(strArray[strArray.length - 1]);
        }
        return strBuilder.toString();
    }

    protected static void validateMountPointPath(String mountPointPath) throws AsmClusterFileSystemException {
        boolean isWindows;
        boolean bl = isWindows = !new SystemFactory().CreateSystem().isUnixSystem();
        if (isWindows && mountPointPath.endsWith(Character.toString(':'))) {
            mountPointPath = mountPointPath + File.separator;
        }
        if (!new File(mountPointPath).isAbsolute()) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.INVALID_MOUNTPOINT_PATH, mountPointPath);
        }
    }

    private String[] validateServerCategoryAndRetrieveServerPoolNames(String[] serverPools, String expectedServerCategory) throws AsmClusterFileSystemException {
        ServerFactoryImpl serverFactoryImpl;
        try {
            serverFactoryImpl = ServerFactoryImpl.getInstance();
        }
        catch (ServerException se) {
            throw new AsmClusterFileSystemException((MessageKey)PrCcMsgID.FAILED_TO_VERIFY_MEMBERSHIP, se, new Object[0]);
        }
        for (int i = 0; i < serverPools.length; ++i) {
            ServerPool currServerPool;
            try {
                currServerPool = serverFactoryImpl.getServerPool(serverPools[i]);
                serverPools[i] = currServerPool.getName();
            }
            catch (NotExistsException nee) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.SERVERPOOL_NOT_EXISTS, serverPools[i]);
            }
            catch (ServerGroupException sge) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.UNABLE_TO_OBTAIN_SERVERPPOOL_INFO, new Object[]{serverPools[i], sge});
            }
            try {
                String serverPoolCategory;
                String string = serverPoolCategory = currServerPool.serverCategory() == null ? "" : currServerPool.serverCategory().getName();
                if (serverPoolCategory.equalsIgnoreCase(expectedServerCategory)) continue;
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.INVALID_SERVER_CATEGORY_FOR_SERVER_POOL, serverPools[i], expectedServerCategory);
            }
            catch (ServerGroupException sge) {
                throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.UNABLE_TO_VALIDATE_SERVER_CATEGORY_FOR_SERVER_POOL, new Object[]{serverPools[i], sge});
            }
        }
        return serverPools;
    }

    protected AsmBaseFileSystem getNestedFS(String mountPoint) throws AsmClusterFileSystemException {
        try {
            List<AsmBaseFileSystem> nestFS = null;
            ASMFactoryImpl af = ASMFactoryImpl.getInstance();
            AsmBaseFileSystemImpl.validateMountPointPath(mountPoint);
            if (mountPoint.length() > 1 && mountPoint.endsWith(File.separator)) {
                mountPoint = mountPoint.substring(0, mountPoint.length() - 1);
            }
            int index = 0;
            String aux_mtp = mountPoint;
            do {
                if ((index = aux_mtp.lastIndexOf(File.separator)) == 0 && aux_mtp.length() >= 1) {
                    aux_mtp = aux_mtp.substring(0, index + 1);
                } else if (index > 0) {
                    aux_mtp = aux_mtp.substring(0, index);
                }
                Trace.out((String)("Checking mount point:" + aux_mtp));
                try {
                    nestFS = af.getValidationFileSystems(aux_mtp, false);
                    if (nestFS.size() == 1) {
                        Trace.out((String)("Parent found: " + nestFS.get(0).getName()));
                        return nestFS.get(0);
                    }
                }
                catch (NotExistsException nee) {
                    Trace.out((String)("Mount point " + aux_mtp + " has no file system resource"));
                }
            } while (index > 0);
            Trace.out((String)"No parent found");
            return null;
        }
        catch (SoftwareModuleException sme) {
            throw new AsmClusterFileSystemException(sme);
        }
    }

    protected List<ResourceAttribute> generateDBAASFSDependencies(AsmBaseFileSystem parentFS) throws CRSException, SoftwareModuleException, NotExistsException {
        ArrayList<ResourceAttribute> dependencies = new ArrayList<ResourceAttribute>(2);
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        ArrayList<ResourceDependency> startList = new ArrayList<ResourceDependency>();
        ArrayList<ResourceDependency> stopList = new ArrayList<ResourceDependency>();
        CCMB ccm = ASMFactory.getInstance().getCCMB();
        startList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.CCMB.NAME.name(), ccm.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]));
        if (parentFS != null) {
            Trace.out((String)"Nested file system, adding hard dependency to parent FS");
            startList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.BaseFileSystem.NAME.name(), parentFS.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]));
        }
        startList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.CCMB.NAME.name(), ccm.getName()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]));
        if (parentFS != null) {
            Trace.out((String)"Nested file system, adding pullup dependency to parent FS");
            startList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.BaseFileSystem.NAME.name(), parentFS.getName()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]));
        }
        Trace.out((String)"Adding Start Dependency for Filesystem resource...");
        dependencies.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])startList.toArray(new ResourceDependency[startList.size()]))));
        stopList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.CCMB.NAME.name(), ccm.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP}));
        if (parentFS != null) {
            Trace.out((String)"Nested file system, adding stop hard dependency to parent FS");
            stopList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.BaseFileSystem.NAME.name(), parentFS.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP}));
        }
        dependencies.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])stopList.toArray(new ResourceDependency[stopList.size()]))));
        return dependencies;
    }

    protected List<ResourceAttribute> generateFSDependencies(Volume volume, String[] auxvolumes, AsmBaseFileSystem parentFS) throws CRSException, SoftwareModuleException, NotExistsException, CmdToolUtilException {
        Volume vol;
        ArrayList<ResourceAttribute> dependencies = new ArrayList<ResourceAttribute>(2);
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        ArrayList<ResourceDependency> startList = new ArrayList<ResourceDependency>();
        ResourceDependency pullupDep = null;
        ResourceDependency hardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.Volume.NAME.name(), volume.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
        Trace.out((String)("   hardDep = " + ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{hardDep})));
        startList.add(hardDep);
        if (auxvolumes != null && auxvolumes.length > 0) {
            for (String auxVol : auxvolumes) {
                vol = ASMFactory.getInstance().getVolume(auxVol);
                startList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.Volume.NAME.name(), vol.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]));
            }
        }
        if (parentFS != null) {
            Trace.out((String)"Nested file system, adding hard dependency to parent FS");
            ResourceDependency hardDepFS = crsFactory.createResourceDependency(crsFactory.create(ResourceType.BaseFileSystem.NAME.name(), parentFS.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            startList.add(hardDepFS);
        }
        pullupDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.Volume.NAME.name(), volume.getName()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
        Trace.out((String)("   pullupDep = " + ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{pullupDep})));
        startList.add(pullupDep);
        if (auxvolumes != null && auxvolumes.length > 0) {
            for (String auxVol : auxvolumes) {
                vol = ASMFactory.getInstance().getVolume(auxVol);
                startList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.Volume.NAME.name(), vol.getName()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]));
            }
        }
        if (parentFS != null) {
            Trace.out((String)"Nested file system, adding pullup dependency to parent FS");
            ResourceDependency pullupDepFS = crsFactory.createResourceDependency(crsFactory.create(ResourceType.BaseFileSystem.NAME.name(), parentFS.getName()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            startList.add(pullupDepFS);
        }
        ASM asm = ASMFactory.getInstance().getASM();
        ResourceDependency asmPullup = crsFactory.createResourceDependency(crsFactory.create(ResourceType.LocalASM.NAME.name(), asm.getName()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
        Trace.out((String)("   asmPullup = " + ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{asmPullup})));
        startList.add(asmPullup);
        Trace.out((String)"Adding Start Dependency for Filesystem resource...");
        dependencies.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])startList.toArray(new ResourceDependency[startList.size()]))));
        Trace.out((String)"Adding Stop Dependency");
        ArrayList<ResourceDependency> stopList = new ArrayList<ResourceDependency>();
        ResourceDependency stopVolDep = null;
        stopVolDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.Volume.NAME.name(), volume.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP});
        Trace.out((String)("stopVolDep = " + ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{stopVolDep})));
        stopList.add(stopVolDep);
        if (auxvolumes != null && auxvolumes.length > 0) {
            for (String auxVol : auxvolumes) {
                Volume vol2 = ASMFactory.getInstance().getVolume(auxVol);
                stopList.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.Volume.NAME.name(), vol2.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP}));
            }
        }
        if (parentFS != null) {
            Trace.out((String)"Nested file system, adding stop hard dependency to parent FS");
            ResourceDependency stopFSDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.BaseFileSystem.NAME.name(), parentFS.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP});
            stopList.add(stopFSDep);
        }
        dependencies.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])stopList.toArray(new ResourceDependency[stopList.size()]))));
        return dependencies;
    }

    protected ResourceAttribute generateACL(String mountOwner, List<String> mountUsers) throws AsmClusterFileSystemException, NotExistsException {
        try {
            String groupName;
            String crsUser;
            this.assertUsers(mountOwner, mountUsers);
            ResourcePermissionsImpl perm = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.ROOT);
            Util util = new Util();
            String crsHome = util.getCRSHome();
            if (Cluster.isCluster()) {
                NodeApps nodeApps = new NodeApps(Cluster.getLocalNode());
                crsUser = nodeApps.getUserName();
                groupName = nodeApps.getGroupName();
            } else {
                crsUser = util.getOracleUser(crsHome, null);
                groupName = util.getOracleGroup(crsHome);
            }
            perm.setPerm(ResourceType.ACL.USER, crsUser, new ResourceType.ACL_PERM[0]);
            perm.setPerm(ResourceType.ACL.GROUP, groupName, new ResourceType.ACL_PERM[0]);
            if (mountUsers != null && !mountUsers.isEmpty()) {
                Trace.out((String)"Adding mount users permissions");
                for (String user : mountUsers) {
                    if (user == null) continue;
                    Trace.out((String)("setting user information for " + user));
                    perm.setPerm(ResourceType.ACL.USER, user, new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE});
                }
            }
            if (mountOwner != null && !mountOwner.isEmpty()) {
                Trace.out((String)"Adding mount owner permissions");
                Trace.out((String)("setting user information for " + mountOwner));
                perm.setPerm(ResourceType.ACL.USER, mountOwner, new ResourceType.ACL_PERM[]{ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE});
            }
            return CRSFactoryImpl.getInstance().create(ResourceLiterals.ACL_ATTR.toString(), perm.getAclString());
        }
        catch (CRSException cre) {
            throw new AsmClusterFileSystemException(cre);
        }
        catch (ClusterException ce) {
            throw new AsmClusterFileSystemException(ce);
        }
        catch (NodeException ne) {
            throw new AsmClusterFileSystemException(ne);
        }
        catch (UtilException ue) {
            throw new AsmClusterFileSystemException(ue);
        }
    }

    public void assertUsers(String mountOwner) throws NotExistsException, AsmClusterFileSystemException {
        this.assertUsers(mountOwner, null);
    }

    public void assertUsers(List<String> mountUsers) throws NotExistsException, AsmClusterFileSystemException {
        this.assertUsers(null, mountUsers);
    }

    public void assertUsers(String mountOwner, List<String> mountUsers) throws NotExistsException, AsmClusterFileSystemException {
        try {
            Util util = new Util();
            if (mountOwner != null && !mountOwner.isEmpty()) {
                Trace.out((String)("Validating mount owner: " + mountOwner));
                if (!util.isUserValid(mountOwner)) {
                    throw new NotExistsException((MessageKey)PrCaMsgID.INVALID_USER, new Object[]{mountOwner});
                }
                if (mountUsers != null && !mountUsers.isEmpty() && mountUsers.contains(mountOwner)) {
                    throw new AsmClusterFileSystemException((MessageKey)PrCaMsgID.MOUNT_OWNER_IN_USERS, mountOwner);
                }
            }
            if (mountUsers != null && !mountUsers.isEmpty()) {
                Trace.out((String)("Validating mount users " + mountUsers.toString()));
                for (String user : mountUsers) {
                    if (util.isUserValid(user)) continue;
                    throw new NotExistsException((MessageKey)PrCaMsgID.INVALID_USER, new Object[]{user});
                }
            }
        }
        catch (UtilException ue) {
            throw new AsmClusterFileSystemException(ue);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AsmBaseFileSystemImpl baseFS = (AsmBaseFileSystemImpl)obj;
        return this.m_name != null && this.m_name.equals(baseFS.getName());
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : super.hashCode();
    }
}

