/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.asm;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.asm.ASMPresence;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.asm.ASMInstanceImpl;
import oracle.cluster.impl.asm.BaseASMImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.CRSResourceTypeEntity;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.nodeapps.ListenerImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.asm.operation.ASMTreeDefinition;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterLock;
import oracle.ops.mgmt.has.ClusterLockException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;

public class ASMImpl
extends BaseASMImpl
implements ASM {
    protected ResourceAttribute m_nameAttr;
    protected static boolean m_isCluster = Cluster.isCluster();
    protected ASMPresence m_presence = ASMPresence.LEGACY;

    protected ASMImpl(ResourceAttribute nameAttr) throws ASMException {
        this(nameAttr, EntityOperations.EntityOpsMode.CRS);
    }

    protected ASMImpl(ResourceAttribute nameAttr, EntityOperations.EntityOpsMode mode) throws ASMException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceLiterals.NAME.name())) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceLiterals.NAME.name(), nameAttr.getName());
        }
        String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        if (values.length != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.ASM.toString().equalsIgnoreCase(values[1])) {
            throw new ASMException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceLiterals.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = values[1];
        try {
            if (mode == EntityOperations.EntityOpsMode.Local) {
                this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().getResource(nameAttr, mode);
                this.m_presence = ASMPresence.NONE;
            } else {
                this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
                ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceLiterals.TYPE.name());
                Trace.out((String)("Resource type is " + attr.getValue()));
                String type = attr.getValue();
                CRSResourceTypeEntity baseResType = CRSFactoryImpl.getInstance().getResourceTypeEntity(attr);
                String baseType = baseResType.getAttribute(ResourceLiterals.BASE_TYPE.toString()).getValue();
                Trace.out((String)("Resource base type is " + baseType));
                if (baseType.equals(ResourceType.LocalASM.NAME.toString())) {
                    Trace.out((String)"Setting ASMPresence to LEGACY");
                    this.m_presence = ASMPresence.LEGACY;
                } else if (baseType.equals(ResourceType.ClusterASM.NAME.toString())) {
                    Trace.out((String)"Setting ASMPresence to FLEX");
                    this.m_presence = ASMPresence.REMOTE;
                } else {
                    Trace.out((String)"ASM base type is not set to local_asm or cluster_asm. Setting ASMPresence to NONE");
                    this.m_presence = ASMPresence.NONE;
                }
            }
        }
        catch (NotExistsException attr) {
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    void create(Version version) throws AlreadyExistsException, ASMException {
        this.createHelper(null, null, null, version);
    }

    void create(String pwfile, Version version) throws AlreadyExistsException, ASMException {
        this.createHelper(null, pwfile, null, null, version);
    }

    void create(Listener lsnr, Version version) throws AlreadyExistsException, ASMException {
        this.createHelper(lsnr, null, null, version);
    }

    void create(Listener lsnr, String pwfile, Version version) throws AlreadyExistsException, ASMException {
        this.createHelper(lsnr, pwfile, null, null, version);
    }

    void create(Listener lsnr, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        this.createHelper(lsnr, spfile, diskString, version);
    }

    void create(Listener lsnr, String pwfile, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        this.createHelper(lsnr, pwfile, spfile, diskString, version);
    }

    private void createHelper(Listener lsnr, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        this.createHelper(lsnr, null, spfile, diskString, version);
    }

    private void createHelper(Listener lsnr, String pwfile, String spfile, String diskString, Version version) throws AlreadyExistsException, ASMException {
        Trace.out((String)"Create helper for ASM");
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute asmLocalTypeAttr = crsFactory.create(ResourceLiterals.NAME.name(), ResourceLiterals.ASM_LOCAL_TYPE.toString());
            ResourceAttribute asmTypeAttr = crsFactory.create(ResourceLiterals.NAME.name(), ResourceLiterals.ASM_TYPE.toString());
            if (crsFactory.isRegistered(ResourceLiterals.ASM_RES_NAME.toString(), CRSEntity.Type.Resource)) {
                Trace.out((String)"Forcing AlreadyExistsException for ora.asm...");
                throw new AlreadyExistsException((MessageKey)PrCaMsgID.ASM_ALREADY_EXISTS, new Object[0]);
            }
            ASMImpl.deleteASMType();
            ASMImpl.createASMType(true);
            if (!m_isCluster) {
                Trace.out((String)"ensuring that ora.cssd exists");
                if (!crsFactory.isRegistered(ResourceLiterals.CSSD_RESOURCE.toString(), CRSEntity.Type.Resource)) {
                    throw new ASMException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, ResourceLiterals.CSSD_RESOURCE.toString());
                }
            }
            List attrList = crsFactory.getResourceTypeEntity(asmLocalTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile((List)attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(asmTypeAttr.getName())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceLiterals.TYPE.toString())) {
                    attr.setValue(ResourceLiterals.ASM_TYPE.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.LocalASM.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.ASM_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.Database.SPFILE.name()) && spfile != null) {
                    attr.setValue(spfile);
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.LocalASM.PWFILE.name()) && pwfile != null) {
                    attr.setValue(pwfile);
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceLiterals.ASM_DISKSTRING.name()) || diskString == null) continue;
                attr.setValue(diskString);
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            ResourceDependency weakDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.Listener.NAME.name(), lsnr != null ? lsnr.getName() : ListenerImpl.getResourceName((String)ResourceLiterals.LISTENER.name())), ResourceDependency.DepType.WEAK_DEP, new ResourceDependency.DepModifier[0]);
            if (m_isCluster) {
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{weakDep})));
            } else {
                ResourceAttribute cssdAttr = crsFactory.create(ResourceType.LocalResource.NAME.name(), ResourceLiterals.CSSD_RESOURCE.toString());
                ResourceDependency hardDep = crsFactory.createResourceDependency(cssdAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{hardDep, weakDep})));
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{hardDep})));
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_CREATE_FAILED, e, this.getUserAssignedName(), this.m_nameAttr.getValue());
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws ASMException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions((ResourcePermissions)perm);
            }
        }
        catch (CRSException e) {
            throw new ASMException(e);
        }
    }

    @Override
    public ASMPresence getPresence() throws ASMException {
        return this.m_presence;
    }

    @Override
    public String getPWFileBackup() throws ASMException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.ClusterASM.PWFILE_BACKUP.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_PWFILE_BACKUP_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public String getPWFile() throws ASMException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.LocalASM.PWFILE.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_PWFILE_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void setPWFile(String pwfile) throws ASMException {
        if (pwfile == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "pwfile", pwfile);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.PWFILE.name(), pwfile));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_PWFILE_FAILED, e, pwfile, this.getUserAssignedName());
        }
    }

    @Override
    public String getSPFile() throws ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        try {
            return this.m_crsResource.getAttribute(ResourceType.Database.SPFILE.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_SPFILE_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void setSPFile(String spfile) throws ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        if (spfile == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "spfile", spfile);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.SPFILE.name(), spfile));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_SPFILE_FAILED, e, spfile, this.getUserAssignedName());
        }
    }

    @Override
    public String getDiskString() throws ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        try {
            return this.m_crsResource.getAttribute(ResourceLiterals.ASM_DISKSTRING.name()).getValue();
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_DISKSTRING_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void setDiskString(String diskString) throws ASMException {
        if (m_isCluster) {
            throw new ASMException((MessageKey)PrCaMsgID.API_NOT_SUPPORTED_CLUSTER, new Object[0]);
        }
        if (diskString == null) {
            throw new ASMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "diskString", diskString);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceLiterals.ASM_DISKSTRING.name(), diskString));
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.SET_DISKSTRING_FAILED, e, diskString, this.getUserAssignedName());
        }
    }

    @Override
    public Map<String, String> getParameters() throws NotExistsException, ASMException {
        throw new NotExistsException((MessageKey)PrCaMsgID.PARAMS_NOT_USED, new Object[]{this.getUserAssignedName(), "PLEASE DO NOT CALL THIS API ANYMORE"});
    }

    @Override
    public List<ASMInstance> allInstances() throws ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.NAME.name(), this.getName());
            Trace.out((String)("getName=" + this.getName()));
            return this.getInstances(nameFilter);
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public List<ASMInstance> instances() throws AlreadyStoppedException, ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter resFilter = FilterFactoryImpl.getFilter4RunningResource((CRSResource)this.m_crsResource, null);
            List<ASMInstance> asmInstList = this.getInstances(resFilter);
            if (asmInstList.size() == 0) {
                throw new AlreadyStoppedException((MessageKey)PrCaMsgID.NO_RUNNING_ASMINSTANCE, new Object[]{this.getUserAssignedName()});
            }
            return asmInstList;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    private List<ASMInstance> getInstances(Filter filter) throws ASMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String nodeAttr = ResourceLiterals.CRS_LAST_SERVER.toString();
            String instAttr = ResourceType.LocalASM.USR_ORA_INST_NAME.name();
            Map resultData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, true, filter, new String[]{nodeAttr, instAttr});
            ServerFactoryImpl sfImpl = ServerFactoryImpl.getInstance();
            LinkedList<ASMInstance> asmInstList = new LinkedList<ASMInstance>();
            for (String riID : resultData.keySet()) {
                Map result = (Map)resultData.get(riID);
                String instName = (String)result.get(instAttr);
                String nodeName = (String)result.get(nodeAttr);
                asmInstList.add(new ASMInstanceImpl(this, instName, sfImpl.getNode(nodeName, false), m_isCluster));
            }
            return asmInstList;
        }
        catch (CRSException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new ASMException((MessageKey)PrCaMsgID.GET_ASMINSTANCE_LIST_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void start(Node node) throws AlreadyRunningException, ASMException {
        try {
            super.start(node);
        }
        catch (SoftwareModuleException e) {
            throw new ASMException(e);
        }
    }

    @Override
    public void start(ArrayList<StartOptions> startupOptions) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        if (startupOptions == null || startupOptions.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"startupOptions", startupOptions});
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StartOptions[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_OPEN_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.start(options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    @Override
    public void start(List<Node> nodes, List<StartOptions> startupOptions) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        if (nodes == null || nodes.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"nodes", nodes});
        }
        if (startupOptions == null || startupOptions.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"startupOptions", startupOptions});
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StartOptions[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_OPEN_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.start(nodes, options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_STOP_MODE.name(), StopOptions.ABORT.toString())};
                this.m_crsResource.stop(true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(false);
        }
    }

    @Override
    public void stop(List<Node> nodeList, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"nodeList"});
        }
        if (force) {
            try {
                ResourceAttribute[] attrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_STOP_MODE.name(), StopOptions.ABORT.toString())};
                this.m_crsResource.stop(nodeList, true, attrs);
            }
            catch (CRSException e) {
                throw new SoftwareModuleException((Throwable)e);
            }
        } else {
            super.stop(nodeList, false);
        }
    }

    @Override
    public void stop(List<Node> nodeList, List<StopOptions> stopOptions, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"nodeList"});
        }
        if (stopOptions == null || stopOptions.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"stopOptions", stopOptions});
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StopOptions[] soarr = stopOptions.toArray(new StopOptions[stopOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_STOP_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.stop(nodeList, force, options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    @Override
    public void stop(ArrayList<StopOptions> stopOptions, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (stopOptions == null || stopOptions.size() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"stopOptions", stopOptions});
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            StopOptions[] soarr = stopOptions.toArray(new StopOptions[stopOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.LocalASM.USR_ORA_STOP_MODE.name(), Utils.getEnumString((Enum[])soarr, (String)String.valueOf(" ")));
            this.m_crsResource.stop(force, options);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove(boolean force) throws AlreadyRunningException, ASMException {
        String lockKey;
        ClusterLock clusterLock;
        block12: {
            clusterLock = null;
            ASMTreeDefinition asmTreeDef = new ASMTreeDefinition();
            String asmRootKey = asmTreeDef.getASMRootKey();
            lockKey = "SRVM.ASM." + asmRootKey;
            try {
                super.remove(force);
                if (!m_isCluster) break block12;
                OCR ocr = OCR.init((int)7, (Version)new Version());
                clusterLock = new ClusterLock();
                Trace.out((String)("Acquiring exclusive CSS lock " + lockKey));
                clusterLock.acquire(lockKey);
                String[] subKeys = ocr.listSubKeys(asmRootKey, false);
                if (subKeys != null) {
                    for (String key : subKeys) {
                        Trace.out((String)("key = " + key));
                        ocr.deleteKey(asmRootKey + "." + key, true);
                    }
                }
            }
            catch (OCRException e) {
                try {
                    throw new ASMException((MessageKey)PrCaMsgID.ASM_REMOVE_FAILED, e, this.getName(), this.getUserAssignedName());
                    catch (ClusterLockException e2) {
                        throw new ASMException((MessageKey)PrCaMsgID.ASM_REMOVE_FAILED, e2, this.getName(), this.getUserAssignedName());
                    }
                    catch (SoftwareModuleException e3) {
                        throw new ASMException((MessageKey)PrCaMsgID.ASM_REMOVE_FAILED, e3, this.getName(), this.getUserAssignedName());
                    }
                }
                catch (Throwable throwable) {
                    Trace.out((String)("Releasing exclusive CSS lock " + lockKey));
                    try {
                        if (clusterLock == null) throw throwable;
                        clusterLock.release(lockKey);
                        throw throwable;
                    }
                    catch (ClusterLockException e4) {
                        throw new ASMException((MessageKey)PrCaMsgID.ASM_REMOVE_FAILED, e4, this.getName(), this.getUserAssignedName());
                    }
                }
            }
        }
        Trace.out((String)("Releasing exclusive CSS lock " + lockKey));
        try {
            if (clusterLock == null) return;
            clusterLock.release(lockKey);
            return;
        }
        catch (ClusterLockException e) {
            throw new ASMException((MessageKey)PrCaMsgID.ASM_REMOVE_FAILED, e, this.getName(), this.getUserAssignedName());
        }
    }

    public static String getResourceName() {
        return ResourceLiterals.ASM_RES_NAME.toString();
    }

    public static String getResourceType() {
        return ResourceLiterals.ASM_TYPE.toString();
    }

    public static void deleteASMType() throws CRSException {
        Trace.out((String)"Deleting ora.asm.type if it exists...");
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        ResourceAttribute asmTypeAttr = crsFactory.create(ResourceLiterals.NAME.name(), ASMImpl.getResourceType());
        if (crsFactory.isRegistered(asmTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
            Trace.out((String)"Deleting ora.asm.type...");
            CRSResourceTypeEntity asmResType = crsFactory.getResourceTypeEntity(asmTypeAttr);
            asmResType.unregister(true);
        }
    }

    public static void createASMType(boolean isLocal) throws CRSException, AlreadyExistsException {
        Trace.out((String)("Creating ora.asm.type..., isLocal=" + isLocal));
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        ResourceAttribute asmTypeAttr = crsFactory.create(ResourceLiterals.NAME.name(), ASMImpl.getResourceType());
        ArrayList<ResourceAttribute> baseList = new ArrayList<ResourceAttribute>();
        String bType = ResourceType.LocalASM.NAME.toString();
        if (!isLocal) {
            bType = ResourceType.ClusterASM.NAME.toString();
        }
        ResourceAttribute baseLocalAttr = crsFactory.create(ResourceLiterals.BASE_TYPE.name(), bType);
        Trace.out((String)("Base name=" + baseLocalAttr.getName() + ", base value=" + baseLocalAttr.getValue()));
        baseList.add(asmTypeAttr);
        baseList.add(baseLocalAttr);
        try {
            if (new Util().hasHAPrivilege()) {
                crsFactory.create(CRSEntity.Type.ResourceType, baseList, ResourceType.ACL_CREATOR.CRS_USER);
            } else {
                crsFactory.create(CRSEntity.Type.ResourceType, baseList);
            }
        }
        catch (UtilException e) {
            throw new CRSException((Throwable)e);
        }
    }
}

