/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.asm;

import java.util.Arrays;
import java.util.List;

public class FSEnums {

    public static enum PlatformEnum {
        WINDOWS("WINDOWS"){

            @Override
            public List<FSTypeEnum> supportedFSType() {
                FSTypeEnum[] supportedFS = new FSTypeEnum[]{FSTypeEnum.ACFS};
                return Arrays.asList(supportedFS);
            }
        }
        ,
        LINUX("Linux"){

            @Override
            public List<FSTypeEnum> supportedFSType() {
                FSTypeEnum[] supportedFS = new FSTypeEnum[]{FSTypeEnum.ACFS, FSTypeEnum.EXT3, FSTypeEnum.EXT4};
                return Arrays.asList(supportedFS);
            }
        }
        ,
        SOLARIS("Solaris"){

            @Override
            public List<FSTypeEnum> supportedFSType() {
                FSTypeEnum[] supportedFS = new FSTypeEnum[]{FSTypeEnum.ACFS};
                return Arrays.asList(supportedFS);
            }
        }
        ,
        SOLARIS_SUNOS("SunOS"){

            @Override
            public List<FSTypeEnum> supportedFSType() {
                FSTypeEnum[] supportedFS = new FSTypeEnum[]{FSTypeEnum.ACFS};
                return Arrays.asList(supportedFS);
            }
        }
        ,
        AIX("AIX"){

            @Override
            public List<FSTypeEnum> supportedFSType() {
                FSTypeEnum[] supportedFS = new FSTypeEnum[]{FSTypeEnum.ACFS};
                return Arrays.asList(supportedFS);
            }
        };

        private String m_value;

        private PlatformEnum(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public static PlatformEnum getMember(String value) {
            for (PlatformEnum member : PlatformEnum.values()) {
                if (!member.getValue().equalsIgnoreCase(value)) continue;
                return member;
            }
            throw new EnumConstantNotPresentException(PlatformEnum.class, value);
        }

        public abstract List<FSTypeEnum> supportedFSType();
    }

    public static enum AutostartEnum {
        ALWAYS("always"),
        NEVER("never"),
        RESTORE("restore");

        private String m_value;

        private AutostartEnum(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public static AutostartEnum getMember(String value) {
            for (AutostartEnum member : AutostartEnum.values()) {
                if (!member.getValue().equalsIgnoreCase(value)) continue;
                return member;
            }
            throw new EnumConstantNotPresentException(AutostartEnum.class, value);
        }
    }

    public static enum FSTypeEnum {
        ACFS("acfs"),
        NTFS("ntfs"),
        ZFS("zfs"),
        JFS("jfs"),
        EXT3("ext3"),
        EXT4("ext4");

        private String m_value;

        private FSTypeEnum(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public static FSTypeEnum getMember(String value) {
            for (FSTypeEnum member : FSTypeEnum.values()) {
                if (!member.getValue().equalsIgnoreCase(value)) continue;
                return member;
            }
            throw new EnumConstantNotPresentException(FSTypeEnum.class, value);
        }
    }
}

