/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiin;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiin.OiinNICInfo;

public class OiinNetOps {
    private ArrayList m_saNICInfo;
    private String m_sHostName;
    private String m_sHostAddress;
    protected static OiinNetOps _sNetOps;
    private boolean m_bCanUseHostName = true;
    private static final String DEFAULT_HOST = "localHost";
    private static final String DEFAULT_IP = "127.0.0.1";
    private static final String DOT = ".";

    private OiinNetOps() {
        this.computeNICList();
        this.computeHostInfo();
    }

    public static OiinNetOps getNetOps() {
        if (_sNetOps == null) {
            _sNetOps = new OiinNetOps();
        }
        return _sNetOps;
    }

    private void computeNICList() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            NetworkInterface niLocal = NetworkInterface.getByInetAddress(ia);
            this.m_saNICInfo = new ArrayList();
            this.addNICInfo(niLocal);
            Enumeration<NetworkInterface> enum_1 = NetworkInterface.getNetworkInterfaces();
            while (enum_1.hasMoreElements()) {
                NetworkInterface ni = enum_1.nextElement();
                this.addNICInfo(ni);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error err) {
            this.m_bCanUseHostName = false;
        }
    }

    private void addNICInfo(NetworkInterface ni) throws Exception {
        InetAddress ia;
        boolean bLoopBack = false;
        String sNIC = ni.getDisplayName();
        Enumeration<InetAddress> enum_1 = ni.getInetAddresses();
        while (enum_1.hasMoreElements() && !(ia = enum_1.nextElement()).isLoopbackAddress()) {
            OiinNICInfo oInfo = new OiinNICInfo(ia.getHostName(), ia.getHostAddress(), sNIC);
            if (this.m_saNICInfo.contains(oInfo)) continue;
            this.m_saNICInfo.add(oInfo);
        }
    }

    public String getHostName() {
        return this.m_sHostName;
    }

    public String getHostAddress() {
        return this.m_sHostAddress;
    }

    public boolean hasMultipleNICs() {
        if (this.m_saNICInfo == null) {
            return false;
        }
        return this.m_saNICInfo.size() > 1;
    }

    public ArrayList getAllNICInfo() {
        return this.m_saNICInfo;
    }

    private void computeHostInfo() {
        this.m_sHostName = DEFAULT_HOST;
        this.m_sHostAddress = DEFAULT_IP;
        try {
            InetAddress local = InetAddress.getLocalHost();
            if (local != null) {
                local = InetAddress.getByName(local.getHostAddress());
                this.m_sHostName = local.getHostName();
                this.m_sHostAddress = local.getHostAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isFQDN(String sHostName) {
        boolean bRet = OiinNetOps.isValidHostName(sHostName);
        if (!bRet) {
            return false;
        }
        StringTokenizer strTok = new StringTokenizer(sHostName, DOT);
        int nToks = strTok.countTokens();
        return nToks > 1;
    }

    public static boolean isValidHostName(String sHostName) {
        if (sHostName == null || sHostName.trim().length() == 0) {
            return false;
        }
        if (sHostName.startsWith(DOT) || sHostName.endsWith(DOT)) {
            return false;
        }
        if (sHostName.trim().indexOf(" ") != -1) {
            return false;
        }
        StringTokenizer strTok = new StringTokenizer(sHostName, DOT, true);
        int nToks = strTok.countTokens();
        if (nToks == 0) {
            return true;
        }
        boolean bInvalidToken = false;
        String sPrevTkn = "";
        while (strTok.hasMoreTokens()) {
            String stkn = strTok.nextToken();
            if (stkn == null || stkn.length() == 0 || sPrevTkn.equals(DOT) && stkn.equals(DOT)) {
                bInvalidToken = true;
                break;
            }
            sPrevTkn = stkn;
        }
        return !bInvalidToken;
    }

    public String ping(String sHost) {
        String sHostAddress = null;
        try {
            InetAddress ia = InetAddress.getByName(sHost);
            sHostAddress = ia.getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sHostAddress;
    }

    public void setHostName(String sHostName) {
        this.m_sHostName = sHostName;
        try {
            InetAddress ia = InetAddress.getByName(sHostName);
            this.m_sHostAddress = ia.getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHostAddress(String sHostAddress) {
        this.m_sHostAddress = sHostAddress;
    }

    public String[] getAllHostNames() {
        String[] sHosts = null;
        if (this.m_saNICInfo == null || this.m_saNICInfo.size() == 0) {
            sHosts = new String[]{this.m_sHostName};
        } else {
            int len = this.m_saNICInfo.size();
            ArrayList<String> alHosts = new ArrayList<String>(len);
            alHosts.add(this.m_sHostName);
            for (int i = 0; i < len; ++i) {
                OiinNICInfo oInfo = (OiinNICInfo)this.m_saNICInfo.get(i);
                String sHost = oInfo.getHostName();
                if (sHost.equals(this.m_sHostName)) continue;
                alHosts.add(sHost);
            }
            len = alHosts.size();
            sHosts = new String[len];
            for (int j = 0; j < len; ++j) {
                sHosts[j] = (String)alHosts.get(j);
            }
        }
        return sHosts;
    }

    public String getDomainName(String sHostName) {
        String retVal = "";
        int dotPos = sHostName.indexOf(46);
        if (dotPos != -1) {
            retVal = sHostName.substring(dotPos + 1);
        }
        return retVal;
    }

    public boolean canUseHostName() {
        return this.m_bCanUseHostName;
    }
}

