/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.cluster.verification.DiskInfoResultSet;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.HAHomeNotFoundException;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

class sVerificationUtil {
    static final String INVENTORY_LOC_PROPERTY = "inventory_loc";
    static final String INVENTORY_XML_PATH_EXTENSION = VerificationConstants.FILE_SEPARATOR + "ContentsXML" + VerificationConstants.FILE_SEPARATOR + "inventory.xml";
    static final String ORACLE_SRVM_REMOTESHELL = "ORACLE_SRVM_REMOTESHELL";
    static final String ORACLE_SRVM_REMOTECOPY = "ORACLE_SRVM_REMOTECOPY";
    static final String SRVM_PROPERTY_REMOTESHELL = "oracle.srvm.remoteshell";
    static final String SRVM_PROPERTY_REMOTECOPY = "oracle.srvm.remotecp";
    static final String DEFAULT_SSH_LOC = "CV_DEFAULT_SSH_LOC";
    static final String DEFAULT_SCP_LOC = "CV_DEFAULT_SCP_LOC";
    static final String OS_VER_COMPAT_XML_FILENAME = "usm_oscompat.xml";
    static final String LS_C1_COMMAND = "ls -dc1 ";
    static final String NEW_LINE_STRING = "\\n";
    static final String WILD_CARD_CHARACTER = "*";
    static final String USM_DRIVER_SCRIPT = "acfsdriverstate";
    static final String STR_USMDEV_OWNER = "root";
    static final String STR_USMDEV_PERMS = "0770";
    static final String TZ_FILE_LOC = "/usr/share/lib/zoneinfo/";
    static final String CSSDPATH = "/etc/init.d/init.cssd";
    static final String SCINSTALL = "/usr/cluster/bin/scinstall";
    static final String ROOT_USER = "root";
    static final String EXADATA_FILE = "/opt/oracle.cellos/ORACLE_CELL_OS_IS_SETUP";
    static final String[] ODA_FILE_ARR = new String[]{"/opt/oracle/extapi/64/liboak.1.so", "opt/oracle/extapi/64/oak/liboak.1.so"};
    static final String ZONENAME_CMD = "/sbin/zonename";
    static final String ZONEADM_CMD = "/usr/sbin/zoneadm list -p";
    static final String GLOBAL_ZONE_STR = "global";
    static final String KERNEL_BRAND_STR = "solaris-kz";
    static final String DEFAULT_ASM_DISKS = "/dev/rdsk/*";
    static final String asmLibScriptPath = "/etc/init.d/oracleasm";
    static final String asmLibMountPath = "/dev/oracleasm";
    private static final String INVENTORY_GROUP_PROPERTY = "inst_group";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static String[] m_supportedArchs = new String[]{"sparc", "i386", "sparcv9"};
    private static final String ARCH_COMMAND = "/bin/uname -p";
    private static final String XVINFO_COMMAND = "/usr/openwin/bin/xdpyinfo";
    private static final String m_afdDriverStateCommand = new SystemFactory().CreateSystem().getExeName("afddriverstate");
    private static final String m_afdToolCommand = new SystemFactory().CreateSystem().getExeName("afdtool");
    private static final String CFTOOL_FILE = "/usr/bin/cftool";
    private static final String CFTOOL_FILE_CMD = "/usr/bin/cftool -l";

    protected sVerificationUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getInventoryFileLocation() throws InvalidOUIInventoryDataException {
        String invCfgFilePtr = sVerificationUtil.getInventoryConfigFilePointer();
        Trace.out((String)("Inventory Config File's name is:'" + invCfgFilePtr + "'"));
        String errMsg = null;
        File configFile = new File(invCfgFilePtr);
        if (!configFile.exists()) {
            Trace.out((String)("Inventory Config File '" + invCfgFilePtr + "' doesn't exist"));
            errMsg = s_msgBundle.getMessage("4025", true, (Object[])new String[]{invCfgFilePtr});
            ReportUtil.processAlert(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + errMsg);
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile.getAbsolutePath());
            Properties props = new Properties();
            props.load(fis);
            Enumeration<?> e = props.propertyNames();
            String propName = null;
            String propValue = null;
            while (e.hasMoreElements()) {
                propName = (String)e.nextElement();
                propValue = props.getProperty(propName);
                if (!propName.trim().equalsIgnoreCase(INVENTORY_LOC_PROPERTY)) continue;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)(propName + "=" + propValue));
                }
                String invFileLocation = propValue + INVENTORY_XML_PATH_EXTENSION;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Inventory File Location is-->" + invFileLocation));
                }
                String string = invFileLocation;
                return string;
            }
        }
        catch (IOException e) {
            Trace.out((String)("IOEXCEPTION: " + e));
            errMsg = s_msgBundle.getMessage("4026", true, (Object[])new String[]{invCfgFilePtr});
            ReportUtil.processAlert(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + errMsg);
        }
        finally {
            block19: {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (!Trace.isLevelEnabled((int)5)) break block19;
                        Trace.out((Exception)e);
                    }
                }
            }
        }
        errMsg = s_msgBundle.getMessage("4027", false, (Object[])new String[]{INVENTORY_GROUP_PROPERTY, invCfgFilePtr});
        ReportUtil.processAlert(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + errMsg);
        return null;
    }

    public static String getInventoryConfigFilePointer() {
        return "/var/opt/oracle/oraInst.loc";
    }

    public static String getUniqueDistributionID(Result result) {
        String cmdOutputStr;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Inside getUniqueDistributionID() ");
        }
        String[] cmd = new String[]{"/usr/bin/uname", "-r"};
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        String[] output = runtimeExec.getOutput();
        String[] error = runtimeExec.getError();
        String commandStr = cmd[0] + " " + cmd[1];
        String cmdError = error != null ? VerificationUtil.strArr2String(error) : "";
        String string = cmdOutputStr = output != null ? VerificationUtil.strArr2String(output) : "";
        if (runtimeExec.getExitValue() != 0) {
            Trace.out((String)("Non-zero exit status for cmd: " + cmd[0]));
            String errorMsg = "";
            if (!VerificationUtil.isStringGood(cmdError) && !VerificationUtil.isStringGood(cmdOutputStr)) {
                errorMsg = s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{commandStr, VerificationUtil.getLocalNode(), Integer.toString(runtimeExec.getExitValue())});
            } else {
                errorMsg = s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{commandStr, VerificationUtil.getLocalNode(), Integer.toString(runtimeExec.getExitValue())});
                if (VerificationUtil.isStringGood(cmdError)) {
                    errorMsg = errorMsg + VerificationConstants.LSEP + cmdError;
                }
                if (VerificationUtil.isStringGood(cmdOutputStr)) {
                    errorMsg = errorMsg + VerificationConstants.LSEP + cmdOutputStr;
                }
            }
            errorMsg = s_gMsgBundle.getMessage("0282", true) + VerificationConstants.LSEP + errorMsg;
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errorMsg));
            VerificationLogData.logError(errorMsg);
            return null;
        }
        if (output != null && output.length > 0) {
            result.setStatus(1);
            for (int j = 0; j < output.length; ++j) {
                VerificationLogData.logError(output[j]);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)output[j]);
            }
            VerificationLogData.logInfo("DistributionID:" + output[0]);
            return output[0];
        }
        Trace.out((String)"The command \"uname -r\" output is empty");
        result.setStatus(2);
        result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{commandStr, VerificationUtil.getLocalNode(), Integer.toString(runtimeExec.getExitValue())})));
        return "";
    }

    public static void getExecutionEnvironment() throws InvalidEnvironmentException {
        boolean bSshonly;
        String remoteCopyFileName;
        String remoteShellFileName;
        block20: {
            String fileName;
            File userFile;
            Object[] fileArg;
            remoteShellFileName = null;
            remoteCopyFileName = null;
            String val = VerificationUtil.getConfiguredValue(ORACLE_SRVM_REMOTESHELL, true);
            if (val != null && val.trim().length() != 0) {
                fileArg = new String[]{val};
                userFile = new File(val);
                fileName = userFile.getName();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("User specified remote shell command=" + val));
                }
                if (!fileName.equals("ssh") && !fileName.equals("rsh")) {
                    throw new InvalidEnvironmentException(MessageBundle.getMessageBundle((String)"Prkc").getMessage("1042", false, fileArg));
                }
                if (!userFile.exists()) {
                    throw new InvalidEnvironmentException(s_msgBundle.getMessage("0040", true, fileArg));
                }
                if (!userFile.isFile()) {
                    throw new InvalidEnvironmentException(s_msgBundle.getMessage("0041", true, fileArg));
                }
                remoteShellFileName = fileName;
                System.setProperty(SRVM_PROPERTY_REMOTESHELL, val);
            }
            if ((val = VerificationUtil.getConfiguredValue(ORACLE_SRVM_REMOTECOPY, true)) != null && val.trim().length() != 0) {
                fileArg = new String[]{val};
                userFile = new File(val);
                fileName = userFile.getName();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("User specified remote copy command=" + val));
                }
                if (!fileName.equals("scp") && !fileName.equals("rcp")) {
                    throw new InvalidEnvironmentException(MessageBundle.getMessageBundle((String)"Prkc").getMessage("1043", false, fileArg));
                }
                if (!userFile.exists()) {
                    throw new InvalidEnvironmentException(s_msgBundle.getMessage("0042", true, fileArg));
                }
                if (!userFile.isFile()) {
                    throw new InvalidEnvironmentException(s_msgBundle.getMessage("0051", true, fileArg));
                }
                remoteCopyFileName = fileName;
                System.setProperty(SRVM_PROPERTY_REMOTECOPY, val);
            }
            bSshonly = false;
            try {
                ParamManager pm = ParamManager.getInstance();
                bSshonly = pm.checkArgSshonly();
            }
            catch (UninitializedParamManagerException e) {
                if (!Trace.isLevelEnabled((int)5)) break block20;
                Trace.out((Exception)e);
            }
        }
        if (bSshonly) {
            if (remoteShellFileName == null || remoteShellFileName != null && remoteShellFileName.equalsIgnoreCase("ssh")) {
                if (remoteShellFileName == null) {
                    String sshLoc = VDMUtil.getDefaultSsh();
                    System.setProperty(SRVM_PROPERTY_REMOTESHELL, sshLoc);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("==== SSH Location set as :" + sshLoc));
                    }
                }
                if (remoteCopyFileName == null || !remoteCopyFileName.equalsIgnoreCase("scp")) {
                    String scpLoc = VDMUtil.getDefaultScp();
                    System.setProperty(SRVM_PROPERTY_REMOTECOPY, scpLoc);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("==== SCP Location set as :" + scpLoc));
                    }
                }
            } else if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"==== Ignored sshonly flag since the specified remote shell was not SSH");
            }
        }
    }

    public static String getCurrentGroup() throws InvalidEnvironmentException {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String curGrp = null;
        try {
            curGrp = nativeSys.getEffectiveGroup();
        }
        catch (NativeException ne) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"getEffectiveGroup failed!");
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((Exception)((Object)ne));
            }
            String errorMsg = s_gMsgBundle.getMessage("0281", true);
            if (VerificationUtil.isStringGood(ne.getMessage())) {
                errorMsg = errorMsg + VerificationUtil.LSEP + ne.getMessage();
            }
            VerificationUtil.traceAndLogError(errorMsg);
            throw new InvalidEnvironmentException(errorMsg);
        }
        return curGrp;
    }

    public static String getPreReqXmlPath() throws XmlFilePathException {
        String xmlFile = VerificationUtil.getEnv("CV_PREREQ_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_PREREQ_XML");
        }
        return xmlFile;
    }

    public static String getCompSoftwareConfigXmlPath() throws XmlFilePathException {
        String xmlFile = VerificationUtil.getEnv("CV_SOFTWARE_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_SOFTWARE_XML");
        }
        if (xmlFile == null) {
            throw new XmlFilePathException("Unable to find the location for comp software config xml file." + VerificationConstants.LINE_SEPARATOR + "Set CV_SOFTWARE_XML environment variable to the correct location.");
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("software distribution config xml file is: '" + xmlFile + "'"));
        }
        return xmlFile;
    }

    public static String getOSVersionCompatXmlPath() {
        String xmlFile = VerificationUtil.getEnv("CV_OSVERCOMPAT_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_OSVERCOMPAT_XML");
        }
        if (xmlFile == null) {
            String s_fsep = System.getProperty("file.separator");
            String cvhome = VerificationUtil.getCVHome();
            xmlFile = cvhome + "cv" + s_fsep + "cvdata" + s_fsep + OS_VER_COMPAT_XML_FILENAME;
        }
        Trace.out((String)("====  File listing supported OS versions for USM: " + xmlFile));
        return xmlFile;
    }

    public static String resolve(CVUVariableConstants variable) {
        String returnValue = null;
        boolean condRes = false;
        switch (variable) {
            case SHELL: {
                String shellPath = VerificationUtil.getEnv("SHELL");
                String[] shellPathArr = shellPath.split(File.separator);
                returnValue = shellPathArr[shellPathArr.length - 1].toUpperCase();
                break;
            }
            case PROCESSOR_NAME: {
                returnValue = sVerificationUtil.getProcessorName();
                break;
            }
            case KERNEL_RELEASE: {
                returnValue = sVerificationUtil.getKernelRelease();
                break;
            }
            case SUNCLUSTER: {
                condRes = sVerificationUtil.isSUNCLUSTERConfigured();
                returnValue = Boolean.toString(condRes);
                break;
            }
            case SUNCLUSTER_3_2: {
                condRes = sVerificationUtil.isSunCluster32();
                returnValue = Boolean.toString(condRes);
                break;
            }
            case ISO8859_1: {
                condRes = sVerificationUtil.isISO88591Exists();
                returnValue = Boolean.toString(condRes);
                break;
            }
            case ISO8859_15: {
                condRes = sVerificationUtil.isISO885915Exists();
                returnValue = Boolean.toString(condRes);
                break;
            }
            default: {
                Trace.out((String)("condition variable " + variable.name() + " not handled "));
            }
        }
        return returnValue;
    }

    public static String getKernelRelease() {
        String[] output = null;
        String osReleaseCmd = "/usr/bin/uname -r";
        String[] cmd = new String[]{"/usr/bin/sh", "-c", osReleaseCmd};
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        String[] error = runtimeExec.getError();
        output = runtimeExec.getOutput();
        if (runtimeExec.getExitValue() != 0) {
            VerificationLogData.logError(cmd[0]);
            if (Trace.isLevelEnabled((int)1)) {
                int j;
                Trace.out((String)("Non-zero exit status for cmd: " + cmd[0]));
                if (output != null && output.length != 0) {
                    for (j = 0; j < output.length; ++j) {
                        VerificationLogData.logError(output[j]);
                        Trace.out((int)5, (String)output[j]);
                    }
                }
                if (error != null && error.length != 0) {
                    for (j = 0; j < error.length; ++j) {
                        VerificationLogData.logError(error[j]);
                        Trace.out((int)5, (String)error[j]);
                    }
                }
            }
        }
        if (output == null || output.length == 0 || output[0] == null || output[0].length() == 0) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Command output is empty");
                Trace.out((String)"Could not retrieve kernel release");
            }
            return null;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("The command output is: '" + output[0] + "'"));
        }
        String osRelease = output[0];
        return osRelease;
    }

    private static String getProcessorName() {
        return "smp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOraInventoryGroup() {
        String invCfgFilePtr = sVerificationUtil.getInventoryConfigFilePointer();
        Trace.out((String)("Inventory Config File's name is:'" + invCfgFilePtr + "'"));
        File configFile = new File(invCfgFilePtr);
        if (!configFile.exists()) {
            Trace.out((String)("Inventory Config File '" + invCfgFilePtr + "' doesn't exist"));
            ReportUtil.printError(s_msgBundle.getMessage("4025", true, (Object[])new String[]{invCfgFilePtr}));
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile.getAbsolutePath());
            Properties props = new Properties();
            props.load(fis);
            Enumeration<?> e = props.propertyNames();
            String propName = null;
            String propValue = null;
            while (e.hasMoreElements()) {
                propName = (String)e.nextElement();
                propValue = props.getProperty(propName);
                if (!propName.trim().equalsIgnoreCase(INVENTORY_GROUP_PROPERTY)) continue;
                Trace.out((String)("Oracle Inventory Group is-->" + propValue));
                String string = propValue.trim();
                return string;
            }
        }
        catch (IOException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(s_msgBundle.getMessage("4026", false, (Object[])new String[]{invCfgFilePtr}));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Trace.out((Exception)e);
                }
            }
        }
        ReportUtil.printError(s_msgBundle.getMessage("4027", false, (Object[])new String[]{INVENTORY_GROUP_PROPERTY, invCfgFilePtr}));
        return null;
    }

    public String[] getDefaultDiscoveryDevice(String version) {
        return new String[]{DEFAULT_ASM_DISKS};
    }

    public boolean containsWildCard(String path) {
        return path.contains(WILD_CARD_CHARACTER);
    }

    public String getFileListCommand() {
        return LS_C1_COMMAND;
    }

    public List<String> parseFileListOutput(String[] cmdOut) {
        List<String> fList = Arrays.asList(cmdOut);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Size of parsed output list is = " + fList.size()));
            for (int i = 0; i < fList.size(); ++i) {
                Trace.out((String)("Output " + i + " : " + fList.get(i)));
            }
        }
        return fList;
    }

    public String getUSMDriverScript() {
        return new String(USM_DRIVER_SCRIPT);
    }

    public String getUSMDeviceOwner() {
        return new String("root");
    }

    public String getDefaultUSMDevPerms() {
        return new String(STR_USMDEV_PERMS);
    }

    public static boolean isSUNCLUSTERConfigured() {
        String[] cmd = new String[]{"/usr/cluster/bin/scstat", "-n"};
        File f = new File(cmd[0]);
        if (!f.exists()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"==== File /usr/cluster/bin/scstat NOT PRESENT");
            }
            return false;
        }
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("==== exit status for cmd= " + runtimeExec.getExitValue()));
        }
        if (runtimeExec.getExitValue() != 0) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==== Non-zero exit status for cmd: " + cmd[0]));
            }
            return false;
        }
        String[] output = runtimeExec.getOutput();
        String[] error = runtimeExec.getError();
        if (output.length == 0) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)(cmd[0] + " result is empty"));
            }
            if (error.length != 0 && Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==== error> " + error[0]));
            }
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("==== output> " + output[0]));
        }
        return true;
    }

    public static boolean isSunCluster32() {
        String[] cmd = new String[]{SCINSTALL, "-p"};
        File f = new File(cmd[0]);
        if (!f.exists()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"==== File /usr/cluster/bin/scinstall NOT PRESENT, returning false.");
            }
            return false;
        }
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("==== exit status for cmd= " + runtimeExec.getExitValue()));
        }
        if (runtimeExec.getExitValue() != 0) {
            Trace.out((int)1, (String)"==== Non-zero exit status for cmd: %s, return false", (Object[])new Object[]{cmd[0]});
            return false;
        }
        String[] output = runtimeExec.getOutput();
        String[] error = runtimeExec.getError();
        if (output.length == 0) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)(cmd[0] + " result is empty"));
            }
            if (error.length != 0 && Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==== error> " + error[0]));
            }
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("==== output> " + output[0]));
        }
        return output[0].startsWith("3.2");
    }

    public static boolean isISO88591Exists() {
        block9: {
            String[] output;
            block8: {
                int j;
                String[] cmd = new String[]{"/usr/bin/locale", "-a"};
                output = null;
                String[] error = null;
                RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
                runtimeExec.runCommand();
                error = runtimeExec.getError();
                output = runtimeExec.getOutput();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("==== exit status for cmd= " + runtimeExec.getExitValue()));
                }
                if (runtimeExec.getExitValue() == 0) break block8;
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Non-zero exit status for cmd: " + cmd[0]));
                }
                if (output != null && output.length != 0) {
                    for (j = 0; j < output.length; ++j) {
                        if (!Trace.isLevelEnabled((int)1)) continue;
                        Trace.out((String)output[j]);
                    }
                }
                if (error == null || error.length == 0) break block9;
                for (j = 0; j < error.length; ++j) {
                    if (!Trace.isLevelEnabled((int)1)) continue;
                    Trace.out((String)error[j]);
                }
                break block9;
            }
            if (output != null && output.length != 0) {
                for (int j = 0; j < output.length; ++j) {
                    if (!output[j].matches(".*ISO8859-1$")) continue;
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("output=" + output[j]));
                        Trace.out((String)"==== ISO8859-1 locale exists");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isISO885915Exists() {
        block9: {
            String[] output;
            block8: {
                int j;
                String[] cmd = new String[]{"/usr/bin/locale", "-a"};
                output = null;
                String[] error = null;
                RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
                runtimeExec.runCommand();
                error = runtimeExec.getError();
                output = runtimeExec.getOutput();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("==== exit status for cmd= " + runtimeExec.getExitValue()));
                }
                if (runtimeExec.getExitValue() == 0) break block8;
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Non-zero exit status for cmd: " + cmd[0]));
                }
                if (output != null && output.length != 0) {
                    for (j = 0; j < output.length; ++j) {
                        if (!Trace.isLevelEnabled((int)1)) continue;
                        Trace.out((String)output[j]);
                    }
                }
                if (error == null || error.length == 0) break block9;
                for (j = 0; j < error.length; ++j) {
                    if (!Trace.isLevelEnabled((int)1)) continue;
                    Trace.out((String)error[j]);
                }
                break block9;
            }
            if (output != null && output.length != 0) {
                for (int j = 0; j < output.length; ++j) {
                    if (!output[j].matches(".*ISO8859-15$")) continue;
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("output=" + output[j]));
                        Trace.out((String)"==== ISO8859-15 locale exists");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean checkPlatform(String osname, String osarch) {
        boolean match = false;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\n osname: " + osname + " osarch: " + osarch));
        }
        if (!VerificationUtil.isStringGood(osname) || !VerificationUtil.isStringGood(osarch)) {
            Trace.out((String)"Returning false. Null OS name or Architecture passed");
            return match;
        }
        for (String arch : m_supportedArchs) {
            String archRegEx = arch.replaceAll("\\*", ".*");
            if (!Pattern.matches(archRegEx = archRegEx.replaceAll("\\?", ".?"), osarch)) continue;
            match = true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Match = " + match));
        }
        if (osname.equalsIgnoreCase(sVerificationUtil.getSupportedOSPlatform().getJavaOSName()) && match) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Return value = true");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Return value = false");
        }
        return false;
    }

    public static boolean checkPlatformOS(String osname) {
        if (osname.equalsIgnoreCase(sVerificationUtil.getSupportedOSPlatform().getJavaOSName())) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Return value = true");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Return value = false");
        }
        return false;
    }

    public static VerificationConstants.OSType getSupportedOSPlatform() {
        return VerificationConstants.OSType.SOLARIS;
    }

    public static String getSupportedArch() {
        return Arrays.toString(m_supportedArchs);
    }

    public static String getCurrentOS() {
        return System.getProperty("os.name");
    }

    public static String getCurrentArch() {
        String arch = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult result = new NativeResult();
        nativeSystem.runRemoteExecCmd(ARCH_COMMAND, null, null, result);
        if (result.getStatus()) {
            String[] res = result.getResultString();
            if (res != null & res.length > 0) {
                arch = VerificationUtil.strArr2List(res, "").trim();
            } else {
                Trace.out((String)"runCmd failed to return successful status");
            }
        } else {
            Trace.out((String)"runCmd failed to return successful status");
        }
        return arch;
    }

    public static void setFileDirPerm(String permStr, String fileDir) {
        String cmdToRun = "chmod " + permStr + " " + fileDir;
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmdToRun);
            int n = proc.waitFor();
        }
        catch (IOException e) {
            Trace.out((Exception)e);
        }
        catch (InterruptedException e) {
            Trace.out((Exception)e);
        }
    }

    public static float getCTSSOffsetLimit() {
        float f = 1000.0f;
        return f;
    }

    public static String getHAHomeWithException() throws HAHomeNotFoundException {
        File cnfgFile;
        Object haHome = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String olrFileName = nativeSys.getOLRConfigLocation("localnode", new Version());
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("olrFileName=" + olrFileName));
        }
        if (!(cnfgFile = new File(olrFileName)).exists()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(olrFileName + " does not exist"));
            }
            throw new HAHomeNotFoundException(s_msgBundle.getMessage("9406", false, new Object[]{new String(olrFileName)}));
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("configFile=" + cnfgFile.getAbsolutePath()));
        }
        try {
            String olrCrsHomePropertyValue = Utils.getPropertyValue((String)cnfgFile.getAbsolutePath(), (String)"crs_home", (boolean)true);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("crs_home=" + olrCrsHomePropertyValue));
            }
            return olrCrsHomePropertyValue;
        }
        catch (FileNotFoundException fnfe) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("FileNotFoundException is caught:" + fnfe.getMessage()));
            }
            throw new HAHomeNotFoundException(fnfe.getMessage());
        }
        catch (IOException ie) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"IO Exception is caught");
            }
            throw new HAHomeNotFoundException(ie.getMessage());
        }
    }

    public static String getLoginShell() {
        String user = System.getProperty("user.name");
        String[] output = null;
        String[] error = null;
        String[] cmd = new String[]{"/bin/sh", "-c", "(/bin/cat /etc/passwd;/usr/bin/ypcat passwd)|/bin/awk -F: '{if ($1==\"" + user + "\") {print $7;exit 0;} }'"};
        Trace.out((String)("cmd[2] is: " + cmd[2]));
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        error = runtimeExec.getError();
        output = runtimeExec.getOutput();
        if (runtimeExec.getExitValue() != 0 || output == null || output.length == 0) {
            int j;
            VerificationLogData.logError(cmd[0]);
            if (runtimeExec.getExitValue() != 0) {
                Trace.out((String)"Received non-zero exit status");
            }
            if (output != null && output.length != 0) {
                for (j = 0; j < output.length; ++j) {
                    VerificationLogData.logError(output[j]);
                    Trace.out((int)5, (String)output[j]);
                }
            } else {
                Trace.out((int)5, (String)"output is NULL/EMPTY");
            }
            if (error != null && error.length != 0) {
                for (j = 0; j < error.length; ++j) {
                    VerificationLogData.logError(error[j]);
                    Trace.out((int)5, (String)error[j]);
                }
            }
            return null;
        }
        Trace.out((String)("Login shell for user '" + user + "' is: " + output[0]));
        return output[0];
    }

    public static boolean isUDEVSupported() {
        if (sVerificationUtil.getCurrentOS().toLowerCase().startsWith("linux")) {
            Trace.out((String)"UDEV supported on this OS");
            return true;
        }
        return false;
    }

    public static String getCRSHome(String node, Result result) {
        ErrorDescription errDesc = null;
        String inventoryFile = null;
        OUIData ouid = null;
        sVerificationUtil sVerUtil = new sVerificationUtil();
        try {
            inventoryFile = sVerUtil.getInventoryFileLocation();
            ouid = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            errDesc = new ErrorDescription(e.getMessage());
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            return null;
        }
        if (ouid == null) {
            Trace.out((String)"sVerificationUtil::getCRSHome(node, result): ERROR instantiating the OUIData object");
            result.setStatus(2);
            return null;
        }
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String olrFileName = nativeSys.getOLRConfigLocation(node, new Version());
        boolean fileExist = false;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("sVerificationUtil::olrFileName=" + olrFileName));
        }
        try {
            fileExist = nativeSys.pathExists(node, olrFileName, 2);
        }
        catch (RemoteDirException rde) {
            Trace.out((String)rde.getMessage());
        }
        if (!fileExist) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(olrFileName + " does not exist, Hence considering pre-TB returning CRS Home of Local Node."));
            }
            result.setStatus(1);
            VerificationLogData.logInfo("ouid.CRSHome:" + ouid.getCRSHomeLocation());
            return ouid.getCRSHomeLocation();
        }
        if (!ouid.isCRSInstalledOnNode(node)) {
            Trace.out((String)("sVerificationUtil::CRS wasn't found installed  on node: " + node));
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7593", false, (Object[])new String[]{node}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        Trace.out((String)("sVerificationUtil::CRS found installed  on node: " + node));
        String olrCrsHome = null;
        olrCrsHome = sVerificationUtil.getOLRPropertyValue(node, "crs_home", result, true);
        if (VerificationUtil.isStringGood(olrCrsHome)) {
            result.setStatus(1);
        } else {
            result.setStatus(2);
        }
        VerificationLogData.logInfo("olrCRSHome:" + olrCrsHome);
        return olrCrsHome;
    }

    public static String getOLRPropertyValue(String nodeName, String propertyName, Result result, boolean ignoreCase) {
        String node = null;
        if ("localnode".equalsIgnoreCase(nodeName)) {
            try {
                node = VerificationUtil.getLocalNodename();
            }
            catch (NodelistNotFoundException nlnfe) {
                result.addErrorDescription(new ErrorDescription(nlnfe.getMessage()));
                result.setStatus(2);
                return null;
            }
        } else {
            node = nodeName;
        }
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String olrFileName = nativeSys.getOLRConfigLocation(node, new Version());
        boolean fileExist = false;
        try {
            fileExist = nativeSys.pathExists(node, olrFileName, 2);
        }
        catch (RemoteDirException rde) {
            Trace.out((String)rde.getMessage());
            result.addErrorDescription(new ErrorDescription(rde.getMessage()));
            result.setStatus(2);
            return null;
        }
        if (!fileExist) {
            String errMsg = s_msgBundle.getMessage("5311", true, (Object[])new String[]{olrFileName, node});
            result.addErrorDescription(new ErrorDescription(errMsg));
            result.setStatus(2);
            return null;
        }
        String olrPropertyValue = sVerificationUtil.getPropertyValue(node, olrFileName, propertyName, result, ignoreCase);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)(propertyName + "=" + olrPropertyValue));
        }
        if (result.getStatus() != 2 && VerificationUtil.isStringGood(olrPropertyValue)) {
            result.setStatus(1);
        }
        VerificationLogData.logInfo("OLRPropterty:" + propertyName + " Value: " + olrPropertyValue);
        return olrPropertyValue;
    }

    public static String getPropertyValue(String nodeName, String cnfgFilePath, String propName, Result result, boolean ignoreCase) {
        ErrorDescription errDesc = null;
        String propValue = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String destinationFullPath = null;
        if (cnfgFilePath == null || cnfgFilePath.trim().length() == 0 || propName == null || propName.trim().length() == 0 || nodeName == null || nodeName.trim().length() == 0) {
            result.setStatus(2);
            return null;
        }
        String shortFileName = cnfgFilePath.substring(cnfgFilePath.lastIndexOf(File.separator) + 1);
        destinationFullPath = VerificationUtil.getDestLoc() + nodeName + "." + shortFileName;
        File localCnfgFileCopy = new File(destinationFullPath);
        try {
            localCnfgFileCopy.createNewFile();
        }
        catch (Exception e) {
            Trace.out((String)("Error creating file" + destinationFullPath));
            Trace.out((String)e.getMessage());
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7706", false, (Object[])new String[]{destinationFullPath}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        nativeSys.copyFile(nodeName, cnfgFilePath, "localnode", destinationFullPath);
        if (!localCnfgFileCopy.exists()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(destinationFullPath + " does not exist"));
            }
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5311", false, (Object[])new String[]{destinationFullPath, nodeName}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        try {
            propValue = Utils.getPropertyValue((String)localCnfgFileCopy.getAbsolutePath(), (String)propName, (boolean)ignoreCase);
        }
        catch (FileNotFoundException e) {
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5311", false, (Object[])new String[]{localCnfgFileCopy.getAbsolutePath(), nodeName}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            return null;
        }
        catch (IOException e) {
            errDesc = new ErrorDescription(e.getMessage());
            result.addErrorDescription(errDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            result.setStatus(2);
            return null;
        }
        nativeSys.removeFile("localnode", localCnfgFileCopy.getAbsolutePath());
        VerificationLogData.logInfo("Propterty:" + propName + " Value: " + propValue);
        return propValue;
    }

    public static String getTZFileLoc() {
        return TZ_FILE_LOC;
    }

    public static String getCSSDFileLoc() {
        return CSSDPATH;
    }

    public static String[] getLdLibraryStrings() {
        String[] ldLibArray = new String[]{"LD_LIBRARY_PATH="};
        return ldLibArray;
    }

    public static boolean isAutoMountEnabled(String node) {
        Trace.out((String)"NOT SUPPORTED ON UNIX!");
        return false;
    }

    public static boolean isDisplayEnabled() {
        return sVerificationUtil.isDisplayEnabled(XVINFO_COMMAND);
    }

    private static boolean isDisplayEnabled(String displayCheckCommand) {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult result = new NativeResult();
        String command = displayCheckCommand;
        nativeSystem.runRemoteExecCmd(command, null, null, result);
        if (result.getStatus()) {
            String[] res = result.getResultString();
            if (res != null & res.length > 0) {
                return true;
            }
            Trace.out((String)"DISPLAY variable is not set properly");
            return false;
        }
        Trace.out((String)"DISPLAY variable is not set properly");
        return false;
    }

    public static String getRootUsername() {
        return "root";
    }

    public static DiskInfoResultSet getDiskInfoForPath(String[] nodeList, String path) throws InvalidPathException {
        Trace.out((String)"NOT SUPPORTED ON UNIX!");
        return null;
    }

    static String getLocalRootGroup(ResultSet rootGrpRS) {
        String cmd = "/usr/bin/id root";
        Runtime r = Runtime.getRuntime();
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            Process p = r.exec(cmd);
            InputStream is = p.getInputStream();
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            Trace.out((String)e.getMessage());
            rootGrpRS.addErrorDescription(new ErrorDescription(e.getMessage()));
            return null;
        }
        String s = sb.toString();
        String j = s.split(" ")[1];
        return j.substring(j.indexOf(40) + 1, j.indexOf(41));
    }

    public static boolean isExadataSystem() {
        return false;
    }

    public static boolean isODASystem() {
        return false;
    }

    public static boolean isASMLibConfigured(String[] nodeList) {
        ResultSet asmLibconfiguredRsltSet;
        GlobalExecution globalExec = new GlobalExecution();
        boolean result = false;
        ResultSet asmLibInstallRsltSet = new ResultSet();
        result = globalExec.checkFileExistence(nodeList, asmLibScriptPath, asmLibInstallRsltSet);
        return result && asmLibInstallRsltSet.allSuccess() && (result = globalExec.checkFileExistence(nodeList, asmLibMountPath, asmLibconfiguredRsltSet = new ResultSet())) && asmLibconfiguredRsltSet.allSuccess();
    }

    public static boolean isASMLibInstallConsistent(String[] nodeList, ResultSet asmLibInstallRsltSet, Vector<String> asmLibNotInstallNodes, Vector<String> operationFailedNode) {
        return false;
    }

    public static boolean isASMLibConfiguredConsistently(String[] nodeList, ResultSet asmLibconfiguredRsltSet, Vector<String> asmLibInconsistantConfigNodes, Vector<String> operationFailedNode) {
        return false;
    }

    public static String getAFDDriverCommandPath(String giHome) {
        return giHome + VerificationConstants.FILE_SEPARATOR + "bin" + VerificationConstants.FILE_SEPARATOR + m_afdDriverStateCommand;
    }

    public static String getAFDToolCommandPath(String giHome) {
        return giHome + VerificationConstants.FILE_SEPARATOR + "bin" + VerificationConstants.FILE_SEPARATOR + m_afdToolCommand;
    }

    public static String getInitTabLoc() {
        return "/etc/inittab";
    }

    public static String getInitdLoc() {
        return "/etc/init.d";
    }

    public static String[] filterSolarisZoneNodes(String[] nodeList, boolean globalZone, ResultSet resultSet) {
        HashSet<String> inZoneNodes = new HashSet<String>();
        GlobalExecution globalExec = new GlobalExecution();
        String cmd = ZONENAME_CMD;
        Trace.out((String)("Running CMD: " + cmd + "on all nodes"));
        Hashtable zoneInfoTable = globalExec.runExeWithOutput(nodeList, cmd, resultSet);
        for (String node : nodeList) {
            ErrorDescription errDesc;
            String errMsg;
            if (zoneInfoTable.containsKey(node)) {
                String output = (String)zoneInfoTable.get(node);
                Trace.out((String)("output for node " + node + " is " + output));
                if (!VerificationUtil.isStringGood(output) || !VerificationUtil.fetchExecResult(output)) {
                    Trace.out((String)"execution result couldn't be determined");
                    resultSet.addResult(node, 2);
                    errMsg = s_gMsgBundle.getMessage("1042", true, (Object[])new String[]{cmd, node});
                    errDesc = new ErrorDescription(errMsg);
                    resultSet.addErrorDescription(node, errDesc);
                    continue;
                }
                String exitStatus = VerificationUtil.fetchVerificationResult(output);
                String zoneName = VerificationUtil.fetchVerificationValue(output.trim());
                if (!"0".equalsIgnoreCase(exitStatus)) {
                    Trace.out((String)"zonename command did't run");
                    resultSet.addResult(node, 3);
                    String errMsg2 = s_gMsgBundle.getMessage("1043", true, (Object[])new String[]{cmd, node, exitStatus, zoneName});
                    ErrorDescription errDesc2 = new ErrorDescription(errMsg2);
                    resultSet.addErrorDescription(node, errDesc2);
                    continue;
                }
                resultSet.addResult(node, 1);
                boolean isInGlobal = GLOBAL_ZONE_STR.equalsIgnoreCase(zoneName.trim());
                if (isInGlobal != globalZone) continue;
                inZoneNodes.add(node);
                continue;
            }
            Trace.out((String)"execution result couldn't be determined");
            resultSet.addResult(node, 2);
            errMsg = s_gMsgBundle.getMessage("1042", true, (Object[])new String[]{cmd, node});
            errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(node, errDesc);
        }
        return inZoneNodes.toArray(new String[0]);
    }

    public static boolean isSolarisKernelZone(String[] nodeList, ResultSet resultSet) {
        GlobalExecution globalExec = new GlobalExecution();
        String cmd = ZONEADM_CMD;
        boolean status = true;
        Trace.out((String)("Running CMD: " + cmd + "on all nodes"));
        Hashtable zoneAdmTable = globalExec.runExeWithOutput(nodeList, cmd, resultSet);
        for (String node : nodeList) {
            ErrorDescription errDesc;
            String errMsg;
            if (zoneAdmTable.containsKey(node)) {
                String output = (String)zoneAdmTable.get(node);
                Trace.out((String)("output for node " + node + " is " + output));
                if (!VerificationUtil.isStringGood(output) || !VerificationUtil.fetchExecResult(output)) {
                    Trace.out((String)"execution result couldn't be determined");
                    resultSet.addResult(node, 2);
                    errMsg = s_gMsgBundle.getMessage("1040", true, (Object[])new String[]{cmd, node});
                    errDesc = new ErrorDescription(errMsg);
                    resultSet.addErrorDescription(node, errDesc);
                    status = false;
                    continue;
                }
                String exitStatus = VerificationUtil.fetchVerificationResult(output);
                String zoneAdmStr = VerificationUtil.fetchVerificationValue(output.trim());
                if (!"0".equalsIgnoreCase(exitStatus)) {
                    Trace.out((String)"zoneadm command did't run");
                    resultSet.addResult(node, 3);
                    String errMsg2 = s_gMsgBundle.getMessage("1041", true, (Object[])new String[]{cmd, node, exitStatus, zoneAdmStr});
                    ErrorDescription errDesc2 = new ErrorDescription(errMsg2);
                    resultSet.addErrorDescription(node, errDesc2);
                    status = false;
                    continue;
                }
                String[] zoneAdmArr = zoneAdmStr.trim().split(":");
                if (zoneAdmArr.length < 6) {
                    Trace.out((String)"zoneadm command did't produce parsable output");
                    resultSet.addResult(node, 3);
                    String errMsg3 = s_gMsgBundle.getMessage("1041", true, (Object[])new String[]{cmd, node, exitStatus, zoneAdmStr});
                    ErrorDescription errDesc3 = new ErrorDescription(errMsg3);
                    resultSet.addErrorDescription(node, errDesc3);
                    status = false;
                    continue;
                }
                String brandName = zoneAdmArr[5];
                Trace.out((String)("brandName = " + brandName));
                resultSet.addResult(node, 1);
                if (KERNEL_BRAND_STR.equalsIgnoreCase(brandName.trim())) {
                    status &= true;
                    continue;
                }
                status &= false;
                continue;
            }
            Trace.out((String)"execution result couldn't be determined");
            resultSet.addResult(node, 2);
            errMsg = s_gMsgBundle.getMessage("1040", true, (Object[])new String[]{cmd, node});
            errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(node, errDesc);
            status = false;
        }
        return status;
    }

    public static ResultSet getSharedMemory(String[] nodeList, StorageUnit unit) {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet resultSet = new ResultSet();
        String paramName = "project.max-shm-memory";
        globalExec.getKerParam(nodeList, paramName, resultSet);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) continue;
            int resInfoSetSize = result.getResultInfoSet().size();
            String value = null;
            if (resInfoSetSize <= 0) continue;
            value = (String)result.getResultInfoSet().elementAt(0);
            if (VerificationUtil.isStringGood(value) && value.contains("=")) {
                value = value.split("=")[1].trim();
            }
            if (VerificationUtil.isStringGood(value)) {
                Trace.out((String)("The shared memory on node (" + node + ") is (" + value + ") Bytes"));
                value = VerificationUtil.parseObjectToString(new StorageSize(VerificationUtil.parseStringToNumber(value), StorageUnit.BYTE).sizeIn(unit));
                resultSet.getResult(node).setHasResultValues(true);
                resultSet.getResult(node).setActualValue(value);
                continue;
            }
            VerificationUtil.traceAndLogError("No value returned for (" + paramName + ") shared memory param on node:" + node);
            resultSet.getResult(node).addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("7544", true, (Object[])new String[]{paramName, node}), s_msgBundle, "7544"));
            resultSet.addResult(node, 2);
        }
        return resultSet;
    }

    public static List<String> filterLinuxContainerNodes(String[] nodeList, ResultSet resultSet) {
        resultSet.addResult(nodeList, 2);
        return new ArrayList<String>();
    }

    public static boolean isChronySupported() {
        return false;
    }

    public static boolean isVirtualEnvironment() {
        return false;
    }

    public static boolean isPrimeCluster() {
        boolean retVal = true;
        VerificationUtil.traceAndLog("Check if prime cluster");
        File cftoolFile = new File(CFTOOL_FILE);
        retVal = cftoolFile.exists();
        if (retVal) {
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            NativeResult result = new NativeResult();
            nativeSystem.runRemoteExecCmd(CFTOOL_FILE_CMD, null, null, result);
            if (result.getStatus()) {
                VerificationUtil.traceAndLog("This is a prime cluster");
                retVal = true;
            } else {
                VerificationUtil.traceAndLog("This is not a prime cluster");
                retVal = false;
            }
        }
        return retVal;
    }

    public static boolean isIPMPNetwork() {
        ResultSet ipmpRsltSet = new ResultSet();
        VerificationUtil.traceAndLog("Check if IPMP is enabled");
        String localNode = VerificationUtil.getLocalNode();
        VerifyNetwork vfyNetwork = new VerifyNetwork();
        HashMap<String, List<NetworkInfo>> ipmpinfo = vfyNetwork.getIPMPConfigInfo(new String[]{localNode}, ipmpRsltSet);
        if (ipmpinfo == null || ipmpinfo.isEmpty()) {
            VerificationUtil.traceAndLog("IPMP is not enabled");
            return false;
        }
        VerificationUtil.traceAndLog("IPMP is enabled");
        return true;
    }

    public static boolean isSameOSVersion(String kernelVersion) {
        VerificationUtil.traceAndLog("Trying to get OS version");
        String kernelRelease = sVerificationUtil.getKernelRelease();
        VerificationUtil.traceAndLog("OS version is " + kernelRelease);
        return VerificationUtil.isStringGood(kernelRelease) && kernelRelease.contains(kernelVersion);
    }

    public static boolean isHAIPSupported() {
        VerificationUtil.traceAndLog("Check if HAIP is supported");
        if (!(sVerificationUtil.isSUNCLUSTERConfigured() || sVerificationUtil.isPrimeCluster() || sVerificationUtil.isIPMPNetwork() || VerificationUtil.isExadataSystem() && sVerificationUtil.isSameOSVersion("5.11"))) {
            VerificationUtil.traceAndLog("HAIP is supported");
            return true;
        }
        VerificationUtil.traceAndLog("HAIP is not supported");
        return false;
    }
}

