/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.GetAllEnvironmentVariablesCommand;
import oracle.ops.verification.framework.command.GetAllPackagesCommand;
import oracle.ops.verification.framework.command.GetAllRLimitsCommand;
import oracle.ops.verification.framework.engine.CollectionResultImpl;
import oracle.ops.verification.framework.engine.CollectionResultSetImpl;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.util.OSPackageInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class sOSCollectionsCommandHandler {
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static final String KERNEL_PARAM_COLLECTION_COMMAND = "/bin/prctl -P -i process $$ | /bin/grep \" privileged \" | /bin/awk '{ print $1 \" = \" $3}'";

    public static boolean kernelParamCollectionAvailable() {
        return true;
    }

    public static String genKernelParamDiscoveryCommand(String m_commandId) {
        return KERNEL_PARAM_COLLECTION_COMMAND;
    }

    public static CollectionResultImpl<Hashtable<String, String>> parseKernelParamCollection(String m_commandId, String node, String cmd, Result result) {
        CollectionResultImpl<Hashtable<String, String>> colResult = new CollectionResultImpl<Hashtable<String, String>>(node);
        if (result != null && result.getStatus() == 1) {
            String outStr = (String)result.getResultInfoSet().firstElement();
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                Hashtable<String, String> kernelParamHT = new Hashtable<String, String>();
                Pattern kernelParamPattern = Pattern.compile("(\\s*)([^=]*)=(\\s*)(.*)(\\s*)");
                for (String line : cmdOut) {
                    line = line.trim();
                    Trace.out((String)("line [" + line + "]"));
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    Matcher m = kernelParamPattern.matcher(line);
                    String name = null;
                    String value = null;
                    if (!m.matches()) continue;
                    name = m.group(2);
                    value = m.group(4);
                    kernelParamHT.put(name, value);
                }
                colResult.setStatus(1);
                colResult.setCollectedData(kernelParamHT);
            } else {
                colResult.setStatus(2);
                if (VerificationUtil.isStringGood(outStr)) {
                    colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
                } else {
                    colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
                }
            }
        } else {
            for (VerificationError error : result.getErrors()) {
                colResult.addErrorDescription((ErrorDescription)error);
            }
            colResult.setStatus(NodeResultStatus.OPERATION_FAILED.getResultStatus());
        }
        return colResult;
    }

    public static boolean osPackagesCollectionAvailable() {
        return true;
    }

    public static CollectionResultSetImpl<List<OSPackageInfo>> getAllPackages(String m_commandId, String[] nodeList) {
        CollectionResultSetImpl<List<OSPackageInfo>> colRS = new CollectionResultSetImpl<List<OSPackageInfo>>();
        ResultSet rsltSet = new ResultSet();
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetAllPackagesCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            colRS.addResult(node, result.getStatus());
            if (result.getStatus() != 1) {
                for (VerificationError error : result.getErrors()) {
                    colRS.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            String outStr = (String)result.getResultInfoSet().get(1);
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            CollectionResultImpl colResult = new CollectionResultImpl(node);
            colRS.addResult(node, colResult);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(0);
                ArrayList<OSPackageInfo> packageList = new ArrayList<OSPackageInfo>();
                try {
                    Vector packageStrs = GenericUtil.getAllStrByTags(VerificationUtil.fetchVerificationValue(outStr), "PACKAGE");
                    for (Object str : packageStrs) {
                        OSPackageInfo packageInfo = new OSPackageInfo();
                        packageInfo.setName(GenericUtil.getValueByKey(str.toString(), "NAME"));
                        packageInfo.setArchitecture(GenericUtil.getValueByKey(str.toString(), "ARCH"));
                        packageInfo.setVersion(GenericUtil.getValueByKey(str.toString(), "VERSION"));
                        packageList.add(packageInfo);
                    }
                }
                catch (ParsingException e1) {
                    colResult.setStatus(2);
                    colResult.addErrorDescription(new ErrorDescription(e1.getMessage()));
                    continue;
                }
                colResult.setStatus(1);
                colResult.setCollectedData(packageList);
                continue;
            }
            String cmd = VerificationUtil.fetchCommandValue(outStr);
            colResult.setStatus(2);
            if (VerificationUtil.isStringGood(outStr)) {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
                continue;
            }
            colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
        }
        return colRS;
    }

    public static boolean osPatchesCollectionAvailable() {
        return false;
    }

    public static String genOSPatchDiscoveryCommand(String m_commandId) {
        throw new UnsupportedOperationException();
    }

    public static CollectionResultImpl<List<String>> parseOSPatchesCollection(String m_commandId, String node, String cmd, Result result) {
        throw new UnsupportedOperationException();
    }

    public static CollectionResultSet<Hashtable<String, String>> getAllEnvironmentVariables(String[] nodeList) {
        CollectionResultSetImpl colRS = new CollectionResultSetImpl();
        ResultSet rsltSet = new ResultSet();
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetAllEnvironmentVariablesCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            colRS.addResult(node, result.getStatus());
            if (result.getStatus() != 1) {
                for (VerificationError error : result.getErrors()) {
                    colRS.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            String outStr = (String)result.getResultInfoSet().get(1);
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            CollectionResultImpl colResult = new CollectionResultImpl(node);
            colRS.addResult(node, colResult);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = VerificationUtil.string2strArr(VerificationUtil.fetchVerificationValue(outStr), VerificationUtil.LSEP);
                Hashtable<String, String> paramHT = new Hashtable<String, String>();
                Pattern paramPattern = Pattern.compile("(\\s*)([^=]*)=(\\s*)(.*)(\\s*)");
                for (String line : cmdOut) {
                    line = line.trim();
                    Trace.out((String)("line [" + line + "]"));
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    Matcher m = paramPattern.matcher(line);
                    String name = null;
                    String value = null;
                    if (!m.matches()) continue;
                    name = m.group(2);
                    value = m.group(4);
                    paramHT.put(name, value);
                }
                colResult.setStatus(1);
                colResult.setCollectedData(paramHT);
                continue;
            }
            String cmd = VerificationUtil.fetchCommandValue(outStr);
            colResult.setStatus(2);
            if (VerificationUtil.isStringGood(outStr)) {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
                continue;
            }
            colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
        }
        return colRS;
    }

    public static CollectionResultSet<Hashtable<String, Hashtable<String, String>>> getAllRLimits(String[] nodeList) {
        CollectionResultSetImpl colRS = new CollectionResultSetImpl();
        ResultSet rsltSet = new ResultSet();
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetAllRLimitsCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            colRS.addResult(node, result.getStatus());
            if (result.getStatus() != 1) {
                for (VerificationError error : result.getErrors()) {
                    colRS.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            String outStr = (String)result.getResultInfoSet().get(1);
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            CollectionResultImpl colResult = new CollectionResultImpl(node);
            colRS.addResult(node, colResult);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = VerificationUtil.string2strArr(VerificationUtil.fetchVerificationValue(outStr), VerificationUtil.LSEP);
                Hashtable paramHT = new Hashtable();
                Pattern paramPattern = Pattern.compile("(\\s*)([^=]*)=(\\s*)(.*)(\\s*)");
                for (String line : cmdOut) {
                    line = line.trim();
                    Trace.out((String)("line [" + line + "]"));
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    Matcher m = paramPattern.matcher(line);
                    String name = null;
                    String[] value = null;
                    Hashtable<String, String> limits = new Hashtable<String, String>();
                    if (!m.matches()) continue;
                    name = m.group(2);
                    value = m.group(4).split(",");
                    limits.put(CDMConstraintTypes.SOFTLIMIT, value[0]);
                    limits.put(CDMConstraintTypes.HARDLIMIT, value[1]);
                    paramHT.put(name, limits);
                }
                colResult.setStatus(1);
                colResult.setCollectedData(paramHT);
                continue;
            }
            String cmd = VerificationUtil.fetchCommandValue(outStr);
            colResult.setStatus(2);
            if (VerificationUtil.isStringGood(outStr)) {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
                continue;
            }
            colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
        }
        return colRS;
    }

    public static CollectionResult<Hashtable<String, String>> parseAllEnvironmentVariablesByPid(String node, String outStr) {
        String exitStat = VerificationUtil.fetchVerificationResult(outStr);
        CollectionResultImpl colResult = new CollectionResultImpl(node);
        if (exitStat != null && exitStat.contentEquals("0")) {
            String[] cmdOut = VerificationUtil.string2strArr(VerificationUtil.fetchVerificationValue(outStr), VerificationUtil.LSEP);
            Hashtable<String, String> paramHT = new Hashtable<String, String>();
            Pattern paramPattern = Pattern.compile("(\\s*)([^=]*)=(\\s*)(.*)(\\s*)");
            for (String line : cmdOut) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                Matcher m = paramPattern.matcher(line);
                String name = null;
                String value = null;
                if (!m.matches()) continue;
                name = m.group(2);
                value = m.group(4);
                paramHT.put(name, value);
            }
            colResult.setStatus(1);
            colResult.setCollectedData(paramHT);
        } else {
            String cmd = VerificationUtil.fetchCommandValue(outStr);
            colResult.setStatus(2);
            if (VerificationUtil.isStringGood(outStr)) {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
            } else {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
            }
        }
        return colResult;
    }

    public static CollectionResult<Hashtable<String, Hashtable<String, String>>> parseAllRLimitsByPid(String node, String outStr) {
        String exitStat = VerificationUtil.fetchVerificationResult(outStr);
        CollectionResultImpl colResult = new CollectionResultImpl(node);
        if (exitStat != null && exitStat.contentEquals("0")) {
            String[] cmdOut = VerificationUtil.string2strArr(VerificationUtil.fetchVerificationValue(outStr), VerificationUtil.LSEP);
            Hashtable limitsHT = new Hashtable();
            Pattern paramPattern = Pattern.compile("(\\s*)([^\t]*)(\\s*)([^\t]*)(\\s*)([^\t]*)(.*)");
            boolean first = true;
            for (String line : cmdOut) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                if (first) {
                    first = false;
                    continue;
                }
                line = line.replaceAll("  ", "\t");
                Matcher m = paramPattern.matcher(line);
                String name = null;
                Object softLimit = null;
                Object hardLimit = null;
                Hashtable<String, String> limits = new Hashtable<String, String>();
                if (!m.matches()) continue;
                name = m.group(2);
                limits.put(CDMConstraintTypes.SOFTLIMIT, m.group(4));
                limits.put(CDMConstraintTypes.HARDLIMIT, m.group(6));
                limitsHT.put(name, limits);
            }
            colResult.setStatus(1);
            colResult.setCollectedData(limitsHT);
        } else {
            String cmd = VerificationUtil.fetchCommandValue(outStr);
            colResult.setStatus(2);
            if (VerificationUtil.isStringGood(outStr)) {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
            } else {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
            }
        }
        return colResult;
    }
}

