/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class VerificationLogData {
    public static final int FINE_LOG = 1;
    public static final int INFO_LOG = 2;
    public static final int WARNING_LOG = 3;
    public static final int ERROR_LOG = 4;
    public static final int SEVERE_LOG = 5;
    private static Hashtable<String, HashMap<ErrorDescription, Set<String>>> m_uniqueGlobalErrors = new Hashtable();
    private static Set<String> m_failureNodeList = new HashSet<String>();
    private static List<ErrorDescription> m_globalErrors = new ArrayList<ErrorDescription>();
    private static boolean s_packageVerificationLogDataEnabled = true;
    private static Hashtable s_packageVerificationLogDataTable = new Hashtable();
    private static String[] s_packageNames = new String[]{"oracle.ops.mgmt.asm", "oracle.ops.mgmt.cluster", "oracle.ops.mgmt.daemon", "oracle.ops.mgmt.command", "oracle.ops.mgmt.command.db", "oracle.ops.mgmt.command.file", "oracle.ops.mgmt.command.listener", "oracle.ops.mgmt.command.service", "oracle.ops.mgmt.command.registry", "oracle.ops.mgmt.command.daemon", "oracle.ops.mgmt.command.util", "oracle.ops.mgmt.synchronize", "oracle.ops.mgmt.database", "oracle.ops.mgmt.nativesystem", "oracle.ops.mgmt.nodeapps", "oracle.ops.mgmt.rawdevice", "oracle.ops.mgmt.operation", "oracle.ops.mgmt.operation.ha"};
    private static String s_strVerificationLogDataFileName;
    private static String s_strFinalizer;
    private static List<String> m_loggerData;

    public static void setPackageLogging(String packageNames, boolean packageLogging) {
        s_packageVerificationLogDataEnabled = packageLogging;
        if (packageNames != null && packageNames.length() != 0) {
            s_packageVerificationLogDataEnabled = true;
            StringTokenizer st = new StringTokenizer(packageNames, ",");
            while (st.hasMoreTokens()) {
                String singlePackageName = st.nextToken();
                if (singlePackageName == null || singlePackageName.length() == 0) {
                    s_packageVerificationLogDataEnabled = false;
                    break;
                }
                Integer integer = (Integer)s_packageVerificationLogDataTable.get(singlePackageName);
                if (integer == null) {
                    s_packageVerificationLogDataEnabled = false;
                    break;
                }
                s_packageVerificationLogDataTable.put(singlePackageName, new Integer(1));
            }
        } else {
            s_packageVerificationLogDataEnabled = false;
        }
    }

    public static synchronized void setVerificationLogData(List<String> logData) {
        m_loggerData = logData;
    }

    public static synchronized List<String> getVerificationLogData() {
        return m_loggerData;
    }

    public static void log(String strText) {
        VerificationLogData.internalLog(strText, 2);
    }

    public static void log(String strText, String whereFrom, int level) {
        VerificationLogData.internalLog(strText, whereFrom, level);
    }

    public static void logFine(String strText) {
        VerificationLogData.internalLog(strText, 1);
    }

    public static void logInfo(String strText) {
        VerificationLogData.internalLog(strText, 2);
    }

    public static void logWarning(String strText) {
        VerificationLogData.internalLog(strText, 3);
    }

    public static void logError(String strText) {
        VerificationLogData.internalLog(strText, 4);
    }

    public static void logSevere(String strText) {
        VerificationLogData.internalLog(strText, 5);
    }

    public static void traceLogData() {
        Trace.out((String)"======================================================================\n===================== VERIFICATION LOG DATA ==========================\n======================================================================");
        for (String err : m_loggerData) {
            Trace.out((String)err);
        }
    }

    public static List<ErrorDescription> getGlobalErrors() {
        ArrayList<ErrorDescription> allErrors = new ArrayList<ErrorDescription>();
        allErrors.addAll(m_globalErrors);
        for (String id : m_uniqueGlobalErrors.keySet()) {
            allErrors.addAll(m_uniqueGlobalErrors.get(id).keySet());
        }
        return allErrors;
    }

    public static void addGlobalErrorOnce(String msgFacility, String msgKey, boolean errNum, Object[] msgArgs, String[] additionalErrors, String[] failedNodes) {
        if (!VerificationUtil.isStringGood(msgFacility) || !VerificationUtil.isStringGood(msgKey)) {
            return;
        }
        String completeErrorMsg = null;
        completeErrorMsg = msgArgs == null ? VerificationUtil.getMessageBundle(msgFacility).getMessage(msgKey, errNum) : VerificationUtil.getMessageBundle(msgFacility).getMessage(msgKey, errNum, msgArgs);
        if (additionalErrors != null) {
            for (String error : additionalErrors) {
                if (!VerificationUtil.isStringGood(error)) continue;
                completeErrorMsg = completeErrorMsg + VerificationConstants.LINE_SEPARATOR + error;
            }
        }
        if (VerificationUtil.isStringGood(completeErrorMsg)) {
            ErrorDescription errDesc = new ErrorDescription(completeErrorMsg);
            VerificationLogData.addGlobalError(msgKey, failedNodes, errDesc, false);
        }
    }

    public static void addGlobalError(ErrorDescription error, String[] failedNodes, boolean ignoreDuplicate) {
        VerificationLogData.addGlobalError(null, failedNodes, error, ignoreDuplicate);
    }

    private static void addGlobalError(String id, String[] failedNodes, ErrorDescription error, boolean ignoreDuplicate) {
        HashSet<String> failedNodesList = new HashSet<String>();
        if (failedNodes != null && failedNodes.length > 0) {
            for (String string : failedNodes) {
                failedNodesList.add(string);
            }
        }
        if (ignoreDuplicate) {
            m_globalErrors.add(error);
        } else {
            if (!VerificationUtil.isStringGood(id)) {
                id = VerificationUtil.getLocationInSource(true);
            }
            if (VerificationUtil.isStringGood(id)) {
                HashMap<Object, Object> entry;
                if (!m_uniqueGlobalErrors.containsKey(id)) {
                    entry = new HashMap<ErrorDescription, HashSet<String>>();
                    entry.put(error, failedNodesList);
                    m_uniqueGlobalErrors.put(id, entry);
                } else {
                    entry = m_uniqueGlobalErrors.get(id);
                    boolean newEntry = true;
                    for (ErrorDescription errorDescription : entry.keySet()) {
                        if (entry.get(errorDescription) == null || !((Set)entry.get(errorDescription)).containsAll(failedNodesList)) continue;
                        newEntry = false;
                        Trace.out((String)"Skipping to add this error as similar error with similar failure nodes has been already added");
                    }
                    if (newEntry) {
                        m_uniqueGlobalErrors.get(id).put(error, failedNodesList);
                    }
                }
            } else {
                Trace.out((String)"No id passsed and also caller could not be identified and hence adding to non-unique error list ");
                m_globalErrors.add(error);
            }
        }
        VerificationLogData.updateFailureNodes(failedNodesList);
    }

    private static void updateFailureNodes(Set<String> failedNodes) {
        if (failedNodes != null && !failedNodes.isEmpty()) {
            m_failureNodeList.addAll(failedNodes);
        }
    }

    public static Set<String> getFailureNodes() {
        return m_failureNodeList;
    }

    public static boolean hasGlobalErrors() {
        return !m_globalErrors.isEmpty() || !m_uniqueGlobalErrors.isEmpty();
    }

    public static void reportGlobalErrors() {
        if (VerificationLogData.hasGlobalErrors()) {
            for (ErrorDescription errorDesc : VerificationLogData.getGlobalErrors()) {
                ReportUtil.printError(errorDesc.getErrorMessage());
            }
        }
    }

    private static synchronized void internalLog(String strText, int level) {
        VerificationLogData.internalLog(strText, null, level);
    }

    private static synchronized void internalLog(String strText, String whereFrom, int level) {
        String logPrefix = "";
        switch (level) {
            case 1: {
                logPrefix = new String("FINE: ");
                break;
            }
            case 2: {
                logPrefix = new String("INFO: ");
                break;
            }
            case 3: {
                logPrefix = new String("WARNING: ");
                break;
            }
            case 4: {
                logPrefix = new String("ERROR: ");
                break;
            }
            case 5: {
                logPrefix = new String("SEVERE: ");
                break;
            }
            default: {
                logPrefix = new String("UNKNOWN: ");
            }
        }
        if (!VerificationUtil.isStringGood(whereFrom)) {
            whereFrom = VerificationUtil.getLocationInSource(true);
        }
        if (whereFrom != null && whereFrom.length() > 0) {
            logPrefix = logPrefix + "[" + whereFrom + "]  ";
            strText = logPrefix + strText;
            m_loggerData.add(strText);
        }
    }

    static {
        s_strFinalizer = "[* Finalizer *] ";
        m_loggerData = new ArrayList<String>();
        for (int i = 0; i < s_packageNames.length; ++i) {
            s_packageVerificationLogDataTable.put(s_packageNames[i], new Integer(0));
        }
        String packageNames = System.getProperty("TRACING.PACKAGE");
        if (packageNames != null && packageNames.length() != 0) {
            StringTokenizer st = new StringTokenizer(packageNames, ",");
            while (st.hasMoreTokens()) {
                String singlePackageName = st.nextToken();
                if (singlePackageName == null || singlePackageName.length() == 0) {
                    s_packageVerificationLogDataEnabled = false;
                    break;
                }
                Integer integer = (Integer)s_packageVerificationLogDataTable.get(singlePackageName);
                if (integer == null) {
                    s_packageVerificationLogDataEnabled = false;
                    break;
                }
                s_packageVerificationLogDataTable.put(singlePackageName, new Integer(1));
            }
        } else {
            s_packageVerificationLogDataEnabled = false;
        }
    }
}

