/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.GetAllEnvironmentVariablesCommand;
import oracle.ops.verification.framework.command.GetAllPackagesCommand;
import oracle.ops.verification.framework.command.GetAllRLimitsCommand;
import oracle.ops.verification.framework.engine.CollectionResultImpl;
import oracle.ops.verification.framework.engine.CollectionResultSetImpl;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.util.OSPackageInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.sOSCollectionsCommandHandler;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class OSCollectionsCommandHandler {
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public static boolean kernelParamCollectionAvailable() {
        return sOSCollectionsCommandHandler.kernelParamCollectionAvailable();
    }

    public static String genKernelParamDiscoveryCommand(String commandId) {
        return sOSCollectionsCommandHandler.genKernelParamDiscoveryCommand(commandId);
    }

    public static CollectionResultImpl<Hashtable<String, String>> parseKernelParamCollection(String commandId, String node, String cmd, Result result) {
        return sOSCollectionsCommandHandler.parseKernelParamCollection(commandId, node, cmd, result);
    }

    public static boolean osPackagesCollectionAvailable() {
        return sOSCollectionsCommandHandler.osPackagesCollectionAvailable();
    }

    public static CollectionResultSetImpl<List<OSPackageInfo>> getAllPackages(String m_commandId, String[] nodeList) {
        CollectionResultSetImpl<List<OSPackageInfo>> colRS = new CollectionResultSetImpl<List<OSPackageInfo>>();
        ResultSet rsltSet = new ResultSet();
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetAllPackagesCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) {
                colRS.addResult(node, result.getStatus());
                for (VerificationError error : result.getErrors()) {
                    colRS.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            String outStr = (String)result.getResultInfoSet().get(1);
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            CollectionResultImpl colResult = new CollectionResultImpl(node);
            colRS.addResult(node, colResult);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(0);
                ArrayList<OSPackageInfo> packageList = new ArrayList<OSPackageInfo>();
                try {
                    Vector packageStrs = GenericUtil.getAllStrByTags(VerificationUtil.fetchVerificationValue(outStr), "PACKAGE");
                    for (Object str : packageStrs) {
                        OSPackageInfo packageInfo = new OSPackageInfo();
                        packageInfo.setName(GenericUtil.getValueByKey(str.toString(), "NAME"));
                        packageInfo.setArchitecture(GenericUtil.getValueByKey(str.toString(), "ARCH"));
                        packageInfo.setVersion(GenericUtil.getValueByKey(str.toString(), "VERSION"));
                        packageList.add(packageInfo);
                    }
                }
                catch (ParsingException e1) {
                    colResult.setStatus(2);
                    colResult.addErrorDescription(new ErrorDescription(e1.getMessage()));
                    continue;
                }
                colResult.setStatus(1);
                colResult.setCollectedData(packageList);
                continue;
            }
            String cmd = VerificationUtil.fetchCommandValue(outStr);
            colResult.setStatus(2);
            if (VerificationUtil.isStringGood(outStr)) {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
                continue;
            }
            colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
        }
        return colRS;
    }

    public static boolean osPatchesCollectionAvailable() {
        return sOSCollectionsCommandHandler.osPatchesCollectionAvailable();
    }

    public static String genOSPatchDiscoveryCommand(String commandId) {
        return sOSCollectionsCommandHandler.genOSPatchDiscoveryCommand(commandId);
    }

    public static CollectionResultImpl<List<String>> parseOSPatchesCollection(String commandId, String node, String cmd, Result result) {
        return sOSCollectionsCommandHandler.parseOSPatchesCollection(commandId, node, cmd, result);
    }

    public static CollectionResultSet<Hashtable<String, String>> getAllEnvironmentVariables(String[] nodeList) {
        CollectionResultSetImpl colRS = new CollectionResultSetImpl();
        ResultSet rsltSet = new ResultSet();
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetAllEnvironmentVariablesCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) {
                colRS.addResult(node, result.getStatus());
                for (VerificationError error : result.getErrors()) {
                    colRS.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            String outStr = (String)result.getResultInfoSet().get(1);
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            CollectionResultImpl colResult = new CollectionResultImpl(node);
            colRS.addResult(node, colResult);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = VerificationUtil.string2strArr(VerificationUtil.fetchVerificationValue(outStr), VerificationUtil.LSEP);
                Hashtable<String, String> paramHT = new Hashtable<String, String>();
                Pattern paramPattern = Pattern.compile("(\\s*)([^=]*)=(\\s*)(.*)(\\s*)");
                for (String line : cmdOut) {
                    line = line.trim();
                    Trace.out((String)("line [" + line + "]"));
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    Matcher m = paramPattern.matcher(line);
                    String name = null;
                    String value = null;
                    if (!m.matches()) continue;
                    name = m.group(2);
                    value = m.group(4);
                    paramHT.put(name, value);
                }
                colResult.setStatus(1);
                colResult.setCollectedData(paramHT);
                continue;
            }
            String cmd = VerificationUtil.fetchCommandValue(outStr);
            colResult.setStatus(2);
            if (VerificationUtil.isStringGood(outStr)) {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
                continue;
            }
            colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
        }
        return colRS;
    }

    public static CollectionResultSet<Hashtable<String, Hashtable<String, String>>> getAllRLimits(String[] nodeList) {
        CollectionResultSetImpl colRS = new CollectionResultSetImpl();
        ResultSet rsltSet = new ResultSet();
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetAllRLimitsCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) {
                colRS.addResult(node, result.getStatus());
                for (VerificationError error : result.getErrors()) {
                    colRS.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            String outStr = (String)result.getResultInfoSet().get(1);
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            CollectionResultImpl colResult = new CollectionResultImpl(node);
            colRS.addResult(node, colResult);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = VerificationUtil.string2strArr(VerificationUtil.fetchVerificationValue(outStr), VerificationUtil.LSEP);
                Hashtable paramHT = new Hashtable();
                Pattern paramPattern = Pattern.compile("(\\s*)([^=]*)=(\\s*)(.*)(\\s*)");
                for (String line : cmdOut) {
                    line = line.trim();
                    Trace.out((String)("line [" + line + "]"));
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    Matcher m = paramPattern.matcher(line);
                    String name = null;
                    String[] value = null;
                    Hashtable<String, String> limits = new Hashtable<String, String>();
                    if (!m.matches()) continue;
                    name = m.group(2);
                    value = m.group(4).split(",");
                    limits.put(CDMConstraintTypes.SOFTLIMIT, value[0]);
                    limits.put(CDMConstraintTypes.HARDLIMIT, value[1]);
                    paramHT.put(name, limits);
                }
                colResult.setStatus(1);
                colResult.setCollectedData(paramHT);
                continue;
            }
            String cmd = VerificationUtil.fetchCommandValue(outStr);
            colResult.setStatus(2);
            if (VerificationUtil.isStringGood(outStr)) {
                colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + VerificationUtil.LSEP + outStr));
                continue;
            }
            colResult.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
        }
        return colRS;
    }
}

